/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.infostore.test;

import com.openexchange.ajax.folder.AbstractObjectCountTest;
import com.openexchange.ajax.infostore.actions.InfostoreTestManager;
import com.openexchange.folderstorage.Folder;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.groupware.infostore.DocumentMetadata;
import com.openexchange.groupware.infostore.database.impl.DocumentMetadataImpl;
import com.openexchange.test.FolderTestManager;
import java.util.Date;
import org.junit.Test;

public final class InfostoreObjectCountTest
extends AbstractObjectCountTest {
    public InfostoreObjectCountTest(String name) {
        super(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCountInPrivateInfostoreFolder_AddedOne_CountReturnsOne() throws Exception {
        FolderTestManager folderTestManager = new FolderTestManager(this.client1);
        InfostoreTestManager infostoreTestManager = new InfostoreTestManager(this.client1);
        try {
            FolderObject created = InfostoreObjectCountTest.createPrivateFolder(this.client1, folderTestManager, 8);
            Folder folder = InfostoreObjectCountTest.getFolder(this.client1, created.getObjectID(), DEFAULT_COLUMNS);
            int objectsInFolder = folder.getTotal();
            InfostoreObjectCountTest.assertEquals((String)"Wrong object count", (int)0, (int)objectsInFolder);
            DocumentMetadata expected = this.createDocumentMetadata(folder);
            infostoreTestManager.newAction(expected);
            Folder reloaded = InfostoreObjectCountTest.getFolder(this.client1, created.getObjectID(), DEFAULT_COLUMNS);
            objectsInFolder = reloaded.getTotal();
            InfostoreObjectCountTest.assertEquals((String)"Wrong object count", (int)1, (int)objectsInFolder);
        }
        finally {
            infostoreTestManager.cleanUp();
            folderTestManager.cleanUp();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCountInPrivateInfostoreFolder_AddedFive_CountReturnsFive() throws Exception {
        FolderTestManager folderTestManager = new FolderTestManager(this.client1);
        InfostoreTestManager infostoreTestManager = new InfostoreTestManager(this.client1);
        try {
            FolderObject created = InfostoreObjectCountTest.createPrivateFolder(this.client1, folderTestManager, 8);
            Folder folder = InfostoreObjectCountTest.getFolder(this.client1, created.getObjectID(), DEFAULT_COLUMNS);
            InfostoreObjectCountTest.assertEquals((String)"Wrong object count", (int)0, (int)folder.getTotal());
            DocumentMetadata expected = this.createDocumentMetadata(folder);
            infostoreTestManager.newAction(expected);
            infostoreTestManager.newAction(expected);
            infostoreTestManager.newAction(expected);
            infostoreTestManager.newAction(expected);
            infostoreTestManager.newAction(expected);
            Folder reloaded = InfostoreObjectCountTest.getFolder(this.client1, created.getObjectID(), DEFAULT_COLUMNS);
            InfostoreObjectCountTest.assertEquals((String)"Wrong object count", (int)5, (int)reloaded.getTotal());
        }
        finally {
            infostoreTestManager.cleanUp();
            folderTestManager.cleanUp();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCountInSharedInfostoreFolder_AddFiveFromOwner_CountReturnsFiveToOwner() throws Exception {
        InfostoreTestManager infostoreTestManager = new InfostoreTestManager(this.client1);
        try {
            FolderObject created = InfostoreObjectCountTest.createSharedFolder(this.client1, 8, this.client2.getValues().getUserId());
            Folder folder = InfostoreObjectCountTest.getFolder(this.client1, created.getObjectID(), DEFAULT_COLUMNS);
            InfostoreObjectCountTest.assertEquals((String)"Wrong object count", (int)0, (int)folder.getTotal());
            DocumentMetadata expected = this.createDocumentMetadata(folder);
            infostoreTestManager.newAction(expected);
            infostoreTestManager.newAction(expected);
            infostoreTestManager.newAction(expected);
            infostoreTestManager.newAction(expected);
            infostoreTestManager.newAction(expected);
            Folder reloaded = InfostoreObjectCountTest.getFolder(this.client1, created.getObjectID(), DEFAULT_COLUMNS);
            InfostoreObjectCountTest.assertEquals((String)"Wrong object count", (int)5, (int)reloaded.getTotal());
            Folder reloaded2 = InfostoreObjectCountTest.getFolder(this.client2, created.getObjectID(), DEFAULT_COLUMNS);
            InfostoreObjectCountTest.assertEquals((String)"Other client is able to see objects", (int)0, (int)reloaded2.getTotal());
        }
        finally {
            infostoreTestManager.cleanUp();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCountInSharedInfostoreFolder_AddFiveFromUserWithPermission_CountReturnsFiveToUserWithPermission() throws Exception {
        InfostoreTestManager infostoreTestManager = new InfostoreTestManager(this.client2);
        try {
            FolderObject created = InfostoreObjectCountTest.createSharedFolder(this.client1, 8, this.client2.getValues().getUserId());
            Folder folder = InfostoreObjectCountTest.getFolder(this.client2, created.getObjectID(), DEFAULT_COLUMNS);
            InfostoreObjectCountTest.assertEquals((String)"Wrong object count", (int)0, (int)folder.getTotal());
            DocumentMetadata expected = this.createDocumentMetadata(folder);
            infostoreTestManager.newAction(expected);
            infostoreTestManager.newAction(expected);
            infostoreTestManager.newAction(expected);
            infostoreTestManager.newAction(expected);
            infostoreTestManager.newAction(expected);
            Folder reloaded = InfostoreObjectCountTest.getFolder(this.client2, created.getObjectID(), DEFAULT_COLUMNS);
            InfostoreObjectCountTest.assertEquals((String)"Wrong object count", (int)5, (int)reloaded.getTotal());
            Folder reloaded2 = InfostoreObjectCountTest.getFolder(this.client1, created.getObjectID(), DEFAULT_COLUMNS);
            InfostoreObjectCountTest.assertEquals((String)"Wrong object count", (int)0, (int)reloaded2.getTotal());
        }
        finally {
            infostoreTestManager.cleanUp();
        }
    }

    private DocumentMetadata createDocumentMetadata(Folder folder) {
        DocumentMetadataImpl expected = new DocumentMetadataImpl();
        expected.setCreationDate(new Date());
        expected.setFolderId(Long.parseLong(folder.getID()));
        expected.setTitle("InfostoreCountTest Item");
        expected.setLastModified(new Date());
        return expected;
    }
}

