/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.infostore;

import com.openexchange.ajax.InfostoreAJAXTest;
import com.openexchange.ajax.framework.AJAXClient;
import com.openexchange.ajax.infostore.actions.DeleteInfostoreRequest;
import com.openexchange.ajax.infostore.actions.DeleteInfostoreResponse;
import com.openexchange.ajax.infostore.actions.GetInfostoreRequest;
import com.openexchange.ajax.infostore.actions.NewInfostoreRequest;
import com.openexchange.ajax.infostore.actions.NewInfostoreResponse;
import com.openexchange.groupware.infostore.DocumentMetadata;
import com.openexchange.groupware.infostore.database.impl.DocumentMetadataImpl;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;
import org.junit.Test;

public class DeleteMultipleFilesTest
extends InfostoreAJAXTest {
    private AJAXClient client;
    private List<Integer> itemIds;
    private List<Integer> folderIds;

    public DeleteMultipleFilesTest(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.client = new AJAXClient(AJAXClient.User.User1);
        this.itemIds = new ArrayList<Integer>();
        this.folderIds = new ArrayList<Integer>();
        File f1 = File.createTempFile("file1", "txt");
        this.writeBytes("Hello World", f1);
        DocumentMetadataImpl data1 = new DocumentMetadataImpl();
        data1.setFileName(f1.getName());
        data1.setFolderId((long)this.client.getValues().getPrivateInfostoreFolder());
        data1.setCreationDate(new Date());
        NewInfostoreRequest newReq1 = new NewInfostoreRequest((DocumentMetadata)data1, f1);
        NewInfostoreResponse newRes1 = this.client.execute(newReq1);
        this.itemIds.add(newRes1.getID());
        this.folderIds.add((int)data1.getFolderId());
        File f2 = File.createTempFile("file2", "txt");
        this.writeBytes("Hello World2", f2);
        DocumentMetadataImpl data2 = new DocumentMetadataImpl();
        data2.setFileName(f2.getName());
        data2.setFolderId((long)this.client.getValues().getPrivateInfostoreFolder());
        data2.setCreationDate(new Date());
        NewInfostoreRequest newReq2 = new NewInfostoreRequest((DocumentMetadata)data2, f2);
        NewInfostoreResponse newRes2 = this.client.execute(newReq2);
        this.itemIds.add(newRes2.getID());
        this.folderIds.add((int)data2.getFolderId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeBytes(String string, File ods) {
        PrintWriter p = null;
        try {
            p = new PrintWriter(new FileWriter(ods));
            p.write(string);
        }
        catch (IOException e) {
            e.printStackTrace();
            DeleteMultipleFilesTest.fail((String)e.getMessage());
        }
        finally {
            if (p != null) {
                p.close();
            }
        }
    }

    @Override
    public void tearDown() throws Exception {
        super.tearDown();
    }

    @Test
    public void testDeleteMultipleFiles() throws Exception {
        GetInfostoreRequest get = new GetInfostoreRequest(this.itemIds.get(0));
        get.setFailOnError(true);
        Date lastModified = this.client.execute(get).getTimestamp();
        get = new GetInfostoreRequest(this.itemIds.get(1));
        get.setFailOnError(true);
        Date tmp = this.client.execute(get).getTimestamp();
        lastModified = lastModified.before(tmp) ? tmp : lastModified;
        DeleteInfostoreRequest delReq = new DeleteInfostoreRequest(this.itemIds, this.folderIds, lastModified);
        DeleteInfostoreResponse delRes = this.client.execute(delReq);
        JSONArray json = (JSONArray)delRes.getData();
        int len = json.length();
        for (int i = 0; i < len; ++i) {
            JSONObject jObject = json.getJSONObject(i);
            DeleteMultipleFilesTest.assertFalse((String)("Delete failed: " + delRes.getResponse().toString()), (boolean)this.itemIds.contains(jObject.getInt("id")));
        }
    }
}

