/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.framework;

import com.meterware.httpunit.GetMethodWebRequest;
import com.meterware.httpunit.PutMethodWebRequest;
import com.meterware.httpunit.WebConversation;
import com.meterware.httpunit.WebRequest;
import com.meterware.httpunit.WebResponse;
import com.meterware.httpunit.cookies.Cookie;
import com.meterware.httpunit.cookies.CookieJar;
import com.openexchange.ajax.framework.AJAXClient;
import com.openexchange.ajax.framework.AJAXRequest;
import com.openexchange.ajax.framework.AJAXSession;
import com.openexchange.ajax.framework.AbstractAJAXParser;
import com.openexchange.ajax.framework.AbstractAJAXResponse;
import com.openexchange.ajax.framework.Header;
import com.openexchange.configuration.AJAXConfig;
import com.openexchange.exception.OXException;
import com.openexchange.java.Charsets;
import com.openexchange.tools.URLParameter;
import com.openexchange.tools.servlet.AjaxExceptionCodes;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import junit.framework.Assert;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.client.CookieStore;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.mime.FormBodyPart;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntity;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.InputStreamBody;
import org.apache.http.entity.mime.content.StringBody;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.cookie.BasicClientCookie2;
import org.apache.http.message.BasicNameValuePair;
import org.json.JSONException;
import org.xml.sax.SAXException;

public class Executor
extends Assert {
    private static final AtomicLong COUNTER = new AtomicLong(1L);

    private Executor() {
    }

    public static <T extends AbstractAJAXResponse> T execute(AJAXClient client, AJAXRequest<T> request) throws OXException, IOException, JSONException {
        return Executor.execute(client.getSession(), request);
    }

    public static <T extends AbstractAJAXResponse> T execute(AJAXClient client, AJAXRequest<T> request, String protocol, String hostname) throws OXException, IOException, JSONException {
        return Executor.execute(client.getSession(), request, protocol, hostname, Executor.getSleep());
    }

    public static <T extends AbstractAJAXResponse> T execute(AJAXSession session, AJAXRequest<T> request) throws OXException, IOException, JSONException {
        return Executor.execute(session, request, AJAXConfig.getProperty(AJAXConfig.Property.PROTOCOL), AJAXConfig.getProperty(AJAXConfig.Property.HOSTNAME), Executor.getSleep());
    }

    public static <T extends AbstractAJAXResponse> T execute(AJAXSession session, AJAXRequest<T> request, String hostname) throws OXException, IOException, JSONException {
        return Executor.execute(session, request, AJAXConfig.getProperty(AJAXConfig.Property.PROTOCOL), hostname, Executor.getSleep());
    }

    public static <T extends AbstractAJAXResponse> T execute(AJAXSession session, AJAXRequest<T> request, String protocol, String hostname) throws OXException, IOException, JSONException {
        return Executor.execute(session, request, protocol, hostname, Executor.getSleep());
    }

    public static <T extends AbstractAJAXResponse> T execute(AJAXSession session, AJAXRequest<T> request, String protocol, String hostname, int sleep) throws OXException, IOException, JSONException {
        HttpGet httpRequest;
        String urlString = protocol + "://" + hostname + request.getServletPath();
        AJAXRequest.Method method = request.getMethod();
        switch (method) {
            case GET: {
                httpRequest = new HttpGet(Executor.addQueryParamsToUri(urlString, Executor.getGETParameter(session, request)));
                break;
            }
            case POST: {
                HttpPost httpPost = new HttpPost(urlString + Executor.getURLParameter(session, request, true));
                String contentType = Executor.detectContentTypeHeader(request);
                HttpEntity postEntity = "multipart/form-data".equals(contentType) ? Executor.buildMultipartEntity(request) : Executor.getBodyParameters(request);
                httpPost.setEntity(postEntity);
                httpRequest = httpPost;
                break;
            }
            case UPLOAD: {
                HttpPost httpUpload = new HttpPost(urlString + Executor.getURLParameter(session, request, false));
                Executor.addUPLOADParameter(httpUpload, request);
                httpRequest = httpUpload;
                break;
            }
            case PUT: {
                HttpPut httpPut = new HttpPut(urlString + Executor.getURLParameter(session, request, false));
                Object body = request.getBody();
                if (null != body) {
                    ByteArrayEntity entity = new ByteArrayEntity(Executor.createBodyBytes(body));
                    entity.setContentType("text/javascript; charset=UTF-8");
                    httpPut.setEntity((HttpEntity)entity);
                }
                httpRequest = httpPut;
                break;
            }
            default: {
                throw AjaxExceptionCodes.IMVALID_PARAMETER.create(new Object[]{request.getMethod().name()});
            }
        }
        for (Header header : request.getHeaders()) {
            if (method == AJAXRequest.Method.POST) {
                if ("Content-Type".equalsIgnoreCase(header.getName())) continue;
                httpRequest.addHeader(header.getName(), header.getValue());
                continue;
            }
            httpRequest.addHeader(header.getName(), header.getValue());
        }
        String echoHeaderName = AJAXConfig.getProperty(AJAXConfig.Property.ECHO_HEADER, "");
        String echoValue = null;
        if (!Executor.isEmpty(echoHeaderName)) {
            echoValue = "pingMeBack-" + COUNTER.getAndIncrement();
            httpRequest.addHeader(echoHeaderName, echoValue);
        }
        DefaultHttpClient httpClient = session.getHttpClient();
        long startRequest = System.currentTimeMillis();
        HttpResponse response = httpClient.execute((HttpUriRequest)httpRequest);
        long requestDuration = System.currentTimeMillis() - startRequest;
        if (null != echoValue) {
            org.apache.http.Header header = response.getFirstHeader(echoHeaderName);
            if (null == header) {
                Executor.fail((String)("Missing echo header: " + echoHeaderName));
            } else {
                Executor.assertEquals((String)"Wrong echo header", (String)echoValue, (String)header.getValue());
            }
        }
        Executor.syncCookies(httpClient, session.getConversation());
        try {
            Thread.sleep(sleep);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            System.out.println("InterruptedException while sleeping between test requests. Does that help?");
            e.printStackTrace();
        }
        AbstractAJAXParser<T> parser = request.getParser();
        String responseBody = parser.checkResponse(response);
        long startParse = System.currentTimeMillis();
        T retval = parser.parse(responseBody);
        long parseDuration = System.currentTimeMillis() - startParse;
        ((AbstractAJAXResponse)((Object)retval)).setRequestDuration(requestDuration);
        ((AbstractAJAXResponse)((Object)retval)).setParseDuration(parseDuration);
        return retval;
    }

    private static String detectContentTypeHeader(AJAXRequest<?> request) {
        for (Header header : request.getHeaders()) {
            if (!"Content-Type".equalsIgnoreCase(header.getName())) continue;
            return header.getValue();
        }
        return null;
    }

    private static boolean isEmpty(String string) {
        if (null == string) {
            return true;
        }
        int len = string.length();
        boolean isWhitespace = true;
        for (int i = 0; isWhitespace && i < len; ++i) {
            isWhitespace = Character.isWhitespace(string.charAt(i));
        }
        return isWhitespace;
    }

    public static void syncCookies(WebConversation conversation, DefaultHttpClient httpClient, String hostname) {
        String domain = hostname.startsWith("http://") ? hostname.substring(7) : (hostname.startsWith("https://") ? hostname.substring(8) : hostname);
        String[] cookies = conversation.getCookieNames();
        CookieStore cookieStore = httpClient.getCookieStore();
        HashSet<String> storedNames = new HashSet<String>();
        for (org.apache.http.cookie.Cookie cookie : cookieStore.getCookies()) {
            storedNames.add(cookie.getName());
        }
        for (String name : cookies) {
            if (storedNames.contains(name)) continue;
            Cookie cookie = conversation.getCookieDetails(name);
            BasicClientCookie2 newCookie = new BasicClientCookie2(name, cookie.getValue());
            newCookie.setDomain(domain);
            cookieStore.addCookie((org.apache.http.cookie.Cookie)newCookie);
        }
    }

    public static void syncCookies(DefaultHttpClient httpClient, WebConversation conversation) {
        HashSet<String> storedNames = new HashSet<String>();
        for (String name : conversation.getCookieNames()) {
            storedNames.add(name);
        }
        CookieStore cookieStore = httpClient.getCookieStore();
        CookieJar cookieJar = conversation.getCookieJar();
        for (org.apache.http.cookie.Cookie cookie : cookieStore.getCookies()) {
            String name = cookie.getName();
            if (storedNames.contains(name)) continue;
            cookieJar.putCookie(name, cookie.getValue());
        }
    }

    public static WebResponse execute4Download(AJAXSession session, AJAXRequest<?> request, String protocol, String hostname) throws OXException, IOException, JSONException, SAXException {
        GetMethodWebRequest req;
        String urlString = protocol + "://" + hostname + request.getServletPath();
        switch (request.getMethod()) {
            case GET: {
                GetMethodWebRequest get;
                req = get = new GetMethodWebRequest(urlString);
                Executor.addURLParameter((WebRequest)get, session, request);
                break;
            }
            case PUT: {
                PutMethodWebRequest put = new PutMethodWebRequest(Executor.addURLParameter(urlString, session, request), (InputStream)new ByteArrayInputStream(request.getBody().toString().getBytes("US-ASCII")), "text/javascript; charset=us-ascii");
                req = put;
                break;
            }
            default: {
                throw AjaxExceptionCodes.IMVALID_PARAMETER.create(new Object[]{request.getMethod().name()});
            }
        }
        WebConversation conv = session.getConversation();
        WebResponse resp = AJAXRequest.Method.GET == request.getMethod() ? conv.getResource((WebRequest)req) : conv.getResponse((WebRequest)req);
        return resp;
    }

    private static String addURLParameter(String urlString, AJAXSession session, AJAXRequest<?> request) throws IOException, JSONException {
        StringBuilder sb = new StringBuilder(urlString);
        boolean first = true;
        if (null != session.getId()) {
            sb.append('?').append("session").append('=').append(session.getId());
            first = false;
        }
        for (AJAXRequest.Parameter param : request.getParameters()) {
            if (param instanceof AJAXRequest.FileParameter) continue;
            if (first) {
                sb.append('?');
                first = false;
            } else {
                sb.append('&');
            }
            sb.append(Executor.encode(param.getName())).append('=').append(Executor.encode(param.getValue()));
        }
        return sb.toString();
    }

    private static String encode(String s) throws UnsupportedEncodingException {
        return URLEncoder.encode(s, "ISO-8859-1");
    }

    private static void addURLParameter(WebRequest req, AJAXSession session, AJAXRequest<?> request) throws IOException, JSONException {
        if (null != session.getId()) {
            req.setParameter("session", session.getId());
        }
        for (AJAXRequest.Parameter param : request.getParameters()) {
            if (param instanceof AJAXRequest.FileParameter) continue;
            req.setParameter(param.getName(), param.getValue());
        }
    }

    private static String addQueryParamsToUri(String uri, List<NameValuePair> queryParams) {
        Collections.sort(queryParams, new Comparator<NameValuePair>(){

            @Override
            public int compare(NameValuePair o1, NameValuePair o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        uri = uri.contains("?") ? uri + "&" : uri + "?";
        return uri + URLEncodedUtils.format(queryParams, (String)"UTF-8");
    }

    private static List<NameValuePair> getGETParameter(AJAXSession session, AJAXRequest<?> ajaxRequest) throws IOException, JSONException {
        LinkedList<NameValuePair> pairs = new LinkedList<NameValuePair>();
        if (session.getId() != null) {
            pairs.add((NameValuePair)new BasicNameValuePair("session", session.getId()));
        }
        for (AJAXRequest.Parameter param : ajaxRequest.getParameters()) {
            if (param instanceof AJAXRequest.FileParameter) continue;
            pairs.add((NameValuePair)new BasicNameValuePair(param.getName(), param.getValue()));
        }
        return pairs;
    }

    private static void addUPLOADParameter(HttpPost postMethod, AJAXRequest<?> request) throws IOException, JSONException {
        MultipartEntity parts = new MultipartEntity(HttpMultipartMode.BROWSER_COMPATIBLE);
        for (AJAXRequest.Parameter param : request.getParameters()) {
            AJAXRequest.Parameter fparam;
            if (param instanceof AJAXRequest.FieldParameter) {
                fparam = (AJAXRequest.FieldParameter)param;
                StringBody body = new StringBody(((AJAXRequest.FieldParameter)fparam).getFieldContent(), Charset.forName("UTF-8"));
                parts.addPart(new FormBodyPart(((AJAXRequest.FieldParameter)fparam).getFieldName(), (ContentBody)body));
            }
            if (!(param instanceof AJAXRequest.FileParameter)) continue;
            fparam = (AJAXRequest.FileParameter)param;
            InputStream is = ((AJAXRequest.FileParameter)fparam).getInputStream();
            InputStreamBody body = null != ((AJAXRequest.FileParameter)fparam).getMimeType() && !"".equals(((AJAXRequest.FileParameter)fparam).getMimeType()) ? new InputStreamBody(is, ((AJAXRequest.FileParameter)fparam).getMimeType(), fparam.getValue()) : new InputStreamBody(is, fparam.getValue());
            parts.addPart(new FormBodyPart(fparam.getName(), (ContentBody)body));
        }
        postMethod.setEntity((HttpEntity)parts);
    }

    private static HttpEntity getBodyParameters(AJAXRequest<?> request) throws IOException, JSONException {
        LinkedList<BasicNameValuePair> pairs = new LinkedList<BasicNameValuePair>();
        for (AJAXRequest.Parameter param : request.getParameters()) {
            if (!(param instanceof AJAXRequest.FieldParameter)) continue;
            AJAXRequest.FieldParameter fparam = (AJAXRequest.FieldParameter)param;
            pairs.add(new BasicNameValuePair(fparam.getFieldName(), fparam.getFieldContent()));
        }
        return new UrlEncodedFormEntity(pairs);
    }

    private static HttpEntity buildMultipartEntity(AJAXRequest<?> request) throws IOException, JSONException {
        MultipartEntity entity = new MultipartEntity();
        for (AJAXRequest.Parameter param : request.getParameters()) {
            if (!(param instanceof AJAXRequest.FileParameter)) continue;
            entity.addPart(param.getName(), (ContentBody)new InputStreamBody(((AJAXRequest.FileParameter)param).getInputStream(), ((AJAXRequest.FileParameter)param).getMimeType(), ((AJAXRequest.FileParameter)param).getFileName()));
        }
        return entity;
    }

    private static String getURLParameter(AJAXSession session, AJAXRequest<?> request, boolean strict) throws IOException, JSONException {
        URLParameter parameter = new URLParameter();
        if (null != session.getId()) {
            parameter.setParameter("session", session.getId());
        }
        for (AJAXRequest.Parameter param : request.getParameters()) {
            if (!(strict || param instanceof AJAXRequest.FileParameter || param instanceof AJAXRequest.FieldParameter)) {
                parameter.setParameter(param.getName(), param.getValue());
            }
            if (!strict || !(param instanceof AJAXRequest.URLParameter)) continue;
            parameter.setParameter(param.getName(), param.getValue());
        }
        return parameter.getURLParameters();
    }

    private static InputStream createBody(Object body) throws UnsupportedCharsetException {
        return new ByteArrayInputStream(body.toString().getBytes(Charsets.UTF_8));
    }

    private static byte[] createBodyBytes(Object body) throws UnsupportedCharsetException {
        return body.toString().getBytes(Charsets.UTF_8);
    }

    private static int getSleep() {
        int sleep;
        String sleepS;
        try {
            sleepS = AJAXConfig.getProperty(AJAXConfig.Property.SLEEP);
        }
        catch (NullPointerException e) {
            sleepS = null;
        }
        try {
            sleep = Integer.parseInt(sleepS);
        }
        catch (NumberFormatException e) {
            sleep = 500;
        }
        return sleep;
    }
}

