/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.folder;

import com.openexchange.ajax.folder.Create;
import com.openexchange.ajax.folder.actions.API;
import com.openexchange.ajax.folder.actions.DeleteRequest;
import com.openexchange.ajax.folder.actions.EnumAPI;
import com.openexchange.ajax.folder.actions.GetRequest;
import com.openexchange.ajax.folder.actions.GetResponse;
import com.openexchange.ajax.folder.actions.InsertRequest;
import com.openexchange.ajax.folder.actions.InsertResponse;
import com.openexchange.ajax.folder.actions.UpdateRequest;
import com.openexchange.ajax.framework.AJAXClient;
import com.openexchange.ajax.framework.AJAXRequest;
import com.openexchange.ajax.framework.AbstractAJAXSession;
import com.openexchange.ajax.framework.CommonDeleteResponse;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.server.impl.OCLPermission;
import java.io.IOException;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;

public class FunctionTests
extends AbstractAJAXSession {
    private AJAXClient client;
    private AJAXClient client2;

    public FunctionTests(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.client = this.getClient();
        this.client2 = new AJAXClient(AJAXClient.User.User2);
    }

    @Override
    protected void tearDown() throws Exception {
        this.client2.logout();
        super.tearDown();
    }

    public void testUnknownAction() throws IOException, JSONException, OXException {
        GetResponse response = this.client.execute(new UnknownActionRequest(EnumAPI.OX_OLD, 2, false));
        FunctionTests.assertTrue((String)"JSON response should contain an error message.", (boolean)response.hasError());
        OXException exception = response.getException();
        String error = exception.getErrorCode();
        FunctionTests.assertTrue((String)("Error is not the expected one: \"" + error + "\""), (boolean)error.equals("SVL-0001"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testInsertUpdateFolder() throws OXException, IOException, JSONException, OXException, OXException {
        FolderObject toDelete = null;
        int userId1 = this.client.getValues().getUserId();
        int userId2 = this.client2.getValues().getUserId();
        try {
            FolderObject folder = Create.createPrivateFolder("ChangeMyPermissions" + System.currentTimeMillis(), 2, userId1, new OCLPermission[0]);
            folder.setParentFolderID(1);
            InsertResponse insertR = this.client.execute(new InsertRequest(EnumAPI.OX_OLD, folder));
            GetResponse getR = this.client.execute(new GetRequest((API)EnumAPI.OX_OLD, insertR.getId()));
            toDelete = getR.getFolder();
            toDelete.setLastModified(getR.getTimestamp());
            FolderObject inserted = getR.getFolder();
            FolderObject update = new FolderObject();
            update.setParentFolderID(inserted.getParentFolderID());
            update.setObjectID(inserted.getObjectID());
            update.setLastModified(insertR.getTimestamp());
            update.addPermission(Create.ocl(userId1, false, true, 128, 128, 128, 128));
            update.addPermission(Create.ocl(userId2, false, false, 4, 0, 0, 0));
            this.client.execute(new UpdateRequest(EnumAPI.OX_OLD, update));
            getR = this.client.execute(new GetRequest((API)EnumAPI.OX_OLD, insertR.getId()));
            toDelete = getR.getFolder();
            toDelete.setLastModified(getR.getTimestamp());
        }
        catch (Throwable throwable) {
            this.client.execute(new DeleteRequest((API)EnumAPI.OX_OLD, toDelete));
            throw throwable;
        }
        this.client.execute(new DeleteRequest((API)EnumAPI.OX_OLD, toDelete));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testFailDeleteFolder() throws OXException, IOException, JSONException, OXException, OXException {
        FolderObject child02;
        FolderObject child01;
        FolderObject parent;
        block25: {
            int userId = this.client.getValues().getUserId();
            int secId = this.client2.getValues().getUserId();
            parent = null;
            child01 = null;
            child02 = null;
            FolderObject subChild01 = null;
            try {
                OCLPermission[] perms = new OCLPermission[]{Create.ocl(userId, false, true, 8, 128, 128, 128), Create.ocl(secId, false, false, 8, 128, 128, 128)};
                FolderObject folder = Create.folder(2, "DeleteMeImmediately", 2, 2, perms);
                InsertResponse response = this.client.execute(new InsertRequest(EnumAPI.OX_NEW, folder));
                GetResponse response2 = this.client.execute(new GetRequest((API)EnumAPI.OX_NEW, response.getId()));
                parent = response2.getFolder();
                parent.setLastModified(response2.getTimestamp());
                folder = Create.folder(parent.getObjectID(), "DeleteMeImmediatelyChild01", 2, 2, perms);
                response = this.client.execute(new InsertRequest(EnumAPI.OX_NEW, folder));
                response2 = this.client.execute(new GetRequest((API)EnumAPI.OX_NEW, response.getId()));
                child01 = response2.getFolder();
                child01.setLastModified(response2.getTimestamp());
                folder = Create.folder(parent.getObjectID(), "DeleteMeImmediatelyChild02", 2, 2, perms);
                response = this.client.execute(new InsertRequest(EnumAPI.OX_NEW, folder));
                response2 = this.client.execute(new GetRequest((API)EnumAPI.OX_NEW, response.getId()));
                child02 = response2.getFolder();
                child02.setLastModified(response2.getTimestamp());
                perms = new OCLPermission[]{Create.ocl(userId, false, false, 8, 128, 128, 128), Create.ocl(secId, false, true, 8, 128, 128, 128)};
                folder = Create.folder(child01.getObjectID(), "NonDeleteableSubChild01", 2, 2, perms);
                folder.setCreator(secId);
                folder.setCreatedBy(secId);
                response = this.client2.execute(new InsertRequest(EnumAPI.OX_NEW, folder));
                response2 = this.client.execute(new GetRequest((API)EnumAPI.OX_NEW, response.getId()));
                subChild01 = response2.getFolder();
                subChild01.setLastModified(response2.getTimestamp());
                CommonDeleteResponse response3 = this.client.execute(new DeleteRequest((API)EnumAPI.OX_NEW, false, parent));
                JSONArray notDeleted = (JSONArray)response3.getData();
                FunctionTests.assertEquals((String)"Expected identifier of not deletable folder.", (int)1, (int)notDeleted.length());
                FunctionTests.assertEquals((String)"Wrong folder identifier", (int)parent.getObjectID(), (int)notDeleted.getInt(0));
                if (null == subChild01) break block25;
            }
            catch (Throwable throwable) {
                if (null != subChild01) {
                    try {
                        this.client2.execute(new DeleteRequest((API)EnumAPI.OX_NEW, subChild01));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                if (null != child02) {
                    try {
                        this.client.execute(new DeleteRequest((API)EnumAPI.OX_NEW, child02));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                if (null != child01) {
                    try {
                        this.client.execute(new DeleteRequest((API)EnumAPI.OX_NEW, child01));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                if (null != parent) {
                    try {
                        this.client.execute(new DeleteRequest((API)EnumAPI.OX_NEW, parent));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                throw throwable;
            }
            try {
                this.client2.execute(new DeleteRequest((API)EnumAPI.OX_NEW, subChild01));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (null != child02) {
            try {
                this.client.execute(new DeleteRequest((API)EnumAPI.OX_NEW, child02));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (null != child01) {
            try {
                this.client.execute(new DeleteRequest((API)EnumAPI.OX_NEW, child01));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (null != parent) {
            try {
                this.client.execute(new DeleteRequest((API)EnumAPI.OX_NEW, parent));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private class UnknownActionRequest
    extends GetRequest {
        UnknownActionRequest(API api, int folderId, boolean failOnError) {
            super(api, folderId, failOnError);
        }

        @Override
        protected void addParameters(List<AJAXRequest.Parameter> params) {
            params.add(new AJAXRequest.Parameter("action", "unknown"));
            params.add(new AJAXRequest.Parameter("id", this.getFolderIdentifier()));
            params.add(new AJAXRequest.Parameter("columns", this.getColumns()));
        }
    }
}

