/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.find.contacts;

import com.openexchange.ajax.find.actions.AutocompleteRequest;
import com.openexchange.ajax.find.actions.AutocompleteResponse;
import com.openexchange.ajax.find.contacts.ContactsFindTest;
import com.openexchange.find.Module;
import com.openexchange.find.facet.FacetValue;
import com.openexchange.groupware.container.Contact;

public class AutocompleteTest
extends ContactsFindTest {
    public AutocompleteTest(String name) {
        super(name);
    }

    public void noTestAutocompleteCurrentUser() throws Exception {
        String defaultAddress = this.client.getValues().getDefaultAddress();
        this.assertFoundFacetInAutocomplete(defaultAddress.substring(0, 3), defaultAddress);
    }

    public void noTestAutocompleteOtherContact() throws Exception {
        Contact contact = this.manager.newAction(this.randomContact());
        this.assertFoundFacetInAutocomplete(contact.getDisplayName().substring(0, 3), contact.getEmail1());
        this.assertFoundFacetInAutocomplete(contact.getSurName().substring(0, 4), contact.getEmail1());
        this.assertFoundFacetInAutocomplete(contact.getGivenName().substring(0, 5), contact.getEmail1());
        this.assertFoundFacetInAutocomplete(contact.getEmail1().substring(0, 3), contact.getEmail1());
    }

    private FacetValue assertFoundFacetInAutocomplete(String prefix, String expectedEmail1) throws Exception {
        AutocompleteRequest autocompleteRequest = new AutocompleteRequest(prefix, Module.CONTACTS.getIdentifier());
        AutocompleteResponse autocompleteResponse = this.client.execute(autocompleteRequest);
        FacetValue foundFacetValue = AutocompleteTest.findByDisplayName(autocompleteResponse.getFacets(), expectedEmail1);
        AutocompleteTest.assertNotNull((String)("no facet value found for: " + expectedEmail1), (Object)foundFacetValue);
        return foundFacetValue;
    }
}

