/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.appointment.recurrence;

import com.openexchange.ajax.AppointmentTest;
import com.openexchange.ajax.appointment.helper.AbstractAssertion;
import com.openexchange.ajax.appointment.helper.AbstractPositiveAssertion;
import com.openexchange.ajax.appointment.helper.NegativeAssertionOnCreate;
import com.openexchange.ajax.appointment.helper.NegativeAssertionOnUpdate;
import com.openexchange.ajax.appointment.helper.PositiveAssertionOnCreate;
import com.openexchange.ajax.appointment.helper.PositiveAssertionOnCreateAndUpdate;
import com.openexchange.ajax.appointment.helper.PositiveAssertionOnDeleteException;
import com.openexchange.ajax.appointment.helper.PositiveAssertionOnUpdateOnly;
import com.openexchange.ajax.appointment.recurrence.NegativeAssertionOnChangeException;
import com.openexchange.ajax.appointment.recurrence.NegativeAssertionOnDeleteException;
import com.openexchange.ajax.appointment.recurrence.PositiveAssertionOnChangeException;
import com.openexchange.ajax.framework.UserValues;
import com.openexchange.groupware.calendar.TimeTools;
import com.openexchange.groupware.container.Appointment;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.groupware.modules.Module;
import com.openexchange.test.CalendarTestManager;
import com.openexchange.test.FolderTestManager;
import com.openexchange.test.ResourceTestManager;
import java.util.Date;
import java.util.TimeZone;

public abstract class ManagedAppointmentTest
extends AppointmentTest {
    protected CalendarTestManager calendarManager;
    protected FolderTestManager folderManager;
    protected ResourceTestManager resourceManager;
    protected FolderObject folder;
    protected TimeZone utc = TimeZone.getTimeZone("UTC");
    protected TimeZone userTimeZone;
    protected NegativeAssertionOnUpdate negativeAssertionOnUpdate;
    protected NegativeAssertionOnCreate negativeAssertionOnCreate;
    protected NegativeAssertionOnChangeException negativeAssertionOnChangeException;
    protected NegativeAssertionOnDeleteException negativeAssertionOnDeleteException;
    protected AbstractPositiveAssertion positiveAssertionOnCreate;
    protected PositiveAssertionOnCreateAndUpdate positiveAssertionOnCreateAndUpdate;
    protected PositiveAssertionOnUpdateOnly positiveAssertionOnUpdate;
    protected PositiveAssertionOnChangeException positiveAssertionOnChangeException;
    protected PositiveAssertionOnDeleteException positiveAssertionOnDeleteException;

    public ManagedAppointmentTest(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.calendarManager = new CalendarTestManager(this.getClient());
        this.folderManager = new FolderTestManager(this.getClient());
        this.resourceManager = new ResourceTestManager(this.getClient());
        UserValues values = this.getClient().getValues();
        this.userTimeZone = values.getTimeZone();
        this.folder = this.folderManager.generatePublicFolder("MAT_" + new Date().getTime(), Module.CALENDAR.getFolderConstant(), values.getPrivateAppointmentFolder(), values.getUserId());
        this.folder = this.folderManager.insertFolderOnServer(this.folder);
        this.negativeAssertionOnUpdate = new NegativeAssertionOnUpdate(this.calendarManager, this.folder.getObjectID());
        this.negativeAssertionOnCreate = new NegativeAssertionOnCreate(this.calendarManager, this.folder.getObjectID());
        this.negativeAssertionOnChangeException = new NegativeAssertionOnChangeException(this.calendarManager, this.folder.getObjectID());
        this.negativeAssertionOnDeleteException = new NegativeAssertionOnDeleteException(this.calendarManager, this.folder.getObjectID());
        this.positiveAssertionOnCreateAndUpdate = new PositiveAssertionOnCreateAndUpdate(this.calendarManager, this.folder.getObjectID());
        this.positiveAssertionOnCreate = new PositiveAssertionOnCreate(this.calendarManager, this.folder.getObjectID());
        this.positiveAssertionOnUpdate = new PositiveAssertionOnUpdateOnly(this.calendarManager, this.folder.getObjectID());
        this.positiveAssertionOnChangeException = new PositiveAssertionOnChangeException(this.calendarManager, this.folder.getObjectID());
        this.positiveAssertionOnDeleteException = new PositiveAssertionOnDeleteException(this.calendarManager, this.folder.getObjectID());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void tearDown() throws Exception {
        try {
            this.calendarManager.cleanUp();
        }
        finally {
            try {
                this.folderManager.cleanUp();
            }
            finally {
                try {
                    this.resourceManager.cleanUp();
                }
                finally {
                    super.tearDown();
                }
            }
        }
    }

    protected Appointment generateDailyAppointment() {
        Appointment app = AbstractAssertion.generateDefaultAppointment(this.folder.getObjectID());
        app.set(209, (Object)1);
        app.set(215, (Object)1);
        return app;
    }

    protected Appointment generateMonthlyAppointment() {
        Appointment app = AbstractAssertion.generateDefaultAppointment(this.folder.getObjectID());
        app.set(209, (Object)3);
        app.set(215, (Object)1);
        app.set(213, (Object)1);
        return app;
    }

    protected Appointment generateYearlyAppointment() {
        Appointment app = AbstractAssertion.generateDefaultAppointment(this.folder.getObjectID());
        app.set(209, (Object)4);
        app.set(215, (Object)1);
        app.set(213, (Object)1);
        app.set(214, (Object)0);
        return app;
    }

    protected Date D(String dateString) {
        return TimeTools.D(dateString);
    }

    protected Date D(String dateString, TimeZone tz) {
        return TimeTools.D(dateString, tz);
    }
}

