/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.appointment.bugtests;

import com.openexchange.ajax.appointment.action.AllRequest;
import com.openexchange.ajax.appointment.action.AppointmentInsertResponse;
import com.openexchange.ajax.appointment.action.AppointmentUpdatesResponse;
import com.openexchange.ajax.appointment.action.DeleteRequest;
import com.openexchange.ajax.appointment.action.GetRequest;
import com.openexchange.ajax.appointment.action.GetResponse;
import com.openexchange.ajax.appointment.action.InsertRequest;
import com.openexchange.ajax.appointment.action.ListRequest;
import com.openexchange.ajax.appointment.action.UpdatesRequest;
import com.openexchange.ajax.framework.AJAXClient;
import com.openexchange.ajax.framework.AJAXRequest;
import com.openexchange.ajax.framework.AbstractAJAXResponse;
import com.openexchange.ajax.framework.AbstractAJAXSession;
import com.openexchange.ajax.framework.AbstractColumnsResponse;
import com.openexchange.ajax.framework.CommonAllResponse;
import com.openexchange.ajax.framework.CommonListResponse;
import com.openexchange.ajax.framework.ListIDs;
import com.openexchange.groupware.calendar.TimeTools;
import com.openexchange.groupware.container.Appointment;
import com.openexchange.java.Autoboxing;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import org.json.JSONArray;
import org.json.JSONObject;

public class Bug13960Test
extends AbstractAJAXSession {
    private static final int[] COLUMNS = new int[]{1, 206, 207};
    private AJAXClient client;
    private TimeZone timeZone;
    private Appointment appointment;

    public Bug13960Test(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.client = this.getClient();
        this.timeZone = this.client.getValues().getTimeZone();
        this.appointment = new Appointment();
        this.appointment.setTitle("Appointment for bug 13960");
        this.appointment.setIgnoreConflicts(true);
        this.appointment.setParentFolderID(this.client.getValues().getPrivateAppointmentFolder());
        Calendar calendar = TimeTools.createCalendar(this.timeZone);
        this.appointment.setStartDate(calendar.getTime());
        calendar.add(10, 1);
        this.appointment.setEndDate(calendar.getTime());
        InsertRequest request = new InsertRequest(this.appointment, this.timeZone);
        AppointmentInsertResponse response = this.client.execute(request);
        response.fillAppointment(this.appointment);
    }

    @Override
    protected void tearDown() throws Exception {
        this.client.execute(new DeleteRequest(this.appointment));
        super.tearDown();
    }

    public void testJSONValues() throws Throwable {
        int row;
        AJAXRequest<GetResponse> request = new GetRequest(this.appointment);
        AbstractAJAXResponse response = this.client.execute(request);
        JSONObject json = (JSONObject)response.getData();
        Bug13960Test.assertFalse((boolean)json.has("recurrence_id"));
        Bug13960Test.assertFalse((boolean)json.has("recurrence_position"));
        request = new UpdatesRequest(this.appointment.getParentFolderID(), COLUMNS, new Date(this.appointment.getLastModified().getTime() - 1L), true);
        response = (AppointmentUpdatesResponse)((Object)this.client.execute(request));
        int idPos = ((AbstractColumnsResponse)response).getColumnPos(1);
        for (row = 0; row < ((AbstractColumnsResponse)response).getArray().length && !((AbstractColumnsResponse)response).getArray()[row][idPos].equals(Autoboxing.I((int)this.appointment.getObjectID())); ++row) {
        }
        JSONArray array = ((JSONArray)response.getData()).getJSONArray(row);
        int recurrenceIdPos = ((AbstractColumnsResponse)response).getColumnPos(206);
        Bug13960Test.assertEquals((Object)JSONObject.NULL, (Object)array.get(recurrenceIdPos));
        int recurrencePositionPos = ((AbstractColumnsResponse)response).getColumnPos(207);
        Bug13960Test.assertEquals((Object)JSONObject.NULL, (Object)array.get(recurrencePositionPos));
        request = new ListRequest(ListIDs.l(new int[][]{{this.appointment.getParentFolderID(), this.appointment.getObjectID()}}), COLUMNS);
        response = (CommonListResponse)((Object)this.client.execute(request));
        JSONArray array2 = ((JSONArray)response.getData()).getJSONArray(0);
        int recurrenceIdPos2 = ((AbstractColumnsResponse)response).getColumnPos(206);
        Bug13960Test.assertEquals((Object)JSONObject.NULL, (Object)array2.get(recurrenceIdPos2));
        int recurrencePositionPos2 = ((AbstractColumnsResponse)response).getColumnPos(207);
        Bug13960Test.assertEquals((Object)JSONObject.NULL, (Object)array2.get(recurrencePositionPos2));
        request = new AllRequest(this.appointment.getParentFolderID(), COLUMNS, this.appointment.getStartDate(), this.appointment.getEndDate(), this.timeZone);
        response = (CommonAllResponse)((Object)this.client.execute(request));
        idPos = ((AbstractColumnsResponse)response).getColumnPos(1);
        for (row = 0; row < ((AbstractColumnsResponse)response).getArray().length && !((AbstractColumnsResponse)response).getArray()[row][idPos].equals(Autoboxing.I((int)this.appointment.getObjectID())); ++row) {
        }
        array = ((JSONArray)response.getData()).getJSONArray(row);
        recurrenceIdPos = ((AbstractColumnsResponse)response).getColumnPos(206);
        Bug13960Test.assertEquals((Object)JSONObject.NULL, (Object)array.get(recurrenceIdPos));
        recurrencePositionPos = ((AbstractColumnsResponse)response).getColumnPos(207);
        Bug13960Test.assertEquals((Object)JSONObject.NULL, (Object)array.get(recurrencePositionPos));
    }
}

