/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.smtp.dataobjects;

import com.openexchange.exception.OXException;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.mail.dataobjects.MailPart;
import com.openexchange.mail.dataobjects.compose.ComposedMailMessage;
import com.openexchange.mail.dataobjects.compose.TextBodyMailPart;
import com.openexchange.session.Session;
import com.openexchange.smtp.dataobjects.SMTPBodyPart;
import java.io.InputStream;
import java.util.ArrayList;
import javax.activation.DataHandler;

public final class SMTPMailMessage
extends ComposedMailMessage {
    private static final long serialVersionUID = 9031153888416594901L;
    private TextBodyMailPart mailPart;
    private String uid;
    private final ArrayList<MailPart> enclosedParts;

    public SMTPMailMessage(String htmlMailBody, Session session, Context ctx) {
        super(session, ctx);
        this.mailPart = new SMTPBodyPart(htmlMailBody);
        this.enclosedParts = new ArrayList();
    }

    public SMTPMailMessage(Session session, Context ctx) {
        super(session, ctx);
        this.enclosedParts = new ArrayList();
    }

    public Object getContent() throws OXException {
        return this.mailPart.getContent();
    }

    public void setBodyPart(TextBodyMailPart mailPart) {
        this.mailPart = mailPart;
    }

    public TextBodyMailPart getBodyPart() {
        return this.mailPart;
    }

    public DataHandler getDataHandler() throws OXException {
        return this.mailPart.getDataHandler();
    }

    public int getEnclosedCount() throws OXException {
        return this.enclosedParts.size();
    }

    public MailPart getEnclosedMailPart(int index) throws OXException {
        return this.enclosedParts.get(index);
    }

    public InputStream getInputStream() throws OXException {
        return this.mailPart.getInputStream();
    }

    public void loadContent() {
    }

    public void prepareForCaching() {
        this.mailPart.prepareForCaching();
    }

    public MailPart removeEnclosedPart(int index) {
        return this.enclosedParts.remove(index);
    }

    public void addEnclosedPart(MailPart part) {
        this.enclosedParts.add(part);
    }

    public String getMailId() {
        return this.uid;
    }

    public void setMailId(String id) {
        this.uid = id;
    }
}

