/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.webdav.xml.resources;

import com.openexchange.exception.OXException;
import com.openexchange.tools.collections.Injector;
import com.openexchange.tools.collections.OXCollections;
import com.openexchange.webdav.protocol.WebdavProtocolException;
import com.openexchange.webdav.protocol.WebdavResource;
import com.openexchange.webdav.xml.resources.ResourceMarshaller;
import java.util.ArrayList;
import java.util.List;
import org.jdom2.Element;

public class RecursiveMarshaller
implements ResourceMarshaller {
    private final ResourceMarshaller delegate;
    private final int depth;

    public RecursiveMarshaller(ResourceMarshaller delegate, int depth) {
        this.delegate = delegate;
        this.depth = depth;
    }

    @Override
    public List<Element> marshal(WebdavResource resource) throws WebdavProtocolException {
        ArrayList<Element> list = new ArrayList<Element>();
        final ResourceMarshaller delegate = this.delegate;
        List<Element> delegateMarshal = delegate.marshal(resource);
        list.addAll(delegateMarshal);
        if (resource.isCollection()) {
            try {
                OXCollections.inject(list, resource.toCollection().toIterable(this.depth), new Injector<List<Element>, WebdavResource>(){

                    @Override
                    public List<Element> inject(List<Element> list, WebdavResource element) {
                        try {
                            list.addAll(delegate.marshal(element));
                        }
                        catch (OXException oXException) {
                            // empty catch block
                        }
                        return list;
                    }
                });
            }
            catch (OXException e) {
                return list;
            }
        }
        return list;
    }
}

