/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.tools.versit.valuedefinitions.rfc2445;

import com.openexchange.tools.versit.Property;
import com.openexchange.tools.versit.StringScanner;
import com.openexchange.tools.versit.ValueDefinition;
import com.openexchange.tools.versit.VersitException;
import java.io.IOException;

public class TextValueDefinition
extends ValueDefinition {
    public static final ValueDefinition Default = new TextValueDefinition();

    @Override
    public Object createValue(StringScanner s, Property property) throws IOException {
        StringBuilder sb = new StringBuilder();
        block5: while (s.peek >= 0 && s.peek != 44 && s.peek != 59) {
            if (s.peek == 92) {
                s.read();
                switch (s.peek) {
                    case 44: 
                    case 58: 
                    case 59: 
                    case 92: {
                        sb.append((char)s.read());
                        continue block5;
                    }
                    case 82: 
                    case 114: {
                        s.read();
                        sb.append('\r');
                        continue block5;
                    }
                    case 78: 
                    case 110: {
                        s.read();
                        sb.append('\n');
                        continue block5;
                    }
                }
                throw new VersitException(s, "Invalid ecape sequence");
            }
            sb.append((char)s.read());
        }
        return sb.length() == 0 ? null : sb.toString();
    }

    @Override
    public String writeValue(Object value) {
        String str = (String)value;
        int length = str.length();
        StringBuilder sb = new StringBuilder(length);
        block5: for (int i = 0; i < length; ++i) {
            char c = str.charAt(i);
            switch (c) {
                case '\r': {
                    if (i + 1 < length && str.charAt(i + 1) == '\n') {
                        ++i;
                    }
                }
                case '\n': {
                    sb.append("\\n");
                    continue block5;
                }
                case ',': 
                case ';': 
                case '\\': {
                    sb.append('\\');
                }
                default: {
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }
}

