/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.tools.versit.valuedefinitions.rfc2445;

import com.openexchange.tools.TimeZoneUtils;
import com.openexchange.tools.versit.Parameter;
import com.openexchange.tools.versit.Property;
import com.openexchange.tools.versit.StringScanner;
import com.openexchange.tools.versit.ValueDefinition;
import com.openexchange.tools.versit.VersitException;
import com.openexchange.tools.versit.values.DateTimeValue;
import java.io.IOException;
import java.text.DecimalFormat;

public class DateTimeValueDefinition
extends ValueDefinition {
    public static final ValueDefinition Default = new DateTimeValueDefinition();
    private static final DecimalFormat YearFormat = new DecimalFormat("0000");
    private static final DecimalFormat Format = new DecimalFormat("00");

    @Override
    public Object createValue(StringScanner s, Property property) throws IOException {
        DateTimeValue date = new DateTimeValue();
        this.parseDate(s, date);
        if (s.peek != 84) {
            throw new VersitException(s, "Date and time expected");
        }
        s.read();
        this.parseTime(s, date, property);
        return date;
    }

    protected void parseDate(StringScanner s, DateTimeValue date) throws IOException {
        date.calendar.set(1, s.parseNumber(4));
        date.calendar.set(2, s.parseNumber(2) - 1);
        date.calendar.set(5, s.parseNumber(2));
    }

    protected void parseTime(StringScanner s, DateTimeValue date, Property property) throws IOException {
        date.calendar.set(11, s.parseNumber(2));
        date.calendar.set(12, s.parseNumber(2));
        date.calendar.set(13, s.parseNumber(2));
        if (s.peek == 90) {
            s.read();
            date.calendar.setTimeZone(DateTimeValue.GMT);
            return;
        }
        date.isUTC = false;
        Parameter tzid = property.getParameter("TZID");
        if (tzid == null) {
            date.isFloating = true;
            return;
        }
        String tz_str = tzid.getValue(0).getText();
        if (tz_str.charAt(0) == '/') {
            date.calendar.setTimeZone(TimeZoneUtils.getTimeZone(tz_str.substring(1)));
        } else {
            date.needsVTIMEZONE = true;
        }
    }

    @Override
    public String writeValue(Object value) {
        DateTimeValue date = (DateTimeValue)value;
        return this.writeDate(date) + 'T' + this.writeTime(date);
    }

    protected String writeDate(DateTimeValue value) {
        return YearFormat.format(value.calendar.get(1)) + Format.format(value.calendar.get(2) + 1) + Format.format(value.calendar.get(5));
    }

    protected String writeTime(DateTimeValue value) {
        StringBuilder sb = new StringBuilder();
        sb.append(Format.format(value.calendar.get(11)));
        sb.append(Format.format(value.calendar.get(12)));
        sb.append(Format.format(value.calendar.get(13)));
        if (value.isUTC) {
            sb.append('Z');
        }
        return sb.toString();
    }
}

