/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.tools.versit.valuedefinitions.rfc2425;

import com.openexchange.tools.versit.Property;
import com.openexchange.tools.versit.StringScanner;
import com.openexchange.tools.versit.ValueDefinition;
import java.io.IOException;
import java.util.ArrayList;

public class ListValueDefinition
extends ValueDefinition {
    private final char Separator;
    private final ValueDefinition Definition;

    public ListValueDefinition(char separator, ValueDefinition definition) {
        this.Separator = separator;
        this.Definition = definition;
    }

    @Override
    public Object createValue(StringScanner s, Property property) throws IOException {
        ArrayList<Object> retval = new ArrayList<Object>();
        while (true) {
            Object val = this.Definition.createValue(s, property);
            retval.add(val);
            if (s.peek != this.Separator) break;
            s.read();
        }
        return retval.isEmpty() ? null : retval;
    }

    @Override
    public String writeValue(Object value) {
        ArrayList list = (ArrayList)value;
        int count = list.size();
        if (count == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        Object val = list.get(0);
        if (val != null) {
            sb.append(this.Definition.writeValue(val));
        }
        for (int i = 1; i < count; ++i) {
            sb.append(this.Separator);
            val = list.get(i);
            if (val == null) continue;
            sb.append(this.Definition.writeValue(val));
        }
        return sb.toString();
    }
}

