/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.tools.versit.old;

import com.openexchange.tools.versit.Property;
import com.openexchange.tools.versit.StringScanner;
import com.openexchange.tools.versit.VersitException;
import com.openexchange.tools.versit.old.OldParamDefinition;
import com.openexchange.tools.versit.old.OldPropertyDefinition;
import com.openexchange.tools.versit.old.OldScanner;
import com.openexchange.tools.versit.valuedefinitions.rfc2445.DateOrDateTimeValueDefinition;
import com.openexchange.tools.versit.values.DateTimeValue;
import com.openexchange.tools.versit.values.RecurrenceValue;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.regex.Pattern;

public class OldRecurrencePropertyDefinition
extends OldPropertyDefinition {
    private static final String[] weekdays = new String[]{"SU", "MO", "TU", "WE", "TH", "FR", "SA"};
    private static final Pattern WeekNo = Pattern.compile("[1-5][+-]");
    private static final Pattern DayNo = Pattern.compile("([0-9]{1,2}[+-]?|LD)(?![0-9#])");
    private static final Pattern Num = Pattern.compile("[0-9]{1,3}(?![0-9#])");

    public OldRecurrencePropertyDefinition(String[] paramNames, OldParamDefinition[] params) {
        super(paramNames, params);
    }

    @Override
    protected Object parseValue(Property property, OldScanner s, byte[] value, String charset) throws IOException {
        StringScanner ss = new StringScanner(s, new String(value, charset).trim().toUpperCase());
        RecurrenceValue recur = new RecurrenceValue();
        block0 : switch (ss.peek) {
            case 68: {
                recur.Freq = 3;
                ss.read();
                recur.Interval = ss.parseNumber();
                ss.skipWS();
                break;
            }
            case 87: {
                recur.Freq = 4;
                ss.read();
                recur.Interval = ss.parseNumber();
                ss.skipWS();
                while (ss.peek >= 65 && ss.peek <= 90) {
                    recur.ByDay.add(new RecurrenceValue.Weekday(0, this.parseWeekday(ss)));
                    ss.skipWS();
                }
                break;
            }
            case 77: {
                recur.Freq = 5;
                ss.read();
                switch (ss.peek) {
                    case 80: {
                        ss.read();
                        recur.Interval = ss.parseNumber();
                        ss.skipWS();
                        int weekNo = 0;
                        String week = ss.regex(WeekNo);
                        while (week != null || ss.peek >= 65 && ss.peek <= 90) {
                            if (week != null) {
                                weekNo = (week.charAt(0) - 48) * (week.charAt(1) == '-' ? -1 : 1);
                            } else {
                                if (weekNo == 0) {
                                    throw new VersitException(ss, "Invalid recurrence");
                                }
                                recur.ByDay.add(new RecurrenceValue.Weekday(weekNo, this.parseWeekday(ss)));
                            }
                            ss.skipWS();
                            week = ss.regex(WeekNo);
                        }
                        break block0;
                    }
                    case 68: {
                        ss.read();
                        recur.Interval = ss.parseNumber();
                        ss.skipWS();
                        String day = ss.regex(DayNo);
                        ArrayList<Integer> days = new ArrayList<Integer>();
                        while (day != null) {
                            if ("LD".equals(day)) {
                                day = "1-";
                            }
                            int sign = 1;
                            switch (day.charAt(day.length() - 1)) {
                                case '-': {
                                    sign = -1;
                                }
                                case '+': {
                                    day = day.substring(0, day.length() - 1);
                                }
                            }
                            days.add(Integer.parseInt(day) * sign);
                            ss.skipWS();
                            day = ss.regex(DayNo);
                        }
                        recur.ByMonthDay = new int[days.size()];
                        for (int i = 0; i < recur.ByMonthDay.length; ++i) {
                            recur.ByMonthDay[i] = (Integer)days.get(i);
                        }
                        break block0;
                    }
                    default: {
                        throw new VersitException(ss, "Invalid recurrence");
                    }
                }
            }
            case 89: {
                boolean month;
                recur.Freq = 6;
                ss.read();
                switch (ss.peek) {
                    case 77: {
                        month = true;
                        break;
                    }
                    case 68: {
                        month = false;
                        break;
                    }
                    default: {
                        throw new VersitException(ss, "Invalid recurrence");
                    }
                }
                ss.read();
                recur.Interval = ss.parseNumber();
                ss.skipWS();
                String val = ss.regex(Num);
                ArrayList<Integer> values = new ArrayList<Integer>();
                while (val != null) {
                    values.add(Integer.parseInt(val));
                    ss.skipWS();
                    val = ss.regex(Num);
                }
                int[] vs = new int[values.size()];
                for (int i = 0; i < vs.length; ++i) {
                    vs[i] = (Integer)values.get(i);
                }
                if (month) {
                    recur.ByMonth = vs;
                    break;
                }
                recur.ByYearDay = vs;
                break;
            }
            default: {
                throw new VersitException(ss, "Invalid recurrence");
            }
        }
        if (ss.peek == 35) {
            ss.read();
            recur.Count = ss.parseNumber();
            ss.skipWS();
        }
        if (ss.peek >= 48 && ss.peek <= 57) {
            recur.Until = (DateTimeValue)DateOrDateTimeValueDefinition.Default.createValue(ss, property);
        }
        if (recur.Count == -1 && recur.Until == null) {
            recur.Count = 2;
        }
        if (recur.Count == 0) {
            recur.Count = -1;
        }
        return recur;
    }

    private int parseWeekday(StringScanner s) throws IOException {
        String weekday = String.valueOf((char)s.read()) + (char)s.read();
        for (int i = 0; i < 7; ++i) {
            if (!weekday.equals(weekdays[i])) continue;
            return 1 + i;
        }
        throw new VersitException(s, "Invalid recurrence: " + weekday);
    }

    @Override
    protected String writeValue(Property property) {
        StringBuilder sb = new StringBuilder();
        RecurrenceValue recur = (RecurrenceValue)property.getValue();
        switch (recur.Freq) {
            case 3: {
                sb.append('D');
                sb.append(recur.Interval);
                break;
            }
            case 4: {
                sb.append('W');
                sb.append(recur.Interval);
                int weeklySize = recur.ByDay.size();
                Iterator<RecurrenceValue.Weekday> weeklyIter = recur.ByDay.iterator();
                for (int k = 0; k < weeklySize; ++k) {
                    sb.append(' ');
                    sb.append(weekdays[weeklyIter.next().day - 1]);
                }
                break;
            }
            case 5: {
                sb.append('M');
                if (recur.ByDay.size() > 0) {
                    sb.append('P');
                    sb.append(recur.Interval);
                    int occurrence = 0;
                    int monthlySize = recur.ByDay.size();
                    Iterator<RecurrenceValue.Weekday> monthlyIter = recur.ByDay.iterator();
                    for (int k = 0; k < monthlySize; ++k) {
                        RecurrenceValue.Weekday day = monthlyIter.next();
                        if (day.week != occurrence) {
                            sb.append(' ');
                            sb.append(Math.abs(day.week));
                            sb.append(day.week < 0 ? (char)'-' : '+');
                            occurrence = day.week;
                        }
                        sb.append(' ');
                        sb.append(weekdays[day.day]);
                    }
                } else {
                    sb.append('D');
                    sb.append(recur.Interval);
                    for (int i = 0; i < recur.ByMonthDay.length; ++i) {
                        sb.append(' ');
                        sb.append(Math.abs(recur.ByMonthDay[i]));
                        if (recur.ByMonthDay[i] >= 0) continue;
                        sb.append('-');
                    }
                }
                break;
            }
            case 6: {
                sb.append('Y');
                if (recur.ByMonth.length > 0) {
                    sb.append('M');
                    sb.append(recur.Interval);
                    for (int i = 0; i < recur.ByMonth.length; ++i) {
                        sb.append(' ');
                        sb.append(recur.ByMonth[i]);
                    }
                } else {
                    sb.append('D');
                    sb.append(recur.Interval);
                    for (int i = 0; i < recur.ByYearDay.length; ++i) {
                        sb.append(' ');
                        sb.append(recur.ByYearDay[i]);
                    }
                }
                break;
            }
        }
        switch (recur.Count) {
            case -1: {
                if (recur.Until == null) {
                    sb.append(" #0");
                }
            }
            case 2: {
                break;
            }
            default: {
                sb.append(" #");
                sb.append(recur.Count);
            }
        }
        if (recur.Until != null) {
            sb.append(' ');
            sb.append(DateOrDateTimeValueDefinition.Default.writeValue(recur.Until));
        }
        return sb.toString();
    }
}

