/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.tools.versit;

import com.openexchange.tools.versit.VersitDefinition;
import com.openexchange.tools.versit.VersitException;
import java.io.IOException;
import java.util.ArrayList;

public abstract class Scanner
implements VersitDefinition.Reader {
    public int peek;
    protected int Column;
    protected int Line;
    protected boolean strict;

    protected Scanner() {
    }

    public void setStrict(boolean strict) {
        this.strict = strict;
    }

    public boolean isStrict() {
        return this.strict;
    }

    public int getColumn() {
        return this.Column;
    }

    public int getLine() {
        return this.Line;
    }

    public void skipWS() throws IOException {
        while (this.peek == 9 || this.peek == 32) {
            this.read();
        }
    }

    public String parseName() throws IOException {
        StringBuilder sb = new StringBuilder();
        while (this.peek >= 65 && this.peek <= 90 || this.peek >= 97 && this.peek <= 122 || this.peek == 45 || this.peek >= 48 && this.peek <= 57) {
            sb.append((char)this.read());
        }
        return sb.toString();
    }

    public int parseNumber() throws IOException {
        if (this.peek < 48 || this.peek > 57) {
            throw new VersitException(this, "Number expected");
        }
        int retval = 0;
        while (this.peek >= 48 && this.peek <= 57) {
            retval = retval * 10 + this.read() - 48;
        }
        return retval;
    }

    public void parseNumber(StringBuffer sb) throws IOException {
        if (this.peek < 48 || this.peek > 57) {
            throw new IOException("Number expected");
        }
        do {
            sb.append((char)this.read());
        } while (this.peek >= 48 && this.peek <= 57);
    }

    public int parseNumber(int digits) throws IOException {
        int retval = 0;
        for (int i = 0; i < digits; ++i) {
            if (this.peek < 48 || this.peek > 57) {
                if (!this.strict) break;
                throw new VersitException(this, digits + "-digit number expected");
            }
            retval = retval * 10 + this.read() - 48;
        }
        return retval;
    }

    public void parseNumber(StringBuffer sb, int digits) throws IOException {
        for (int i = 0; i < digits; ++i) {
            if (this.peek < 48 || this.peek > 57) {
                if (!this.strict) break;
                throw new IOException(digits + "-digit number expected");
            }
            sb.append((char)this.read());
        }
    }

    public boolean optionalNumber(StringBuffer sb) throws IOException {
        if (this.peek < 48 || this.peek > 57) {
            return false;
        }
        sb.setLength(0);
        while (this.peek >= 48 && this.peek <= 57) {
            sb.append((char)this.read());
        }
        return true;
    }

    public int[] parseNumList() throws IOException {
        int i;
        ArrayList<Integer> list = new ArrayList<Integer>();
        while (true) {
            int sign = 1;
            if (this.peek == 43) {
                this.read();
            } else if (this.peek == 45) {
                sign = -1;
                this.read();
            }
            i = this.parseNumber();
            list.add(i * sign);
            if (this.peek != 44) break;
            this.read();
        }
        int[] retval = new int[list.size()];
        for (i = 0; i < retval.length; ++i) {
            retval[i] = (Integer)list.get(i);
        }
        return retval;
    }

    public int read() throws IOException {
        int retval = this.peek;
        this.peek = this.readImpl();
        return retval;
    }

    protected abstract int readImpl() throws IOException;
}

