/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.tools.oxfolder.deletelistener.sql;

import com.openexchange.tools.oxfolder.deletelistener.CorruptPermission;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;

public final class DetectCorruptPermissions {
    private static final String SQL_SEL_INVALID_USER_PERMS = "SELECT op.cid, op.fuid, op.permission_id FROM oxfolder_permissions as op WHERE op.cid = ? AND op.group_flag = 0 AND op.permission_id NOT IN (SELECT id FROM user AS u WHERE u.cid = op.cid)";
    private static final String SQL_SEL_INVALID_GROUP_PERM = "SELECT cid, fuid, permission_id FROM oxfolder_permissions AS op WHERE op.cid = ? AND op.group_flag = 1 AND op.permission_id != 0 AND op.permission_id NOT IN (SELECT id FROM groups AS g WHERE g.cid = op.cid)";

    private DetectCorruptPermissions() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CorruptPermission[] detectCorruptUserPermissions(int cid, Connection readCon) throws SQLException {
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = readCon.prepareStatement(SQL_SEL_INVALID_USER_PERMS);
            stmt.setInt(1, cid);
            rs = stmt.executeQuery();
            if (!rs.next()) {
                CorruptPermission[] corruptPermissionArray = null;
                return corruptPermissionArray;
            }
            ArrayList<CorruptPermission> l = new ArrayList<CorruptPermission>();
            do {
                l.add(new CorruptPermission(rs.getInt(1), rs.getInt(2), rs.getInt(3)));
            } while (rs.next());
            CorruptPermission[] corruptPermissionArray = l.toArray(new CorruptPermission[l.size()]);
            return corruptPermissionArray;
        }
        finally {
            if (null != rs) {
                try {
                    rs.close();
                    rs = null;
                }
                catch (SQLException e) {
                    System.err.println("Warning: Result set could not be properly closed");
                    e.printStackTrace(System.err);
                }
            }
            if (null != stmt) {
                try {
                    stmt.close();
                }
                catch (SQLException e) {
                    System.err.println("Warning: Statement could not be properly closed");
                    e.printStackTrace(System.err);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CorruptPermission[] detectCorruptGroupPermissions(int cid, Connection readCon) throws SQLException {
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = readCon.prepareStatement(SQL_SEL_INVALID_GROUP_PERM);
            stmt.setInt(1, cid);
            rs = stmt.executeQuery();
            if (!rs.next()) {
                CorruptPermission[] corruptPermissionArray = null;
                return corruptPermissionArray;
            }
            ArrayList<CorruptPermission> l = new ArrayList<CorruptPermission>();
            do {
                l.add(new CorruptPermission(rs.getInt(1), rs.getInt(2), rs.getInt(3)));
            } while (rs.next());
            CorruptPermission[] corruptPermissionArray = l.toArray(new CorruptPermission[l.size()]);
            return corruptPermissionArray;
        }
        finally {
            if (null != rs) {
                try {
                    rs.close();
                    rs = null;
                }
                catch (SQLException e) {
                    System.err.println("Warning: Result set could not be properly closed");
                    e.printStackTrace(System.err);
                }
            }
            if (null != stmt) {
                try {
                    stmt.close();
                }
                catch (SQLException e) {
                    System.err.println("Warning: Statement could not be properly closed");
                    e.printStackTrace(System.err);
                }
            }
        }
    }
}

