/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.resource.json;

import com.openexchange.ajax.requesthandler.AJAXActionService;
import com.openexchange.ajax.requesthandler.AJAXActionServiceFactory;
import com.openexchange.documentation.annotations.Module;
import com.openexchange.exception.OXException;
import com.openexchange.resource.json.actions.AbstractResourceAction;
import com.openexchange.resource.json.actions.AllAction;
import com.openexchange.resource.json.actions.GetAction;
import com.openexchange.resource.json.actions.ListAction;
import com.openexchange.resource.json.actions.SearchAction;
import com.openexchange.resource.json.actions.UpdatesAction;
import com.openexchange.server.ServiceLookup;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

@Module(name="resource", description="Allows to query available resources. It is mainly used by the dialog for the selection of participants.")
@com.openexchange.ajax.requesthandler.Module(actions={"get", "all", "list", "search", "updates"})
public class ResourceActionFactory
implements AJAXActionServiceFactory {
    private final Map<String, AbstractResourceAction> actions = new ConcurrentHashMap<String, AbstractResourceAction>(5);

    public ResourceActionFactory(ServiceLookup services) {
        this.actions.put("get", new GetAction(services));
        this.actions.put("all", new AllAction(services));
        this.actions.put("list", new ListAction(services));
        this.actions.put("search", new SearchAction(services));
        this.actions.put("updates", new UpdatesAction(services));
    }

    @Override
    public AJAXActionService createActionService(String action) throws OXException {
        return this.actions.get(action);
    }

    public Collection<? extends AJAXActionService> getSupportedServices() {
        return Collections.unmodifiableCollection(this.actions.values());
    }
}

