/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mailaccount.json.actions;

import com.openexchange.exception.OXException;
import com.openexchange.mail.api.MailAccess;
import com.openexchange.mail.api.MailConfig;
import com.openexchange.mail.dataobjects.MailFolder;
import com.openexchange.mail.json.writer.FolderWriter;
import com.openexchange.mailaccount.json.actions.AbstractMailAccountAction;
import com.openexchange.tools.session.ServerSession;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractMailAccountTreeAction
extends AbstractMailAccountAction {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractMailAccountTreeAction.class);

    protected AbstractMailAccountTreeAction() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static JSONObject actionValidateTree0(MailAccess<?, ?> mailAccess, ServerSession session) throws JSONException {
        boolean close = false;
        try {
            mailAccess.connect();
            close = true;
            JSONObject root = FolderWriter.writeMailFolder(-1, mailAccess.getRootFolder(), mailAccess.getMailConfig(), session);
            AbstractMailAccountTreeAction.addSubfolders(root, mailAccess.getFolderStorage().getSubfolders("default", true), mailAccess, mailAccess.getMailConfig(), session);
            JSONObject jSONObject = root;
            return jSONObject;
        }
        catch (OXException e) {
            LOG.debug("Composing mail account's folder tree failed.", (Throwable)e);
            JSONObject jSONObject = null;
            return jSONObject;
        }
        finally {
            if (close) {
                mailAccess.close(false);
            }
        }
    }

    protected static void addSubfolders(JSONObject parent, MailFolder[] subfolders, MailAccess<?, ?> mailAccess, MailConfig mailConfig, ServerSession session) throws JSONException, OXException {
        if (subfolders.length == 0) {
            return;
        }
        JSONArray subfolderArray = new JSONArray();
        parent.put("subfolder_array", (Object)subfolderArray);
        for (MailFolder subfolder : subfolders) {
            JSONObject subfolderObject = FolderWriter.writeMailFolder(-1, subfolder, mailConfig, session);
            subfolderArray.put((Object)subfolderObject);
            AbstractMailAccountTreeAction.addSubfolders(subfolderObject, mailAccess.getFolderStorage().getSubfolders(subfolder.getFullname(), true), mailAccess, mailConfig, session);
        }
    }
}

