/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mailaccount;

import com.openexchange.exception.OXException;
import com.openexchange.mailaccount.AttributeSwitch;
import gnu.trove.map.TIntObjectMap;
import gnu.trove.map.hash.TIntObjectHashMap;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;

public enum Attribute {
    ID_LITERAL("id", 1001),
    LOGIN_LITERAL("login", 1002),
    PASSWORD_LITERAL("password", 1003),
    MAIL_URL_LITERAL("mail_url", 1004),
    TRANSPORT_URL_LITERAL("transport_url", 1005),
    NAME_LITERAL("name", 1006),
    PRIMARY_ADDRESS_LITERAL("primary_address", 1007),
    SPAM_HANDLER_LITERAL("spam_handler", 1008),
    TRASH_LITERAL("trash", 1009),
    SENT_LITERAL("sent", 1010),
    DRAFTS_LITERAL("drafts", 1011),
    SPAM_LITERAL("spam", 1012),
    CONFIRMED_SPAM_LITERAL("confirmed_spam", 1013),
    CONFIRMED_HAM_LITERAL("confirmed_ham", 1014),
    MAIL_SERVER_LITERAL("mail_server", 1015),
    MAIL_PORT_LITERAL("mail_port", 1016),
    MAIL_PROTOCOL_LITERAL("mail_protocol", 1017),
    MAIL_SECURE_LITERAL("mail_secure", 1018),
    TRANSPORT_SERVER_LITERAL("transport_server", 1019),
    TRANSPORT_PORT_LITERAL("transport_port", 1020),
    TRANSPORT_PROTOCOL_LITERAL("transport_protocol", 1021),
    TRANSPORT_SECURE_LITERAL("transport_secure", 1022),
    TRANSPORT_LOGIN_LITERAL("transport_login", 1023),
    TRANSPORT_PASSWORD_LITERAL("transport_password", 1024),
    UNIFIED_INBOX_ENABLED_LITERAL("unified_inbox_enabled", 1025),
    TRASH_FULLNAME_LITERAL("trash_fullname", 1026),
    SENT_FULLNAME_LITERAL("sent_fullname", 1027),
    DRAFTS_FULLNAME_LITERAL("drafts_fullname", 1028),
    SPAM_FULLNAME_LITERAL("spam_fullname", 1029),
    CONFIRMED_SPAM_FULLNAME_LITERAL("confirmed_spam_fullname", 1030),
    CONFIRMED_HAM_FULLNAME_LITERAL("confirmed_ham_fullname", 1031),
    POP3_REFRESH_RATE_LITERAL("pop3_refresh_rate", 1032),
    POP3_EXPUNGE_ON_QUIT_LITERAL("pop3_expunge_on_quit", 1033),
    POP3_DELETE_WRITE_THROUGH_LITERAL("pop3_delete_write_through", 1034),
    POP3_STORAGE_LITERAL("pop3_storage", 1035),
    POP3_PATH_LITERAL("pop3_path", 1036),
    PERSONAL_LITERAL("personal", 1037),
    REPLY_TO_LITERAL("reply_to", 1038),
    ADDRESSES("addresses", 1039),
    META("meta", 1040),
    ARCHIVE_LITERAL("archive", 1041),
    ARCHIVE_FULLNAME_LITERAL("archive_fullname", 1042);

    public static final Set<Attribute> MAIL_URL_ATTRIBUTES;
    public static final Set<Attribute> TRANSPORT_URL_ATTRIBUTES;
    public static final EnumSet<Attribute> DEFAULT;
    public static final EnumSet<Attribute> DEFAULT_FULL_NAMES;
    private int id;
    private String attrName;
    private static TIntObjectMap<Attribute> byId;

    private Attribute(String name, int id) {
        this.attrName = name;
        this.id = id;
    }

    public Object doSwitch(AttributeSwitch switcher) throws OXException {
        switch (this) {
            case ID_LITERAL: {
                return switcher.id();
            }
            case LOGIN_LITERAL: {
                return switcher.login();
            }
            case PASSWORD_LITERAL: {
                return switcher.password();
            }
            case MAIL_URL_LITERAL: {
                return switcher.mailURL();
            }
            case TRANSPORT_URL_LITERAL: {
                return switcher.transportURL();
            }
            case NAME_LITERAL: {
                return switcher.name();
            }
            case PRIMARY_ADDRESS_LITERAL: {
                return switcher.primaryAddress();
            }
            case PERSONAL_LITERAL: {
                return switcher.personal();
            }
            case REPLY_TO_LITERAL: {
                return switcher.replyTo();
            }
            case SPAM_HANDLER_LITERAL: {
                return switcher.spamHandler();
            }
            case TRASH_LITERAL: {
                return switcher.trash();
            }
            case DRAFTS_LITERAL: {
                return switcher.drafts();
            }
            case SPAM_LITERAL: {
                return switcher.spam();
            }
            case SENT_LITERAL: {
                return switcher.sent();
            }
            case CONFIRMED_SPAM_LITERAL: {
                return switcher.confirmedSpam();
            }
            case CONFIRMED_HAM_LITERAL: {
                return switcher.confirmedHam();
            }
            case MAIL_SERVER_LITERAL: {
                return switcher.mailServer();
            }
            case MAIL_PORT_LITERAL: {
                return switcher.mailPort();
            }
            case MAIL_PROTOCOL_LITERAL: {
                return switcher.mailProtocol();
            }
            case MAIL_SECURE_LITERAL: {
                return switcher.mailSecure();
            }
            case TRANSPORT_SERVER_LITERAL: {
                return switcher.transportServer();
            }
            case TRANSPORT_PORT_LITERAL: {
                return switcher.transportPort();
            }
            case TRANSPORT_PROTOCOL_LITERAL: {
                return switcher.transportProtocol();
            }
            case TRANSPORT_SECURE_LITERAL: {
                return switcher.transportSecure();
            }
            case TRANSPORT_LOGIN_LITERAL: {
                return switcher.transportLogin();
            }
            case TRANSPORT_PASSWORD_LITERAL: {
                return switcher.transportPassword();
            }
            case UNIFIED_INBOX_ENABLED_LITERAL: {
                return switcher.unifiedINBOXEnabled();
            }
            case TRASH_FULLNAME_LITERAL: {
                return switcher.trashFullname();
            }
            case DRAFTS_FULLNAME_LITERAL: {
                return switcher.draftsFullname();
            }
            case SPAM_FULLNAME_LITERAL: {
                return switcher.spamFullname();
            }
            case SENT_FULLNAME_LITERAL: {
                return switcher.sentFullname();
            }
            case CONFIRMED_SPAM_FULLNAME_LITERAL: {
                return switcher.confirmedSpamFullname();
            }
            case CONFIRMED_HAM_FULLNAME_LITERAL: {
                return switcher.confirmedHamFullname();
            }
            case POP3_DELETE_WRITE_THROUGH_LITERAL: {
                return switcher.pop3DeleteWriteThrough();
            }
            case POP3_EXPUNGE_ON_QUIT_LITERAL: {
                return switcher.pop3ExpungeOnQuit();
            }
            case POP3_REFRESH_RATE_LITERAL: {
                return switcher.pop3RefreshRate();
            }
            case POP3_STORAGE_LITERAL: {
                return switcher.pop3Storage();
            }
            case POP3_PATH_LITERAL: {
                return switcher.pop3Path();
            }
            case ADDRESSES: {
                return switcher.addresses();
            }
            case ARCHIVE_FULLNAME_LITERAL: {
                return switcher.archiveFullname();
            }
            case ARCHIVE_LITERAL: {
                return switcher.archive();
            }
            case META: {
                return null;
            }
        }
        throw new IllegalArgumentException(this.getName());
    }

    public String getName() {
        return this.attrName;
    }

    public int getId() {
        return this.id;
    }

    public static Attribute getById(int col) {
        return (Attribute)((Object)byId.get(col));
    }

    static {
        MAIL_URL_ATTRIBUTES = Collections.unmodifiableSet(EnumSet.of(MAIL_PORT_LITERAL, MAIL_PROTOCOL_LITERAL, MAIL_SECURE_LITERAL, MAIL_SERVER_LITERAL));
        TRANSPORT_URL_ATTRIBUTES = Collections.unmodifiableSet(EnumSet.of(TRANSPORT_PORT_LITERAL, TRANSPORT_PROTOCOL_LITERAL, TRANSPORT_SECURE_LITERAL, TRANSPORT_SERVER_LITERAL));
        DEFAULT = EnumSet.of(CONFIRMED_HAM_FULLNAME_LITERAL, new Attribute[]{CONFIRMED_HAM_LITERAL, CONFIRMED_SPAM_FULLNAME_LITERAL, CONFIRMED_SPAM_LITERAL, DRAFTS_FULLNAME_LITERAL, DRAFTS_LITERAL, SENT_FULLNAME_LITERAL, SENT_LITERAL, SPAM_FULLNAME_LITERAL, SPAM_LITERAL, TRASH_FULLNAME_LITERAL, TRASH_LITERAL});
        DEFAULT_FULL_NAMES = EnumSet.of(CONFIRMED_HAM_FULLNAME_LITERAL, new Attribute[]{CONFIRMED_SPAM_FULLNAME_LITERAL, DRAFTS_FULLNAME_LITERAL, SENT_FULLNAME_LITERAL, SPAM_FULLNAME_LITERAL, TRASH_FULLNAME_LITERAL});
        byId = new TIntObjectHashMap();
        for (Attribute attribute : Attribute.values()) {
            byId.put(attribute.getId(), (Object)attribute);
        }
    }
}

