/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.parser.handlers;

import com.openexchange.data.conversion.ical.ICalParser;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.contexts.impl.ContextStorage;
import com.openexchange.groupware.ldap.UserStorage;
import com.openexchange.html.HtmlService;
import com.openexchange.image.ImageLocation;
import com.openexchange.java.Streams;
import com.openexchange.java.Strings;
import com.openexchange.mail.MailExceptionCode;
import com.openexchange.mail.MailJSONField;
import com.openexchange.mail.MailListField;
import com.openexchange.mail.MailPath;
import com.openexchange.mail.attachment.AttachmentToken;
import com.openexchange.mail.attachment.AttachmentTokenRegistry;
import com.openexchange.mail.conversion.InlineImageDataSource;
import com.openexchange.mail.dataobjects.MailMessage;
import com.openexchange.mail.dataobjects.MailPart;
import com.openexchange.mail.json.writer.MessageWriter;
import com.openexchange.mail.mime.ContentType;
import com.openexchange.mail.mime.HeaderName;
import com.openexchange.mail.mime.MessageHeaders;
import com.openexchange.mail.mime.MimeDefaultSession;
import com.openexchange.mail.mime.MimeMailException;
import com.openexchange.mail.mime.MimeType2ExtMap;
import com.openexchange.mail.mime.converters.MimeMessageConverter;
import com.openexchange.mail.mime.utils.MimeMessageUtility;
import com.openexchange.mail.parser.MailMessageHandler;
import com.openexchange.mail.parser.MailMessageParser;
import com.openexchange.mail.text.Enriched2HtmlConverter;
import com.openexchange.mail.text.HtmlProcessing;
import com.openexchange.mail.usersetting.UserSettingMail;
import com.openexchange.mail.utils.DisplayMode;
import com.openexchange.mail.utils.MailFolderUtility;
import com.openexchange.mail.uuencode.UUEncodedPart;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.session.Session;
import com.openexchange.tools.TimeZoneUtils;
import com.openexchange.tools.session.ServerSession;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import javax.mail.MessagingException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JsonMessageHandler
implements MailMessageHandler {
    private static final Logger LOG = LoggerFactory.getLogger(JsonMessageHandler.class);
    private static final String CONTENT = MailJSONField.CONTENT.getKey();
    private static final String DISPOSITION = MailJSONField.DISPOSITION.getKey();
    private static final String SIZE = MailJSONField.SIZE.getKey();
    private static final String CONTENT_TYPE = MailJSONField.CONTENT_TYPE.getKey();
    private static final String ID = MailListField.ID.getKey();
    private static final String PRIORITY = MailJSONField.PRIORITY.getKey();
    private static final String NESTED_MESSAGES = MailJSONField.NESTED_MESSAGES.getKey();
    private static final String ATTACHMENTS = MailJSONField.ATTACHMENTS.getKey();
    private static final String ACCOUNT_ID = MailJSONField.ACCOUNT_ID.getKey();
    private static final String ACCOUNT_NAME = MailJSONField.ACCOUNT_NAME.getKey();
    private static final String HAS_ATTACHMENTS = MailJSONField.HAS_ATTACHMENTS.getKey();
    private static final String UNREAD = MailJSONField.UNREAD.getKey();
    private static final String ATTACHMENT_FILE_NAME = MailJSONField.ATTACHMENT_FILE_NAME.getKey();
    private static final String FROM = MailJSONField.FROM.getKey();
    private static final String CID = MailJSONField.CID.getKey();
    private static final String COLOR_LABEL = MailJSONField.COLOR_LABEL.getKey();
    private static final String RECIPIENT_CC = MailJSONField.RECIPIENT_CC.getKey();
    private static final String RECIPIENT_BCC = MailJSONField.RECIPIENT_BCC.getKey();
    private static final String HEADERS = MailJSONField.HEADERS.getKey();
    private static final String VIRTUAL = "___VIRTUAL___";
    private static final String MULTIPART_ID = "___MP-ID___";
    private final Session session;
    private final Context ctx;
    private final LinkedList<MultipartInfo> multiparts = new LinkedList();
    private TimeZone timeZone;
    private final UserSettingMail usm;
    private final DisplayMode displayMode;
    private final int accountId;
    private final MailPath mailPath;
    private final JSONObject jsonObject;
    private JSONArray attachmentsArr;
    private JSONArray nestedMsgsArr;
    private boolean isAlternative;
    private String altId;
    private boolean textAppended;
    private boolean textWasEmpty;
    private final boolean[] modified;
    private PlainTextContent plainText;
    private String tokenFolder;
    private String tokenMailId;
    private final boolean token;
    private final int ttlMillis;
    private final boolean embedded;
    private boolean attachHTMLAlternativePart;
    private boolean includePlainText;
    private boolean exactLength;
    private static final Set<HeaderName> COVERED_HEADER_NAMES = new HashSet<HeaderName>(Arrays.asList(MessageHeaders.CONTENT_DISPOSITION, MessageHeaders.CONTENT_ID, MessageHeaders.CONTENT_TYPE, MessageHeaders.BCC, MessageHeaders.CC, MessageHeaders.DATE, MessageHeaders.DISP_NOT_TO, MessageHeaders.FROM, MessageHeaders.X_PRIORITY, MessageHeaders.SUBJECT, MessageHeaders.TO));
    private static final Enriched2HtmlConverter ENRCONV = new Enriched2HtmlConverter();

    public JsonMessageHandler(int accountId, String mailPath, DisplayMode displayMode, boolean embedded, Session session, UserSettingMail usm, boolean token, int ttlMillis) throws OXException {
        this.embedded = embedded;
        this.attachHTMLAlternativePart = !usm.isSuppressHTMLAlternativePart();
        this.accountId = accountId;
        this.modified = new boolean[1];
        this.session = session;
        this.ctx = JsonMessageHandler.getContext(session);
        this.usm = usm;
        this.displayMode = displayMode;
        this.mailPath = new MailPath(mailPath);
        this.jsonObject = new JSONObject(32);
        this.token = token;
        this.ttlMillis = ttlMillis;
    }

    public JsonMessageHandler(int accountId, MailPath mailPath, MailMessage mail, DisplayMode displayMode, boolean embedded, Session session, UserSettingMail usm, boolean token, int ttlMillis) throws OXException {
        this(accountId, mailPath, mail, displayMode, embedded, session, usm, JsonMessageHandler.getContext(session), token, ttlMillis);
    }

    private static Context getContext(Session session) throws OXException {
        if (session instanceof ServerSession) {
            return ((ServerSession)session).getContext();
        }
        return ContextStorage.getStorageContext(session.getContextId());
    }

    private JsonMessageHandler(int accountId, MailPath mailPath, MailMessage mail, DisplayMode displayMode, boolean embedded, Session session, UserSettingMail usm, Context ctx, boolean token, int ttlMillis) throws OXException {
        this.embedded = embedded;
        this.attachHTMLAlternativePart = !usm.isSuppressHTMLAlternativePart();
        this.ttlMillis = ttlMillis;
        this.token = token;
        this.accountId = accountId;
        this.modified = new boolean[1];
        this.session = session;
        this.ctx = ctx;
        this.usm = usm;
        this.displayMode = displayMode;
        this.mailPath = mailPath;
        this.jsonObject = new JSONObject(32);
        try {
            if (DisplayMode.MODIFYABLE.equals((Object)this.displayMode) && null != mailPath) {
                this.jsonObject.put(MailJSONField.MSGREF.getKey(), (Object)mailPath.toString());
            }
            if (null != mail) {
                int unreadMessages;
                String mailId = mail.getMailId();
                if (mail.containsFolder() && mailId != null) {
                    this.tokenFolder = MailFolderUtility.prepareFullname(accountId, mail.getFolder());
                    this.jsonObject.put("folder_id", (Object)this.tokenFolder);
                    this.tokenMailId = mailId;
                    this.jsonObject.put("id", (Object)mailId);
                }
                if ((unreadMessages = mail.getUnreadMessages()) >= 0) {
                    this.jsonObject.put(UNREAD, unreadMessages);
                }
                this.jsonObject.put(HAS_ATTACHMENTS, mail.containsHasAttachment() ? mail.hasAttachment() : mail.getContentType().isMimeType("multipart/mixed"));
                this.jsonObject.put(CONTENT_TYPE, (Object)mail.getContentType().getBaseType());
                this.jsonObject.put(SIZE, mail.getSize());
                this.jsonObject.put(ACCOUNT_NAME, (Object)mail.getAccountName());
                this.jsonObject.put(ACCOUNT_ID, mail.getAccountId());
            }
        }
        catch (JSONException e) {
            throw MailExceptionCode.JSON_ERROR.create(e, e.getMessage());
        }
    }

    public JsonMessageHandler setExactLength(boolean exactLength) {
        this.exactLength = exactLength;
        return this;
    }

    public JsonMessageHandler setAttachHTMLAlternativePart(boolean attachHTMLAlternativePart) {
        this.attachHTMLAlternativePart = attachHTMLAlternativePart;
        return this;
    }

    public JsonMessageHandler setIncludePlainText(boolean includePlainText) {
        this.includePlainText = includePlainText;
        return this;
    }

    private JSONArray getAttachmentsArr() throws JSONException {
        if (this.attachmentsArr == null) {
            this.attachmentsArr = new JSONArray();
            this.jsonObject.put(ATTACHMENTS, (Object)this.attachmentsArr);
        }
        return this.attachmentsArr;
    }

    private JSONArray getNestedMsgsArr() throws JSONException {
        if (this.nestedMsgsArr == null) {
            this.nestedMsgsArr = new JSONArray();
            this.jsonObject.put(NESTED_MESSAGES, (Object)this.nestedMsgsArr);
        }
        return this.nestedMsgsArr;
    }

    private TimeZone getTimeZone() throws OXException {
        if (this.timeZone == null) {
            this.timeZone = this.session instanceof ServerSession ? TimeZoneUtils.getTimeZone(((ServerSession)this.session).getUser().getTimeZone()) : TimeZoneUtils.getTimeZone(UserStorage.getInstance().getUser(this.session.getUserId(), this.ctx).getTimeZone());
        }
        return this.timeZone;
    }

    public JsonMessageHandler setTimeZone(TimeZone timeZone) {
        this.timeZone = timeZone;
        return this;
    }

    private void addToken(JSONObject jsonObject, String attachmentId) {
        if (this.token && null != this.tokenFolder && null != this.tokenMailId) {
            try {
                AttachmentToken token = new AttachmentToken(this.ttlMillis <= 0 ? 3600000L : (long)this.ttlMillis);
                token.setAccessInfo(this.accountId, this.session);
                token.setAttachmentInfo(this.tokenFolder, this.tokenMailId, attachmentId);
                AttachmentTokenRegistry.getInstance().putToken(token, this.session);
                JSONObject attachmentObject = new JSONObject(2);
                attachmentObject.put("id", (Object)token.getId());
                attachmentObject.put("jsessionid", (Object)token.getJSessionId());
                jsonObject.put("token", (Object)attachmentObject);
            }
            catch (Exception e) {
                LOG.warn("Adding attachment token failed.", (Throwable)e);
            }
        }
    }

    @Override
    public boolean handleAttachment(MailPart part, boolean isInline, String baseContentType, String fileName, String id) throws OXException {
        if (isInline && this.isAlternative && null != this.altId && id.startsWith(this.altId) && baseContentType.startsWith("text/xml")) {
            return true;
        }
        return this.handleAttachment0(part, isInline, null, baseContentType, fileName, id);
    }

    private boolean handleAttachment0(MailPart part, boolean isInline, String disposition, String baseContentType, String fileName, String id) throws OXException {
        try {
            String contentId;
            JSONObject jsonObject = new JSONObject(8);
            String attachmentId = part.containsSequenceId() ? part.getSequenceId() : id;
            jsonObject.put(ID, (Object)attachmentId);
            if (fileName == null) {
                Object val;
                if (isInline) {
                    val = JSONObject.NULL;
                } else {
                    val = MailMessageParser.generateFilename(id, baseContentType);
                    part.setFileName((String)val);
                }
                jsonObject.put(ATTACHMENT_FILE_NAME, val);
            } else {
                jsonObject.put(ATTACHMENT_FILE_NAME, (Object)fileName);
            }
            boolean checkSize = true;
            if (this.exactLength) {
                try {
                    jsonObject.put(SIZE, Streams.countInputStream((InputStream)part.getInputStream()));
                    checkSize = false;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (checkSize && part.containsSize()) {
                jsonObject.put(SIZE, part.getSize());
            }
            jsonObject.put(DISPOSITION, (Object)(null == disposition ? "attachment" : disposition));
            if (part.containsContentId() && (contentId = part.getContentId()) != null) {
                jsonObject.put(CID, (Object)contentId);
            }
            ContentType clone = new ContentType();
            clone.setContentType(part.getContentType());
            clone.removeNameParameter();
            jsonObject.put(CONTENT_TYPE, (Object)clone.toString());
            jsonObject.put(CONTENT, JSONObject.NULL);
            this.addToken(jsonObject, attachmentId);
            this.getAttachmentsArr().put((Object)jsonObject);
            return true;
        }
        catch (JSONException e) {
            throw MailExceptionCode.JSON_ERROR.create(e, e.getMessage());
        }
    }

    @Override
    public boolean handleBccRecipient(InternetAddress[] recipientAddrs) throws OXException {
        try {
            this.jsonObject.put(RECIPIENT_BCC, (Object)MessageWriter.getAddressesAsArray(recipientAddrs));
        }
        catch (JSONException e) {
            throw MailExceptionCode.JSON_ERROR.create(e, e.getMessage());
        }
        return true;
    }

    @Override
    public boolean handleCcRecipient(InternetAddress[] recipientAddrs) throws OXException {
        try {
            this.jsonObject.put(RECIPIENT_CC, (Object)MessageWriter.getAddressesAsArray(recipientAddrs));
        }
        catch (JSONException e) {
            throw MailExceptionCode.JSON_ERROR.create(e, e.getMessage());
        }
        return true;
    }

    @Override
    public boolean handleColorLabel(int colorLabel) throws OXException {
        try {
            this.jsonObject.put(COLOR_LABEL, colorLabel);
        }
        catch (JSONException e) {
            throw MailExceptionCode.JSON_ERROR.create(e, e.getMessage());
        }
        return true;
    }

    @Override
    public boolean handleContentId(String contentId) throws OXException {
        try {
            this.jsonObject.put(CID, (Object)contentId);
        }
        catch (JSONException e) {
            throw MailExceptionCode.JSON_ERROR.create(e, e.getMessage());
        }
        return true;
    }

    @Override
    public boolean handleFrom(InternetAddress[] fromAddrs) throws OXException {
        try {
            this.jsonObject.put(FROM, (Object)MessageWriter.getAddressesAsArray(fromAddrs));
        }
        catch (JSONException e) {
            throw MailExceptionCode.JSON_ERROR.create(e, e.getMessage());
        }
        return true;
    }

    @Override
    public boolean handleHeaders(int size, Iterator<Map.Entry<String, String>> iter) throws OXException {
        if (size == 0) {
            return true;
        }
        try {
            JSONObject hdrObject = new JSONObject(size);
            int i = size;
            while (i-- > 0) {
                Map.Entry<String, String> entry = iter.next();
                String headerName = entry.getKey();
                if ("Disposition-Notification-To".equalsIgnoreCase(headerName)) continue;
                if ("Importance".equalsIgnoreCase(headerName)) {
                    int priority = 3;
                    if (null == entry.getValue()) continue;
                    priority = MimeMessageConverter.parseImportance(entry.getValue());
                    this.jsonObject.put(PRIORITY, priority);
                    continue;
                }
                if ("X-Priority".equalsIgnoreCase(headerName)) {
                    if (this.jsonObject.has(PRIORITY)) continue;
                    int priority = 3;
                    if (null != entry.getValue()) {
                        priority = MimeMessageConverter.parsePriority(entry.getValue());
                    }
                    this.jsonObject.put(PRIORITY, priority);
                    continue;
                }
                if ("X-Mailer".equalsIgnoreCase(headerName)) {
                    hdrObject.put(headerName, (Object)entry.getValue());
                    continue;
                }
                if ("X-OX-VCard-Attached".equalsIgnoreCase(headerName)) {
                    this.jsonObject.put(MailJSONField.VCARD.getKey(), true);
                    continue;
                }
                if ("X-OX-Notification".equalsIgnoreCase(headerName)) {
                    this.jsonObject.put(MailJSONField.DISPOSITION_NOTIFICATION_TO.getKey(), (Object)entry.getValue());
                    continue;
                }
                if (COVERED_HEADER_NAMES.contains(HeaderName.valueOf(headerName))) continue;
                if (hdrObject.has(headerName)) {
                    JSONArray ja;
                    Object previous = hdrObject.get(headerName);
                    if (previous instanceof JSONArray) {
                        ja = (JSONArray)previous;
                        ja.put((Object)MimeMessageUtility.decodeMultiEncodedHeader(entry.getValue()));
                        continue;
                    }
                    ja = new JSONArray();
                    ja.put(previous);
                    ja.put((Object)MimeMessageUtility.decodeMultiEncodedHeader(entry.getValue()));
                    hdrObject.put(headerName, (Object)ja);
                    continue;
                }
                hdrObject.put(headerName, (Object)MimeMessageUtility.decodeMultiEncodedHeader(entry.getValue()));
            }
            this.jsonObject.put(HEADERS, (Object)hdrObject);
            return true;
        }
        catch (JSONException e) {
            throw MailExceptionCode.JSON_ERROR.create(e, e.getMessage());
        }
    }

    @Override
    public boolean handleImagePart(MailPart part, String imageCID, String baseContentType, boolean isInline, String fileName, String id) throws OXException {
        MultipartInfo mpInfo;
        boolean considerAsInline;
        boolean bl = considerAsInline = isInline || part.containsHeader("Content-Id");
        if (considerAsInline && DisplayMode.MODIFYABLE.getMode() < this.displayMode.getMode() && null != (mpInfo = this.multiparts.peek()) && this.textAppended && id.startsWith(mpInfo.mpId) && mpInfo.isSubType("mixed")) {
            try {
                JSONObject jAttachment;
                JSONArray attachments2 = this.getAttachmentsArr();
                int len = attachments2.length();
                String keyContentType = CONTENT_TYPE;
                String keyContent = CONTENT;
                String keySize = SIZE;
                boolean b = true;
                int i = len;
                while (b && i-- > 0) {
                    jAttachment = attachments2.getJSONObject(i);
                    if (!jAttachment.getString(keyContentType).startsWith("text/plain")) continue;
                    try {
                        InlineImageDataSource imgSource = InlineImageDataSource.getInstance();
                        ImageLocation imageLocation = new ImageLocation.Builder(fileName).folder(MailFolderUtility.prepareFullname(this.accountId, this.mailPath.getFolder())).id(this.mailPath.getMailID()).build();
                        String imageURL = imgSource.generateUrl(imageLocation, this.session);
                        String imgTag = "<img src=\"" + imageURL + "&scaleType=contain&width=800\" alt=\"\" style=\"display: block\" id=\"" + fileName + "\">";
                        String content = jAttachment.getString(keyContent);
                        String newContent = content + imgTag;
                        jAttachment.put(keyContent, (Object)newContent);
                        jAttachment.put(keySize, newContent.length());
                        b = false;
                    }
                    catch (Exception e) {
                        LOG.error("Error while inlining image part.", (Throwable)e);
                    }
                }
                if (b) {
                    try {
                        i = len;
                        while (b && i-- > 0) {
                            String content;
                            jAttachment = attachments2.getJSONObject(i);
                            if (!jAttachment.optString(CONTENT_TYPE, "").startsWith("text/htm") || !mpInfo.mpId.equals(jAttachment.optString(MULTIPART_ID, null)) || "null".equals(content = jAttachment.optString(CONTENT, "null"))) continue;
                            try {
                                InlineImageDataSource imgSource = InlineImageDataSource.getInstance();
                                ImageLocation imageLocation = new ImageLocation.Builder(fileName).folder(MailFolderUtility.prepareFullname(this.accountId, this.mailPath.getFolder())).id(this.mailPath.getMailID()).build();
                                String imageURL = imgSource.generateUrl(imageLocation, this.session);
                                String imgTag = "<img src=\"" + imageURL + "&scaleType=contain&width=800\" alt=\"\" style=\"display: block\" id=\"" + fileName + "\">";
                                content = content + imgTag;
                                jAttachment.put(CONTENT, (Object)content);
                                b = false;
                            }
                            catch (Exception e) {
                                LOG.error("Error while inlining image part.", (Throwable)e);
                            }
                        }
                    }
                    catch (JSONException e) {
                        throw MailExceptionCode.JSON_ERROR.create(e, e.getMessage());
                    }
                }
                return this.handleAttachment0(part, considerAsInline, considerAsInline ? "inline" : "attachment", baseContentType, fileName, id);
            }
            catch (JSONException e) {
                throw MailExceptionCode.JSON_ERROR.create(e, e.getMessage());
            }
        }
        return this.handleAttachment0(part, considerAsInline, considerAsInline ? "inline" : "attachment", baseContentType, fileName, id);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean handleInlineHtml(String htmlContent, ContentType contentType, long size, String fileName, String id) throws OXException {
        if (this.textAppended) {
            if (this.isAlternative) {
                if (DisplayMode.DISPLAY.equals((Object)this.displayMode)) {
                    if (this.textWasEmpty) {
                        if (this.usm.isDisplayHtmlInlineContent()) {
                            JSONObject jsonObject = this.asDisplayHtml(id, contentType.getBaseType(), htmlContent, contentType.getCharsetParameter());
                            if (this.includePlainText) {
                                try {
                                    String plainText = this.html2text(htmlContent);
                                    jsonObject.put("plain_text", (Object)plainText);
                                }
                                catch (JSONException e) {
                                    throw MailExceptionCode.JSON_ERROR.create(e, e.getMessage());
                                }
                            }
                        } else {
                            try {
                                this.asDisplayText(id, contentType.getBaseType(), htmlContent, fileName, false);
                                this.getAttachmentsArr().remove(0);
                            }
                            catch (JSONException e) {
                                throw MailExceptionCode.JSON_ERROR.create(e, e.getMessage());
                            }
                        }
                    }
                    try {
                        int length;
                        MultipartInfo mpInfo = this.multiparts.peek();
                        JSONArray attachments2 = this.getAttachmentsArr();
                        int i = length = attachments2.length();
                        while (i-- > 0) {
                            String content;
                            JSONObject jAttachment = attachments2.getJSONObject(i);
                            if (!jAttachment.optString(CONTENT_TYPE, "").startsWith("text/htm") || null == mpInfo || !mpInfo.mpId.equals(jAttachment.optString(MULTIPART_ID, null)) || !mpInfo.isSubType("mixed") || "null".equals(content = jAttachment.optString(CONTENT, "null"))) continue;
                            String moreContent = HtmlProcessing.formatHTMLForDisplay(htmlContent, contentType.getCharsetParameter(), this.session, this.mailPath, this.usm, this.modified, this.displayMode, this.embedded);
                            content = content + moreContent;
                            jAttachment.put(CONTENT, (Object)content);
                            return true;
                        }
                    }
                    catch (JSONException e) {
                        throw MailExceptionCode.JSON_ERROR.create(e, e.getMessage());
                    }
                    if (!this.attachHTMLAlternativePart) return true;
                    try {
                        JSONObject attachment = this.asAttachment(id, contentType.getBaseType(), htmlContent.length(), fileName, null);
                        attachment.put(VIRTUAL, true);
                        return true;
                    }
                    catch (JSONException e) {
                        throw MailExceptionCode.JSON_ERROR.create(e, e.getMessage());
                    }
                }
                if (!DisplayMode.RAW.equals((Object)this.displayMode)) return true;
                this.asRawContent(id, contentType.getBaseType(), htmlContent);
                return true;
            }
            try {
                int length;
                MultipartInfo mpInfo = this.multiparts.peek();
                JSONArray attachments3 = this.getAttachmentsArr();
                int i = length = attachments3.length();
                while (i-- > 0) {
                    String content;
                    JSONObject jAttachment = attachments3.getJSONObject(i);
                    if (!jAttachment.optString(CONTENT_TYPE, "").startsWith("text/htm") || null == mpInfo || !mpInfo.mpId.equals(jAttachment.optString(MULTIPART_ID, null)) || !mpInfo.isSubType("mixed") || "null".equals(content = jAttachment.optString(CONTENT, "null"))) continue;
                    String moreContent = HtmlProcessing.formatHTMLForDisplay(htmlContent, contentType.getCharsetParameter(), this.session, this.mailPath, this.usm, this.modified, this.displayMode, this.embedded);
                    content = content + moreContent;
                    jAttachment.put(CONTENT, (Object)content);
                    return true;
                }
            }
            catch (JSONException e) {
                throw MailExceptionCode.JSON_ERROR.create(e, e.getMessage());
            }
            this.asAttachment(id, contentType.getBaseType(), htmlContent.length(), fileName, null);
            return true;
        }
        if (DisplayMode.MODIFYABLE.getMode() <= this.displayMode.getMode()) {
            if (this.usm.isDisplayHtmlInlineContent()) {
                if ((Strings.isEmpty((String)htmlContent) || htmlContent.length() < 1024 && this.hasNoImage(htmlContent) && Strings.isEmpty((String)this.html2text(htmlContent))) && this.plainText != null) {
                    this.asRawContent(this.plainText.id, this.plainText.contentType, this.plainText.content);
                } else {
                    JSONObject jsonObject = this.asDisplayHtml(id, contentType.getBaseType(), htmlContent, contentType.getCharsetParameter());
                    if (this.includePlainText) {
                        try {
                            String plainText = this.html2text(htmlContent);
                            jsonObject.put("plain_text", (Object)plainText);
                        }
                        catch (JSONException e) {
                            throw MailExceptionCode.JSON_ERROR.create(e, e.getMessage());
                        }
                    }
                }
            } else {
                this.asDisplayText(id, contentType.getBaseType(), htmlContent, fileName, DisplayMode.DISPLAY.equals((Object)this.displayMode));
            }
        } else if (DisplayMode.RAW.equals((Object)this.displayMode)) {
            this.asRawContent(id, contentType.getBaseType(), htmlContent);
        } else {
            try {
                JSONObject jsonObject = new JSONObject(6);
                jsonObject.put(ID, (Object)id);
                jsonObject.put(CONTENT_TYPE, (Object)contentType.getBaseType());
                jsonObject.put(SIZE, htmlContent.length());
                jsonObject.put(DISPOSITION, (Object)"inline");
                jsonObject.put(CONTENT, (Object)htmlContent);
                this.getAttachmentsArr().put((Object)jsonObject);
            }
            catch (JSONException e) {
                throw MailExceptionCode.JSON_ERROR.create(e, e.getMessage());
            }
        }
        this.textAppended = true;
        return true;
    }

    @Override
    public boolean handleInlinePlainText(String plainTextContentArg, ContentType contentType, long size, String fileName, String id) throws OXException {
        if (this.isAlternative && this.usm.isDisplayHtmlInlineContent() && DisplayMode.RAW.getMode() < this.displayMode.getMode() && contentType.startsWith("text/plain")) {
            if (null == this.plainText) {
                this.plainText = new PlainTextContent(id, contentType.getBaseType(), HtmlProcessing.formatTextForDisplay(plainTextContentArg, this.usm, this.displayMode));
            }
            return true;
        }
        try {
            if (contentType.startsWith("text/enriched") || contentType.startsWith("text/richtext") || contentType.startsWith("text/rtf")) {
                if (this.textAppended) {
                    if (DisplayMode.DISPLAY.equals((Object)this.displayMode)) {
                        this.asAttachment(id, contentType.getBaseType(), plainTextContentArg.length(), fileName, null);
                        return true;
                    }
                    if (DisplayMode.RAW.equals((Object)this.displayMode)) {
                        this.asRawContent(id, contentType.getBaseType(), plainTextContentArg);
                    }
                    return true;
                }
                if (DisplayMode.MODIFYABLE.getMode() <= this.displayMode.getMode()) {
                    JSONObject textObject = this.usm.isDisplayHtmlInlineContent() ? this.asDisplayHtml(id, contentType.getBaseType(), this.getHtmlDisplayVersion(contentType, plainTextContentArg), contentType.getCharsetParameter()) : this.asDisplayText(id, contentType.getBaseType(), this.getHtmlDisplayVersion(contentType, plainTextContentArg), fileName, DisplayMode.DISPLAY.equals((Object)this.displayMode));
                    if (this.includePlainText && !textObject.has("plain_text")) {
                        textObject.put("plain_text", (Object)plainTextContentArg);
                    }
                } else if (DisplayMode.RAW.equals((Object)this.displayMode)) {
                    this.asRawContent(id, contentType.getBaseType(), plainTextContentArg);
                } else {
                    JSONObject jsonObject = new JSONObject(6);
                    jsonObject.put(ID, (Object)id);
                    jsonObject.put(DISPOSITION, (Object)"inline");
                    jsonObject.put(CONTENT_TYPE, (Object)contentType.getBaseType());
                    jsonObject.put(SIZE, plainTextContentArg.length());
                    jsonObject.put(CONTENT, (Object)plainTextContentArg);
                    if (this.includePlainText) {
                        jsonObject.put("plain_text", (Object)plainTextContentArg);
                    }
                    this.getAttachmentsArr().put((Object)jsonObject);
                }
                this.textAppended = true;
                return true;
            }
            if (this.textAppended) {
                if (this.textWasEmpty) {
                    String content = HtmlProcessing.formatTextForDisplay(plainTextContentArg, this.usm, this.displayMode);
                    JSONObject textObject = this.asPlainText(id, contentType.getBaseType(), content);
                    if (this.includePlainText) {
                        textObject.put("plain_text", (Object)plainTextContentArg);
                    }
                    this.textWasEmpty = null == content || 0 == content.length();
                } else {
                    String content = HtmlProcessing.formatTextForDisplay(plainTextContentArg, this.usm, this.displayMode);
                    MultipartInfo mpInfo = this.multiparts.peek();
                    if (null != mpInfo && DisplayMode.RAW.getMode() < this.displayMode.getMode() && id.startsWith(mpInfo.mpId) && mpInfo.isSubType("mixed")) {
                        JSONArray attachments2 = this.getAttachmentsArr();
                        int len = attachments2.length();
                        String keyContentType = CONTENT_TYPE;
                        String keyContent = CONTENT;
                        String keySize = SIZE;
                        boolean b = true;
                        for (int i = len - 1; b && i >= 0; --i) {
                            JSONObject jObject = attachments2.getJSONObject(i);
                            if (!jObject.getString(keyContentType).startsWith("text/plain") || !jObject.hasAndNotNull(keyContent)) continue;
                            String newContent = jObject.getString(keyContent) + content;
                            jObject.put(keyContent, (Object)newContent);
                            jObject.put(keySize, newContent.length());
                            if (this.includePlainText && jObject.has("plain_text")) {
                                jObject.put("plain_text", (Object)(jObject.getString("plain_text") + plainTextContentArg));
                            }
                            b = false;
                        }
                    } else {
                        JSONObject textObject = this.asAttachment(id, contentType.getBaseType(), plainTextContentArg.length(), fileName, content);
                        if (this.includePlainText) {
                            textObject.put("plain_text", (Object)plainTextContentArg);
                        }
                    }
                }
            } else {
                String content = Strings.isEmpty((String)plainTextContentArg) ? "" : HtmlProcessing.formatTextForDisplay(plainTextContentArg, this.usm, this.displayMode);
                JSONObject textObject = this.asPlainText(id, contentType.getBaseType(), content);
                if (this.includePlainText) {
                    textObject.put("plain_text", (Object)plainTextContentArg);
                }
                this.textAppended = true;
                this.textWasEmpty = null == content || 0 == content.length();
            }
            return true;
        }
        catch (JSONException e) {
            throw MailExceptionCode.JSON_ERROR.create(e, e.getMessage());
        }
    }

    private String getHtmlDisplayVersion(ContentType contentType, String src) {
        String baseType = contentType.getBaseType().toLowerCase(Locale.ENGLISH);
        if (baseType.startsWith("text/enriched") || baseType.startsWith("text/richtext")) {
            return HtmlProcessing.formatHTMLForDisplay(ENRCONV.convert(src), contentType.getCharsetParameter(), this.session, this.mailPath, this.usm, this.modified, this.displayMode, this.embedded);
        }
        return HtmlProcessing.formatTextForDisplay(src, this.usm, this.displayMode);
    }

    @Override
    public boolean handleInlineUUEncodedAttachment(UUEncodedPart part, String id) throws OXException {
        try {
            JSONObject jsonObject = new JSONObject(8);
            jsonObject.put(ID, (Object)id);
            String contentType = "application/octet-stream";
            String filename = part.getFileName();
            try {
                Locale locale = UserStorage.getInstance().getUser(this.session.getUserId(), this.ctx).getLocale();
                contentType = MimeType2ExtMap.getContentType(new File(filename.toLowerCase(locale)).getName()).toLowerCase(locale);
            }
            catch (Exception e) {
                Throwable t = new Throwable("Unable to fetch content/type for '" + filename + "': " + e);
                LOG.warn("", t);
            }
            jsonObject.put(CONTENT_TYPE, (Object)contentType);
            jsonObject.put(ATTACHMENT_FILE_NAME, (Object)filename);
            jsonObject.put(SIZE, part.getFileSize());
            jsonObject.put(DISPOSITION, (Object)"attachment");
            if (contentType.startsWith("text/")) {
                jsonObject.put(CONTENT, (Object)part.getPart().toString());
            } else {
                jsonObject.put(CONTENT, JSONObject.NULL);
            }
            this.getAttachmentsArr().put((Object)jsonObject);
            return true;
        }
        catch (JSONException e) {
            throw MailExceptionCode.JSON_ERROR.create(e, e.getMessage());
        }
    }

    @Override
    public boolean handleInlineUUEncodedPlainText(String decodedTextContent, ContentType contentType, int size, String fileName, String id) throws OXException {
        return this.handleInlinePlainText(decodedTextContent, contentType, size, fileName, id);
    }

    @Override
    public void handleMessageEnd(MailMessage mail) throws OXException {
        mail.setFlags(mail.getFlags() | 0x20);
        if (!this.textAppended && this.plainText != null) {
            this.asRawContent(this.plainText.id, this.plainText.contentType, this.plainText.content);
        }
        try {
            String headersKey = HEADERS;
            if (!this.jsonObject.hasAndNotNull(headersKey)) {
                this.jsonObject.put(headersKey, (Object)new JSONObject(1));
            }
            String attachKey = ATTACHMENTS;
            String dispKey = DISPOSITION;
            if (this.jsonObject.hasAndNotNull(attachKey)) {
                JSONArray attachments2 = this.jsonObject.getJSONArray(attachKey);
                int len = attachments2.length();
                for (int i = 0; i < len; ++i) {
                    JSONObject attachment = attachments2.getJSONObject(i);
                    attachment.remove(MULTIPART_ID);
                    if (!attachment.hasAndNotNull(dispKey) || !"attachment".equalsIgnoreCase(attachment.getString(dispKey))) continue;
                    if (attachment.hasAndNotNull(VIRTUAL) && attachment.getBoolean(VIRTUAL)) {
                        attachment.remove(VIRTUAL);
                    } else {
                        this.jsonObject.put(HAS_ATTACHMENTS, true);
                    }
                    if (!this.token || attachment.hasAndNotNull("token")) continue;
                    try {
                        this.addToken(attachment, attachment.getString(ID));
                        continue;
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
            }
        }
        catch (JSONException e) {
            LOG.error("", (Throwable)e);
        }
    }

    @Override
    public boolean handleMultipart(MailPart mp, int bodyPartCount, String id) throws OXException {
        if (mp.getContentType().startsWith("multipart/alternative") && bodyPartCount >= 2) {
            this.isAlternative = true;
            this.altId = id;
        } else if (null != this.altId && !id.startsWith(this.altId)) {
            this.isAlternative = false;
        }
        this.multiparts.push(new MultipartInfo(id, mp.getContentType()));
        return true;
    }

    @Override
    public boolean handleMultipartEnd(MailPart mp, String id) throws OXException {
        this.multiparts.pop();
        return true;
    }

    @Override
    public boolean handleNestedMessage(MailPart mailPart, String id) throws OXException {
        try {
            String name;
            MailMessage nestedMail;
            block13: {
                Object content = mailPart.getContent();
                if (content instanceof MailMessage) {
                    nestedMail = (MailMessage)content;
                } else {
                    if (content instanceof InputStream) {
                        try {
                            nestedMail = MimeMessageConverter.convertMessage(new MimeMessage(MimeDefaultSession.getDefaultSession(), (InputStream)content));
                        }
                        catch (MessagingException e) {
                            throw MimeMailException.handleMessagingException(e);
                        }
                    }
                    if (content instanceof String) {
                        try {
                            try {
                                nestedMail = MimeMessageConverter.convertMessage(new MimeMessage(MimeDefaultSession.getDefaultSession(), (InputStream)new ByteArrayInputStream(((String)content).getBytes("UTF-8"))));
                                break block13;
                            }
                            catch (UnsupportedEncodingException e) {
                                return true;
                            }
                        }
                        catch (MessagingException e) {
                            throw MimeMailException.handleMessagingException(e);
                        }
                    }
                    StringBuilder sb = new StringBuilder(128);
                    sb.append("Ignoring nested message.").append("Cannot handle part's content which should be a RFC822 message according to its content type: ");
                    sb.append(null == content ? "null" : content.getClass().getSimpleName());
                    LOG.error(sb.toString());
                    return true;
                }
            }
            JsonMessageHandler msgHandler = new JsonMessageHandler(this.accountId, null, null, this.displayMode, this.embedded, this.session, this.usm, this.ctx, this.token, this.ttlMillis).setTimeZone(this.timeZone);
            msgHandler.includePlainText = this.includePlainText;
            msgHandler.attachHTMLAlternativePart = this.attachHTMLAlternativePart;
            msgHandler.tokenFolder = this.tokenFolder;
            msgHandler.tokenMailId = this.tokenMailId;
            msgHandler.exactLength = this.exactLength;
            new MailMessageParser().parseMailMessage(nestedMail, msgHandler, id);
            JSONObject nestedObject = msgHandler.getJSONObject();
            nestedObject.put(ID, (Object)(mailPart.containsSequenceId() ? mailPart.getSequenceId() : id));
            if (mailPart.containsFileName() && null != (name = mailPart.getFileName())) {
                nestedObject.put(ATTACHMENT_FILE_NAME, (Object)name);
            }
            this.getNestedMsgsArr().put((Object)nestedObject);
            return true;
        }
        catch (JSONException e) {
            throw MailExceptionCode.JSON_ERROR.create(e, e.getMessage());
        }
    }

    @Override
    public boolean handlePriority(int priority) throws OXException {
        try {
            this.jsonObject.put(PRIORITY, priority);
            return true;
        }
        catch (JSONException e) {
            throw MailExceptionCode.JSON_ERROR.create(e, e.getMessage());
        }
    }

    @Override
    public boolean handleMsgRef(String msgRef) throws OXException {
        try {
            this.jsonObject.put(MailJSONField.MSGREF.getKey(), (Object)msgRef);
            return true;
        }
        catch (JSONException e) {
            throw MailExceptionCode.JSON_ERROR.create(e, e.getMessage());
        }
    }

    @Override
    public boolean handleDispositionNotification(InternetAddress dispositionNotificationTo, boolean seen) throws OXException {
        try {
            if (!seen) {
                this.jsonObject.put(MailJSONField.DISPOSITION_NOTIFICATION_TO.getKey(), (Object)dispositionNotificationTo.toUnicodeString());
            }
            return true;
        }
        catch (JSONException e) {
            throw MailExceptionCode.JSON_ERROR.create(e, e.getMessage());
        }
    }

    @Override
    public boolean handleReceivedDate(Date receivedDate) throws OXException {
        try {
            this.jsonObject.put(MailJSONField.RECEIVED_DATE.getKey(), receivedDate == null ? JSONObject.NULL : Long.valueOf(MessageWriter.addUserTimezone(receivedDate.getTime(), this.getTimeZone())));
            return true;
        }
        catch (JSONException e) {
            throw MailExceptionCode.JSON_ERROR.create(e, e.getMessage());
        }
    }

    @Override
    public boolean handleSentDate(Date sentDate) throws OXException {
        try {
            this.jsonObject.put(MailJSONField.SENT_DATE.getKey(), sentDate == null ? JSONObject.NULL : Long.valueOf(MessageWriter.addUserTimezone(sentDate.getTime(), this.getTimeZone())));
            return true;
        }
        catch (JSONException e) {
            throw MailExceptionCode.JSON_ERROR.create(e, e.getMessage());
        }
    }

    @Override
    public boolean handleSpecialPart(MailPart part, String baseContentType, String fileName, String id) throws OXException {
        ICalParser iCalParser;
        ContentType contentType = part.getContentType();
        if (JsonMessageHandler.isVCalendar(baseContentType) && !contentType.containsParameter("method") && (iCalParser = ServerServiceRegistry.getInstance().getService(ICalParser.class)) != null) {
            try {
                String method = iCalParser.parseProperty("METHOD", part.getInputStream());
                if (null != method) {
                    contentType.setParameter("method", method.toUpperCase(Locale.US));
                }
            }
            catch (RuntimeException e) {
                LOG.warn("A runtime error occurred.", (Throwable)e);
            }
        }
        return this.handleAttachment0(part, false, null, baseContentType, fileName, id);
    }

    private static boolean isVCalendar(String baseContentType) {
        return "text/calendar".equalsIgnoreCase(baseContentType) || "text/x-vcalendar".equalsIgnoreCase(baseContentType);
    }

    @Override
    public boolean handleSubject(String subject) throws OXException {
        try {
            this.jsonObject.put(MailJSONField.SUBJECT.getKey(), subject == null ? JSONObject.NULL : subject.trim());
            return true;
        }
        catch (JSONException e) {
            throw MailExceptionCode.JSON_ERROR.create(e, e.getMessage());
        }
    }

    @Override
    public boolean handleSystemFlags(int flags) throws OXException {
        try {
            if (this.jsonObject.hasAndNotNull(MailJSONField.FLAGS.getKey())) {
                int prevFlags = this.jsonObject.getInt(MailJSONField.FLAGS.getKey());
                this.jsonObject.put(MailJSONField.FLAGS.getKey(), prevFlags | flags);
            } else {
                this.jsonObject.put(MailJSONField.FLAGS.getKey(), flags);
            }
            return true;
        }
        catch (JSONException e) {
            throw MailExceptionCode.JSON_ERROR.create(e, e.getMessage());
        }
    }

    @Override
    public boolean handleToRecipient(InternetAddress[] recipientAddrs) throws OXException {
        try {
            this.jsonObject.put(MailJSONField.RECIPIENT_TO.getKey(), (Object)MessageWriter.getAddressesAsArray(recipientAddrs));
            return true;
        }
        catch (JSONException e) {
            throw MailExceptionCode.JSON_ERROR.create(e, e.getMessage());
        }
    }

    @Override
    public boolean handleUserFlags(String[] userFlags) throws OXException {
        if (userFlags == null) {
            return true;
        }
        try {
            JSONArray userFlagsArr = new JSONArray(userFlags.length);
            for (String userFlag : userFlags) {
                int flags;
                if (MailMessage.isColorLabel(userFlag)) {
                    this.jsonObject.put(COLOR_LABEL, MailMessage.getColorLabelIntValue(userFlag));
                    continue;
                }
                if ("$Forwarded".equalsIgnoreCase(userFlag)) {
                    if (this.jsonObject.hasAndNotNull(MailJSONField.FLAGS.getKey())) {
                        flags = this.jsonObject.getInt(MailJSONField.FLAGS.getKey());
                        this.jsonObject.put(MailJSONField.FLAGS.getKey(), flags | 0x100);
                        continue;
                    }
                    this.jsonObject.put(MailJSONField.FLAGS.getKey(), 256);
                    continue;
                }
                if ("$MDNSent".equalsIgnoreCase(userFlag)) {
                    if (this.jsonObject.hasAndNotNull(MailJSONField.FLAGS.getKey())) {
                        flags = this.jsonObject.getInt(MailJSONField.FLAGS.getKey());
                        this.jsonObject.put(MailJSONField.FLAGS.getKey(), flags | 0x200);
                        continue;
                    }
                    this.jsonObject.put(MailJSONField.FLAGS.getKey(), 512);
                    continue;
                }
                userFlagsArr.put((Object)userFlag);
            }
            this.jsonObject.put(MailJSONField.USER.getKey(), (Object)userFlagsArr);
            return true;
        }
        catch (JSONException e) {
            throw MailExceptionCode.JSON_ERROR.create(e, e.getMessage());
        }
    }

    public JSONObject getJSONObject() {
        if (!this.jsonObject.has(MailJSONField.MODIFIED.getKey())) {
            try {
                this.jsonObject.put(MailJSONField.MODIFIED.getKey(), this.modified[0] ? 1 : 0);
            }
            catch (JSONException e) {
                LOG.error("", (Throwable)e);
            }
        }
        return this.jsonObject;
    }

    private JSONObject asAttachment(String id, String baseContentType, int len, String fileName, String optContent) throws OXException {
        try {
            JSONObject jsonObject = new JSONObject(8);
            jsonObject.put(ID, (Object)id);
            jsonObject.put(CONTENT_TYPE, (Object)baseContentType);
            jsonObject.put(SIZE, len);
            jsonObject.put(DISPOSITION, (Object)"attachment");
            if (null == optContent) {
                jsonObject.put(CONTENT, JSONObject.NULL);
            } else {
                jsonObject.put(CONTENT, (Object)optContent);
            }
            if (fileName == null) {
                jsonObject.put(ATTACHMENT_FILE_NAME, JSONObject.NULL);
            } else {
                jsonObject.put(ATTACHMENT_FILE_NAME, (Object)MimeMessageUtility.decodeMultiEncodedHeader(fileName));
            }
            this.addToken(jsonObject, id);
            this.getAttachmentsArr().put((Object)jsonObject);
            return jsonObject;
        }
        catch (JSONException e) {
            throw MailExceptionCode.JSON_ERROR.create(e, e.getMessage());
        }
    }

    private void asRawContent(String id, String baseContentType, String content) throws OXException {
        try {
            JSONObject jsonObject = new JSONObject(6);
            jsonObject.put(ID, (Object)id);
            jsonObject.put(CONTENT_TYPE, (Object)baseContentType);
            jsonObject.put(SIZE, content.length());
            jsonObject.put(DISPOSITION, (Object)"inline");
            jsonObject.put(CONTENT, (Object)content);
            MultipartInfo mpInfo = this.multiparts.peek();
            jsonObject.put(MULTIPART_ID, null == mpInfo ? JSONObject.NULL : mpInfo.mpId);
            this.getAttachmentsArr().put((Object)jsonObject);
        }
        catch (JSONException e) {
            throw MailExceptionCode.JSON_ERROR.create(e, e.getMessage());
        }
    }

    private JSONObject asDisplayHtml(String id, String baseContentType, String htmlContent, String charset) throws OXException {
        try {
            JSONObject jsonObject = new JSONObject(6);
            jsonObject.put(ID, (Object)id);
            String content = HtmlProcessing.formatHTMLForDisplay(htmlContent, charset, this.session, this.mailPath, this.usm, this.modified, this.displayMode, this.embedded);
            jsonObject.put(CONTENT_TYPE, (Object)baseContentType);
            jsonObject.put(SIZE, content.length());
            jsonObject.put(DISPOSITION, (Object)"inline");
            jsonObject.put(CONTENT, (Object)content);
            MultipartInfo mpInfo = this.multiparts.peek();
            jsonObject.put(MULTIPART_ID, null == mpInfo ? JSONObject.NULL : mpInfo.mpId);
            this.getAttachmentsArr().put((Object)jsonObject);
            return jsonObject;
        }
        catch (JSONException e) {
            throw MailExceptionCode.JSON_ERROR.create(e, e.getMessage());
        }
    }

    private JSONObject asDisplayText(String id, String baseContentType, String htmlContent, String fileName, boolean addAttachment) throws OXException {
        try {
            JSONObject jsonObject = new JSONObject(6);
            jsonObject.put(ID, (Object)id);
            jsonObject.put(CONTENT_TYPE, (Object)"text/plain");
            String plainText = this.html2text(htmlContent);
            if (this.includePlainText) {
                jsonObject.put("plain_text", (Object)plainText);
            }
            String content = HtmlProcessing.formatTextForDisplay(plainText, this.usm, this.displayMode);
            jsonObject.put(DISPOSITION, (Object)"inline");
            jsonObject.put(SIZE, content.length());
            jsonObject.put(CONTENT, (Object)content);
            MultipartInfo mpInfo = this.multiparts.peek();
            jsonObject.put(MULTIPART_ID, null == mpInfo ? JSONObject.NULL : mpInfo.mpId);
            this.getAttachmentsArr().put((Object)jsonObject);
            if (addAttachment) {
                JSONObject originalVersion = new JSONObject(6);
                originalVersion.put(ID, (Object)id);
                originalVersion.put(CONTENT_TYPE, (Object)baseContentType);
                originalVersion.put(DISPOSITION, (Object)"attachment");
                originalVersion.put(SIZE, htmlContent.length());
                originalVersion.put(CONTENT, JSONObject.NULL);
                if (fileName == null) {
                    originalVersion.put(ATTACHMENT_FILE_NAME, JSONObject.NULL);
                } else {
                    originalVersion.put(ATTACHMENT_FILE_NAME, (Object)MimeMessageUtility.decodeMultiEncodedHeader(fileName));
                }
                this.getAttachmentsArr().put((Object)originalVersion);
            }
            return jsonObject;
        }
        catch (JSONException e) {
            throw MailExceptionCode.JSON_ERROR.create(e, e.getMessage());
        }
    }

    private JSONObject asPlainText(String id, String baseContentType, String content) throws OXException {
        try {
            JSONObject jsonObject = new JSONObject(6);
            jsonObject.put(ID, (Object)id);
            jsonObject.put(DISPOSITION, (Object)"inline");
            jsonObject.put(CONTENT_TYPE, (Object)baseContentType);
            jsonObject.put(SIZE, content.length());
            jsonObject.put(CONTENT, (Object)content);
            this.getAttachmentsArr().put((Object)jsonObject);
            return jsonObject;
        }
        catch (JSONException e) {
            throw MailExceptionCode.JSON_ERROR.create(e, e.getMessage());
        }
    }

    private String html2text(String htmlContent) {
        HtmlService htmlService = ServerServiceRegistry.getInstance().getService(HtmlService.class);
        return null == htmlService ? null : htmlService.html2text(htmlContent, true);
    }

    private boolean hasNoImage(String htmlContent) {
        return null == htmlContent || JsonMessageHandler.toLowerCase(htmlContent).indexOf("<img ") < 0;
    }

    static String toLowerCase(CharSequence chars) {
        if (null == chars) {
            return null;
        }
        int length = chars.length();
        StringBuilder builder = new StringBuilder(length);
        for (int i = 0; i < length; ++i) {
            char c = chars.charAt(i);
            builder.append(c >= 'A' && c <= 'Z' ? (char)(c ^ 0x20) : c);
        }
        return builder.toString();
    }

    private static final class MultipartInfo {
        final String mpId;
        final ContentType contentType;

        MultipartInfo(String mpId, ContentType contentType) {
            this.mpId = mpId;
            this.contentType = contentType;
        }

        boolean isSubType(String subtype) {
            return null != this.contentType && this.contentType.startsWith("multipart/" + subtype);
        }

        public String toString() {
            StringBuilder builder = new StringBuilder(256);
            builder.append("MultipartInfo [");
            if (this.mpId != null) {
                builder.append("mpId=").append(this.mpId).append(", ");
            }
            if (this.contentType != null) {
                builder.append("contentType=").append(this.contentType);
            }
            builder.append("]");
            return builder.toString();
        }
    }

    private static final class PlainTextContent {
        final String id;
        final String contentType;
        final String content;

        PlainTextContent(String id, String contentType, String content) {
            this.id = id;
            this.contentType = contentType;
            this.content = content;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder(256);
            builder.append("PlainTextContent [");
            if (this.id != null) {
                builder.append("id=").append(this.id).append(", ");
            }
            if (this.contentType != null) {
                builder.append("contentType=").append(this.contentType).append(", ");
            }
            if (this.content != null) {
                builder.append("content=").append(this.content);
            }
            builder.append("]");
            return builder.toString();
        }
    }
}

