/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.parser.handlers;

import com.openexchange.exception.OXException;
import com.openexchange.java.Strings;
import com.openexchange.mail.dataobjects.MailMessage;
import com.openexchange.mail.dataobjects.MailPart;
import com.openexchange.mail.mime.ContentType;
import com.openexchange.mail.mime.MimeDefaultSession;
import com.openexchange.mail.mime.MimeMailException;
import com.openexchange.mail.mime.converters.MimeMessageConverter;
import com.openexchange.mail.mime.utils.MimeMessageUtility;
import com.openexchange.mail.parser.MailMessageHandler;
import com.openexchange.mail.parser.MailMessageParser;
import com.openexchange.mail.uuencode.UUEncodedPart;
import java.io.InputStream;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import javax.mail.MessagingException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ImageMessageHandler
implements MailMessageHandler {
    private static final Logger LOG = LoggerFactory.getLogger(ImageMessageHandler.class);
    private final String cid;
    private MailPart imagePart;
    private static final String IMAGE = "image/";
    private static final String MIME_APPL_OCTET = "application/octet-stream";
    private static final String SUFFIX = "@Open-Xchange";

    public ImageMessageHandler(String cid) {
        if (cid == null || cid.length() == 0) {
            throw new IllegalArgumentException("Image's Content-ID must not be null or empty");
        }
        this.cid = cid;
    }

    public MailPart getImagePart() {
        return this.imagePart;
    }

    @Override
    public boolean handleMultipartEnd(MailPart mp, String id) throws OXException {
        return true;
    }

    @Override
    public boolean handleAttachment(MailPart part, boolean isInline, String baseContentType, String fileName, String id) throws OXException {
        if (part.getContentType().startsWith(IMAGE) || part.getContentType().startsWith(MIME_APPL_OCTET)) {
            String cid = part.getContentId();
            if (Strings.isEmpty((String)cid) && Strings.isEmpty((String)(cid = part.getFirstHeader("Content-ID")))) {
                String realFilename = MimeMessageUtility.getRealFilename(part);
                if (MimeMessageUtility.equalsCID(this.cid, realFilename, SUFFIX)) {
                    this.imagePart = part;
                    return false;
                }
                return true;
            }
            if (MimeMessageUtility.equalsCID(this.cid, cid, SUFFIX)) {
                this.imagePart = part;
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean handleBccRecipient(InternetAddress[] recipientAddrs) throws OXException {
        return true;
    }

    @Override
    public boolean handleCcRecipient(InternetAddress[] recipientAddrs) throws OXException {
        return true;
    }

    @Override
    public boolean handleColorLabel(int colorLabel) throws OXException {
        return true;
    }

    @Override
    public boolean handleContentId(String contentId) throws OXException {
        return true;
    }

    @Override
    public boolean handleFrom(InternetAddress[] fromAddrs) throws OXException {
        return true;
    }

    @Override
    public boolean handleHeaders(int size, Iterator<Map.Entry<String, String>> iter) throws OXException {
        return true;
    }

    @Override
    public boolean handleImagePart(MailPart part, String imageCID, String baseContentType, boolean isInline, String fileName, String id) throws OXException {
        if (imageCID == null) {
            String realFilename = MimeMessageUtility.getRealFilename(part);
            if (MimeMessageUtility.equalsCID(this.cid, realFilename)) {
                this.imagePart = part;
                return false;
            }
            return true;
        }
        if (MimeMessageUtility.equalsCID(this.cid, imageCID)) {
            this.imagePart = part;
            return false;
        }
        String realFilename = MimeMessageUtility.getRealFilename(part);
        if (MimeMessageUtility.equalsCID(this.cid, realFilename)) {
            this.imagePart = part;
            return false;
        }
        return true;
    }

    @Override
    public boolean handleInlineHtml(String htmlContent, ContentType contentType, long size, String fileName, String id) throws OXException {
        return true;
    }

    @Override
    public boolean handleInlinePlainText(String plainTextContent, ContentType contentType, long size, String fileName, String id) throws OXException {
        return true;
    }

    @Override
    public boolean handleInlineUUEncodedAttachment(UUEncodedPart part, String id) throws OXException {
        return true;
    }

    @Override
    public boolean handleInlineUUEncodedPlainText(String decodedTextContent, ContentType contentType, int size, String fileName, String id) throws OXException {
        return true;
    }

    @Override
    public void handleMessageEnd(MailMessage mail) throws OXException {
    }

    @Override
    public boolean handleMultipart(MailPart mp, int bodyPartCount, String id) throws OXException {
        return true;
    }

    @Override
    public boolean handleNestedMessage(MailPart mailPart, String id) throws OXException {
        MailMessage nestedMail;
        Object content = mailPart.getContent();
        if (content instanceof MailMessage) {
            nestedMail = (MailMessage)content;
        } else if (content instanceof InputStream) {
            try {
                nestedMail = MimeMessageConverter.convertMessage(new MimeMessage(MimeDefaultSession.getDefaultSession(), (InputStream)content));
            }
            catch (MessagingException e) {
                throw MimeMailException.handleMessagingException(e);
            }
        } else {
            LOG.error("Ignoring nested message. Cannot handle part's content which should be a RFC822 message according to its content type: {}", (Object)(null == content ? "null" : content.getClass().getSimpleName()));
            return true;
        }
        ImageMessageHandler handler = new ImageMessageHandler(this.cid);
        new MailMessageParser().parseMailMessage(nestedMail, handler, id);
        if (handler.getImagePart() != null) {
            this.imagePart = handler.getImagePart();
            return false;
        }
        return true;
    }

    @Override
    public boolean handlePriority(int priority) throws OXException {
        return true;
    }

    @Override
    public boolean handleMsgRef(String msgRef) throws OXException {
        return true;
    }

    @Override
    public boolean handleDispositionNotification(InternetAddress dispositionNotificationTo, boolean seen) throws OXException {
        return true;
    }

    @Override
    public boolean handleReceivedDate(Date receivedDate) throws OXException {
        return true;
    }

    @Override
    public boolean handleSentDate(Date sentDate) throws OXException {
        return true;
    }

    @Override
    public boolean handleSpecialPart(MailPart part, String baseContentType, String fileName, String id) throws OXException {
        return this.handleAttachment(part, !"attachment".equalsIgnoreCase(part.getContentDisposition().getDisposition()), baseContentType, fileName, id);
    }

    @Override
    public boolean handleSubject(String subject) throws OXException {
        return true;
    }

    @Override
    public boolean handleSystemFlags(int flags) throws OXException {
        return true;
    }

    @Override
    public boolean handleToRecipient(InternetAddress[] recipientAddrs) throws OXException {
        return true;
    }

    @Override
    public boolean handleUserFlags(String[] userFlags) throws OXException {
        return true;
    }
}

