/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.mime;

import com.openexchange.exception.OXException;
import com.openexchange.mail.MailExceptionCode;
import com.openexchange.mail.dataobjects.MailMessage;
import com.openexchange.mail.mime.ContentDisposition;
import com.openexchange.mail.mime.ContentType;
import com.openexchange.mail.mime.MimeDefaultSession;
import com.openexchange.mail.mime.MimeMailException;
import com.openexchange.mail.mime.converters.MimeMessageConverter;
import com.openexchange.mail.mime.utils.MimeMessageUtility;
import com.openexchange.mail.utils.MessageUtility;
import com.sun.mail.util.MessageRemovedIOException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.BodyPart;
import javax.mail.Header;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Part;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.MimePart;
import javax.mail.internet.MimePartDataSource;

public final class MimeStructureFixer {
    private static final MimeStructureFixer INSTANCE = new MimeStructureFixer();
    private static final String CONTENT_TRANSFER_ENC = "Content-Transfer-Encoding";
    private static final String MIME_VERSION = "MIME-Version";
    private static final String CONTENT_DISPOSITION = "Content-Disposition";
    private static final String CONTENT_TYPE = "Content-Type";
    private static final String MESSAGE_ID = "Message-ID";
    private static final Pattern PATTERN_BODY_START = Pattern.compile("<body[^>]*?>", 2);
    private static final Pattern PATTERN_BODY_END = Pattern.compile("</body>", 2);
    private static final Set<String> EXCLUDE_BOUNDARY = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("boundary")));

    public static MimeStructureFixer getInstance() {
        return INSTANCE;
    }

    private MimeStructureFixer() {
    }

    public MailMessage process(MailMessage message) throws OXException {
        boolean noAppleMailer;
        if (null == message) {
            return message;
        }
        ContentType contentType = message.getContentType();
        if (!contentType.startsWith("multipart/")) {
            return message;
        }
        if (contentType.startsWith("multipart/signed")) {
            return message;
        }
        String mailer = message.getHeader("X-Mailer", null);
        if (null == mailer || (noAppleMailer = MimeStructureFixer.toLowerCase(mailer).indexOf("apple") < 0)) {
            return message;
        }
        String boundary = contentType.getParameter("boundary");
        if (noAppleMailer && (null == boundary || MimeStructureFixer.toLowerCase(boundary).indexOf("apple") < 0)) {
            return message;
        }
        MimeMessage mimeMessage = (MimeMessage)MimeMessageConverter.convertMailMessage(message);
        MimeMessage processed = this.process0(mimeMessage, contentType);
        MailMessage processedMessage = MimeMessageConverter.convertMessage(processed, true);
        processedMessage.setMailId(message.getMailId());
        if (message.containsReceivedDate()) {
            processedMessage.setReceivedDate(message.getReceivedDate());
        }
        if (!processedMessage.containsSize() && message.containsSize()) {
            processedMessage.setSize(message.getSize());
        }
        if (message.containsAccountId()) {
            processedMessage.setAccountId(message.getAccountId());
        }
        if (message.containsFolder()) {
            processedMessage.setFolder(message.getFolder());
        }
        if (message.containsFlags()) {
            processedMessage.setFlags(message.getFlags());
        }
        if (message.containsColorLabel()) {
            processedMessage.setColorLabel(message.getColorLabel());
        }
        if (message.containsUserFlags()) {
            processedMessage.addUserFlags(message.getUserFlags());
        }
        return processedMessage;
    }

    public MimeMessage process(MimeMessage mimeMessage) throws OXException {
        if (null == mimeMessage) {
            return mimeMessage;
        }
        ContentType contentType = this.getContentType((Part)mimeMessage);
        if (!contentType.startsWith("multipart/")) {
            return mimeMessage;
        }
        try {
            boolean noAppleMailer;
            String mailer = mimeMessage.getHeader("X-Mailer", null);
            if (null == mailer || (noAppleMailer = MimeStructureFixer.toLowerCase(mailer).indexOf("apple") < 0)) {
                return mimeMessage;
            }
            String boundary = contentType.getParameter("boundary");
            if (noAppleMailer && (null == boundary || MimeStructureFixer.toLowerCase(boundary).indexOf("apple") < 0)) {
                return mimeMessage;
            }
            return this.process0(mimeMessage, contentType);
        }
        catch (MessagingException e) {
            throw MimeMailException.handleMessagingException(e);
        }
    }

    private MimeMessage process0(MimeMessage mimeMessage, ContentType contentType) throws OXException {
        try {
            MimeMultipart newMultipart = new MimeMultipart(contentType.getSubType(), MimeStructureFixer.getParametersFrom(contentType, EXCLUDE_BOUNDARY));
            String messageId = mimeMessage.getHeader(MESSAGE_ID, null);
            AtomicReference<MimeMultipart> artificialRoot = new AtomicReference<MimeMultipart>();
            LinkedList<MimeMultipart> mpStack = new LinkedList<MimeMultipart>();
            mpStack.add(newMultipart);
            this.handlePart(MimeMessageConverter.multipartFor(mimeMessage, contentType), new AtomicReference<MimeMultipart>(newMultipart), artificialRoot, mpStack);
            MimeMultipart artificialRootMimeMultipart = artificialRoot.get();
            if (null == artificialRootMimeMultipart) {
                MessageUtility.setContent((Multipart)newMultipart, (Part)mimeMessage);
            } else {
                MimeBodyPart mimeBodyPart = new MimeBodyPart();
                MessageUtility.setContent((Multipart)newMultipart, (Part)mimeBodyPart);
                artificialRootMimeMultipart.addBodyPart((BodyPart)mimeBodyPart, 0);
                MessageUtility.setContent((Multipart)artificialRootMimeMultipart, (Part)mimeMessage);
            }
            MimeMessageConverter.saveChanges(mimeMessage);
            if (null == messageId) {
                mimeMessage.removeHeader(MESSAGE_ID);
            } else {
                mimeMessage.setHeader(MESSAGE_ID, messageId);
            }
            return mimeMessage;
        }
        catch (MessagingException e) {
            throw MimeMailException.handleMessagingException(e);
        }
        catch (MessageRemovedIOException e) {
            throw MailExceptionCode.MAIL_NOT_FOUND_SIMPLE.create();
        }
        catch (IOException e) {
            throw MailExceptionCode.IO_ERROR.create(e, e.getMessage());
        }
    }

    private void handlePart(Multipart multipart, AtomicReference<MimeMultipart> newMultipartRef, AtomicReference<MimeMultipart> artificialRoot, LinkedList<MimeMultipart> mpStack) throws MessagingException, IOException, OXException {
        int count = multipart.getCount();
        if (MimeStructureFixer.toLowerCase(multipart.getContentType()).startsWith("multipart/mixed")) {
            ContentType contentType;
            BodyPart bodyPart;
            int i;
            String prefixImage = "image/";
            String prefixHtm = "text/htm";
            String prefixText = "text/plain";
            int inlineCount = 0;
            int inlineImageCount = 0;
            boolean isHtml = true;
            for (i = 0; i < count; ++i) {
                bodyPart = multipart.getBodyPart(i);
                if (!MimeStructureFixer.isInline((Part)bodyPart, contentType = this.getContentType((Part)bodyPart))) continue;
                if (contentType.startsWith("text/htm")) {
                    ++inlineCount;
                    continue;
                }
                if (!contentType.startsWith("image/")) continue;
                ++inlineImageCount;
            }
            if (inlineImageCount > 0 && inlineCount <= 1) {
                inlineCount = 0;
                inlineImageCount = 0;
                isHtml = false;
                for (i = 0; i < count; ++i) {
                    bodyPart = multipart.getBodyPart(i);
                    if (!MimeStructureFixer.isInline((Part)bodyPart, contentType = this.getContentType((Part)bodyPart))) continue;
                    if (contentType.startsWith("text/plain")) {
                        ++inlineCount;
                        continue;
                    }
                    if (!contentType.startsWith("image/")) continue;
                    ++inlineImageCount;
                }
            }
            if (inlineImageCount > 0 && inlineCount > 1) {
                String charset;
                MimeBodyPart contentBodyPart;
                MimeMultipart newSubMultipart;
                String textContent = null;
                String firstCharset = null;
                ArrayList<Object> bodyParts = new ArrayList<Object>(count);
                LinkedList<BodyPart> others = new LinkedList<BodyPart>();
                for (int i2 = 0; i2 < count; ++i2) {
                    BodyPart bodyPart2 = multipart.getBodyPart(i2);
                    ContentType contentType2 = this.getContentType((Part)bodyPart2);
                    if (contentType2.startsWith(isHtml ? "text/htm" : "text/plain")) {
                        String string = MessageUtility.checkCharset((Part)bodyPart2, contentType2);
                        if (null == firstCharset) {
                            firstCharset = string;
                        }
                        String text = MessageUtility.readMimePart((Part)bodyPart2, string);
                        if (null == textContent) {
                            textContent = text;
                            continue;
                        }
                        textContent = isHtml ? this.mergeInto(text, textContent) : textContent + text;
                        continue;
                    }
                    if (contentType2.startsWith("image/")) {
                        if (isHtml) {
                            MimeBodyPart mimeBodyPart = new MimeBodyPart();
                            mimeBodyPart.setDataHandler(new DataHandler((DataSource)new MimePartDataSource((MimePart)bodyPart2)));
                            mimeBodyPart.setHeader(CONTENT_TYPE, contentType2.toString());
                            String contentId = null;
                            Enumeration headers = bodyPart2.getAllHeaders();
                            while (headers.hasMoreElements()) {
                                Header header = (Header)headers.nextElement();
                                String name = MimeStructureFixer.toLowerCase(header.getName());
                                if ("content-type".equals(name)) continue;
                                if ("content-id".equals(name)) {
                                    contentId = header.getValue();
                                }
                                mimeBodyPart.addHeader(header.getName(), header.getValue());
                            }
                            if (null == contentId) {
                                contentId = new StringBuilder(48).append('<').append(UUID.randomUUID().toString()).append('>').toString();
                                mimeBodyPart.setContentID(contentId);
                            }
                            bodyParts.add(mimeBodyPart);
                            String text = new StringBuilder(64).append("<img src=\"cid:").append(this.getContentId(contentId)).append("\">").toString();
                            if (null == textContent) {
                                textContent = text;
                                continue;
                            }
                            textContent = this.mergeInto(text, textContent);
                            continue;
                        }
                        bodyParts.add(bodyPart2);
                        continue;
                    }
                    if (isHtml || mpStack.size() > 1) {
                        others.add(bodyPart2);
                        continue;
                    }
                    bodyParts.add(bodyPart2);
                }
                MimeMultipart mimeMultipart = newSubMultipart = isHtml ? new MimeMultipart("related") : newMultipartRef.get();
                if (isHtml) {
                    contentBodyPart = new MimeBodyPart();
                    charset = null == firstCharset ? "ISO-8859-1" : firstCharset;
                    contentBodyPart.setText(textContent, charset, "html");
                    contentBodyPart.setHeader(CONTENT_TYPE, MimeMessageUtility.foldContentType("text/html; charset=\"" + charset + "\""));
                } else {
                    contentBodyPart = new MimeBodyPart();
                    charset = null == firstCharset ? "ISO-8859-1" : firstCharset;
                    contentBodyPart.setText(textContent, charset, "plain");
                    contentBodyPart.setHeader(CONTENT_TYPE, MimeMessageUtility.foldContentType("text/plain; charset=\"" + charset + "\""));
                }
                contentBodyPart.setHeader(CONTENT_DISPOSITION, "inline");
                contentBodyPart.setHeader(MIME_VERSION, "1.0");
                contentBodyPart.setHeader(CONTENT_TRANSFER_ENC, "quoted-printable");
                newSubMultipart.addBodyPart((BodyPart)contentBodyPart);
                for (BodyPart bodyPart2 : bodyParts) {
                    newSubMultipart.addBodyPart(bodyPart2);
                }
                if (isHtml && 1 == mpStack.size()) {
                    MimeMultipart mimeMultipart2 = newMultipartRef.get();
                    MimeBodyPart mimeBodyPart = new MimeBodyPart();
                    MessageUtility.setContent((Multipart)newSubMultipart, (Part)mimeBodyPart);
                    mimeMultipart2.addBodyPart((BodyPart)mimeBodyPart, 0);
                } else {
                    newMultipartRef.set(newSubMultipart);
                }
                if (!others.isEmpty()) {
                    MimeMultipart mixedMultipart;
                    if (isHtml) {
                        if (MimeStructureFixer.toLowerCase(mpStack.getFirst().getContentType()).indexOf("multipart/mixed") < 0) {
                            mixedMultipart = artificialRoot.get();
                            if (null == mixedMultipart) {
                                mixedMultipart = new MimeMultipart("mixed");
                                artificialRoot.set(mixedMultipart);
                            }
                        } else {
                            mixedMultipart = mpStack.getFirst();
                        }
                        for (BodyPart otherBodyPart : others) {
                            mixedMultipart.addBodyPart(otherBodyPart);
                        }
                    } else {
                        mixedMultipart = newSubMultipart;
                        for (BodyPart otherBodyPart : others) {
                            mixedMultipart.addBodyPart(otherBodyPart);
                        }
                    }
                }
                return;
            }
        }
        MimeMultipart newMimeMultipart = newMultipartRef.get();
        for (int i = 0; i < count; ++i) {
            BodyPart bodyPart = multipart.getBodyPart(i);
            String sContentType = bodyPart.getContentType();
            if (MimeStructureFixer.isEmpty(sContentType)) {
                newMimeMultipart.addBodyPart(bodyPart);
                continue;
            }
            ContentType contentType = new ContentType(sContentType);
            if (contentType.startsWith("multipart/")) {
                MimeMultipart newMimeMultipart2 = new MimeMultipart(contentType.getSubType());
                AtomicReference<MimeMultipart> mpReference = new AtomicReference<MimeMultipart>(newMimeMultipart2);
                Object content = bodyPart.getContent();
                Object mpContent = content instanceof Multipart ? (Multipart)content : new MimeMultipart(bodyPart.getDataHandler().getDataSource());
                mpStack.add(newMimeMultipart2);
                this.handlePart((Multipart)mpContent, mpReference, artificialRoot, mpStack);
                mpStack.removeLast();
                MimeBodyPart mimeBodyPart = new MimeBodyPart();
                MessageUtility.setContent((Multipart)mpReference.get(), (Part)mimeBodyPart);
                newMimeMultipart.addBodyPart((BodyPart)mimeBodyPart);
                continue;
            }
            if (contentType.startsWith("message/rfc822") || contentType.getNameParameter() != null && contentType.getNameParameter().endsWith(".eml")) {
                Object content = bodyPart.getContent();
                MimeMessage filteredMessage = content instanceof MimeMessage ? this.process((MimeMessage)content) : this.process(new MimeMessage(MimeDefaultSession.getDefaultSession(), bodyPart.getInputStream()));
                MimeBodyPart mimeBodyPart = new MimeBodyPart();
                MessageUtility.setContent((Message)filteredMessage, (Part)mimeBodyPart);
                newMimeMultipart.addBodyPart((BodyPart)mimeBodyPart);
                continue;
            }
            newMimeMultipart.addBodyPart(bodyPart);
        }
    }

    private String mergeInto(String anotherHtml, String mainHtml) {
        Matcher mStart = PATTERN_BODY_START.matcher(anotherHtml);
        Matcher mEnd = PATTERN_BODY_END.matcher(anotherHtml);
        if (!mStart.find() || !mEnd.find()) {
            Matcher mMain = PATTERN_BODY_END.matcher(mainHtml);
            if (mMain.find()) {
                StringBuffer sb = new StringBuffer(mainHtml.length() + anotherHtml.length());
                mMain.appendReplacement(sb, Matcher.quoteReplacement(anotherHtml) + Matcher.quoteReplacement(mMain.group()));
                mMain.appendTail(sb);
                return sb.toString();
            }
            StringBuilder sb = new StringBuilder(mainHtml.length() + anotherHtml.length());
            sb.append(mainHtml).append(anotherHtml);
            return sb.toString();
        }
        Matcher mMain = PATTERN_BODY_END.matcher(mainHtml);
        if (mMain.find()) {
            StringBuffer sb = new StringBuffer(mainHtml.length() + anotherHtml.length());
            mMain.appendReplacement(sb, Matcher.quoteReplacement(anotherHtml.substring(mStart.end(), mEnd.start())) + Matcher.quoteReplacement(mMain.group()));
            mMain.appendTail(sb);
            return sb.toString();
        }
        StringBuilder sb = new StringBuilder(mainHtml.length() + anotherHtml.length());
        sb.append(mainHtml).append(anotherHtml.substring(mStart.end(), mEnd.start()));
        return sb.toString();
    }

    private ContentType getContentType(Part part) throws OXException {
        try {
            String[] tmp = part.getHeader(CONTENT_TYPE);
            return tmp != null && tmp.length > 0 ? new ContentType(tmp[0]) : new ContentType("text/plain; charset=us-ascii");
        }
        catch (MessagingException e) {
            throw MimeMailException.handleMessagingException(e);
        }
    }

    private String getContentId(String sContentId) {
        if (null == sContentId) {
            return null;
        }
        if (sContentId.startsWith("<") && sContentId.endsWith(">")) {
            return sContentId.substring(1, sContentId.length() - 1);
        }
        return sContentId;
    }

    private static boolean isInline(Part part, ContentType contentType) throws OXException {
        try {
            boolean hasDisposition;
            ContentDisposition cd;
            String[] hdr = part.getHeader(CONTENT_DISPOSITION);
            if (null == hdr) {
                cd = new ContentDisposition();
                hasDisposition = false;
            } else {
                cd = new ContentDisposition(hdr[0]);
                hasDisposition = true;
            }
            return hasDisposition && "inline".equalsIgnoreCase(cd.getDisposition()) || !hasDisposition && !cd.containsFilenameParameter() && !contentType.containsParameter("name");
        }
        catch (MessagingException e) {
            throw MimeMailException.handleMessagingException(e);
        }
    }

    private static boolean isEmpty(String string) {
        if (null == string) {
            return true;
        }
        int len = string.length();
        boolean isWhitespace = true;
        block3: for (int i = 0; isWhitespace && i < len; ++i) {
            switch (string.charAt(i)) {
                case '\t': 
                case '\n': 
                case '\u000b': 
                case '\f': 
                case '\r': 
                case '\u000e': 
                case '\u001c': 
                case '\u001d': 
                case '\u001e': 
                case '\u001f': 
                case ' ': {
                    isWhitespace = true;
                    continue block3;
                }
                default: {
                    isWhitespace = false;
                }
            }
        }
        return isWhitespace;
    }

    private static String toLowerCase(CharSequence chars) {
        if (null == chars) {
            return null;
        }
        int length = chars.length();
        StringBuilder builder = new StringBuilder(length);
        for (int i = 0; i < length; ++i) {
            char c = chars.charAt(i);
            builder.append(c >= 'A' && c <= 'Z' ? (char)(c ^ 0x20) : c);
        }
        return builder.toString();
    }

    private static Map<String, String> getParametersFrom(ContentType contentType, Set<String> exclude) {
        LinkedHashMap<String, String> retval = new LinkedHashMap<String, String>(4);
        if (null == exclude || exclude.isEmpty()) {
            Iterator<String> it = contentType.getParameterNames();
            while (it.hasNext()) {
                String name = it.next();
                retval.put(name, contentType.getParameter(name));
            }
        } else {
            Iterator<String> it = contentType.getParameterNames();
            while (it.hasNext()) {
                String name = it.next();
                if (exclude.contains(name)) continue;
                retval.put(name, contentType.getParameter(name));
            }
        }
        return retval;
    }
}

