/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.json.parser;

import com.openexchange.conversion.ConversionService;
import com.openexchange.conversion.Data;
import com.openexchange.conversion.DataArguments;
import com.openexchange.conversion.DataExceptionCodes;
import com.openexchange.conversion.DataProperties;
import com.openexchange.conversion.DataSource;
import com.openexchange.conversion.SimpleData;
import com.openexchange.exception.OXException;
import com.openexchange.filemanagement.ManagedFile;
import com.openexchange.filemanagement.ManagedFileManagement;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.contexts.impl.ContextStorage;
import com.openexchange.groupware.ldap.UserStorage;
import com.openexchange.groupware.upload.UploadFile;
import com.openexchange.groupware.upload.impl.UploadEvent;
import com.openexchange.groupware.upload.impl.UploadFileImpl;
import com.openexchange.html.HtmlService;
import com.openexchange.java.Charsets;
import com.openexchange.java.Strings;
import com.openexchange.mail.FullnameArgument;
import com.openexchange.mail.MailExceptionCode;
import com.openexchange.mail.MailJSONField;
import com.openexchange.mail.MailListField;
import com.openexchange.mail.MailPath;
import com.openexchange.mail.api.IMailFolderStorage;
import com.openexchange.mail.api.IMailMessageStorage;
import com.openexchange.mail.api.MailAccess;
import com.openexchange.mail.config.MailProperties;
import com.openexchange.mail.dataobjects.MailMessage;
import com.openexchange.mail.dataobjects.MailPart;
import com.openexchange.mail.dataobjects.compose.ComposedMailMessage;
import com.openexchange.mail.dataobjects.compose.DataMailPart;
import com.openexchange.mail.dataobjects.compose.InfostoreDocumentMailPart;
import com.openexchange.mail.dataobjects.compose.ReferencedMailPart;
import com.openexchange.mail.dataobjects.compose.TextBodyMailPart;
import com.openexchange.mail.dataobjects.compose.UploadFileMailPart;
import com.openexchange.mail.json.parser.AbortAttachmentHandler;
import com.openexchange.mail.json.parser.AbstractAttachmentHandler;
import com.openexchange.mail.json.parser.IAttachmentHandler;
import com.openexchange.mail.json.parser.PublishAttachmentHandler;
import com.openexchange.mail.mime.HeaderCollection;
import com.openexchange.mail.mime.ManagedMimeMessage;
import com.openexchange.mail.mime.MimeMailException;
import com.openexchange.mail.mime.QuotedInternetAddress;
import com.openexchange.mail.mime.filler.MimeMessageFiller;
import com.openexchange.mail.mime.utils.ImageMatcher;
import com.openexchange.mail.mime.utils.MimeMessageUtility;
import com.openexchange.mail.parser.MailMessageParser;
import com.openexchange.mail.parser.handlers.MultipleMailPartHandler;
import com.openexchange.mail.transport.TransportProvider;
import com.openexchange.mail.transport.TransportProviderRegistry;
import com.openexchange.mail.transport.config.TransportProperties;
import com.openexchange.mail.utils.MailFolderUtility;
import com.openexchange.mailaccount.UnifiedInboxManagement;
import com.openexchange.server.ServiceExceptionCode;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.session.Session;
import com.openexchange.tools.TimeZoneUtils;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.mail.MessagingException;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.net.QuotedPrintableCodec;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MessageParser {
    private static final Logger LOG = LoggerFactory.getLogger(MessageParser.class);
    private static final String CONTENT_TYPE = MailJSONField.CONTENT_TYPE.getKey();
    private static final String CONTENT = MailJSONField.CONTENT.getKey();
    private static final String ATTACHMENTS = MailJSONField.ATTACHMENTS.getKey();
    private static final String STR_TRUE = "true";
    private static final String JSON_ARGS = "args";
    private static final String JSON_IDENTIFIER = "identifier";
    private static final Pattern PATTERN_ID_ATTRIBUTE = Pattern.compile("id=\"((?:\\\\\\\"|[^\"])+?)\"");
    private static final String ROOT = "0";
    private static final String FILE_PREFIX = "file://";
    private static final Pattern DECODE_PATTERN = Pattern.compile("%");
    private static final String CT_ALTERNATIVE = "alternative";
    private static final InternetAddress[] EMPTY_ADDRS = new InternetAddress[0];

    private MessageParser() {
    }

    public static ComposedMailMessage parse4Draft(JSONObject jsonObj, UploadEvent uploadEvent, Session session, int accountId, List<OXException> warnings) throws OXException {
        return MessageParser.parse(jsonObj, uploadEvent, session, accountId, null, null, false, warnings)[0];
    }

    public static ComposedMailMessage[] parse4Transport(JSONObject jsonObj, UploadEvent uploadEvent, Session session, int accountId, String protocol, String hostName, List<OXException> warnings) throws OXException {
        return MessageParser.parse(jsonObj, uploadEvent, session, accountId, protocol, hostName, true, warnings);
    }

    private static ComposedMailMessage[] parse(JSONObject jsonObj, UploadEvent uploadEvent, Session session, int accountId, String protocol, String hostName, boolean prepare4Transport, List<OXException> warnings) throws OXException {
        try {
            ComposedMailMessage[] ret;
            JSONArray datasourceArray;
            int length;
            TransportProvider provider = TransportProviderRegistry.getTransportProviderBySession(session, accountId);
            Context ctx = ContextStorage.getStorageContext(session.getContextId());
            ComposedMailMessage composedMail = provider.getNewComposedMailMessage(session, ctx);
            composedMail.setAccountId(accountId);
            AbstractAttachmentHandler attachmentHandler = prepare4Transport && TransportProperties.getInstance().isPublishOnExceededQuota() && (!TransportProperties.getInstance().isPublishPrimaryAccountOnly() || 0 == accountId) ? new PublishAttachmentHandler(session, provider, protocol, hostName) : new AbortAttachmentHandler(session);
            MessageParser.parse(composedMail, jsonObj, session, accountId, provider, attachmentHandler, ctx, prepare4Transport);
            if (null != uploadEvent) {
                for (UploadFile uf : uploadEvent.getUploadFiles()) {
                    if (uf == null) continue;
                    UploadFileMailPart mailPart = provider.getNewFilePart(uf);
                    attachmentHandler.addAttachment(mailPart);
                }
            }
            if (jsonObj.hasAndNotNull(MailJSONField.DATASOURCES.getKey()) && (length = (datasourceArray = jsonObj.getJSONArray(MailJSONField.DATASOURCES.getKey())).length()) > 0) {
                ConversionService conversionService = ServerServiceRegistry.getInstance().getService(ConversionService.class);
                if (conversionService == null) {
                    throw ServiceExceptionCode.SERVICE_UNAVAILABLE.create(new Object[]{ConversionService.class.getName()});
                }
                HashSet<Class> types = new HashSet<Class>(4);
                for (int i = 0; i < length; ++i) {
                    Data data;
                    JSONObject dataSourceObject = datasourceArray.getJSONObject(i);
                    if (!dataSourceObject.hasAndNotNull(JSON_IDENTIFIER)) {
                        throw MailExceptionCode.MISSING_PARAM.create(JSON_IDENTIFIER);
                    }
                    DataSource dataSource = conversionService.getDataSource(dataSourceObject.getString(JSON_IDENTIFIER));
                    if (dataSource == null) {
                        throw DataExceptionCodes.UNKNOWN_DATA_SOURCE.create(new Object[]{dataSourceObject.getString(JSON_IDENTIFIER)});
                    }
                    if (!types.isEmpty()) {
                        types.clear();
                    }
                    types.addAll(Arrays.asList(dataSource.getTypes()));
                    if (types.contains(InputStream.class)) {
                        data = dataSource.getData(InputStream.class, MessageParser.parseDataSourceArguments(dataSourceObject), session);
                    } else if (types.contains(byte[].class)) {
                        data = dataSource.getData(byte[].class, MessageParser.parseDataSourceArguments(dataSourceObject), session);
                    } else {
                        throw MailExceptionCode.UNSUPPORTED_DATASOURCE.create();
                    }
                    DataMailPart dataMailPart = provider.getNewDataPart(data.getData(), data.getDataProperties().toMap(), session);
                    attachmentHandler.addAttachment(dataMailPart);
                }
            }
            if (jsonObj.hasAndNotNull(MailJSONField.INFOSTORE_IDS.getKey())) {
                JSONArray ja = jsonObj.getJSONArray(MailJSONField.INFOSTORE_IDS.getKey());
                length = ja.length();
                for (int i = 0; i < length; ++i) {
                    InfostoreDocumentMailPart part = provider.getNewDocumentPart(ja.getString(i), session);
                    attachmentHandler.addAttachment(part);
                }
            }
            for (ComposedMailMessage mail : ret = attachmentHandler.generateComposedMails(composedMail, warnings)) {
                if (mail.containsAccountId()) continue;
                mail.setAccountId(accountId);
            }
            return ret;
        }
        catch (JSONException e) {
            throw MailExceptionCode.JSON_ERROR.create(e, e.getMessage());
        }
    }

    private static DataArguments parseDataSourceArguments(JSONObject json) throws JSONException {
        if (!json.hasAndNotNull(JSON_ARGS)) {
            return DataArguments.EMPTY_ARGS;
        }
        Object args = json.get(JSON_ARGS);
        if (args instanceof JSONArray) {
            JSONArray jsonArray = (JSONArray)args;
            int len = jsonArray.length();
            DataArguments dataArguments = new DataArguments(len);
            for (int i = 0; i < len; ++i) {
                JSONObject elem = jsonArray.getJSONObject(i);
                if (elem.length() == 1) {
                    String key = (String)elem.keys().next();
                    dataArguments.put(key, elem.getString(key));
                    continue;
                }
                LOG.warn("Corrupt data argument in JSON object: {}", (Object)elem);
            }
            return dataArguments;
        }
        JSONObject argsObject = (JSONObject)args;
        int len = argsObject.length();
        DataArguments dataArguments = new DataArguments(len);
        for (Map.Entry entry : argsObject.entrySet()) {
            dataArguments.put((String)entry.getKey(), entry.getValue().toString());
        }
        return dataArguments;
    }

    private static void parse(ComposedMailMessage transportMail, JSONObject jsonObj, Session session, int accountId, TransportProvider provider, IAttachmentHandler attachmentHandler, Context ctx, boolean prepare4Transport) throws OXException {
        MessageParser.parse(jsonObj, transportMail, TimeZoneUtils.getTimeZone(UserStorage.getInstance().getUser(session.getUserId(), ctx).getTimeZone()), provider, session, accountId, attachmentHandler, prepare4Transport);
    }

    public static void parse(JSONObject jsonObj, MailMessage mail, Session session, int accountId) throws OXException {
        MessageParser.parse(jsonObj, mail, TimeZoneUtils.getTimeZone(UserStorage.getInstance().getUser(session.getUserId(), ContextStorage.getStorageContext(session.getContextId())).getTimeZone()), session, accountId);
    }

    public static void parse(JSONObject jsonObj, MailMessage mail, TimeZone timeZone, Session session, int accountId) throws OXException {
        MessageParser.parse(jsonObj, mail, timeZone, TransportProviderRegistry.getTransportProviderBySession(session, accountId), session, accountId, new AbortAttachmentHandler(session), false);
    }

    private static void parse(JSONObject jsonObj, MailMessage mail, TimeZone timeZone, TransportProvider provider, Session session, int accountId, IAttachmentHandler attachmentHandler, boolean prepare4Transport) throws OXException {
        try {
            MessageParser.parseBasics(jsonObj, mail, timeZone, prepare4Transport);
            MessageParser.prepareMsgRef(session, mail);
            if (mail instanceof ComposedMailMessage) {
                ComposedMailMessage transportMail = (ComposedMailMessage)mail;
                JSONArray attachmentArray = jsonObj.optJSONArray(ATTACHMENTS);
                if (null != attachmentArray) {
                    JSONObject tmp = attachmentArray.getJSONObject(0);
                    String sContent = tmp.getString(CONTENT);
                    TextBodyMailPart part = provider.getNewTextBodyPart(sContent);
                    String contentType = MessageParser.parseContentType(tmp.getString(CONTENT_TYPE));
                    part.setContentType(contentType);
                    if (contentType.startsWith("text/plain") && tmp.optBoolean("raw", false)) {
                        part.setPlainText(sContent);
                    }
                    transportMail.setContentType(part.getContentType());
                    attachmentHandler.setTextPart(part);
                    if (attachmentArray.length() > 1) {
                        Set<String> contentIds = MessageParser.extractContentIds(sContent);
                        MessageParser.parseReferencedParts(provider, session, accountId, transportMail.getMsgref(), attachmentHandler, attachmentArray, contentIds, prepare4Transport);
                    }
                } else {
                    TextBodyMailPart part = provider.getNewTextBodyPart("");
                    part.setContentType("text/plain; charset=us-ascii");
                    transportMail.setContentType(part.getContentType());
                    attachmentHandler.setTextPart(part);
                }
            }
        }
        catch (JSONException e) {
            throw MailExceptionCode.JSON_ERROR.create(e, e.getMessage());
        }
        catch (AddressException e) {
            throw MimeMailException.handleMessagingException((MessagingException)((Object)e));
        }
    }

    private static Set<String> extractContentIds(String htmlContent) {
        ImageMatcher m = ImageMatcher.matcher(htmlContent);
        if (!m.find()) {
            return Collections.emptySet();
        }
        HashSet<String> set = new HashSet<String>(4);
        do {
            String imageTag;
            Matcher tmp;
            if (!(tmp = PATTERN_ID_ATTRIBUTE.matcher(imageTag = m.group())).find()) continue;
            set.add(tmp.group(1));
        } while (m.find());
        return set;
    }

    public static void parseBasics(JSONObject jsonObj, MailMessage mail, TimeZone timeZone) throws JSONException, AddressException, OXException {
        MessageParser.parseBasics(jsonObj, mail, timeZone, false);
    }

    private static void parseBasics(JSONObject jsonObj, MailMessage mail, TimeZone timeZone, boolean prepare4Transport) throws JSONException, AddressException, OXException {
        Date date;
        String fromKey;
        if (jsonObj.hasAndNotNull(MailJSONField.FLAGS.getKey())) {
            mail.setFlags(jsonObj.getInt(MailJSONField.FLAGS.getKey()));
        }
        if (jsonObj.hasAndNotNull(MailJSONField.THREAD_LEVEL.getKey())) {
            mail.setThreadLevel(jsonObj.getInt(MailJSONField.THREAD_LEVEL.getKey()));
        }
        if (jsonObj.hasAndNotNull(MailJSONField.USER.getKey())) {
            JSONArray arr = jsonObj.getJSONArray(MailJSONField.USER.getKey());
            int length = arr.length();
            ArrayList<String> l = new ArrayList<String>(length);
            for (int i = 0; i < length; ++i) {
                l.add(arr.getString(i));
            }
            mail.addUserFlags(l.toArray(new String[l.size()]));
        }
        if (jsonObj.hasAndNotNull(MailJSONField.HEADERS.getKey())) {
            JSONObject obj = jsonObj.getJSONObject(MailJSONField.HEADERS.getKey());
            int size = obj.length();
            HeaderCollection headers = new HeaderCollection(size);
            Iterator iter = obj.keys();
            for (int i = 0; i < size; ++i) {
                String key = (String)iter.next();
                if (!MimeMessageFiller.isCustomOrReplyHeader(key) || key.equalsIgnoreCase("x-original-headers")) continue;
                headers.setHeader(key, obj.getString(key));
            }
            mail.addHeaders(headers);
        }
        if (jsonObj.hasAndNotNull(fromKey = MailJSONField.FROM.getKey())) {
            try {
                int endPos;
                String value = jsonObj.getString(fromKey);
                if ('[' == value.charAt(0) && (endPos = value.indexOf(93, 1)) < value.length()) {
                    value = new StringBuilder(32).append("\"[").append(value.substring(1, endPos)).append("]\"").append(value.substring(endPos + 1)).toString();
                }
                mail.addFrom(MimeMessageUtility.parseAddressList(value, true, true));
            }
            catch (AddressException e) {
                mail.addFrom(MessageParser.parseAddressKey(fromKey, jsonObj, prepare4Transport));
            }
        } else if (prepare4Transport) {
            throw MailExceptionCode.MISSING_FIELD.create(fromKey);
        }
        mail.addTo(MessageParser.parseAddressKey(MailJSONField.RECIPIENT_TO.getKey(), jsonObj, prepare4Transport));
        mail.addCc(MessageParser.parseAddressKey(MailJSONField.RECIPIENT_CC.getKey(), jsonObj, prepare4Transport));
        mail.addBcc(MessageParser.parseAddressKey(MailJSONField.RECIPIENT_BCC.getKey(), jsonObj, prepare4Transport));
        InternetAddress[] addrs = MessageParser.parseAddressKey("reply_to", jsonObj, false);
        if (null != addrs && addrs.length > 0) {
            mail.setHeader("Reply-To", addrs[0].toString());
        }
        if (jsonObj.hasAndNotNull(MailJSONField.DISPOSITION_NOTIFICATION_TO.getKey())) {
            String dispVal = jsonObj.getString(MailJSONField.DISPOSITION_NOTIFICATION_TO.getKey());
            if (STR_TRUE.equalsIgnoreCase(dispVal)) {
                InternetAddress[] from = mail.getFrom();
                mail.setDispositionNotification(from.length > 0 ? from[0] : null);
            } else {
                InternetAddress ia = MessageParser.getEmailAddress(dispVal);
                if (ia == null) {
                    mail.setDispositionNotification(null);
                } else {
                    mail.setDispositionNotification(ia);
                }
            }
        }
        if (jsonObj.hasAndNotNull(MailJSONField.PRIORITY.getKey())) {
            mail.setPriority(jsonObj.getInt(MailJSONField.PRIORITY.getKey()));
        }
        if (jsonObj.hasAndNotNull(MailJSONField.COLOR_LABEL.getKey())) {
            mail.setColorLabel(jsonObj.getInt(MailJSONField.COLOR_LABEL.getKey()));
        }
        if (jsonObj.hasAndNotNull(MailJSONField.VCARD.getKey())) {
            mail.setAppendVCard(jsonObj.getInt(MailJSONField.VCARD.getKey()) > 0);
        }
        if (jsonObj.hasAndNotNull(MailJSONField.MSGREF.getKey())) {
            mail.setMsgref(new MailPath(jsonObj.getString(MailJSONField.MSGREF.getKey())));
        }
        if (jsonObj.hasAndNotNull(MailJSONField.SUBJECT.getKey())) {
            mail.setSubject(jsonObj.getString(MailJSONField.SUBJECT.getKey()));
        }
        if (jsonObj.hasAndNotNull(MailJSONField.SIZE.getKey())) {
            mail.setSize(jsonObj.getInt(MailJSONField.SIZE.getKey()));
        }
        if (jsonObj.hasAndNotNull(MailJSONField.SENT_DATE.getKey())) {
            date = new Date(jsonObj.getLong(MailJSONField.SENT_DATE.getKey()));
            int offset = timeZone.getOffset(date.getTime());
            mail.setSentDate(new Date(jsonObj.getLong(MailJSONField.SENT_DATE.getKey()) - (long)offset));
        }
        if (jsonObj.hasAndNotNull(MailJSONField.RECEIVED_DATE.getKey())) {
            date = new Date(jsonObj.getLong(MailJSONField.RECEIVED_DATE.getKey()));
            int offset = timeZone.getOffset(date.getTime());
            mail.setReceivedDate(new Date(jsonObj.getLong(MailJSONField.RECEIVED_DATE.getKey()) - (long)offset));
        }
        mail.removeHeader("x-original-headers");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void parseReferencedParts(TransportProvider provider, Session session, int accountId, MailPath transportMailMsgref, IAttachmentHandler attachmentHandler, JSONArray attachmentArray, Set<String> contentIds, boolean prepare4Transport) throws OXException, JSONException {
        int len = attachmentArray.length();
        Map<String, ReferencedMailPart> groupedReferencedParts = MessageParser.groupReferencedParts(provider, session, transportMailMsgref, attachmentArray, contentIds, prepare4Transport);
        MailAccess<IMailFolderStorage, IMailMessageStorage> access = null;
        try {
            ManagedFileManagement management = null;
            for (int i = 1; i < len; ++i) {
                ReferencedMailPart referencedMailPart;
                boolean isMail;
                MailPath msgref;
                JSONObject attachment = attachmentArray.getJSONObject(i);
                String seqId = attachment.optString(MailListField.ID.getKey(), null);
                if (null == seqId && attachment.hasAndNotNull(CONTENT)) {
                    byte[] content;
                    String contentType = MessageParser.parseContentType(attachment.getString(CONTENT_TYPE));
                    String charsetName = "UTF-8";
                    try {
                        HtmlService htmlService = ServerServiceRegistry.getInstance().getService(HtmlService.class);
                        if ("text/plain".equals(contentType)) {
                            content = htmlService.html2text(attachment.getString(CONTENT), true).getBytes("UTF-8");
                        } else {
                            String conformHTML = htmlService.getConformHTML(attachment.getString(CONTENT), "ISO-8859-1");
                            content = conformHTML.getBytes("UTF-8");
                        }
                    }
                    catch (UnsupportedEncodingException e) {
                        throw MailExceptionCode.ENCODING_ERROR.create(e, e.getMessage());
                    }
                    DataProperties properties = new DataProperties();
                    properties.put("com.openexchange.conversion.content-type", contentType);
                    properties.put("com.openexchange.conversion.size", String.valueOf(content.length));
                    properties.put("com.openexchange.conversion.charset", "UTF-8");
                    SimpleData data = new SimpleData((Object)content, properties);
                    DataMailPart dataMailPart = provider.getNewDataPart(data.getData(), data.getDataProperties().toMap(), session);
                    attachmentHandler.addAttachment(dataMailPart);
                    continue;
                }
                if (null != seqId && seqId.startsWith(FILE_PREFIX, 0)) {
                    if (null == management) {
                        management = ServerServiceRegistry.getInstance().getService(ManagedFileManagement.class);
                    }
                    MessageParser.processReferencedUploadFile(provider, management, seqId, attachmentHandler);
                    continue;
                }
                if (attachment.hasAndNotNull(MailJSONField.MSGREF.getKey())) {
                    msgref = new MailPath(attachment.get(MailJSONField.MSGREF.getKey()).toString());
                    isMail = true;
                } else {
                    msgref = transportMailMsgref;
                    isMail = false;
                }
                if (null == msgref) continue;
                msgref = MessageParser.prepareMsgRef(session, msgref);
                if (isMail || null == seqId || ROOT.equals(seqId)) {
                    MailMessage referencedMail;
                    if (null == access) {
                        access = MailAccess.getInstance(session, msgref.getAccountId());
                        access.connect();
                    }
                    if (null == (referencedMail = access.getMessageStorage().getMessage(msgref.getFolder(), msgref.getMailID(), false))) {
                        throw MailExceptionCode.REFERENCED_MAIL_NOT_FOUND.create(msgref.getMailID(), msgref.getFolder());
                    }
                    referencedMail.setAccountId(access.getAccountId());
                    referencedMail = ManagedMimeMessage.clone(referencedMail);
                    referencedMailPart = provider.getNewReferencedMail(referencedMail, session);
                } else {
                    String contentId;
                    ReferencedMailPart tmp = groupedReferencedParts.get(seqId);
                    if (null != tmp && tmp.containsContentId() && null != (contentId = tmp.getContentId()) && contentIds.contains('<' == contentId.charAt(0) ? contentId.substring(1, contentId.length() - 1) : contentId)) {
                        tmp = null;
                    }
                    referencedMailPart = tmp;
                }
                if (null == referencedMailPart) continue;
                referencedMailPart.setMsgref(msgref);
                attachmentHandler.addAttachment(referencedMailPart);
            }
        }
        finally {
            if (null != access) {
                access.close(true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<String, ReferencedMailPart> groupReferencedParts(TransportProvider provider, Session session, MailPath parentMsgRef, JSONArray attachmentArray, Set<String> contentIds, boolean prepare4Transport) throws OXException, JSONException {
        if (null == parentMsgRef) {
            return Collections.emptyMap();
        }
        int len = attachmentArray.length();
        HashMap<String, String> groupedSeqIDs = new HashMap<String, String>(len);
        for (int i = 1; i < len; ++i) {
            String seqId;
            JSONObject attachment = attachmentArray.getJSONObject(i);
            String string = seqId = attachment.hasAndNotNull(MailListField.ID.getKey()) ? attachment.getString(MailListField.ID.getKey()) : null;
            if (seqId == null || seqId.startsWith(FILE_PREFIX, 0) || attachment.hasAndNotNull(MailJSONField.MSGREF.getKey())) continue;
            Object cid = attachment.opt(MailJSONField.CID.getKey());
            groupedSeqIDs.put(seqId, null == cid ? "" : cid.toString());
        }
        if (groupedSeqIDs.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<String, ReferencedMailPart> retval = null;
        MailAccess<IMailFolderStorage, IMailMessageStorage> access = null;
        try {
            access = MailAccess.getInstance(session, parentMsgRef.getAccountId());
            access.connect();
            retval = new HashMap<String, ReferencedMailPart>(len);
            MessageParser.handleMultipleRefs(provider, session, parentMsgRef, contentIds, prepare4Transport, groupedSeqIDs, retval, access);
        }
        catch (OXException oe) {
            if (null == access || !MimeMessageUtility.shouldRetry(oe)) {
                throw oe;
            }
            access = MailAccess.reconnect(access);
            retval = new HashMap(len);
            MessageParser.handleMultipleRefs(provider, session, parentMsgRef, contentIds, prepare4Transport, groupedSeqIDs, retval, access);
        }
        finally {
            if (null != access) {
                access.close(true);
            }
        }
        return retval;
    }

    private static void handleMultipleRefs(TransportProvider provider, Session session, MailPath parentMsgRef, Set<String> contentIds, boolean prepare4Transport, Map<String, String> groupedSeqIDs, Map<String, ReferencedMailPart> retval, MailAccess<?, ?> access) throws OXException {
        MailPath pMsgRef = parentMsgRef;
        MailMessage referencedMail = access.getMessageStorage().getMessage(pMsgRef.getFolder(), pMsgRef.getMailID(), false);
        if (null == referencedMail) {
            throw MailExceptionCode.REFERENCED_MAIL_NOT_FOUND.create(pMsgRef.getMailID(), pMsgRef.getFolder());
        }
        referencedMail.setAccountId(access.getAccountId());
        referencedMail = ManagedMimeMessage.clone(referencedMail);
        HashSet<String> remaining = new HashSet<String>(groupedSeqIDs.keySet());
        MultipleMailPartHandler handler = new MultipleMailPartHandler(groupedSeqIDs.keySet(), false);
        new MailMessageParser().parseMailMessage(referencedMail, handler);
        for (Map.Entry<String, MailPart> e : handler.getMailParts().entrySet()) {
            String seqId = e.getKey();
            retval.put(seqId, provider.getNewReferencedPart(e.getValue(), session));
            remaining.remove(seqId);
        }
        if (prepare4Transport && !remaining.isEmpty()) {
            for (String seqId : remaining) {
                if (contentIds.contains(seqId)) continue;
                throw MailExceptionCode.ATTACHMENT_NOT_FOUND.create(seqId, Long.valueOf(referencedMail.getMailId()), referencedMail.getFolder());
            }
        }
    }

    private static MailPath prepareMsgref(MailPath msgref) throws OXException {
        String mailID = msgref.getMailID();
        if (mailID.startsWith("%64%65%66%61")) {
            return new MailPath(MessageParser.decodeQP(mailID));
        }
        return msgref;
    }

    private static String decodeQP(String string) {
        try {
            return new String(QuotedPrintableCodec.decodeQuotedPrintable((byte[])Charsets.toAsciiBytes((String)DECODE_PATTERN.matcher(string).replaceAll("="))), Charsets.UTF_8);
        }
        catch (DecoderException e) {
            throw new IllegalStateException(e);
        }
    }

    private static void processReferencedUploadFile(TransportProvider provider, ManagedFileManagement management, String seqId, IAttachmentHandler attachmentHandler) throws OXException {
        ManagedFile managedFile;
        try {
            managedFile = management.getByID(seqId.substring(FILE_PREFIX.length()));
        }
        catch (OXException e) {
            LOG.error("No temp file found for ID: {}", (Object)seqId.substring(FILE_PREFIX.length()), (Object)e);
            return;
        }
        UploadFileImpl wrapper = new UploadFileImpl();
        wrapper.setContentType(managedFile.getContentType());
        wrapper.setFileName(managedFile.getFileName());
        wrapper.setSize(managedFile.getSize());
        wrapper.setTmpFile(managedFile.getFile());
        attachmentHandler.addAttachment(provider.getNewFilePart(wrapper));
    }

    private static String parseContentType(String ctStrArg) {
        String ctStr = MessageParser.toLowerCase(ctStrArg).trim();
        if (ctStr.indexOf(CT_ALTERNATIVE) != -1) {
            return "multipart/alternative";
        }
        if ("text/plain".equals(ctStr) || "text".equals(ctStr)) {
            return "text/plain";
        }
        return "text/html";
    }

    public static InternetAddress[] getFromField(JSONObject jo) throws AddressException, JSONException {
        return MessageParser.parseAddressKey(MailJSONField.FROM.getKey(), jo);
    }

    public static InternetAddress[] parseAddressKey(String key, JSONObject jo) throws JSONException, AddressException {
        return MessageParser.parseAddressKey(key, jo, false);
    }

    public static InternetAddress[] parseAddressKey(String key, JSONObject jo, boolean failOnError) throws JSONException, AddressException {
        String value = null;
        if (!jo.has(key) || jo.isNull(key) || Strings.isEmpty((String)(value = jo.getString(key)))) {
            return EMPTY_ADDRS;
        }
        if (value.charAt(0) == '[') {
            try {
                JSONArray jsonArr = new JSONArray(value);
                int length = jsonArr.length();
                if (length == 0) {
                    return EMPTY_ADDRS;
                }
                return MessageParser.parseAdressArray(jsonArr, length);
            }
            catch (JSONException e) {
                LOG.error("", (Throwable)e);
                value = jo.getString(key);
            }
        }
        return MimeMessageUtility.parseAddressList(value, true, failOnError);
    }

    private static InternetAddress[] parseAdressArray(JSONArray jsonArray, int length) throws JSONException, AddressException {
        ArrayList<QuotedInternetAddress> addresses = new ArrayList<QuotedInternetAddress>(length);
        for (int i = 0; i < length; ++i) {
            boolean hasPersonal;
            JSONArray persAndAddr = jsonArray.getJSONArray(i);
            int pLen = persAndAddr.length();
            if (pLen == 0) continue;
            if (1 == pLen) {
                addresses.add(new QuotedInternetAddress(persAndAddr.getString(0)));
                continue;
            }
            String personal = persAndAddr.getString(0);
            boolean bl = hasPersonal = personal != null && !"null".equals(personal);
            if (hasPersonal) {
                try {
                    addresses.add(new QuotedInternetAddress(persAndAddr.getString(1), personal, "UTF-8"));
                }
                catch (UnsupportedEncodingException x) {}
                continue;
            }
            addresses.add(new QuotedInternetAddress(persAndAddr.getString(1)));
        }
        return addresses.toArray(new InternetAddress[0]);
    }

    private static InternetAddress getEmailAddress(String addrStr) {
        if (Strings.isEmpty((String)addrStr)) {
            return null;
        }
        try {
            return new QuotedInternetAddress(addrStr, false);
        }
        catch (AddressException e) {
            return null;
        }
    }

    private static void prepareMsgRef(Session session, MailMessage mail) throws OXException {
        MailPath msgref = mail.getMsgref();
        if (null == msgref) {
            return;
        }
        mail.setMsgref(MessageParser.prepareMsgRef(session, msgref));
    }

    private static MailPath prepareMsgRef(Session session, MailPath msgref) throws OXException {
        UnifiedInboxManagement unifiedINBOXManagement = ServerServiceRegistry.getInstance().getService(UnifiedInboxManagement.class);
        if (null != unifiedINBOXManagement && msgref.getAccountId() == unifiedINBOXManagement.getUnifiedINBOXAccountID(session)) {
            String nestedFullname = msgref.getFolder();
            int pos = nestedFullname.indexOf("default");
            if (-1 == pos) {
                return msgref;
            }
            int check = pos + "default".length();
            while (Character.isDigit(nestedFullname.charAt(check))) {
                ++check;
            }
            if (MailProperties.getInstance().getDefaultSeparator() != nestedFullname.charAt(check)) {
                return msgref;
            }
            FullnameArgument arg = MailFolderUtility.prepareMailFolderParam(nestedFullname.substring(pos));
            return new MailPath(arg.getAccountId(), arg.getFullname(), msgref.getMailID());
        }
        return msgref;
    }

    private static String toLowerCase(CharSequence chars) {
        if (null == chars) {
            return null;
        }
        int length = chars.length();
        StringBuilder builder = new StringBuilder(length);
        for (int i = 0; i < length; ++i) {
            char c = chars.charAt(i);
            builder.append(c >= 'A' && c <= 'Z' ? (char)(c ^ 0x20) : c);
        }
        return builder.toString();
    }
}

