/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.json.actions;

import com.openexchange.ajax.AJAXUtility;
import com.openexchange.ajax.Mail;
import com.openexchange.ajax.container.FileHolder;
import com.openexchange.ajax.container.IFileHolder;
import com.openexchange.ajax.container.ThresholdFileHolder;
import com.openexchange.ajax.requesthandler.AJAXRequestData;
import com.openexchange.ajax.requesthandler.AJAXRequestDataTools;
import com.openexchange.ajax.requesthandler.AJAXRequestResult;
import com.openexchange.ajax.requesthandler.DispatcherNotes;
import com.openexchange.ajax.requesthandler.ETagAwareAJAXActionService;
import com.openexchange.documentation.RequestMethod;
import com.openexchange.documentation.annotations.Action;
import com.openexchange.documentation.annotations.Parameter;
import com.openexchange.exception.OXException;
import com.openexchange.file.storage.File;
import com.openexchange.file.storage.composition.IDBasedFileAccess;
import com.openexchange.file.storage.composition.IDBasedFileAccessFactory;
import com.openexchange.file.storage.parse.FileMetadataParserService;
import com.openexchange.html.HtmlService;
import com.openexchange.java.Charsets;
import com.openexchange.java.Streams;
import com.openexchange.java.Strings;
import com.openexchange.mail.FullnameArgument;
import com.openexchange.mail.MailExceptionCode;
import com.openexchange.mail.MailServletInterface;
import com.openexchange.mail.api.IMailFolderStorage;
import com.openexchange.mail.api.IMailMessageStorage;
import com.openexchange.mail.api.MailAccess;
import com.openexchange.mail.config.MailProperties;
import com.openexchange.mail.dataobjects.MailPart;
import com.openexchange.mail.json.MailRequest;
import com.openexchange.mail.json.actions.AbstractMailAction;
import com.openexchange.mail.mime.ContentType;
import com.openexchange.mail.mime.MimeType2ExtMap;
import com.openexchange.mail.mime.MimeTypes;
import com.openexchange.mail.parser.MailMessageParser;
import com.openexchange.mail.utils.MailFolderUtility;
import com.openexchange.mail.utils.MessageUtility;
import com.openexchange.server.ServiceLookup;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.session.Session;
import com.openexchange.tools.HashUtility;
import com.openexchange.tools.session.ServerSession;
import com.sun.mail.util.FolderClosedIOException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.util.EnumSet;
import java.util.List;
import java.util.regex.Pattern;
import org.json.JSONException;
import org.json.JSONObject;

@Action(method=RequestMethod.GET, name="get", description="Get a mail.", parameters={@Parameter(name="session", description="A session ID previously obtained from the login module."), @Parameter(name="folder", description="The folder identifier."), @Parameter(name="id", description="Object ID of the mail which contains the attachment."), @Parameter(name="attachment", description="ID of the requested attachment OR"), @Parameter(name="cid", description="Value of header 'Content-ID' of the requested attachment"), @Parameter(name="save", description="1 overwrites the defined mimetype for this attachment to force the download dialog, otherwise 0."), @Parameter(name="filter", optional=true, description="1 to apply HTML white-list filter rules if and only if requested attachment is of MIME type text/htm* AND parameter save is set to 0.")}, responseDescription="The raw byte data of the document. The response type for the HTTP Request is set accordingly to the defined mimetype for this attachment, except the parameter save is set to 1.")
@DispatcherNotes(allowPublicSession=true)
public final class GetAttachmentAction
extends AbstractMailAction
implements ETagAwareAJAXActionService {
    private static final long EXPIRES_MILLIS_YEAR = 1572480000000L;
    private static final String MIME_APPL_OCTET = "application/octet-stream";
    private static final String PARAMETER_FILTER = "filter";
    private static final String PARAMETER_SAVE = "save";
    private static final String PARAMETER_ID = "id";
    private static final String PARAMETER_FOLDERID = "folder";
    private static final String PARAMETER_MAILCID = "cid";
    private static final String PARAMETER_MAILATTCHMENT = "attachment";
    private static final String PARAMETER_DELIVERY = Mail.PARAMETER_DELIVERY;

    public GetAttachmentAction(ServiceLookup services) {
        super(services);
    }

    @Override
    public boolean checkETag(String clientETag, AJAXRequestData request, ServerSession session) throws OXException {
        return clientETag != null && clientETag.length() != 0;
    }

    @Override
    public void setETag(String eTag, long expires, AJAXRequestResult result) throws OXException {
        result.setExpires(expires);
        result.setHeader("ETag", eTag);
    }

    @Override
    protected AJAXRequestResult perform(MailRequest req) throws OXException {
        JSONObject bodyObject = (JSONObject)req.getRequest().getData();
        if (null == bodyObject) {
            return this.performGET(req);
        }
        return this.performPUT(req, bodyObject);
    }

    private AJAXRequestResult performGET(MailRequest req) throws OXException {
        try {
            FileHolder fileHolder;
            IFileHolder.InputStreamClosure isClosure;
            MailPart mailPart;
            String folderPath = req.checkParameter(PARAMETER_FOLDERID);
            String uid = req.checkParameter(PARAMETER_ID);
            String sequenceId = req.getParameter(PARAMETER_MAILATTCHMENT);
            String imageContentId = req.getParameter(PARAMETER_MAILCID);
            String fileNameFromRequest = req.getParameter("save_as");
            String saveParam = req.getParameter(PARAMETER_SAVE);
            boolean saveToDisk = AJAXRequestDataTools.parseBoolParameter(saveParam) || "download".equals(Strings.toLowerCase((CharSequence)req.getParameter(PARAMETER_DELIVERY)));
            String filterParam = req.getParameter(PARAMETER_FILTER);
            boolean filter = Boolean.parseBoolean(filterParam) || "1".equals(filterParam);
            MailServletInterface mailInterface = this.getMailInterface(req);
            if (sequenceId == null && imageContentId == null) {
                throw MailExceptionCode.MISSING_PARAM.create(PARAMETER_MAILATTCHMENT + " | " + PARAMETER_MAILCID);
            }
            long size = -1L;
            if (imageContentId == null) {
                mailPart = mailInterface.getMessageAttachment(folderPath, uid, sequenceId, !saveToDisk);
                if (mailPart == null) {
                    throw MailExceptionCode.NO_ATTACHMENT_FOUND.create(sequenceId);
                }
                if (GetAttachmentAction.isEmpty(mailPart.getFileName())) {
                    mailPart.setFileName(MailMessageParser.generateFilename(sequenceId, mailPart.getContentType().getBaseType()));
                }
                if (filter && !saveToDisk && mailPart.getContentType().startsWithAny("text/htm", "text/xhtm", "text/xml")) {
                    ContentType contentType = mailPart.getContentType();
                    String cs = contentType.containsCharsetParameter() ? contentType.getCharsetParameter() : MailProperties.getInstance().getDefaultMimeCharset();
                    String htmlContent = MessageUtility.readMailPart(mailPart, cs);
                    HtmlService htmlService = ServerServiceRegistry.getInstance().getService(HtmlService.class);
                    final byte[] bytes = GetAttachmentAction.sanitizeHtml(htmlContent, htmlService).getBytes(Charsets.forName((String)cs));
                    contentType.setCharsetParameter(cs);
                    size = bytes.length;
                    isClosure = new IFileHolder.InputStreamClosure(){

                        @Override
                        public InputStream newStream() throws OXException, IOException {
                            return Streams.newByteArrayInputStream((byte[])bytes);
                        }
                    };
                } else {
                    boolean exactLength = AJAXRequestDataTools.parseBoolParameter(req.getParameter("exact_length"));
                    if (exactLength) {
                        size = Streams.countInputStream((InputStream)mailPart.getInputStream());
                    }
                    isClosure = new ReconnectingInputStreamClosure(mailPart, folderPath, uid, sequenceId, false, req.getSession());
                }
            } else {
                mailPart = mailInterface.getMessageImage(folderPath, uid, imageContentId);
                if (mailPart == null) {
                    throw MailExceptionCode.NO_ATTACHMENT_FOUND.create(sequenceId);
                }
                boolean exactLength = AJAXRequestDataTools.parseBoolParameter(req.getParameter("exact_length"));
                if (exactLength) {
                    size = Streams.countInputStream((InputStream)mailPart.getInputStream());
                }
                isClosure = new ReconnectingInputStreamClosure(mailPart, folderPath, uid, imageContentId, true, req.getSession());
            }
            AJAXRequestData requestData = req.getRequest();
            boolean isPreviewImage = "preview_image".equals(requestData.getFormat());
            if (saveToDisk) {
                String filename = this.getFileName(fileNameFromRequest, mailPart.getFileName(), mailPart.getContentType().getBaseType());
                fileHolder = new FileHolder(isClosure, size, MimeType2ExtMap.getContentType(filename), filename);
                fileHolder.setDelivery("download");
                req.getRequest().putParameter(PARAMETER_DELIVERY, "download");
            } else {
                String baseType = mailPart.getContentType().getBaseType();
                fileHolder = new FileHolder(isClosure, size, baseType, this.getFileName(fileNameFromRequest, mailPart.getFileName(), baseType));
            }
            AJAXRequestResult result = new AJAXRequestResult((Object)fileHolder, "file");
            requestData.putParameter("cache", "false");
            if (!isPreviewImage) {
                requestData.setFormat("file");
            }
            this.setETag(this.getHash(folderPath, uid, imageContentId == null ? sequenceId : imageContentId), 1572480000000L, result);
            return result;
        }
        catch (IOException e) {
            if ("com.sun.mail.util.MessageRemovedIOException".equals(e.getClass().getName())) {
                throw MailExceptionCode.MAIL_NOT_FOUND_SIMPLE.create(e, new Object[0]);
            }
            throw MailExceptionCode.IO_ERROR.create(e, e.getMessage());
        }
        catch (RuntimeException e) {
            throw MailExceptionCode.UNEXPECTED_ERROR.create(e, e.getMessage());
        }
    }

    private String getFileName(String fileNameFromRequest, String mailPartFileName, String baseType) {
        if (!GetAttachmentAction.isEmpty(fileNameFromRequest)) {
            return AJAXUtility.encodeUrl(fileNameFromRequest, true);
        }
        if (!GetAttachmentAction.isEmpty(mailPartFileName)) {
            return mailPartFileName;
        }
        String fileExtension = GetAttachmentAction.isEmpty(baseType) ? "dat" : MimeType2ExtMap.getFileExtension(baseType);
        return "file." + fileExtension;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AJAXRequestResult performPUT(MailRequest req, JSONObject bodyObject) throws OXException {
        AJAXRequestResult aJAXRequestResult;
        block15: {
            IDBasedFileAccess fileAccess;
            block16: {
                ServerSession session = req.getSession();
                String folderPath = req.checkParameter(PARAMETER_FOLDERID);
                String uid = req.checkParameter(PARAMETER_ID);
                String sequenceId = req.checkParameter(PARAMETER_MAILATTCHMENT);
                String destFolderIdentifier = req.checkParameter("dest_folder");
                MailServletInterface mailInterface = this.getMailInterface(req);
                ServerServiceRegistry serviceRegistry = ServerServiceRegistry.getInstance();
                fileAccess = serviceRegistry.getService(IDBasedFileAccessFactory.class).createAccess((Session)session);
                boolean performRollback = false;
                try {
                    if (!session.getUserPermissionBits().hasInfostore()) {
                        throw MailExceptionCode.NO_MAIL_ACCESS.create();
                    }
                    MailPart mailPart = mailInterface.getMessageAttachment(folderPath, uid, sequenceId, false);
                    if (mailPart == null) {
                        throw MailExceptionCode.NO_ATTACHMENT_FOUND.create(sequenceId);
                    }
                    String destFolderID = destFolderIdentifier;
                    FileMetadataParserService parser = serviceRegistry.getService(FileMetadataParserService.class, true);
                    JSONObject jsonFileObject = bodyObject;
                    File file = parser.parse(jsonFileObject);
                    List fields = parser.getFields(jsonFileObject);
                    EnumSet set = EnumSet.copyOf(fields);
                    String mimeType = mailPart.getContentType().getBaseType();
                    String fileName = mailPart.getFileName();
                    if (GetAttachmentAction.isEmpty(fileName)) {
                        fileName = "part_" + sequenceId + ".dat";
                    } else {
                        String contentTypeByFileName = MimeType2ExtMap.getContentType(fileName);
                        if (!MIME_APPL_OCTET.equals(contentTypeByFileName) && !MimeTypes.equalPrimaryTypes(mimeType, contentTypeByFileName)) {
                            mimeType = contentTypeByFileName;
                        }
                    }
                    fileName = fileName.replaceAll(Pattern.quote("/"), "_");
                    if (!set.contains(File.Field.FILENAME) || GetAttachmentAction.isEmpty(file.getFileName())) {
                        file.setFileName(fileName);
                    }
                    file.setFileMIMEType(mimeType);
                    file.setFileSize(0L);
                    if (!set.contains(File.Field.TITLE) || GetAttachmentAction.isEmpty(file.getTitle())) {
                        file.setTitle(fileName);
                    }
                    file.setFolderId(destFolderID);
                    fileAccess.startTransaction();
                    performRollback = true;
                    fileAccess.saveDocument(file, mailPart.getInputStream(), System.currentTimeMillis(), fields);
                    fileAccess.commit();
                    performRollback = false;
                    JSONObject jFileData = new JSONObject(8);
                    jFileData.put("mailFolder", (Object)folderPath);
                    jFileData.put("mailUID", (Object)uid);
                    jFileData.put(PARAMETER_ID, (Object)file.getId());
                    jFileData.put("folder_id", (Object)file.getFolderId());
                    jFileData.put("filename", (Object)file.getFileName());
                    aJAXRequestResult = new AJAXRequestResult((Object)jFileData, "json");
                    if (fileAccess == null) break block15;
                    if (!performRollback) break block16;
                }
                catch (Throwable throwable) {
                    try {
                        if (fileAccess != null) {
                            if (performRollback) {
                                fileAccess.rollback();
                            }
                            fileAccess.finish();
                        }
                        throw throwable;
                    }
                    catch (JSONException e) {
                        throw MailExceptionCode.JSON_ERROR.create(e, e.getMessage());
                    }
                    catch (RuntimeException e) {
                        throw MailExceptionCode.UNEXPECTED_ERROR.create(e, e.getMessage());
                    }
                }
                fileAccess.rollback();
            }
            fileAccess.finish();
        }
        return aJAXRequestResult;
    }

    static String sanitizeHtml(String htmlContent, HtmlService htmlService) {
        return htmlService.sanitize(htmlContent, null, false, null, null);
    }

    private String getHash(String folderPath, String uid, String sequenceId) {
        return HashUtility.getHash(new StringBuilder(32).append(folderPath).append('/').append(uid).append('/').append(sequenceId).toString(), "md5", "hex");
    }

    private static final class ReconnectingInputStreamClosure
    implements IFileHolder.InputStreamClosure {
        private final ServerSession session;
        private final String id;
        private final String uid;
        private final MailPart mailPart;
        private final String folderPath;
        private final boolean image;
        private volatile ThresholdFileHolder tfh;

        ReconnectingInputStreamClosure(MailPart mailPart, String folderPath, String uid, String id, boolean image, ServerSession session) {
            this.session = session;
            this.id = id;
            this.uid = uid;
            this.mailPart = mailPart;
            this.folderPath = folderPath;
            this.image = image;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public InputStream newStream() throws OXException, IOException {
            ThresholdFileHolder tfh = this.tfh;
            if (null != tfh) {
                return tfh.getStream();
            }
            try {
                PushbackInputStream in = new PushbackInputStream(this.mailPart.getInputStream());
                int read = in.read();
                if (read < 0) {
                    return Streams.EMPTY_INPUT_STREAM;
                }
                in.unread(read);
                return in;
            }
            catch (FolderClosedIOException e) {
                FullnameArgument fa = MailFolderUtility.prepareMailFolderParam(this.folderPath);
                MailAccess<IMailFolderStorage, IMailMessageStorage> ma = null;
                try {
                    ma = MailAccess.getInstance(this.session, fa.getAccountId());
                    ma.connect(false);
                    ThresholdFileHolder newTfh = new ThresholdFileHolder();
                    if (this.image) {
                        newTfh.write(ma.getMessageStorage().getImageAttachment(fa.getFullName(), this.uid, this.id).getInputStream());
                    } else {
                        newTfh.write(ma.getMessageStorage().getAttachment(fa.getFullName(), this.uid, this.id).getInputStream());
                    }
                    this.tfh = newTfh;
                    InputStream inputStream = newTfh.getStream();
                    return inputStream;
                }
                finally {
                    if (null != ma) {
                        ma.close(true);
                    }
                }
            }
        }
    }
}

