/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.dataobjects.compose;

import com.openexchange.exception.OXException;
import com.openexchange.filemanagement.ManagedFileManagement;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.mail.dataobjects.MailMessage;
import com.openexchange.mail.dataobjects.MailPart;
import com.openexchange.mail.dataobjects.compose.ComposeType;
import com.openexchange.mail.dataobjects.compose.ComposedMailPart;
import com.openexchange.mail.dataobjects.compose.DataMailPart;
import com.openexchange.mail.dataobjects.compose.ReferencedMailPart;
import com.openexchange.mail.dataobjects.compose.TextBodyMailPart;
import com.openexchange.mail.dataobjects.compose.UploadFileMailPart;
import com.openexchange.mail.mime.QuotedInternetAddress;
import com.openexchange.mail.mime.filler.MimeMessageFiller;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.session.Session;
import java.io.File;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.mail.internet.InternetAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ComposedMailMessage
extends MailMessage {
    private static final transient Logger LOG = LoggerFactory.getLogger(ComposedMailMessage.class);
    private static final long serialVersionUID = -6179506566418364076L;
    private final Session session;
    private final Context ctx;
    private ComposeType sendType;
    private transient MimeMessageFiller filler;
    private final Set<InternetAddress> recipients;

    protected ComposedMailMessage(Session session, Context ctx) {
        this.session = session;
        this.ctx = ctx;
        this.recipients = new HashSet<InternetAddress>();
    }

    public void setSendType(ComposeType sendType) {
        this.sendType = sendType;
    }

    public ComposeType getSendType() {
        return this.sendType;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        throw new NotSerializableException(ComposedMailMessage.class.getName());
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        throw new NotSerializableException(ComposedMailMessage.class.getName());
    }

    public boolean hasRecipients() {
        return !this.recipients.isEmpty();
    }

    public InternetAddress[] getRecipients() {
        return this.recipients.toArray(new QuotedInternetAddress[this.recipients.size()]);
    }

    public void addRecipient(InternetAddress recipient) {
        this.recipients.add(recipient);
    }

    public void addRecipients(InternetAddress[] recipients) {
        this.recipients.addAll(Arrays.asList(recipients));
    }

    public Session getSession() {
        return this.session;
    }

    public Context getContext() {
        return this.ctx;
    }

    public void setFiller(MimeMessageFiller filler) {
        this.filler = filler;
    }

    public void cleanUp() {
        if (null != this.filler) {
            this.filler.deleteReferencedUploadFiles();
        }
        try {
            int count = this.getEnclosedCount();
            ManagedFileManagement mfm = ServerServiceRegistry.getInstance().getService(ManagedFileManagement.class);
            for (int i = 0; i < count; ++i) {
                File f;
                String fileId;
                if (!(this.getEnclosedMailPart(i) instanceof ComposedMailPart)) continue;
                ComposedMailPart composedMailPart = (ComposedMailPart)((Object)this.getEnclosedMailPart(i));
                if (ComposedMailPart.ComposedPartType.REFERENCE.equals((Object)composedMailPart.getType())) {
                    fileId = ((ReferencedMailPart)composedMailPart).getFileID();
                    if (null == fileId) continue;
                    try {
                        mfm.removeByID(fileId);
                    }
                    catch (OXException e) {
                        LOG.warn("", (Throwable)e);
                    }
                    continue;
                }
                if (ComposedMailPart.ComposedPartType.DATA.equals((Object)composedMailPart.getType())) {
                    fileId = ((DataMailPart)composedMailPart).getFileID();
                    if (null == fileId) continue;
                    try {
                        mfm.removeByID(fileId);
                    }
                    catch (OXException e) {
                        LOG.warn("", (Throwable)e);
                    }
                    continue;
                }
                if (!ComposedMailPart.ComposedPartType.FILE.equals((Object)composedMailPart.getType()) || !(f = ((UploadFileMailPart)composedMailPart).getUploadFile()).exists() || f.delete()) continue;
                LOG.warn("Temporary store file '{}' could not be deleted.", (Object)f.getName());
            }
        }
        catch (OXException e) {
            LOG.error("", (Throwable)e);
        }
    }

    @Override
    public int getUnreadMessages() {
        throw new UnsupportedOperationException("ComposedMailMessage.getUnreadMessages() not supported");
    }

    @Override
    public void setUnreadMessages(int unreadMessages) {
        throw new UnsupportedOperationException("ComposedMailMessage.setUnreadMessages() not supported");
    }

    @Override
    public abstract int getEnclosedCount() throws OXException;

    @Override
    public abstract MailPart getEnclosedMailPart(int var1) throws OXException;

    public abstract void setBodyPart(TextBodyMailPart var1);

    public abstract TextBodyMailPart getBodyPart();

    public abstract MailPart removeEnclosedPart(int var1);

    public abstract void addEnclosedPart(MailPart var1);
}

