/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.config;

import com.openexchange.config.ConfigurationService;
import com.openexchange.exception.OXException;
import com.openexchange.java.Streams;
import com.openexchange.java.Strings;
import com.openexchange.mail.api.IMailProperties;
import com.openexchange.mail.api.MailConfig;
import com.openexchange.mail.config.IPRange;
import com.openexchange.mail.config.MailConfigException;
import com.openexchange.mail.partmodifier.DummyPartModifier;
import com.openexchange.mail.partmodifier.PartModifier;
import com.openexchange.server.services.ServerServiceRegistry;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MailProperties
implements IMailProperties {
    private static final Logger LOG = LoggerFactory.getLogger(MailProperties.class);
    private static volatile MailProperties instance;
    private final AtomicBoolean loaded = new AtomicBoolean();
    private MailConfig.LoginSource loginSource;
    private MailConfig.PasswordSource passwordSource;
    private MailConfig.ServerSource mailServerSource;
    private MailConfig.ServerSource transportServerSource;
    private String mailServer;
    private String transportServer;
    private String masterPassword;
    private int mailFetchLimit;
    private int attachDisplaySize;
    private boolean userFlagsEnabled;
    private boolean allowNestedDefaultFolderOnAltNamespace;
    private String defaultMimeCharset;
    private boolean ignoreSubscription;
    private boolean hidePOP3StorageFolders;
    private char defaultSeparator = (char)47;
    private String[] quoteLineColors;
    private Properties javaMailProperties;
    private boolean watcherEnabled;
    private int watcherTime;
    private int watcherFrequency;
    private boolean watcherShallClose;
    private boolean supportSubscription;
    private String[] phishingHeaders;
    private String defaultMailProvider;
    private boolean adminMailLoginEnabled;
    private int mailAccessCacheShrinkerSeconds;
    private int mailAccessCacheIdleSeconds;
    private boolean addClientIPAddress;
    private boolean rateLimitPrimaryOnly;
    private int rateLimit;
    private int maxToCcBcc;
    private String authProxyDelimiter;
    private boolean supportMsisdnAddresses;
    private List<IPRange> accountBlacklistRanges;
    private boolean enforceSecureConnection;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static MailProperties getInstance() {
        MailProperties tmp = instance;
        if (null != tmp) return tmp;
        Class<MailProperties> clazz = MailProperties.class;
        synchronized (MailProperties.class) {
            tmp = instance;
            if (null != tmp) return tmp;
            instance = new MailProperties();
            return instance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void releaseInstance() {
        if (null == instance) return;
        Class<MailProperties> clazz = MailProperties.class;
        synchronized (MailProperties.class) {
            if (null == instance) return;
            instance = null;
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    private MailProperties() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadProperties() throws OXException {
        if (!this.loaded.get()) {
            AtomicBoolean atomicBoolean = this.loaded;
            synchronized (atomicBoolean) {
                if (!this.loaded.get()) {
                    this.loadProperties0();
                    this.loaded.set(true);
                    this.loaded.notifyAll();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetProperties() {
        if (this.loaded.get()) {
            AtomicBoolean atomicBoolean = this.loaded;
            synchronized (atomicBoolean) {
                if (this.loaded.get()) {
                    this.resetFields();
                    this.loaded.set(false);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void waitForLoading() throws InterruptedException {
        if (!this.loaded.get()) {
            AtomicBoolean atomicBoolean = this.loaded;
            synchronized (atomicBoolean) {
                while (!this.loaded.get()) {
                    this.loaded.wait();
                }
            }
        }
    }

    private void resetFields() {
        this.loginSource = null;
        this.passwordSource = null;
        this.mailServerSource = null;
        this.transportServerSource = null;
        this.mailServer = null;
        this.transportServer = null;
        this.masterPassword = null;
        this.mailFetchLimit = 0;
        this.attachDisplaySize = 0;
        this.userFlagsEnabled = false;
        this.allowNestedDefaultFolderOnAltNamespace = false;
        this.defaultMimeCharset = null;
        this.ignoreSubscription = false;
        this.hidePOP3StorageFolders = false;
        this.defaultSeparator = (char)47;
        this.quoteLineColors = null;
        this.javaMailProperties = null;
        this.watcherEnabled = false;
        this.watcherTime = 0;
        this.watcherFrequency = 0;
        this.watcherShallClose = false;
        this.supportSubscription = false;
        this.defaultMailProvider = null;
        this.adminMailLoginEnabled = false;
        this.mailAccessCacheShrinkerSeconds = 0;
        this.mailAccessCacheIdleSeconds = 0;
        this.addClientIPAddress = false;
        this.rateLimitPrimaryOnly = true;
        this.rateLimit = 0;
        this.maxToCcBcc = 0;
        this.authProxyDelimiter = null;
        this.supportMsisdnAddresses = false;
        this.accountBlacklistRanges = null;
        this.enforceSecureConnection = false;
    }

    private void loadProperties0() throws OXException {
        String defaultMailProviderStr;
        StringBuilder logBuilder = new StringBuilder(1024);
        logBuilder.append("\nLoading global mail properties...\n");
        ConfigurationService configuration = ServerServiceRegistry.getInstance().getService(ConfigurationService.class);
        String loginStr = configuration.getProperty("com.openexchange.mail.loginSource");
        if (loginStr == null) {
            throw MailConfigException.create("Property \"com.openexchange.mail.loginSource\" not set");
        }
        MailConfig.LoginSource loginSource = MailConfig.LoginSource.parse(loginStr.trim());
        if (null == loginSource) {
            throw MailConfigException.create(new StringBuilder(256).append("Unknown value in property \"com.openexchange.mail.loginSource\": ").append(loginStr).toString());
        }
        this.loginSource = loginSource;
        logBuilder.append("\tLogin Source: ").append(this.loginSource.toString()).append('\n');
        String pwStr = configuration.getProperty("com.openexchange.mail.passwordSource");
        if (pwStr == null) {
            throw MailConfigException.create("Property \"com.openexchange.mail.passwordSource\" not set");
        }
        MailConfig.PasswordSource pwSource = MailConfig.PasswordSource.parse(pwStr.trim());
        if (null == pwSource) {
            throw MailConfigException.create(new StringBuilder(256).append("Unknown value in property \"com.openexchange.mail.passwordSource\": ").append(pwStr).toString());
        }
        this.passwordSource = pwSource;
        logBuilder.append("\tPassword Source: ").append(this.passwordSource.toString()).append('\n');
        String mailSrcStr = configuration.getProperty("com.openexchange.mail.mailServerSource");
        if (mailSrcStr == null) {
            throw MailConfigException.create("Property \"com.openexchange.mail.mailServerSource\" not set");
        }
        MailConfig.ServerSource mailServerSource = MailConfig.ServerSource.parse(mailSrcStr.trim());
        if (null == mailServerSource) {
            throw MailConfigException.create(new StringBuilder(256).append("Unknown value in property \"com.openexchange.mail.mailServerSource\": ").append(mailSrcStr).toString());
        }
        this.mailServerSource = mailServerSource;
        logBuilder.append("\tMail Server Source: ").append(this.mailServerSource.toString()).append('\n');
        String transSrcStr = configuration.getProperty("com.openexchange.mail.transportServerSource");
        if (transSrcStr == null) {
            throw MailConfigException.create("Property \"com.openexchange.mail.transportServerSource\" not set");
        }
        MailConfig.ServerSource transportServerSource = MailConfig.ServerSource.parse(transSrcStr.trim());
        if (null == transportServerSource) {
            throw MailConfigException.create(new StringBuilder(256).append("Unknown value in property \"com.openexchange.mail.transportServerSource\": ").append(transSrcStr).toString());
        }
        this.transportServerSource = transportServerSource;
        logBuilder.append("\tTransport Server Source: ").append(this.transportServerSource.toString()).append('\n');
        this.mailServer = configuration.getProperty("com.openexchange.mail.mailServer");
        if (this.mailServer != null) {
            this.mailServer = this.mailServer.trim();
        }
        this.transportServer = configuration.getProperty("com.openexchange.mail.transportServer");
        if (this.transportServer != null) {
            this.transportServer = this.transportServer.trim();
        }
        this.masterPassword = configuration.getProperty("com.openexchange.mail.masterPassword");
        if (this.masterPassword != null) {
            this.masterPassword = this.masterPassword.trim();
        }
        String fallbackPrefix = "\". Setting to fallback: ";
        String mailFetchLimitStr = configuration.getProperty("com.openexchange.mail.mailFetchLimit", "1000").trim();
        try {
            this.mailFetchLimit = Integer.parseInt(mailFetchLimitStr);
            logBuilder.append("\tMail Fetch Limit: ").append(this.mailFetchLimit).append('\n');
        }
        catch (NumberFormatException e) {
            this.mailFetchLimit = 1000;
            logBuilder.append("\tMail Fetch Limit: Non parseable value \"").append(mailFetchLimitStr).append("\". Setting to fallback: ").append(this.mailFetchLimit).append('\n');
        }
        String attachDisplaySizeStr = configuration.getProperty("com.openexchange.mail.attachmentDisplaySizeLimit", "8192").trim();
        try {
            this.attachDisplaySize = Integer.parseInt(attachDisplaySizeStr);
            logBuilder.append("\tAttachment Display Size Limit: ").append(this.attachDisplaySize).append('\n');
        }
        catch (NumberFormatException e) {
            this.attachDisplaySize = 8192;
            logBuilder.append("\tAttachment Display Size Limit: Non parseable value \"").append(attachDisplaySizeStr).append("\". Setting to fallback: ").append(this.attachDisplaySize).append('\n');
        }
        String tmp = configuration.getProperty("com.openexchange.mail.mailAccessCacheShrinkerSeconds", "3").trim();
        try {
            this.mailAccessCacheShrinkerSeconds = Integer.parseInt(tmp);
            logBuilder.append("\tMail Access Cache shrinker-interval seconds: ").append(this.mailAccessCacheShrinkerSeconds).append('\n');
        }
        catch (NumberFormatException e) {
            this.mailAccessCacheShrinkerSeconds = 3;
            logBuilder.append("\tMail Access Cache shrinker-interval seconds: Non parseable value \"").append(tmp).append("\". Setting to fallback: ").append(this.mailAccessCacheShrinkerSeconds).append('\n');
        }
        tmp = configuration.getProperty("com.openexchange.mail.mailAccessCacheIdleSeconds", "4").trim();
        try {
            this.mailAccessCacheIdleSeconds = Integer.parseInt(tmp);
            logBuilder.append("\tMail Access Cache idle seconds: ").append(this.mailAccessCacheIdleSeconds).append('\n');
        }
        catch (NumberFormatException e) {
            this.mailAccessCacheIdleSeconds = 4;
            logBuilder.append("\tMail Access Cache idle seconds: Non parseable value \"").append(tmp).append("\". Setting to fallback: ").append(this.mailAccessCacheIdleSeconds).append('\n');
        }
        String userFlagsStr = configuration.getProperty("com.openexchange.mail.userFlagsEnabled", "false").trim();
        this.userFlagsEnabled = Boolean.parseBoolean(userFlagsStr);
        logBuilder.append("\tUser Flags Enabled: ").append(this.userFlagsEnabled).append('\n');
        String allowNestedStr = configuration.getProperty("com.openexchange.mail.allowNestedDefaultFolderOnAltNamespace", "false").trim();
        this.allowNestedDefaultFolderOnAltNamespace = Boolean.parseBoolean(allowNestedStr);
        logBuilder.append("\tAllow Nested Default Folders on AltNamespace: ").append(this.allowNestedDefaultFolderOnAltNamespace).append('\n');
        String defaultMimeCharsetStr = configuration.getProperty("mail.mime.charset", "UTF-8").trim();
        try {
            Charset.forName(defaultMimeCharsetStr);
            this.defaultMimeCharset = defaultMimeCharsetStr;
            logBuilder.append("\tDefault MIME Charset: ").append(this.defaultMimeCharset).append('\n');
        }
        catch (Throwable t) {
            this.defaultMimeCharset = "UTF-8";
            logBuilder.append("\tDefault MIME Charset: Unsupported charset \"").append(defaultMimeCharsetStr).append("\". Setting to fallback: ").append(this.defaultMimeCharset).append('\n');
        }
        System.getProperties().setProperty("mail.mime.charset", this.defaultMimeCharset);
        this.defaultMailProvider = defaultMailProviderStr = configuration.getProperty("com.openexchange.mail.defaultMailProvider", "imap").trim();
        logBuilder.append("\tDefault Mail Provider: ").append(this.defaultMailProvider).append('\n');
        String adminMailLoginEnabledStr = configuration.getProperty("com.openexchange.mail.adminMailLoginEnabled", "false").trim();
        this.adminMailLoginEnabled = Boolean.parseBoolean(adminMailLoginEnabledStr);
        logBuilder.append("\tAdmin Mail Login Enabled: ").append(this.adminMailLoginEnabled).append('\n');
        String ignoreSubsStr = configuration.getProperty("com.openexchange.mail.ignoreSubscription", "false").trim();
        this.ignoreSubscription = Boolean.parseBoolean(ignoreSubsStr);
        logBuilder.append("\tIgnore Folder Subscription: ").append(this.ignoreSubscription).append('\n');
        tmp = configuration.getProperty("com.openexchange.mail.hidePOP3StorageFolders", "false").trim();
        this.hidePOP3StorageFolders = Boolean.parseBoolean(tmp);
        logBuilder.append("\tHide POP3 Storage Folders: ").append(this.hidePOP3StorageFolders).append('\n');
        String supSubsStr = configuration.getProperty("com.openexchange.mail.supportSubscription", "true").trim();
        this.supportSubscription = Boolean.parseBoolean(supSubsStr);
        logBuilder.append("\tSupport Subscription: ").append(this.supportSubscription).append('\n');
        tmp = configuration.getProperty("com.openexchange.mail.addClientIPAddress", "false").trim();
        this.addClientIPAddress = Boolean.parseBoolean(tmp);
        logBuilder.append("\tAdd Client IP Address: ").append(this.addClientIPAddress).append('\n');
        tmp = configuration.getProperty("com.openexchange.mail.enforceSecureConnection", "false").trim();
        this.enforceSecureConnection = Boolean.parseBoolean(tmp);
        logBuilder.append("\tEnforced secure connections to external accounts: ").append(this.enforceSecureConnection).append('\n');
        char defaultSep = configuration.getProperty("com.openexchange.mail.defaultSeparator", "/").trim().charAt(0);
        if (defaultSep <= ' ') {
            this.defaultSeparator = (char)47;
            logBuilder.append("\tDefault Separator: Invalid separator (decimal ascii value=").append((int)defaultSep).append("). Setting to fallback: ").append(this.defaultSeparator).append('\n');
        } else {
            this.defaultSeparator = defaultSep;
            logBuilder.append("\tDefault Separator: ").append(this.defaultSeparator).append('\n');
        }
        String partModifierStr = configuration.getProperty("com.openexchange.mail.partModifierImpl", DummyPartModifier.class.getName()).trim();
        try {
            PartModifier.init(partModifierStr);
            logBuilder.append("\tPartModifier Implementation: ").append(PartModifier.getInstance().getClass().getName()).append('\n');
        }
        catch (OXException e) {
            try {
                PartModifier.init(DummyPartModifier.class.getName());
            }
            catch (OXException e1) {
                LOG.error("", (Throwable)e);
            }
            logBuilder.append("\tPartModifier Implementation: Unknown class \"").append(partModifierStr).append("\". Setting to fallback: ").append(DummyPartModifier.class.getName()).append('\n');
        }
        String quoteColors = configuration.getProperty("com.openexchange.mail.quoteLineColors", "#666666").trim();
        if (Pattern.matches("((#[0-9a-fA-F&&[^,]]{6})(?:\r?\n|\\z|\\s*,\\s*))+", quoteColors)) {
            this.quoteLineColors = quoteColors.split("\\s*,\\s*");
            logBuilder.append("\tHTML Quote Colors: ").append(quoteColors).append('\n');
        } else {
            this.quoteLineColors = new String[]{"#666666"};
            logBuilder.append("\tHTML Quote Colors: Invalid sequence of colors \"").append(quoteColors).append("\". Setting to fallback: #666666").append('\n');
        }
        String watcherEnabledStr = configuration.getProperty("com.openexchange.mail.watcherEnabled", "false").trim();
        this.watcherEnabled = Boolean.parseBoolean(watcherEnabledStr);
        logBuilder.append("\tWatcher Enabled: ").append(this.watcherEnabled).append('\n');
        String watcherTimeStr = configuration.getProperty("com.openexchange.mail.watcherTime", "60000").trim();
        try {
            this.watcherTime = Integer.parseInt(watcherTimeStr);
            logBuilder.append("\tWatcher Time: ").append(this.watcherTime).append('\n');
        }
        catch (NumberFormatException e) {
            this.watcherTime = 60000;
            logBuilder.append("\tWatcher Time: Invalid value \"").append(watcherTimeStr).append("\". Setting to fallback: ").append(this.watcherTime).append('\n');
        }
        String watcherFeqStr = configuration.getProperty("com.openexchange.mail.watcherFrequency", "10000").trim();
        try {
            this.watcherFrequency = Integer.parseInt(watcherFeqStr);
            logBuilder.append("\tWatcher Frequency: ").append(this.watcherFrequency).append('\n');
        }
        catch (NumberFormatException e) {
            this.watcherFrequency = 10000;
            logBuilder.append("\tWatcher Frequency: Invalid value \"").append(watcherFeqStr).append("\". Setting to fallback: ").append(this.watcherFrequency).append('\n');
        }
        String watcherShallCloseStr = configuration.getProperty("com.openexchange.mail.watcherShallClose", "false").trim();
        this.watcherShallClose = Boolean.parseBoolean(watcherShallCloseStr);
        logBuilder.append("\tWatcher Shall Close: ").append(this.watcherShallClose).append('\n');
        String phishingHdrsStr = configuration.getProperty("com.openexchange.mail.phishingHeader", "").trim();
        this.phishingHeaders = null != phishingHdrsStr && phishingHdrsStr.length() > 0 ? phishingHdrsStr.split(" *, *") : null;
        String rateLimitPrimaryOnlyStr = configuration.getProperty("com.openexchange.mail.rateLimitPrimaryOnly", "true").trim();
        this.rateLimitPrimaryOnly = Boolean.parseBoolean(rateLimitPrimaryOnlyStr);
        logBuilder.append("\tRate limit primary only: ").append(this.rateLimitPrimaryOnly).append('\n');
        String rateLimitStr = configuration.getProperty("com.openexchange.mail.rateLimit", "0").trim();
        try {
            this.rateLimit = Integer.parseInt(rateLimitStr);
            logBuilder.append("\tSent Rate limit: ").append(this.rateLimit).append('\n');
        }
        catch (NumberFormatException e) {
            this.rateLimit = 0;
            logBuilder.append("\tSent Rate limit: Invalid value \"").append(rateLimitStr).append("\". Setting to fallback ").append(this.rateLimit).append('\n');
        }
        String maxToCcBccStr = configuration.getProperty("com.openexchange.mail.maxToCcBcc", "0").trim();
        try {
            this.maxToCcBcc = Integer.parseInt(maxToCcBccStr);
            logBuilder.append("\tmaxToCcBcc: ").append(this.maxToCcBcc).append('\n');
        }
        catch (NumberFormatException e) {
            this.maxToCcBcc = 0;
            logBuilder.append("\tmaxToCcBcc: Invalid value \"").append(maxToCcBccStr).append("\". Setting to fallback ").append(this.maxToCcBcc).append('\n');
        }
        String javaMailPropertiesStr = configuration.getProperty("com.openexchange.mail.JavaMailProperties");
        if (null != javaMailPropertiesStr) {
            javaMailPropertiesStr = javaMailPropertiesStr.trim();
            File javaMailPropsFile = configuration.getFileByName(javaMailPropertiesStr);
            try {
                this.javaMailProperties = MailProperties.readPropertiesFromFile(new FileInputStream(javaMailPropsFile));
                if (this.javaMailProperties.size() == 0) {
                    this.javaMailProperties = null;
                }
            }
            catch (FileNotFoundException e) {
                this.javaMailProperties = null;
            }
        }
        logBuilder.append("\tJavaMail Properties loaded: ").append(this.javaMailProperties != null).append('\n');
        this.authProxyDelimiter = configuration.getProperty("com.openexchange.mail.authProxyDelimiter");
        if (this.authProxyDelimiter != null) {
            this.authProxyDelimiter = this.authProxyDelimiter.trim();
            if (this.authProxyDelimiter.length() == 0) {
                this.authProxyDelimiter = null;
            }
        }
        String supportMsisdnAddressesStr = configuration.getProperty("com.openexchange.mail.supportMsisdnAddresses", "false").trim();
        this.supportMsisdnAddresses = Boolean.parseBoolean(supportMsisdnAddressesStr);
        logBuilder.append("\tSupports MSISDN addresses: ").append(this.supportMsisdnAddresses).append('\n');
        tmp = configuration.getProperty("com.openexchange.mail.account.blacklist", "").trim();
        if (!Strings.isEmpty((String)tmp)) {
            String[] sRanges;
            tmp = Strings.unquote((String)tmp);
            LinkedList<IPRange> ranges = new LinkedList<IPRange>();
            for (String sRange : sRanges = Strings.splitByComma((String)tmp)) {
                if (Strings.isEmpty((String)(sRange = sRange.replaceAll("\\s", "")))) continue;
                ranges.add(IPRange.parseRange(sRange));
            }
            this.accountBlacklistRanges = ranges.isEmpty() ? null : ranges;
        }
        logBuilder.append("Global mail properties successfully loaded!");
        LOG.info(logBuilder.toString());
    }

    protected static Properties readPropertiesFromFile(String propFile) throws OXException {
        FileInputStream fis;
        Properties properties = new Properties();
        try {
            fis = new FileInputStream(new File(propFile));
        }
        catch (FileNotFoundException e) {
            throw MailConfigException.create(new StringBuilder(256).append("Properties not found at location: ").append(propFile).toString(), e);
        }
        try {
            properties.load(fis);
            Properties e = properties;
            return e;
        }
        catch (IOException e) {
            throw MailConfigException.create(new StringBuilder(256).append("I/O error while reading properties from file \"").append(propFile).append("\": ").append(e.getMessage()).toString(), e);
        }
        finally {
            Streams.close((Closeable)fis);
        }
    }

    protected static Properties readPropertiesFromFile(InputStream in) throws OXException {
        Properties properties = new Properties();
        try {
            properties.load(in);
            Properties properties2 = properties;
            return properties2;
        }
        catch (IOException e) {
            throw MailConfigException.create(new StringBuilder(256).append("I/O error: ").append(e.getMessage()).toString(), e);
        }
        finally {
            Streams.close((Closeable)in);
        }
    }

    @Override
    public boolean isAllowNestedDefaultFolderOnAltNamespace() {
        return this.allowNestedDefaultFolderOnAltNamespace;
    }

    @Override
    public int getAttachDisplaySize() {
        return this.attachDisplaySize;
    }

    public boolean isEnforceSecureConnection() {
        return this.enforceSecureConnection;
    }

    public List<IPRange> getAccountBlacklistRanges() {
        return this.accountBlacklistRanges;
    }

    public String getDefaultMimeCharset() {
        return this.defaultMimeCharset;
    }

    public String getDefaultMailProvider() {
        return this.defaultMailProvider;
    }

    public boolean isAdminMailLoginEnabled() {
        return this.adminMailLoginEnabled;
    }

    @Override
    public char getDefaultSeparator() {
        return this.defaultSeparator;
    }

    @Override
    public boolean isIgnoreSubscription() {
        return this.ignoreSubscription;
    }

    public boolean isHidePOP3StorageFolders() {
        return this.hidePOP3StorageFolders;
    }

    @Override
    public boolean isSupportSubscription() {
        return this.supportSubscription;
    }

    public boolean isAddClientIPAddress() {
        return this.addClientIPAddress;
    }

    public Properties getJavaMailProperties() {
        return this.javaMailProperties;
    }

    public MailConfig.LoginSource getLoginSource() {
        return this.loginSource;
    }

    public MailConfig.PasswordSource getPasswordSource() {
        return this.passwordSource;
    }

    public MailConfig.ServerSource getMailServerSource() {
        return this.mailServerSource;
    }

    public MailConfig.ServerSource getTransportServerSource() {
        return this.transportServerSource;
    }

    @Override
    public int getMailFetchLimit() {
        return this.mailFetchLimit;
    }

    public String getMailServer() {
        return this.mailServer;
    }

    public String getMasterPassword() {
        return this.masterPassword;
    }

    public int getMaxToCcBcc() {
        return this.maxToCcBcc;
    }

    public String[] getQuoteLineColors() {
        return this.quoteLineColors;
    }

    public int getRateLimit() {
        return this.rateLimit;
    }

    public boolean getRateLimitPrimaryOnly() {
        return this.rateLimitPrimaryOnly;
    }

    public String getTransportServer() {
        return this.transportServer;
    }

    @Override
    public boolean isUserFlagsEnabled() {
        return this.userFlagsEnabled;
    }

    @Override
    public boolean isWatcherEnabled() {
        return this.watcherEnabled;
    }

    @Override
    public int getWatcherFrequency() {
        return this.watcherFrequency;
    }

    @Override
    public boolean isWatcherShallClose() {
        return this.watcherShallClose;
    }

    @Override
    public int getWatcherTime() {
        return this.watcherTime;
    }

    public String[] getPhishingHeaders() {
        if (null == this.phishingHeaders) {
            return null;
        }
        String[] retval = new String[this.phishingHeaders.length];
        System.arraycopy(this.phishingHeaders, 0, retval, 0, this.phishingHeaders.length);
        return retval;
    }

    @Override
    public int getMailAccessCacheShrinkerSeconds() {
        return this.mailAccessCacheShrinkerSeconds;
    }

    @Override
    public int getMailAccessCacheIdleSeconds() {
        return this.mailAccessCacheIdleSeconds;
    }

    public final String getAuthProxyDelimiter() {
        return this.authProxyDelimiter;
    }

    public void setAuthProxyDelimiter(String authProxyDelimiter) {
        this.authProxyDelimiter = authProxyDelimiter;
    }

    public boolean isSupportMsisdnAddresses() {
        return this.supportMsisdnAddresses;
    }
}

