/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail;

import com.openexchange.mail.api.MailAccess;
import com.openexchange.mail.config.MailProperties;
import com.openexchange.mail.watcher.MailAccessDelayElement;
import com.openexchange.mail.watcher.MailAccessDelayQueue;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.timer.ScheduledTimerTask;
import com.openexchange.timer.TimerService;
import java.util.LinkedList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MailAccessWatcher {
    private static final Logger LOG = LoggerFactory.getLogger(MailAccessWatcher.class);
    private static final MailAccessDelayQueue MAIL_ACCESSES = new MailAccessDelayQueue();
    private static boolean initialized = false;
    private static volatile ScheduledTimerTask watcherTask;

    static synchronized void init() {
        if (initialized) {
            return;
        }
        if (MailProperties.getInstance().isWatcherEnabled()) {
            TimerService timer = ServerServiceRegistry.getInstance().getService(TimerService.class);
            if (null != timer) {
                int frequencyMillis = MailProperties.getInstance().getWatcherFrequency();
                watcherTask = timer.scheduleWithFixedDelay((Runnable)new WatcherTask(MAIL_ACCESSES, LOG), 1000L, (long)frequencyMillis);
            }
            LOG.info("Mail connection watcher successfully established and ready for tracing");
        }
        initialized = true;
    }

    static synchronized void stop() {
        if (!initialized) {
            return;
        }
        if (MailProperties.getInstance().isWatcherEnabled()) {
            ScheduledTimerTask watcherTask = MailAccessWatcher.watcherTask;
            if (null != watcherTask) {
                watcherTask.cancel(false);
                MailAccessWatcher.watcherTask = null;
                TimerService timer = ServerServiceRegistry.getInstance().getService(TimerService.class);
                if (null != timer) {
                    timer.purge();
                }
            }
            LOG.info("Mail connection watcher successfully stopped");
        }
        MAIL_ACCESSES.clear();
        initialized = false;
    }

    private MailAccessWatcher() {
    }

    public static void addMailAccess(MailAccess<?, ?> mailAccess) {
        MAIL_ACCESSES.put(new MailAccessDelayElement(mailAccess, System.currentTimeMillis()));
    }

    public static void removeMailAccess(MailAccess<?, ?> mailAccess) {
        MAIL_ACCESSES.remove(new MailAccessDelayElement(mailAccess, 0L));
    }

    public static int getNumberOfMailAccesses() {
        return MAIL_ACCESSES.size();
    }

    public static int getNumberOfIdlingMailAccesses() {
        int count = 0;
        for (MailAccessDelayElement element : MAIL_ACCESSES) {
            MailAccess<?, ?> mailAccess = element.mailAccess;
            if (!mailAccess.isConnectedUnsafe() || !mailAccess.isWaiting()) continue;
            ++count;
        }
        return count;
    }

    private static class WatcherTask
    implements Runnable {
        private final MailAccessDelayQueue queue;
        private final Logger logger;
        private final String lineSeparator;
        private final MailAccessDelayQueue.ElementFilter filter;

        public WatcherTask(MailAccessDelayQueue mailAccesses, final Logger logger) {
            String lineSeparator;
            this.queue = mailAccesses;
            this.logger = logger;
            this.lineSeparator = lineSeparator = System.getProperty("line.separator");
            this.filter = new MailAccessDelayQueue.ElementFilter(){

                @Override
                public boolean accept(MailAccessDelayElement element) {
                    MailAccess<?, ?> mailAccess = element.mailAccess;
                    if (!mailAccess.isConnected()) {
                        return true;
                    }
                    if (mailAccess.isWaiting()) {
                        logger.trace("Idling/waiting mail connection:{}{}", (Object)lineSeparator, (Object)mailAccess.getTrace());
                        return false;
                    }
                    return true;
                }
            };
        }

        @Override
        public void run() {
            try {
                MailAccessDelayElement expired = this.queue.poll(this.filter);
                if (null == expired) {
                    return;
                }
                StringBuilder sb = new StringBuilder(512);
                long now = System.currentTimeMillis();
                if (MailProperties.getInstance().isWatcherShallClose()) {
                    LinkedList exceededAcesses = new LinkedList();
                    do {
                        MailAccess<?, ?> mailAccess;
                        if (!(mailAccess = expired.mailAccess).isConnected()) continue;
                        long l = expired.stamp;
                        long duration = now - l;
                        sb.setLength(0);
                        sb.append("UNCLOSED MAIL CONNECTION AFTER ");
                        sb.append(duration).append("msec:");
                        mailAccess.logTrace(sb, this.logger);
                        exceededAcesses.add(mailAccess);
                    } while ((expired = this.queue.poll(this.filter)) != null);
                    for (MailAccess mailAccess : exceededAcesses) {
                        sb.setLength(0);
                        sb.append("CLOSING MAIL CONNECTION BY WATCHER:").append(this.lineSeparator).append(mailAccess.toString());
                        mailAccess.close(false);
                        sb.append(this.lineSeparator).append("    DONE");
                        this.logger.info(sb.toString());
                    }
                } else {
                    do {
                        MailAccess<?, ?> mailAccess;
                        if (!(mailAccess = expired.mailAccess).isConnected()) continue;
                        long val = expired.stamp;
                        long duration = now - val;
                        sb.setLength(0);
                        sb.append("UNCLOSED MAIL CONNECTION AFTER ");
                        sb.append(duration).append("msec:");
                        mailAccess.logTrace(sb, this.logger);
                    } while ((expired = this.queue.poll(this.filter)) != null);
                }
            }
            catch (Exception e) {
                this.logger.error("", (Throwable)e);
            }
        }
    }
}

