/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.update.tasks;

import com.openexchange.databaseold.Database;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.update.Schema;
import com.openexchange.groupware.update.UpdateExceptionCodes;
import com.openexchange.groupware.update.UpdateTask;
import com.openexchange.java.Autoboxing;
import com.openexchange.tools.update.Tools;
import java.sql.Connection;
import java.sql.SQLException;

public class CreatePublicationTablesTask
implements UpdateTask {
    public static final String CREATE_TABLE_PUBLICATIONS = "CREATE TABLE publications (id INT4 UNSIGNED NOT NULL,cid INT4 UNSIGNED NOT NULL,user_id INT4 UNSIGNED NOT NULL,entity VARCHAR(255) NOT NULL,module VARCHAR(255) NOT NULL,configuration_id INT4 UNSIGNED NOT NULL,target_id VARCHAR(255) NOT NULL,PRIMARY KEY (cid,id),FOREIGN KEY (cid,user_id) REFERENCES user(cid,id)) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci";
    public static final String CREATE_TABLE_SEQUENCE_PUBLICATIONS = "CREATE TABLE sequence_publications (cid int4 UNSIGNED NOT NULL,id int4 UNSIGNED NOT NULL,PRIMARY KEY (cid)) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci";
    private final String INSERT_IN_SEQUENCE = "INSERT INTO sequence_publications (cid,id) VALUES (?,0)";

    @Override
    public int addedWithVersion() {
        return 48;
    }

    @Override
    public int getPriority() {
        return UpdateTask.UpdateTaskPriority.NORMAL.priority;
    }

    @Override
    public void perform(Schema schema, int contextId) throws OXException {
        Connection con = Database.getNoTimeout(contextId, true);
        try {
            if (!Tools.tableExists(con, "publications")) {
                Tools.exec(con, CREATE_TABLE_PUBLICATIONS, new Object[0]);
            }
            if (!Tools.tableExists(con, "sequence_publications")) {
                Tools.exec(con, CREATE_TABLE_SEQUENCE_PUBLICATIONS, new Object[0]);
            }
            for (int ctxId : Tools.getContextIDs(con)) {
                if (Tools.hasSequenceEntry("sequence_publications", con, ctxId)) continue;
                Tools.exec(con, "INSERT INTO sequence_publications (cid,id) VALUES (?,0)", Autoboxing.I((int)ctxId));
            }
        }
        catch (SQLException e) {
            throw CreatePublicationTablesTask.createSQLError(e);
        }
        finally {
            Database.backNoTimeout(contextId, true, con);
        }
    }

    private static OXException createSQLError(SQLException e) {
        return UpdateExceptionCodes.SQL_PROBLEM.create(e, e.getMessage());
    }
}

