/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.update.tasks;

import com.openexchange.database.DatabaseService;
import com.openexchange.database.Databases;
import com.openexchange.databaseold.Database;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.update.PerformParameters;
import com.openexchange.groupware.update.UpdateExceptionCodes;
import com.openexchange.groupware.update.UpdateTaskAdapter;
import com.openexchange.groupware.update.tasks.CalendarAddNewPrimaryKeyForConfirmPerOccurrence;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.tools.sql.DBUtils;
import com.openexchange.tools.update.Tools;
import gnu.trove.map.TIntObjectMap;
import gnu.trove.map.hash.TIntObjectHashMap;
import gnu.trove.procedure.TIntObjectProcedure;
import gnu.trove.procedure.TIntProcedure;
import gnu.trove.set.TIntSet;
import gnu.trove.set.hash.TIntHashSet;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CalendarRevokeAddNewPrimaryKeyForConfirmPerOccurrence
extends UpdateTaskAdapter {
    @Override
    public String[] getDependencies() {
        return new String[]{CalendarAddNewPrimaryKeyForConfirmPerOccurrence.class.getName()};
    }

    @Override
    public void perform(PerformParameters params) throws OXException {
        int contextID = params.getContextId();
        DatabaseService dbService = ServerServiceRegistry.getInstance().getService(DatabaseService.class);
        final Connection connnection = dbService.getForUpdateTask(contextID);
        boolean rollback = false;
        try {
            connnection.setAutoCommit(false);
            rollback = true;
            final Logger logger = LoggerFactory.getLogger(CalendarRevokeAddNewPrimaryKeyForConfirmPerOccurrence.class);
            TIntObjectMap<TIntSet> cid2ids = this.determineAffectedAppointments("del_dates_members", "delDateExternal", connnection);
            if (null != cid2ids) {
                cid2ids.forEachEntry((TIntObjectProcedure)new TIntObjectProcedure<TIntSet>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public boolean execute(int contextId, TIntSet ids) {
                        final StringBuilder sqlIn = new StringBuilder(ids.size() << 4);
                        sqlIn.append('(');
                        ids.forEach(new TIntProcedure(){

                            public boolean execute(int objectId) {
                                sqlIn.append(objectId).append(',');
                                return true;
                            }
                        });
                        sqlIn.deleteCharAt(sqlIn.length() - 1);
                        sqlIn.append(')');
                        String str = sqlIn.toString();
                        Statement stmt = null;
                        try {
                            stmt = connnection.createStatement();
                            stmt.executeUpdate("DELETE FROM delDateExternal WHERE cid = " + contextId + " AND objectId IN " + str);
                        }
                        catch (Exception e) {
                            logger.error("Couldn't delete appointment data.", (Throwable)e);
                        }
                        finally {
                            Databases.closeSQLStuff((Statement)stmt);
                        }
                        stmt = null;
                        try {
                            stmt = connnection.createStatement();
                            stmt.executeUpdate("DELETE FROM del_date_rights WHERE cid = " + contextId + " AND object_id IN " + str);
                        }
                        catch (Exception e) {
                            logger.error("Couldn't delete appointment data.", (Throwable)e);
                        }
                        finally {
                            Databases.closeSQLStuff((Statement)stmt);
                        }
                        stmt = null;
                        try {
                            stmt = connnection.createStatement();
                            stmt.executeUpdate("DELETE FROM del_dates_members WHERE cid = " + contextId + " AND object_id IN " + str);
                        }
                        catch (Exception e) {
                            logger.error("Couldn't delete appointment data.", (Throwable)e);
                        }
                        finally {
                            Databases.closeSQLStuff((Statement)stmt);
                        }
                        stmt = null;
                        try {
                            stmt = connnection.createStatement();
                            stmt.executeUpdate("DELETE FROM del_dates WHERE cid = " + contextId + " AND intfield01 IN " + str);
                        }
                        catch (Exception e) {
                            logger.error("Couldn't delete appointment data.", (Throwable)e);
                        }
                        finally {
                            Databases.closeSQLStuff((Statement)stmt);
                        }
                        return true;
                    }
                });
            }
            if (null != (cid2ids = this.determineAffectedAppointments("prg_dates_members", "dateExternal", connnection))) {
                cid2ids.forEachEntry((TIntObjectProcedure)new TIntObjectProcedure<TIntSet>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public boolean execute(int contextId, TIntSet ids) {
                        final StringBuilder sqlIn = new StringBuilder(ids.size() << 4);
                        sqlIn.append('(');
                        ids.forEach(new TIntProcedure(){

                            public boolean execute(int objectId) {
                                sqlIn.append(objectId).append(',');
                                return true;
                            }
                        });
                        sqlIn.deleteCharAt(sqlIn.length() - 1);
                        sqlIn.append(')');
                        String str = sqlIn.toString();
                        Statement stmt = null;
                        try {
                            stmt = connnection.createStatement();
                            stmt.executeUpdate("DELETE FROM dateExternal WHERE cid = " + contextId + " AND objectId IN " + str);
                        }
                        catch (Exception e) {
                            logger.error("Couldn't delete appointment data.", (Throwable)e);
                        }
                        finally {
                            Databases.closeSQLStuff((Statement)stmt);
                        }
                        stmt = null;
                        try {
                            stmt = connnection.createStatement();
                            stmt.executeUpdate("DELETE FROM prg_date_rights WHERE cid = " + contextId + " AND object_id IN " + str);
                        }
                        catch (Exception e) {
                            logger.error("Couldn't delete appointment data.", (Throwable)e);
                        }
                        finally {
                            Databases.closeSQLStuff((Statement)stmt);
                        }
                        stmt = null;
                        try {
                            stmt = connnection.createStatement();
                            stmt.executeUpdate("DELETE FROM prg_dates_members WHERE cid = " + contextId + " AND object_id IN " + str);
                        }
                        catch (Exception e) {
                            logger.error("Couldn't delete appointment data.", (Throwable)e);
                        }
                        finally {
                            Databases.closeSQLStuff((Statement)stmt);
                        }
                        stmt = null;
                        try {
                            stmt = connnection.createStatement();
                            stmt.executeUpdate("DELETE FROM prg_dates WHERE cid = " + contextId + " AND intfield01 IN " + str);
                        }
                        catch (Exception e) {
                            logger.error("Couldn't delete appointment data.", (Throwable)e);
                        }
                        finally {
                            Databases.closeSQLStuff((Statement)stmt);
                        }
                        return true;
                    }
                });
            }
            String[] tables = new String[]{"prg_dates_members", "del_dates_members"};
            String[] oldCols = new String[]{"cid", "member_uid", "object_id", "occurrence"};
            String[] newCols = new String[]{"cid", "member_uid", "object_id"};
            this.checkUniqueKey(oldCols, newCols, tables, connnection);
            String[] columns = new String[]{"cid", "object_id", "member_uid", "pfid"};
            int[] lengths = new int[4];
            Arrays.fill(lengths, 0);
            this.checkPrimaryKey(columns, lengths, tables, connnection);
            String foreignKey = Tools.existsForeignKey(connnection, "prg_dates", new String[]{"cid", "intfield01"}, "dateExternal", new String[]{"cid", "objectId"});
            if (null != foreignKey && !foreignKey.equals("")) {
                Tools.dropForeignKey(connnection, "dateExternal", foreignKey);
            }
            if (null != (foreignKey = Tools.existsForeignKey(connnection, "del_dates", new String[]{"cid", "intfield01"}, "delDateExternal", new String[]{"cid", "objectId"})) && !foreignKey.equals("")) {
                Tools.dropForeignKey(connnection, "delDateExternal", foreignKey);
            }
            String[] tables2 = new String[]{"dateExternal", "delDateExternal"};
            String[] columns2 = new String[]{"cid", "objectId", "mailAddress"};
            int[] lengths2 = new int[3];
            Arrays.fill(lengths2, 0);
            lengths2[2] = 255;
            this.checkPrimaryKey(columns2, lengths2, tables2, connnection);
            connnection.commit();
            rollback = false;
        }
        catch (SQLException e) {
            throw UpdateExceptionCodes.SQL_PROBLEM.create(e, e.getMessage());
        }
        finally {
            if (rollback) {
                DBUtils.rollback(connnection);
            }
            DBUtils.autocommit(connnection);
            Database.backNoTimeout(contextID, true, connnection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TIntObjectMap<TIntSet> determineAffectedAppointments(String table, String table2, Connection connnection) throws SQLException {
        int contextId;
        TIntSet ids;
        ResultSet rs;
        PreparedStatement stmt;
        TIntObjectHashMap cid2ids = new TIntObjectHashMap(64);
        if (Tools.columnExists(connnection, table, "occurrence")) {
            block10: {
                stmt = null;
                rs = null;
                try {
                    stmt = connnection.prepareStatement("SELECT cid, object_id FROM " + table + " GROUP BY cid, object_id, member_uid HAVING count(*) > 1");
                    rs = stmt.executeQuery();
                    if (!rs.next()) break block10;
                    do {
                        if (null == (ids = (TIntSet)cid2ids.get(contextId = rs.getInt(1)))) {
                            ids = new TIntHashSet();
                            cid2ids.put(contextId, (Object)ids);
                        }
                        ids.add(rs.getInt(2));
                    } while (rs.next());
                }
                catch (Throwable throwable) {
                    Databases.closeSQLStuff(rs, stmt);
                    throw throwable;
                }
            }
            Databases.closeSQLStuff((ResultSet)rs, (Statement)stmt);
        }
        if (Tools.columnExists(connnection, table2, "occurrence")) {
            block11: {
                stmt = null;
                rs = null;
                try {
                    stmt = connnection.prepareStatement("SELECT cid, objectId FROM " + table2 + " GROUP BY cid, objectId, mailAddress HAVING count(*) > 1");
                    rs = stmt.executeQuery();
                    if (!rs.next()) break block11;
                    do {
                        if (null == (ids = (TIntSet)cid2ids.get(contextId = rs.getInt(1)))) {
                            ids = new TIntHashSet();
                            cid2ids.put(contextId, (Object)ids);
                        }
                        ids.add(rs.getInt(2));
                    } while (rs.next());
                }
                catch (Throwable throwable) {
                    Databases.closeSQLStuff(rs, stmt);
                    throw throwable;
                }
            }
            Databases.closeSQLStuff((ResultSet)rs, (Statement)stmt);
        }
        return cid2ids;
    }

    private void checkPrimaryKey(String[] columns, int[] lengths, String[] tables, Connection connnection) throws SQLException {
        for (String table : tables) {
            if (Tools.existsPrimaryKey(connnection, table, columns)) continue;
            try {
                Tools.dropPrimaryKey(connnection, table);
            }
            catch (Exception x) {
                // empty catch block
            }
            Tools.createPrimaryKey(connnection, table, columns, lengths);
        }
    }

    private void checkUniqueKey(String[] oldColumns, String[] newColumns, String[] tables, Connection connnection) throws SQLException {
        for (String table : tables) {
            String newIndex;
            String oldIndex = Tools.existsIndex(connnection, table, oldColumns);
            if (null != oldIndex) {
                Tools.dropIndex(connnection, table, oldIndex);
            }
            if (null != (newIndex = Tools.existsIndex(connnection, table, newColumns))) continue;
            Tools.createIndex(connnection, table, "member", newColumns, true);
        }
    }
}

