/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.update.tasks;

import com.openexchange.databaseold.Database;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.update.PerformParameters;
import com.openexchange.groupware.update.UpdateExceptionCodes;
import com.openexchange.groupware.update.UpdateTaskAdapter;
import com.openexchange.groupware.update.tasks.AddMetaForInfostoreDocumentTable;
import com.openexchange.tools.sql.DBUtils;
import com.openexchange.tools.update.Tools;
import java.sql.Connection;
import java.sql.SQLException;

public class AddMD5SumIndexForInfostoreDocumentTable
extends UpdateTaskAdapter {
    @Override
    public void perform(PerformParameters params) throws OXException {
        int ctxId = params.getContextId();
        Connection con = Database.getNoTimeout(ctxId, true);
        boolean rollback = false;
        try {
            DBUtils.startTransaction(con);
            rollback = true;
            if (null == Tools.existsIndex(con, "infostore_document", new String[]{"cid", "file_md5sum"})) {
                Tools.createIndex(con, "infostore_document", "md5sum", new String[]{"cid", "file_md5sum"}, false);
            }
            if (null == Tools.existsIndex(con, "del_infostore_document", new String[]{"cid", "file_md5sum"})) {
                Tools.createIndex(con, "del_infostore_document", "md5sum", new String[]{"cid", "file_md5sum"}, false);
            }
            con.commit();
            rollback = false;
        }
        catch (SQLException e) {
            throw UpdateExceptionCodes.SQL_PROBLEM.create(e, e.getMessage());
        }
        catch (RuntimeException e) {
            throw UpdateExceptionCodes.UNEXPECTED_ERROR.create(e, e.getMessage());
        }
        finally {
            if (rollback) {
                DBUtils.rollback(con);
            }
            DBUtils.autocommit(con);
            Database.backNoTimeout(ctxId, true, con);
        }
    }

    @Override
    public String[] getDependencies() {
        return new String[]{AddMetaForInfostoreDocumentTable.class.getName()};
    }
}

