/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.infostore.webdav;

import com.openexchange.event.impl.FolderEventInterface;
import com.openexchange.exception.OXException;
import com.openexchange.file.storage.FileStorageEventHelper;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.groupware.infostore.webdav.PropertyStore;
import com.openexchange.session.Session;
import com.openexchange.tools.session.ServerSession;
import com.openexchange.tools.session.ServerSessionAdapter;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertyCleaner
implements FolderEventInterface,
EventHandler {
    private final PropertyStore infoProperties;
    private final PropertyStore folderProperties;
    private static final Logger LOG = LoggerFactory.getLogger(PropertyCleaner.class);

    public PropertyCleaner(PropertyStore folderProperties, PropertyStore infoProperties) {
        this.folderProperties = folderProperties;
        this.infoProperties = infoProperties;
    }

    @Override
    public void folderCreated(FolderObject folderObj, Session sessionObj) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void folderDeleted(FolderObject folderObj, Session session) {
        try {
            ServerSession sessionObj = ServerSessionAdapter.valueOf(session);
            this.folderProperties.startTransaction();
            this.folderProperties.removeAll(folderObj.getObjectID(), sessionObj.getContext());
            this.folderProperties.commit();
        }
        catch (OXException e) {
            LOG.error("", (Throwable)e);
        }
        finally {
            try {
                this.folderProperties.finish();
            }
            catch (OXException e) {
                LOG.error("", (Throwable)e);
            }
        }
    }

    @Override
    public void folderModified(FolderObject folderObj, Session sessionObj) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleEvent(final Event event) {
        if (FileStorageEventHelper.isInfostoreEvent((Event)event) && FileStorageEventHelper.isUpdateEvent((Event)event)) {
            try {
                ServerSession session = ServerSessionAdapter.valueOf(FileStorageEventHelper.extractSession((Event)event));
                int id = Integer.parseInt(FileStorageEventHelper.extractObjectId((Event)event));
                this.infoProperties.startTransaction();
                this.infoProperties.removeAll(id, session.getContext());
                this.infoProperties.commit();
            }
            catch (OXException e) {
                LOG.error("", (Throwable)e);
            }
            catch (NumberFormatException e) {
                LOG.debug("", (Throwable)e);
            }
            finally {
                try {
                    this.infoProperties.finish();
                }
                catch (OXException e) {
                    LOG.error("", (Throwable)e);
                }
            }
            LOG.debug("{}", new Object(){

                public String toString() {
                    return FileStorageEventHelper.createDebugMessage((String)"UpdateEvent", (Event)event);
                }
            });
        }
    }
}

