/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.infostore.validation;

import com.openexchange.exception.OXException;
import com.openexchange.groupware.infostore.DocumentMetadata;
import com.openexchange.groupware.infostore.InfostoreExceptionCodes;
import com.openexchange.groupware.infostore.utils.Metadata;
import com.openexchange.groupware.infostore.validation.DocumentMetadataValidation;
import com.openexchange.groupware.infostore.validation.InfostoreValidator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ValidationChain {
    private final List<InfostoreValidator> validators = new ArrayList<InfostoreValidator>();

    public void add(InfostoreValidator validator) {
        this.validators.add(validator);
    }

    public void validate(DocumentMetadata metadata) throws OXException {
        StringBuilder message = new StringBuilder();
        boolean failed = false;
        OXException exception = null;
        for (InfostoreValidator validator : this.validators) {
            DocumentMetadataValidation validation = validator.validate(metadata);
            if (validation.isValid()) continue;
            failed = true;
            if (null == exception) {
                exception = validation.getException();
            }
            HashMap<String, ArrayList<Metadata>> errors = new HashMap<String, ArrayList<Metadata>>();
            for (Metadata metadata2 : validation.getInvalidFields()) {
                String error = validation.getError(metadata2);
                ArrayList<Metadata> errorList = (ArrayList<Metadata>)errors.get(error);
                if (null == errorList) {
                    errorList = new ArrayList<Metadata>();
                    errors.put(error, errorList);
                }
                errorList.add(metadata2);
            }
            message.append(validator.getName()).append(": ").append('(');
            for (Map.Entry entry : errors.entrySet()) {
                for (Metadata field : (List)entry.getValue()) {
                    message.append(field.getName()).append(", ");
                }
                message.setLength(message.length() - 2);
                message.append(") ").append((String)entry.getKey());
                message.append('\n');
            }
        }
        if (failed) {
            if (null != exception) {
                exception.setLogMessage(InfostoreExceptionCodes.VALIDATION_FAILED.getMessage(), new Object[]{message.toString()});
                throw exception;
            }
            throw InfostoreExceptionCodes.VALIDATION_FAILED.create(message.toString());
        }
    }
}

