/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.infostore.database.impl;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PreparedStatementHolder {
    private static final Logger LOG = LoggerFactory.getLogger(PreparedStatementHolder.class);
    private final Connection writeConnection;
    private final Map<String, PreparedStatement> statements = new HashMap<String, PreparedStatement>();

    public PreparedStatementHolder(Connection writeConnection) {
        this.writeConnection = writeConnection;
    }

    public void execute(String sql, Object ... replacements) throws SQLException {
        PreparedStatement statement = this.get(sql);
        int size = replacements.length;
        for (int i = 0; i < size; ++i) {
            statement.setObject(i + 1, replacements[i]);
        }
        statement.executeUpdate();
    }

    private PreparedStatement get(String sql) throws SQLException {
        if (this.statements.containsKey(sql)) {
            return this.statements.get(sql);
        }
        PreparedStatement prepped = this.writeConnection.prepareStatement(sql);
        this.statements.put(sql, prepped);
        return prepped;
    }

    public void close() {
        for (PreparedStatement stmt : this.statements.values()) {
            try {
                stmt.close();
            }
            catch (SQLException x) {
                LOG.error("", (Throwable)x);
            }
        }
    }

    public Connection getConnection() {
        return this.writeConnection;
    }
}

