/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.infostore;

import com.openexchange.exception.Category;
import com.openexchange.exception.DisplayableOXExceptionCode;
import com.openexchange.exception.OXException;
import com.openexchange.exception.OXExceptionCode;
import com.openexchange.exception.OXExceptionFactory;
import com.openexchange.groupware.EnumComponent;

public enum InfostoreExceptionCodes implements DisplayableOXExceptionCode
{
    TOO_LONG_VALUES("Some field values are too long.", CATEGORY_TRUNCATED, 100),
    SQL_PROBLEM("Invalid SQL Query: %1$s", CATEGORY_ERROR, 200, "Error while reading/writing data from/to the database."),
    PREFETCH_FAILED("Cannot pre-fetch results.", CATEGORY_TRY_AGAIN, 219),
    NOT_EXIST("The requested item does not exist.", CATEGORY_USER_INPUT, 300, "The document you requested does not exist."),
    COULD_NOT_LOAD("Could not load documents to check the permissions", CATEGORY_USER_INPUT, 301, "Unable to load the document(s). Please try again."),
    NOT_INFOSTORE_FOLDER("The folder %1$s is not an Infostore folder", CATEGORY_ERROR, 302, "The folder %1$s you requested is not an Infostore folder."),
    NO_READ_PERMISSION("You do not have sufficient read permissions to read objects in this folder..", CATEGORY_PERMISSION_DENIED, 400, "You do not have the appropriate permissions to read the document."),
    NO_CREATE_PERMISSION("You do not have sufficient permissions to create objects in this folder.", CATEGORY_PERMISSION_DENIED, 402, "You do not have the appropriate permissions to create a document in this folder."),
    NO_WRITE_PERMISSION("You are not allowed to update this item.", CATEGORY_PERMISSION_DENIED, 403, "You do not have the appropriate permissions to update the document."),
    NOT_ALL_DELETED("Could not delete all objects.", CATEGORY_ERROR, 405, "Unable to delete all documents. Please try again."),
    NO_DELETE_PERMISSION_FOR_VERSION("You do not have sufficient permissions to delete this version.", CATEGORY_PERMISSION_DENIED, 406, "You do not have the appropriate permissions to delete this version."),
    ITERATE_FAILED("Could not iterate result.", CATEGORY_ERROR, 413),
    ALREADY_LOCKED("This document is locked.", CATEGORY_CONFLICT, 415, "The document is already locked. Please try again later."),
    LOCKED_BY_ANOTHER("You cannot unlock this document.", CATEGORY_CONFLICT, 416),
    WRITE_PERMS_FOR_UNLOCK_MISSING("You need write permissions to unlock a document.", CATEGORY_PERMISSION_DENIED, 417, "You do not have the appropriate permissions to unlock the document."),
    WRITE_PERMS_FOR_LOCK_MISSING("You need write permissions to lock a document.", CATEGORY_PERMISSION_DENIED, 418, "You do not have the appropriate permissions to lock a document."),
    NEW_ID_FAILED("Could not generate new ID.", CATEGORY_ERROR, 420),
    NO_SOURCE_DELETE_PERMISSION("You are not allowed to delete objects in the source folder. This document cannot be moved.", CATEGORY_PERMISSION_DENIED, 421, "You do not have the appropriate permissions to move the document."),
    DOCUMENT_NOT_EXIST("The document you requested does not exist.", CATEGORY_USER_INPUT, 438, "The document you requested does not exist."),
    FILENAME_NOT_UNIQUE("Files attached to InfoStore items must have unique names. File name: %1$s. The other document with this file name is %2$s.", CATEGORY_USER_INPUT, 441, "The document name \"%1$s\" already exists. Please choose another."),
    NUMBER_OF_VERSIONS_FAILED("Could not determine number of versions for info item %1$s in context %s. Invalid query: %2$s", CATEGORY_ERROR, 442),
    NO_DELETE_PERMISSION("You do not have the permissions to delete at least one of the info items.", CATEGORY_PERMISSION_DENIED, 445, "You do not have the appropriate permissions to delete a document."),
    DOCUMENT_CONTAINS_NO_FILE("Illegal argument: document %1$s contains no file", CATEGORY_ERROR, 500),
    DUPLICATE_SUBFOLDER("Folder %1$s has two subfolders named %2$s. The database for context %3$s is not consistent.", CATEGORY_ERROR, 501),
    PATTERN_NEEDS_MORE_CHARACTERS("In order to accomplish the search, %1$s or more characters are required.", CATEGORY_USER_INPUT, 602, "In order to accomplish the search, %1$s or more characters are required."),
    DELETE_FAILED("DocumentMetadata %1$s could not be deleted. Please try again.", CATEGORY_CONFLICT, 700),
    MODIFIED_CONCURRENTLY("The document could not be updated because it was modified. Reload the view.", CATEGORY_CONFLICT, 1302, "The document could not be updated because it was modified. Please try again."),
    UPDATED_BETWEEN_DO_AND_UNDO("The document was updated in between do and undo. The database is now probably inconsistent.", CATEGORY_CONFLICT, 1303),
    NO_DOCUMENTS_IN_VIRTUAL_FOLDER("This folder is a virtual folder. It cannot contain documents.", CATEGORY_USER_INPUT, 1700, "This folder is a virtual folder that cannot contain documents. Please choose another folder."),
    VALIDATION_FAILED("Validation failed: %1$s", CATEGORY_USER_INPUT, 2100),
    VALIDATION_FAILED_SLASH("File name must not contain slashes.", CATEGORY_USER_INPUT, 2101, "The file name must not contain slashes."),
    VALIDATION_FAILED_CHARACTERS("File name contains invalid characters.", CATEGORY_USER_INPUT, 2101, "The file name contains invalid characters."),
    NO_OFFSET_FOR_NEW_VERSIONS("New file versions can't be saved with an offset.", CATEGORY_USER_INPUT, 2102, "New file versions can't be saved with an offset.");

    private static final String SQL_PROBLEM_MSG = "Invalid SQL Query: %1$s";
    private static final String TOO_LONG_VALUES_MSG = "Some field values are too long.";
    private static final String PREFETCH_FAILED_MSG = "Cannot pre-fetch results.";
    private static final String NOT_EXIST_MSG = "The requested item does not exist.";
    private static final String COULD_NOT_LOAD_MSG = "Could not load documents to check the permissions";
    private static final String NOT_INFOSTORE_FOLDER_MSG = "The folder %1$s is not an Infostore folder";
    private static final String NO_READ_PERMISSION_MSG = "You do not have sufficient read permissions to read objects in this folder..";
    private static final String NO_CREATE_PERMISSION_MSG = "You do not have sufficient permissions to create objects in this folder.";
    private static final String NO_WRITE_PERMISSION_MSG = "You are not allowed to update this item.";
    private static final String NOT_ALL_DELETED_MSG = "Could not delete all objects.";
    private static final String NO_DELETE_PERMISSION_FOR_VERSION_MSG = "You do not have sufficient permissions to delete this version.";
    private static final String ITERATE_FAILED_MSG = "Could not iterate result.";
    private static final String ALREADY_LOCKED_MSG = "This document is locked.";
    private static final String LOCKED_BY_ANOTHER_MSG = "You cannot unlock this document.";
    private static final String WRITE_PERMS_FOR_UNLOCK_MISSING_MSG = "You need write permissions to unlock a document.";
    private static final String WRITE_PERMS_FOR_LOCK_MISSING_MSG = "You need write permissions to lock a document.";
    private static final String NEW_ID_FAILED_MSG = "Could not generate new ID.";
    private static final String NO_SOURCE_DELETE_PERMISSION_MSG = "You are not allowed to delete objects in the source folder. This document cannot be moved.";
    private static final String DOCUMENT_NOT_EXISTS_MSG = "The document you requested does not exist.";
    private static final String FILENAME_NOT_UNIQUE_MSG = "Files attached to InfoStore items must have unique names. File name: %1$s. The other document with this file name is %2$s.";
    private static final String NUMBER_OF_VERSIONS_FAILED_MSG = "Could not determine number of versions for info item %1$s in context %s. Invalid query: %2$s";
    private static final String NO_DELETE_PERMISSION_MSG = "You do not have the permissions to delete at least one of the info items.";
    private static final String DOCUMENT_CONTAINS_NO_FILE_MSG = "Illegal argument: document %1$s contains no file";
    private static final String DUPLICATE_SUBFOLDER_MSG = "Folder %1$s has two subfolders named %2$s. The database for context %3$s is not consistent.";
    private static final String PATTERN_NEEDS_MORE_CHARACTERS_MSG = "In order to accomplish the search, %1$s or more characters are required.";
    private static final String DELETE_FAILED_MSG = "DocumentMetadata %1$s could not be deleted. Please try again.";
    private static final String MODIFIED_CONCURRENTLY_MSG = "The document could not be updated because it was modified. Reload the view.";
    private static final String UPDATED_BETWEEN_DO_AND_UNDO_MSG = "The document was updated in between do and undo. The database is now probably inconsistent.";
    private static final String NO_DOCUMENTS_IN_VIRTUAL_FOLDER_MSG = "This folder is a virtual folder. It cannot contain documents.";
    private static final String VALIDATION_FAILED_MSG = "Validation failed: %1$s";
    private static final String VALIDATION_FAILED_SLASH_MSG = "File name must not contain slashes.";
    private static final String VALIDATION_FAILED_CHARACTERS_MSG = "File name contains invalid characters.";
    private static final String NO_OFFSET_FOR_NEW_VERSIONS_MSG = "New file versions can't be saved with an offset.";
    private final String message;
    private final Category category;
    private final int number;
    private String displayMessage;

    private InfostoreExceptionCodes(String message, Category category, int number) {
        this(message, category, number, null);
    }

    private InfostoreExceptionCodes(String message, Category category, int number, String displayMessage) {
        this.message = message;
        this.category = category;
        this.number = number;
        this.displayMessage = displayMessage != null ? displayMessage : "An error occurred inside the server which prevented it from fulfilling the request.";
    }

    public String getPrefix() {
        return EnumComponent.INFOSTORE.getAbbreviation();
    }

    public int getNumber() {
        return this.number;
    }

    public String getMessage() {
        return this.message;
    }

    public Category getCategory() {
        return this.category;
    }

    public boolean equals(OXException e) {
        return OXExceptionFactory.getInstance().equals((OXExceptionCode)this, e);
    }

    public String getDisplayMessage() {
        return this.displayMessage;
    }

    public OXException create() {
        return OXExceptionFactory.getInstance().create((OXExceptionCode)this, new Object[0]);
    }

    public OXException create(Object ... args) {
        return OXExceptionFactory.getInstance().create((OXExceptionCode)this, (Throwable)null, args);
    }

    public OXException create(Throwable cause, Object ... args) {
        return OXExceptionFactory.getInstance().create((OXExceptionCode)this, cause, args);
    }
}

