/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.contact;

import com.openexchange.exception.Category;
import com.openexchange.exception.DisplayableOXExceptionCode;
import com.openexchange.exception.OXException;
import com.openexchange.exception.OXExceptionCode;
import com.openexchange.exception.OXExceptionFactory;

public enum ContactExceptionCodes implements DisplayableOXExceptionCode
{
    USER_OUTSIDE_GLOBAL("Found a user contact outside global address book in folder %1$d in context %2$d.", null, Category.CATEGORY_ERROR, 1),
    INVALID_EMAIL("Invalid E-Mail address: '%s'. Please correct the E-Mail address.", "Invalid E-Mail address.", Category.CATEGORY_USER_INPUT, 100),
    IMAGE_SCALE_PROBLEM("Unable to import this contact picture. Either the type is not part of the supported type (JPG, GIF, BMP or PNG) or the size exceed %3$d. Your file type is %1$s and your image size is %2$d.", "Unable to import this contact picture.", Category.CATEGORY_USER_INPUT, 101),
    NON_CONTACT_FOLDER("You are not allowed to store this contact in a non-contact folder: folder id %1$d in context %2$d with user %3$d", "Folder is not of type Contact.", Category.CATEGORY_PERMISSION_DENIED, 103),
    NO_ACCESS_PERMISSION("You do not have the permission to access objects in the folder %1$d in the context %2$d as user %3$d", "You do not have the appropriate permission to access objects in the folder \"%1$s\".", Category.CATEGORY_PERMISSION_DENIED, 104),
    ID_GENERATION_FAILED("Got a -1 ID from IDGenerator", null, Category.CATEGORY_ERROR, 107),
    IMAGE_DOWNSCALE_FAILED("Unable to scale image down.", "Unable to scale image down.", Category.CATEGORY_ERROR, 108),
    SQL_PROBLEM("Invalid SQL query.", "Error while reading/writing data from/to the database.", Category.CATEGORY_ERROR, 109),
    AGGREGATING_CONTACTS_NOT_ENABLED("This feature has not been enabled", "This feature has not been enabled", Category.CATEGORY_SERVICE_DOWN, 110),
    NO_CREATE_PERMISSION("You do not have the permission to create objects in the folder %1$d in context %2$d as user %3$d", "You do not have the appropriate permission to create objects in the folder \"%1$s\".", Category.CATEGORY_PERMISSION_DENIED, 112),
    LOAD_OLD_CONTACT_FAILED("Unable to synchronize the old contact with the new changes: context %1$d object %2$d", "Unable to synchronize the old contact with the new changes.", Category.CATEGORY_ERROR, 116),
    MARK_PRIVATE_NOT_ALLOWED("You are not allowed to mark this contact as private contact: context %1$d object %2$d", "You are not allowed to mark this contact as private contact.", Category.CATEGORY_PERMISSION_DENIED, 118),
    OBJECT_HAS_CHANGED("Edit Conflict. Your change cannot be completed because somebody else has made a conflicting change to the same item. Please refresh or synchronize and try again.", "An edit conflict occurred. To edit the contact please reload it.", Category.CATEGORY_CONFLICT, 119),
    NEGATIVE_OBJECT_ID("An error occurred: object id is -1", null, Category.CATEGORY_ERROR, 121),
    NO_CHANGES("No changes found. No update required. context %1$d object %2$d", "No changes found. No update required.", Category.CATEGORY_USER_INPUT, 122),
    CONTACT_NOT_FOUND("Contact %1$d not found in context %2$d.", "Contact \"%1$s\" not found.", Category.CATEGORY_ERROR, 125),
    IMAGE_BROKEN("Unable to save contact image. The image appears to be broken.", "The image appears to be broken.", Category.CATEGORY_USER_INPUT, 136),
    TRIGGERING_EVENT_FAILED("Unable to trigger object events: context %1$d folder %2$d", null, Category.CATEGORY_ERROR, 146),
    INIT_CONNECTION_FROM_DBPOOL("Unable to pick up a connection from the DBPool", null, Category.CATEGORY_SERVICE_DOWN, 151),
    DATA_TRUNCATION("Some data entered exceeded the field limit. Please shorten the value for \"%1$s\" (limit: %2$s, current: %3$s) and try again.", "Some data entered exceeded the field limit. Please shorten the value for \"%1$s\" (limit: %2$s, current: %3$s) and try again.", Category.CATEGORY_USER_INPUT, 154),
    NOT_VALID_IMAGE("The image you tried to attach is not a valid picture. It may be broken or is not a valid file.", "The image you tried to attach is not a valid picture. It may be broken or is not a valid file.", Category.CATEGORY_TRY_AGAIN, 158),
    FIRST_NAME_MANDATORY("Your first name is mandatory. Please enter it.", "Required  value \"first name\" was not supplied.", Category.CATEGORY_USER_INPUT, 164),
    NO_PRIVATE_MOVE("Unable to move this contact because it is marked as private: context %1$d object %2$d", "Unable to move this contact because it is marked as private.", Category.CATEGORY_PERMISSION_DENIED, 165),
    DISPLAY_NAME_MANDATORY("Your display name is mandatory. Please enter it.", "Required  value \"display name\" was not supplied.", Category.CATEGORY_USER_INPUT, 166),
    DISPLAY_NAME_IN_USE("The name you entered is already assigned to another user. Please choose another display name. context %1$d object %2$d", "The name you entered is already assigned to another user. Please choose another display name.", Category.CATEGORY_TRY_AGAIN, 167),
    BAD_CHARACTER("Bad character in field %2$s. Error: %1$s", "Bad character in field \"%2$s\".", Category.CATEGORY_USER_INPUT, 168),
    NO_DELETE_PERMISSION("You do not have the permission to delete objects from folder %1$d in context %2$d as user %3$d", "You do not have the appropriate permission to delete objects from the folder \"%1$s\".", Category.CATEGORY_PERMISSION_DENIED, 169),
    MIME_TYPE_NOT_DEFINED("Mime type is not defined.", "Mime type is not defined.", Category.CATEGORY_USER_INPUT, 170),
    PFLAG_IN_PUBLIC_FOLDER("A contact with private flag cannot be stored in a public folder. Folder: %1$d context %2$d user %3$d", "Storing a contact with private flag in a shared folder is not allowed.", Category.CATEGORY_USER_INPUT, 171),
    IMAGE_TOO_LARGE("Image size too large. Image size: %1$s. Max. size: %2$s.", "Image size too large. Image size: %1$s. Max. size: %2$s.", Category.CATEGORY_USER_INPUT, 172),
    NO_PRIMARY_EMAIL_EDIT("Primary E-Mail address in system contact must not be edited: context %1$d object %2$d user %3$d", "Primary E-Mail address in system contact must not be edited.", Category.CATEGORY_PERMISSION_DENIED, 173),
    NOT_IN_FOLDER("The contact %1$d is not located in folder %2$s (%3$d)", "The contact %1$d is not located in folder %2$s (%3$d).", Category.CATEGORY_PERMISSION_DENIED, 174),
    LAST_NAME_MANDATORY("Your last name is mandatory. Please enter it.", "Required  value \"last name\" was not supplied.", Category.CATEGORY_USER_INPUT, 175),
    NO_CHANGE_PERMISSION("You are not allowed to modify contact %1$d in context %2$d.", "You do not have the appropriate permission to change objects in the folder \"%2$s\".", Category.CATEGORY_PERMISSION_DENIED, 176),
    EMAIL_MANDATORY_FOR_EXTERNAL_MEMBERS("An E-Mail address is mandatory for external distribution list members. Please add a valid E-Mail address.", "An E-Mail address is mandatory for external distribution list members. Please add a valid E-Mail address.", Category.CATEGORY_USER_INPUT, 177),
    OBJECT_ID_MANDATORY_FOR_REFERENCED_MEMBERS("The object identifier is mandatory for distribution list members referencing existing contacts.", "The object identifier is mandatory for distribution list members referencing existing contacts.", Category.CATEGORY_USER_INPUT, 178),
    LOAD_OBJECT_FAILED("Unable to load objects. Context %1$d user %2$d", null, Category.CATEGORY_ERROR, 252),
    NO_USER_CONTACT_DELETE("User contacts can not be deleted.", "User contacts can not be deleted.", Category.CATEGORY_PERMISSION_DENIED, 260),
    ID_PARSING_FAILED("The identifier %1$s can not be parsed.", null, Category.CATEGORY_ERROR, 261),
    TOO_FEW_ATTACHMENTS("Number of documents attached to this contact is below zero. You can not remove any more attachments.", "Number of documents attached to this contact is below zero. You can not remove any more attachments.", Category.CATEGORY_USER_INPUT, 400),
    TOO_FEW_ATTRIBUTES("Setting %s requires at least a ContactObject and a value.", "Setting %s requires at least a contact and a value.", Category.CATEGORY_ERROR, 500),
    DATE_CONVERSION_FAILED("Given string %1$s could not be converted to a date.", "Given string %1$s could not be converted to a date.", Category.CATEGORY_ERROR, 600),
    CONV_OBJ_2_DATE_FAILED("Could not convert given object %s to a date when setting %s.", "Could not convert given object %s to a date when setting %s.", Category.CATEGORY_ERROR, 700),
    CONTACT_OBJECT_MISSING("Getting the value of %s requires at least a ContactObject", "Getting the value of %s requires at least a ContactObject", Category.CATEGORY_ERROR, 800),
    TOO_FEW_SEARCH_CHARS("In order to accomplish the search, %1$d or more characters are required.", "In order to accomplish the search, %1$d or more characters are required.", Category.CATEGORY_USER_INPUT, 1000),
    UNEXPECTED_ERROR("An unexpected error occurred: %1$s", null, Category.CATEGORY_ERROR, 1001);

    public static final String PREFIX;
    private String message;
    private String displayMessage;
    private Category category;
    private int number;

    private ContactExceptionCodes(String message, String displayMessage, Category category, int number) {
        this.message = message;
        this.displayMessage = displayMessage != null ? displayMessage : "An error occurred inside the server which prevented it from fulfilling the request.";
        this.category = category;
        this.number = number;
    }

    public int getNumber() {
        return this.number;
    }

    public String getMessage() {
        return this.message;
    }

    public String getDisplayMessage() {
        return this.displayMessage;
    }

    public String getPrefix() {
        return PREFIX;
    }

    public Category getCategory() {
        return this.category;
    }

    public boolean equals(OXException e) {
        return OXExceptionFactory.getInstance().equals((OXExceptionCode)this, e);
    }

    public OXException create() {
        return this.specials(OXExceptionFactory.getInstance().create((OXExceptionCode)this, new Object[0]));
    }

    public OXException create(Object ... args) {
        return this.specials(OXExceptionFactory.getInstance().create((OXExceptionCode)this, (Throwable)null, args));
    }

    public OXException create(Throwable cause, Object ... args) {
        return this.specials(OXExceptionFactory.getInstance().create((OXExceptionCode)this, cause, args));
    }

    private OXException specials(OXException exc) {
        switch (this) {
            case CONTACT_NOT_FOUND: 
            case CONTACT_OBJECT_MISSING: {
                exc.setGeneric(OXException.Generic.NOT_FOUND);
                break;
            }
            case OBJECT_HAS_CHANGED: {
                exc.setGeneric(OXException.Generic.CONFLICT);
            }
        }
        if (exc.getCategories().contains(Category.CATEGORY_PERMISSION_DENIED)) {
            exc.setGeneric(OXException.Generic.NO_PERMISSION);
        }
        return exc;
    }

    static {
        PREFIX = "CON".intern();
    }
}

