/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.attach.impl;

import com.openexchange.exception.OXException;
import com.openexchange.groupware.attach.AttachmentExceptionCodes;
import com.openexchange.groupware.attach.AttachmentMetadata;
import com.openexchange.groupware.attach.impl.AttachmentEventAction;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FireDetachedEventAction
extends AttachmentEventAction {
    private static final Logger LOG = LoggerFactory.getLogger(FireDetachedEventAction.class);

    protected void undoAction() throws OXException {
        ArrayList<AttachmentMetadata> processed = new ArrayList<AttachmentMetadata>();
        try {
            this.fireAttached(this.getAttachments(), processed, this.getUser(), this.getUserConfiguration(), this.getSession(), this.getContext(), this.getProvider());
        }
        catch (OXException e) {
            try {
                this.fireDetached(processed, this.getUser(), this.getUserConfiguration(), this.getSession(), this.getContext(), this.getProvider());
            }
            catch (Exception e1) {
                LOG.error("", (Throwable)e);
                throw AttachmentExceptionCodes.UNDONE_FAILED.create(e1, new Object[0]);
            }
            throw e;
        }
        catch (Exception e) {
            throw AttachmentExceptionCodes.ATTACH_FAILED.create(e, new Object[0]);
        }
    }

    public void perform() throws OXException {
        try {
            this.fireDetached(this.getAttachments(), this.getUser(), this.getUserConfiguration(), this.getSession(), this.getContext(), this.getProvider());
        }
        catch (OXException e) {
            throw e;
        }
        catch (Exception e) {
            throw AttachmentExceptionCodes.DETACH_FAILED.create(e, new Object[0]);
        }
    }
}

