/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.group.json.actions;

import com.openexchange.ajax.requesthandler.AJAXRequestResult;
import com.openexchange.ajax.writer.GroupWriter;
import com.openexchange.documentation.RequestMethod;
import com.openexchange.documentation.annotations.Action;
import com.openexchange.documentation.annotations.Parameter;
import com.openexchange.exception.OXException;
import com.openexchange.group.Group;
import com.openexchange.group.GroupStorage;
import com.openexchange.group.json.GroupAJAXRequest;
import com.openexchange.group.json.actions.AbstractGroupAction;
import com.openexchange.server.ServiceLookup;
import java.util.Date;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@Action(method=RequestMethod.GET, name="updates", description="Get updates (since v6.18.1)", parameters={@Parameter(name="session", description="A session ID previously obtained from the login module."), @Parameter(name="timestamp", description="Timestamp of the last update of the requested groups.")}, responseDescription="Response with timestamp: An array with new, modified and deleted groups. New, modified and deleted groups are represented by JSON objects as described in Group data.")
public final class UpdatesAction
extends AbstractGroupAction {
    public UpdatesAction(ServiceLookup services) {
        super(services);
    }

    @Override
    protected AJAXRequestResult perform(GroupAJAXRequest req) throws OXException, JSONException {
        JSONObject temp;
        Date timestamp = new Date(0L);
        GroupStorage groupStorage = GroupStorage.getInstance();
        Date modifiedSince = req.checkDate("timestamp");
        Group[] modifiedGroups = groupStorage.listModifiedGroups(modifiedSince, req.getSession().getContext());
        Group[] deletedGroups = groupStorage.listDeletedGroups(modifiedSince, req.getSession().getContext());
        GroupWriter groupWriter = new GroupWriter();
        JSONArray modified = new JSONArray();
        JSONArray deleted = new JSONArray();
        long lm = 0L;
        for (Group group : modifiedGroups) {
            temp = new JSONObject();
            groupWriter.writeGroup(group, temp);
            modified.put((Object)temp);
            lm = group.getLastModified().getTime() > lm ? group.getLastModified().getTime() : lm;
        }
        for (Group group : deletedGroups) {
            temp = new JSONObject();
            groupWriter.writeGroup(group, temp);
            deleted.put((Object)temp);
            lm = group.getLastModified().getTime() > lm ? group.getLastModified().getTime() : lm;
        }
        timestamp = new Date(lm);
        JSONObject retVal = new JSONObject();
        retVal.put("new", (Object)modified);
        retVal.put("modified", (Object)modified);
        retVal.put("deleted", (Object)deleted);
        return new AJAXRequestResult(retVal, timestamp, "json");
    }
}

