/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.folderstorage.virtual.sql;

import com.openexchange.config.ConfigurationService;
import com.openexchange.database.DatabaseService;
import com.openexchange.event.impl.EventClient;
import com.openexchange.exception.OXException;
import com.openexchange.folderstorage.FolderExceptionErrorMessage;
import com.openexchange.folderstorage.internal.Tools;
import com.openexchange.folderstorage.mail.MailFolderType;
import com.openexchange.folderstorage.virtual.VirtualServiceRegistry;
import com.openexchange.mail.FullnameArgument;
import com.openexchange.mail.event.EventPool;
import com.openexchange.mail.event.PooledEvent;
import com.openexchange.mail.utils.MailFolderUtility;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.session.Session;
import com.openexchange.tools.oxfolder.OXFolderAccess;
import com.openexchange.tools.session.ServerSession;
import com.openexchange.tools.session.ServerSessionAdapter;
import com.openexchange.tools.sql.DBUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.slf4j.LoggerFactory;

public final class Delete {
    private static final String SQL_DELETE_SUBS = "DELETE FROM virtualSubscription WHERE cid = ? AND tree = ? AND user = ? AND folderId = ?";
    private static final String SQL_DELETE_INSERT_SUBS = "INSERT INTO virtualBackupSubscription SELECT * FROM virtualSubscription WHERE cid = ? AND tree = ? AND user = ? AND folderId = ?";
    private static final String SQL_DELETE_PERMS = "DELETE FROM virtualPermission WHERE cid = ? AND tree = ? AND user = ? AND folderId = ?";
    private static final String SQL_DELETE_INSERT_PERMS = "INSERT INTO virtualBackupPermission SELECT * FROM virtualPermission WHERE cid = ? AND tree = ? AND user = ? AND folderId = ?";
    private static final String SQL_DELETE = "DELETE FROM virtualTree WHERE cid = ? AND tree = ? AND user = ? AND folderId = ?";
    private static final String SQL_DELETE_INSERT = "INSERT INTO virtualBackupTree SELECT * FROM virtualTree WHERE cid = ? AND tree = ? AND user = ? AND folderId = ?";

    private Delete() {
    }

    public static void deleteFolder(int cid, int tree, int user, String folderId, boolean backup, Session session) throws OXException {
        DatabaseService databaseService = (DatabaseService)VirtualServiceRegistry.getServiceRegistry().getService(DatabaseService.class, true);
        Connection con = databaseService.getWritable(cid);
        try {
            con.setAutoCommit(false);
            Delete.deleteFolder(cid, tree, user, folderId, backup, session, con);
            con.commit();
        }
        catch (SQLException e) {
            DBUtils.rollback(con);
            throw FolderExceptionErrorMessage.SQL_ERROR.create(e, e.getMessage());
        }
        catch (OXException e) {
            DBUtils.rollback(con);
            throw e;
        }
        catch (Exception e) {
            DBUtils.rollback(con);
            throw FolderExceptionErrorMessage.UNEXPECTED_ERROR.create(e, e.getMessage());
        }
        finally {
            DBUtils.autocommit(con);
            databaseService.backWritable(cid, con);
        }
    }

    public static void deleteFolder(int cid, int tree, int user, String folderId, boolean backup, Session session, Connection con) throws OXException {
        int pos;
        ResultSet rs;
        PreparedStatement stmt;
        block44: {
            if (null == con) {
                Delete.deleteFolder(cid, tree, user, folderId, backup, session);
                return;
            }
            stmt = null;
            rs = null;
            stmt = con.prepareStatement("SELECT shadow FROM virtualTree WHERE cid = ? AND tree = ? AND user = ? AND folderId = ?");
            pos = 1;
            stmt.setInt(pos++, cid);
            stmt.setInt(pos++, tree);
            stmt.setInt(pos++, user);
            stmt.setString(pos, folderId);
            rs = stmt.executeQuery();
            if (rs.next()) break block44;
            DBUtils.closeSQLStuff(rs, stmt);
            rs = null;
            return;
        }
        try {
            String shadow = rs.getString(1);
            if ("default".equals(shadow)) {
                throw FolderExceptionErrorMessage.FOLDER_NOT_DELETEABLE.create(folderId, user, cid);
            }
        }
        catch (SQLException e) {
            try {
                throw FolderExceptionErrorMessage.SQL_ERROR.create(e, e.getMessage());
            }
            catch (Throwable throwable) {
                DBUtils.closeSQLStuff(rs, stmt);
                rs = null;
                throw throwable;
            }
        }
        DBUtils.closeSQLStuff(rs, stmt);
        rs = null;
        if (backup) {
            try {
                stmt = con.prepareStatement(SQL_DELETE_INSERT);
                pos = 1;
                stmt.setInt(pos++, cid);
                stmt.setInt(pos++, tree);
                stmt.setInt(pos++, user);
                stmt.setString(pos, folderId);
                stmt.executeUpdate();
            }
            catch (SQLException e) {
                throw FolderExceptionErrorMessage.SQL_ERROR.create(e, e.getMessage());
            }
            finally {
                DBUtils.closeSQLStuff(stmt);
            }
            try {
                stmt = con.prepareStatement(SQL_DELETE_INSERT_PERMS);
                pos = 1;
                stmt.setInt(pos++, cid);
                stmt.setInt(pos++, tree);
                stmt.setInt(pos++, user);
                stmt.setString(pos, folderId);
                stmt.executeUpdate();
            }
            catch (SQLException e) {
                throw FolderExceptionErrorMessage.SQL_ERROR.create(e, e.getMessage());
            }
            finally {
                DBUtils.closeSQLStuff(stmt);
            }
            try {
                stmt = con.prepareStatement(SQL_DELETE_INSERT_SUBS);
                pos = 1;
                stmt.setInt(pos++, cid);
                stmt.setInt(pos++, tree);
                stmt.setInt(pos++, user);
                stmt.setString(pos, folderId);
                stmt.executeUpdate();
            }
            catch (SQLException e) {
                throw FolderExceptionErrorMessage.SQL_ERROR.create(e, e.getMessage());
            }
            finally {
                DBUtils.closeSQLStuff(stmt);
            }
        }
        try {
            stmt = con.prepareStatement(SQL_DELETE_SUBS);
            pos = 1;
            stmt.setInt(pos++, cid);
            stmt.setInt(pos++, tree);
            stmt.setInt(pos++, user);
            stmt.setString(pos, folderId);
            stmt.executeUpdate();
        }
        catch (SQLException e) {
            throw FolderExceptionErrorMessage.SQL_ERROR.create(e, e.getMessage());
        }
        finally {
            DBUtils.closeSQLStuff(stmt);
        }
        try {
            stmt = con.prepareStatement(SQL_DELETE_PERMS);
            pos = 1;
            stmt.setInt(pos++, cid);
            stmt.setInt(pos++, tree);
            stmt.setInt(pos++, user);
            stmt.setString(pos, folderId);
            stmt.executeUpdate();
        }
        catch (SQLException e) {
            throw FolderExceptionErrorMessage.SQL_ERROR.create(e, e.getMessage());
        }
        finally {
            DBUtils.closeSQLStuff(stmt);
        }
        try {
            stmt = con.prepareStatement(SQL_DELETE);
            pos = 1;
            stmt.setInt(pos++, cid);
            stmt.setInt(pos++, tree);
            stmt.setInt(pos++, user);
            stmt.setString(pos, folderId);
            stmt.executeUpdate();
        }
        catch (SQLException e) {
            throw FolderExceptionErrorMessage.SQL_ERROR.create(e, e.getMessage());
        }
        finally {
            DBUtils.closeSQLStuff(stmt);
        }
        if (null != session) {
            boolean postEvent;
            ConfigurationService service = ServerServiceRegistry.getInstance().getService(ConfigurationService.class);
            boolean bl = postEvent = null == service ? true : service.getBoolProperty("com.openexchange.folderstorage.postEASFolderEvents", true);
            if (postEvent) {
                try {
                    if (MailFolderType.getInstance().servesFolderId(folderId)) {
                        FullnameArgument argument = MailFolderUtility.prepareMailFolderParam(folderId);
                        Delete.postEvent(argument.getAccountId(), argument.getFullname(), false, true, false, session);
                    } else {
                        ServerSession serverSession = ServerSessionAdapter.valueOf(session);
                        new EventClient(serverSession).delete(new OXFolderAccess(con, serverSession.getContext()).getFolderObject(Delete.unsignedInt(folderId)));
                    }
                }
                catch (Exception e) {
                    LoggerFactory.getLogger(Delete.class).error("", (Throwable)e);
                }
            }
        }
    }

    private static void postEvent(int accountId, String fullname, boolean contentRelated, boolean immediateDelivery, boolean async, Session session) {
        if (0 != accountId) {
            return;
        }
        EventPool.getInstance().put(new PooledEvent(session.getContextId(), session.getUserId(), accountId, MailFolderUtility.prepareFullname(accountId, fullname), contentRelated, immediateDelivery, true, session).setAsync(async));
    }

    private static int unsignedInt(String sInteger) {
        return Tools.getUnsignedInteger(sInteger);
    }
}

