/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.event.impl;

import com.openexchange.event.impl.AppointmentEventInterface;
import com.openexchange.event.impl.ContactEventInterface;
import com.openexchange.event.impl.EventConfig;
import com.openexchange.event.impl.EventDispatcher;
import com.openexchange.event.impl.EventObject;
import com.openexchange.event.impl.FolderEventInterface;
import com.openexchange.event.impl.NoDelayEventInterface;
import com.openexchange.event.impl.TaskEventInterface;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.container.Appointment;
import com.openexchange.groupware.container.Contact;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.groupware.tasks.Task;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.session.Session;
import com.openexchange.timer.ScheduledTimerTask;
import com.openexchange.timer.TimerService;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class EventQueue {
    private static final AtomicBoolean isFirst = new AtomicBoolean(true);
    private static volatile boolean isInit;
    private static volatile boolean noDelay;
    private static List<EventObject> queue1;
    private static List<EventObject> queue2;
    private static int delay;
    private static volatile boolean isEnabled;
    static final Logger LOG;
    private static final List<AppointmentEventInterface> appointmentEventList;
    private static final List<AppointmentEventInterface> noDelayAppointmentEventList;
    private static final List<TaskEventInterface> taskEventList;
    private static final List<TaskEventInterface> noDelayTaskEventList;
    private static final List<ContactEventInterface> contactEventList;
    private static final List<ContactEventInterface> noDelayContactEventList;
    private static final List<FolderEventInterface> folderEventList;
    private static final List<FolderEventInterface> noDelayFolderEventList;
    private static final AtomicBoolean shuttingDown;
    private static final ReentrantLock SHUTDOWN_LOCK;
    private static final Condition ALL_EVENTS_PROCESSED;
    private static final AtomicBoolean shutdownComplete;
    private static volatile ScheduledTimerTask timerTask;
    private static volatile EventDispatcher newEventDispatcher;

    private EventQueue() {
    }

    public static void setNewEventDispatcher(EventDispatcher eventDispatcher) {
        newEventDispatcher = eventDispatcher;
    }

    static void init(EventConfig config) {
        delay = config.getEventQueueDelay();
        if (config.isEventQueueEnabled()) {
            TimerService timer;
            LOG.info("Starting EventQueue");
            queue1 = new ArrayList<EventObject>();
            queue2 = new ArrayList<EventObject>();
            boolean bl = noDelay = delay == 0;
            if (!noDelay && (timer = ServerServiceRegistry.getInstance().getService(TimerService.class)) != null) {
                EventQueueTimerTask task2schedule = new EventQueueTimerTask(ALL_EVENTS_PROCESSED, SHUTDOWN_LOCK, isFirst, queue1, queue2, shutdownComplete, shuttingDown);
                ScheduledTimerTask timerTask = timer.scheduleWithFixedDelay((Runnable)task2schedule, (long)delay, (long)delay);
                task2schedule.setScheduledTimerTask(timerTask);
                EventQueue.timerTask = timerTask;
            }
            isEnabled = true;
        } else {
            LOG.info("EventQueue is disabled");
        }
        isInit = true;
        shuttingDown.set(false);
    }

    public static void add(EventObject eventObj) throws OXException {
        if (shuttingDown.get()) {
            LOG.info("Shutting down event system, so no events are accepted. Throwing Invalid State Exception");
            throw new OXException().setLogMessage("Event system is being shut down and therefore does not accept new events.");
        }
        if (null == eventObj) {
            LOG.warn("Skipping null event", new Throwable());
            return;
        }
        LOG.debug("add EventObject: {}", (Object)eventObj);
        if (!isEnabled) {
            return;
        }
        if (!isInit) {
            throw new OXException().setLogMessage("EventQueue not initialized!");
        }
        EventQueue.event(eventObj, true);
        if (noDelay) {
            EventQueue.event(eventObj);
        } else if (isFirst.get()) {
            queue1.add(eventObj);
        } else {
            queue2.add(eventObj);
        }
    }

    protected static void callEvent(List<EventObject> al) {
        for (int a = 0; a < al.size(); ++a) {
            EventQueue.event(al.get(a));
        }
        al.clear();
    }

    protected static void event(EventObject eventObj) {
        EventQueue.event(eventObj, false);
    }

    protected static void event(EventObject eventObj, boolean noDelay) {
        if (null == eventObj) {
            LOG.warn("Skipping null event", new Throwable());
            return;
        }
        int module = eventObj.getModule();
        switch (module) {
            case 1: {
                EventQueue.appointment(eventObj, noDelay ? noDelayAppointmentEventList : appointmentEventList);
                break;
            }
            case 7: {
                EventQueue.contact(eventObj, noDelay ? noDelayContactEventList : contactEventList);
                break;
            }
            case 4: {
                EventQueue.task(eventObj, noDelay ? noDelayTaskEventList : taskEventList);
                break;
            }
            case 20: {
                EventQueue.folder(eventObj, noDelay ? noDelayFolderEventList : folderEventList);
                break;
            }
            default: {
                LOG.error("invalid module: {}", (Object)module);
            }
        }
    }

    protected static void appointment(EventObject eventObj, List<AppointmentEventInterface> appointmentEventList) {
        if (appointmentEventList.isEmpty()) {
            return;
        }
        Appointment appointment = (Appointment)eventObj.getObject();
        Session session = eventObj.getSessionObject();
        int action = eventObj.getAction();
        switch (action) {
            case 5: {
                for (AppointmentEventInterface next : appointmentEventList) {
                    try {
                        next.appointmentCreated(appointment, session);
                    }
                    catch (Throwable t) {
                        LOG.error("", t);
                    }
                }
                break;
            }
            case 6: {
                for (AppointmentEventInterface next : appointmentEventList) {
                    try {
                        next.appointmentModified(appointment, session);
                    }
                    catch (Throwable t) {
                        LOG.error("", t);
                    }
                }
                break;
            }
            case 7: {
                for (AppointmentEventInterface next : appointmentEventList) {
                    try {
                        next.appointmentDeleted(appointment, session);
                    }
                    catch (Throwable t) {
                        LOG.error("", t);
                    }
                }
                break;
            }
            case 9: {
                for (AppointmentEventInterface next : appointmentEventList) {
                    try {
                        next.appointmentAccepted(appointment, session);
                    }
                    catch (Throwable t) {
                        LOG.error("", t);
                    }
                }
                break;
            }
            case 10: {
                for (AppointmentEventInterface next : appointmentEventList) {
                    try {
                        next.appointmentDeclined(appointment, session);
                    }
                    catch (Throwable t) {
                        LOG.error("", t);
                    }
                }
                break;
            }
            case 11: {
                for (AppointmentEventInterface next : appointmentEventList) {
                    try {
                        next.appointmentTentativelyAccepted(appointment, session);
                    }
                    catch (Throwable t) {
                        LOG.error("", t);
                    }
                }
                break;
            }
            default: {
                LOG.error("invalid action for appointment: {}", (Object)action);
            }
        }
    }

    protected static void contact(EventObject eventObj, List<ContactEventInterface> contactEventList) {
        if (contactEventList.isEmpty()) {
            return;
        }
        int action = eventObj.getAction();
        Contact contact = (Contact)eventObj.getObject();
        Session session = eventObj.getSessionObject();
        switch (action) {
            case 5: {
                for (ContactEventInterface next : contactEventList) {
                    try {
                        next.contactCreated(contact, session);
                    }
                    catch (Throwable t) {
                        LOG.error("", t);
                    }
                }
                break;
            }
            case 6: {
                for (ContactEventInterface next : contactEventList) {
                    try {
                        next.contactModified(contact, session);
                    }
                    catch (Throwable t) {
                        LOG.error("", t);
                    }
                }
                break;
            }
            case 7: {
                for (ContactEventInterface next : contactEventList) {
                    try {
                        next.contactDeleted(contact, session);
                    }
                    catch (Throwable t) {
                        LOG.error("", t);
                    }
                }
                break;
            }
            default: {
                LOG.error("invalid action for contact: {}", (Object)action);
            }
        }
    }

    protected static void task(EventObject eventObj, List<TaskEventInterface> taskEventList) {
        if (taskEventList.isEmpty()) {
            return;
        }
        int action = eventObj.getAction();
        Task task = (Task)eventObj.getObject();
        Session session = eventObj.getSessionObject();
        switch (action) {
            case 5: {
                for (TaskEventInterface next : taskEventList) {
                    try {
                        next.taskCreated(task, session);
                    }
                    catch (Throwable t) {
                        LOG.error("", t);
                    }
                }
                break;
            }
            case 6: {
                for (TaskEventInterface next : taskEventList) {
                    try {
                        next.taskModified(task, session);
                    }
                    catch (Throwable t) {
                        LOG.error("", t);
                    }
                }
                break;
            }
            case 7: {
                for (TaskEventInterface next : taskEventList) {
                    try {
                        next.taskDeleted(task, session);
                    }
                    catch (Throwable t) {
                        LOG.error("", t);
                    }
                }
                break;
            }
            case 9: {
                for (TaskEventInterface next : taskEventList) {
                    try {
                        next.taskAccepted(task, session);
                    }
                    catch (Throwable t) {
                        LOG.error("", t);
                    }
                }
                break;
            }
            case 10: {
                for (TaskEventInterface next : taskEventList) {
                    try {
                        next.taskDeclined(task, session);
                    }
                    catch (Throwable t) {
                        LOG.error("", t);
                    }
                }
                break;
            }
            case 11: {
                for (TaskEventInterface next : taskEventList) {
                    try {
                        next.taskTentativelyAccepted(task, session);
                    }
                    catch (Throwable t) {
                        LOG.error("", t);
                    }
                }
                break;
            }
            default: {
                LOG.error("invalid action for task: {}", (Object)action);
            }
        }
    }

    protected static void folder(EventObject eventObj, List<FolderEventInterface> folderEventList) {
        if (folderEventList.isEmpty()) {
            return;
        }
        int action = eventObj.getAction();
        FolderObject folderObject = (FolderObject)eventObj.getObject();
        Session session = eventObj.getSessionObject();
        switch (action) {
            case 5: {
                for (FolderEventInterface next : folderEventList) {
                    try {
                        next.folderCreated(folderObject, session);
                    }
                    catch (Throwable t) {
                        LOG.error("", t);
                    }
                }
                break;
            }
            case 6: {
                for (FolderEventInterface next : folderEventList) {
                    try {
                        next.folderModified(folderObject, session);
                    }
                    catch (Throwable t) {
                        LOG.error("", t);
                    }
                }
                break;
            }
            case 7: {
                for (FolderEventInterface next : folderEventList) {
                    try {
                        next.folderDeleted(folderObject, session);
                    }
                    catch (Throwable t) {
                        LOG.error("", t);
                    }
                }
                break;
            }
            default: {
                LOG.error("invalid action for folder: {}", (Object)action);
            }
        }
    }

    public static void addAppointmentEvent(AppointmentEventInterface event) {
        if (NoDelayEventInterface.class.isInstance(event)) {
            noDelayAppointmentEventList.add(event);
        } else {
            appointmentEventList.add(event);
        }
    }

    public static void addTaskEvent(TaskEventInterface event) {
        if (NoDelayEventInterface.class.isInstance(event)) {
            noDelayTaskEventList.add(event);
        } else {
            taskEventList.add(event);
        }
    }

    public static void addContactEvent(ContactEventInterface event) {
        if (NoDelayEventInterface.class.isInstance(event)) {
            noDelayContactEventList.add(event);
        } else {
            contactEventList.add(event);
        }
    }

    public static void addFolderEvent(FolderEventInterface event) {
        if (NoDelayEventInterface.class.isInstance(event)) {
            noDelayFolderEventList.add(event);
        } else {
            folderEventList.add(event);
        }
    }

    public static void removeAppointmentEvent(AppointmentEventInterface event) {
        if (NoDelayEventInterface.class.isInstance(event)) {
            noDelayAppointmentEventList.remove(event);
        } else {
            appointmentEventList.remove(event);
        }
    }

    public static void removeTaskEvent(TaskEventInterface event) {
        if (NoDelayEventInterface.class.isInstance(event)) {
            noDelayTaskEventList.remove(event);
        } else {
            taskEventList.remove(event);
        }
    }

    public static void removeContactEvent(ContactEventInterface event) {
        if (NoDelayEventInterface.class.isInstance(event)) {
            noDelayContactEventList.remove(event);
        } else {
            contactEventList.remove(event);
        }
    }

    public static void removeFolderEvent(FolderEventInterface event) {
        if (NoDelayEventInterface.class.isInstance(event)) {
            noDelayFolderEventList.remove(event);
        } else {
            folderEventList.remove(event);
        }
    }

    public static void addModernListener(AppointmentEventInterface listener) {
        EventQueue.checkEventDispatcher();
        newEventDispatcher.addListener(listener);
    }

    public static void addModernListener(TaskEventInterface listener) {
        EventQueue.checkEventDispatcher();
        newEventDispatcher.addListener(listener);
    }

    private static void checkEventDispatcher() {
        if (null == newEventDispatcher) {
            throw new IllegalStateException("The event dispatcher must have been initialized before adding listeners.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void stop() {
        SHUTDOWN_LOCK.lock();
        try {
            if (shutdownComplete.get()) {
                return;
            }
            shuttingDown.set(true);
            if (queue1.isEmpty() && queue2.isEmpty()) {
                return;
            }
            if (null != ServerServiceRegistry.getInstance().getService(TimerService.class) && !ALL_EVENTS_PROCESSED.await(2 * delay, TimeUnit.MILLISECONDS)) {
                LOG.warn("Task did not clean event queues on shutdown.");
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            LOG.error("", (Throwable)e);
        }
        finally {
            EventQueue.signalAll(ALL_EVENTS_PROCESSED);
            SHUTDOWN_LOCK.unlock();
        }
    }

    private static void signalAll(Condition condition) {
        if (null != condition) {
            try {
                condition.signalAll();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void clearAllListeners() {
        appointmentEventList.clear();
        taskEventList.clear();
        contactEventList.clear();
        folderEventList.clear();
    }

    static {
        delay = 180000;
        LOG = LoggerFactory.getLogger(EventQueue.class);
        appointmentEventList = new ArrayList<AppointmentEventInterface>(4);
        noDelayAppointmentEventList = new ArrayList<AppointmentEventInterface>(4);
        taskEventList = new ArrayList<TaskEventInterface>(4);
        noDelayTaskEventList = new ArrayList<TaskEventInterface>(4);
        contactEventList = new ArrayList<ContactEventInterface>(4);
        noDelayContactEventList = new ArrayList<ContactEventInterface>(4);
        folderEventList = new ArrayList<FolderEventInterface>(4);
        noDelayFolderEventList = new ArrayList<FolderEventInterface>(4);
        shuttingDown = new AtomicBoolean();
        SHUTDOWN_LOCK = new ReentrantLock();
        ALL_EVENTS_PROCESSED = SHUTDOWN_LOCK.newCondition();
        shutdownComplete = new AtomicBoolean();
    }

    private static final class EventQueueTimerTask
    implements Runnable {
        private final AtomicBoolean useFirst;
        private final List<EventObject> q1;
        private final List<EventObject> q2;
        private final AtomicBoolean closing;
        private final AtomicBoolean shutdown;
        private final ReentrantLock shutdownLock;
        private final Condition allEventsProcessed;
        private volatile ScheduledTimerTask scheduledTimerTask;

        public EventQueueTimerTask(Condition allEventsProcessed, ReentrantLock shutdownLock, AtomicBoolean isFirst, List<EventObject> queue1, List<EventObject> queue2, AtomicBoolean shutdownComplete, AtomicBoolean shuttingDown) {
            this.allEventsProcessed = allEventsProcessed;
            this.shutdownLock = shutdownLock;
            this.useFirst = isFirst;
            this.q1 = queue1;
            this.q2 = queue2;
            this.shutdown = shutdownComplete;
            this.closing = shuttingDown;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block8: {
                try {
                    if (this.useFirst.compareAndSet(true, false)) {
                        EventQueue.callEvent(this.q1);
                    } else {
                        this.useFirst.set(true);
                        EventQueue.callEvent(this.q2);
                    }
                    if (!this.closing.get() || !this.q1.isEmpty() || !this.q2.isEmpty()) break block8;
                    this.scheduledTimerTask.cancel(false);
                    TimerService timer = ServerServiceRegistry.getInstance().getService(TimerService.class);
                    if (timer != null) {
                        timer.purge();
                    }
                    this.shutdownLock.lock();
                    try {
                        this.shutdown.set(true);
                        this.allEventsProcessed.signalAll();
                    }
                    finally {
                        this.shutdownLock.unlock();
                    }
                }
                catch (Throwable t) {
                    LOG.error("", t);
                }
            }
        }

        public void setScheduledTimerTask(ScheduledTimerTask scheduledTimerTask) {
            this.scheduledTimerTask = scheduledTimerTask;
        }
    }
}

