/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.event.impl;

import com.openexchange.context.ContextService;
import com.openexchange.event.impl.CommonEventImpl;
import com.openexchange.event.impl.EventObject;
import com.openexchange.event.impl.EventQueue;
import com.openexchange.exception.OXException;
import com.openexchange.folder.FolderService;
import com.openexchange.group.Group;
import com.openexchange.group.GroupService;
import com.openexchange.groupware.container.Appointment;
import com.openexchange.groupware.container.CalendarObject;
import com.openexchange.groupware.container.Contact;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.groupware.container.UserParticipant;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.contexts.impl.ContextStorage;
import com.openexchange.groupware.tasks.Task;
import com.openexchange.java.Autoboxing;
import com.openexchange.server.impl.OCLPermission;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.session.Session;
import com.openexchange.tools.oxfolder.OXFolderAccess;
import java.util.Collections;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventAdmin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventClient {
    private static final Logger LOG = LoggerFactory.getLogger(EventClient.class);
    public static final int CREATED = 5;
    public static final int CHANGED = 6;
    public static final int DELETED = 7;
    public static final int MOVED = 8;
    public static final int CONFIRM_ACCEPTED = 9;
    public static final int CONFIRM_DECLINED = 10;
    public static final int CONFIRM_TENTATIVE = 11;
    public static final int CONFIRM_WAITING = 11;
    private final Session session;
    private final int userId;
    private final int contextId;

    public EventClient(Session session) {
        this.session = session;
        this.userId = session.getUserId();
        this.contextId = session.getContextId();
    }

    public void create(Appointment appointment) throws OXException {
        Context ctx = ContextStorage.getInstance().getContext(this.contextId);
        int folderId = appointment.getParentFolderID();
        if (folderId > 0) {
            FolderObject folderObj = this.getFolder(folderId, ctx);
            this.create(appointment, folderObj);
        }
    }

    public void create(Appointment appointment, FolderObject folder) throws OXException {
        Map<Integer, Set<Integer>> affectedUsers = this.getAffectedUsers(new CalendarObject[]{appointment}, new FolderObject[]{folder});
        CommonEventImpl genericEvent = new CommonEventImpl(this.contextId, this.userId, EventClient.unmodifyable(affectedUsers), 1, 1, appointment, null, folder, null, this.session);
        Hashtable<String, CommonEventImpl> ht = new Hashtable<String, CommonEventImpl>(1);
        ((Dictionary)ht).put("OX_EVENT", genericEvent);
        Event event = new Event("com/openexchange/groupware/appointment/insert", ht);
        this.triggerEvent(event);
        EventObject eventObject = new EventObject(appointment, 5, this.session);
        EventQueue.add(eventObject);
    }

    public void modify(Appointment appointment) throws OXException {
        Context ctx = ContextStorage.getInstance().getContext(this.contextId);
        int folderId = appointment.getParentFolderID();
        if (folderId > 0) {
            FolderObject folderObj = this.getFolder(folderId, ctx);
            this.modify(null, appointment, folderObj);
        }
    }

    public void modify(Appointment oldAppointment, Appointment newAppointment, FolderObject folderObj) throws OXException {
        Map<Integer, Set<Integer>> affectedUsers = this.getAffectedUsers(new CalendarObject[]{oldAppointment, newAppointment}, new FolderObject[]{folderObj});
        CommonEventImpl genericEvent = new CommonEventImpl(this.contextId, this.userId, EventClient.unmodifyable(affectedUsers), 2, 1, newAppointment, oldAppointment, folderObj, null, this.session);
        Hashtable<String, CommonEventImpl> ht = new Hashtable<String, CommonEventImpl>(1);
        ((Dictionary)ht).put("OX_EVENT", genericEvent);
        Event event = new Event("com/openexchange/groupware/appointment/update", ht);
        this.triggerEvent(event);
        EventObject eventObject = new EventObject(newAppointment, 6, this.session);
        EventQueue.add(eventObject);
    }

    public void accepted(Appointment appointment) throws OXException {
        Context ctx = ContextStorage.getInstance().getContext(this.contextId);
        int folderId = appointment.getParentFolderID();
        if (folderId > 0) {
            FolderObject folderObj = this.getFolder(folderId, ctx);
            this.accepted(null, appointment, folderObj);
        }
    }

    public void accepted(Appointment oldAppointment, Appointment newAppointment, FolderObject folder) throws OXException {
        Map<Integer, Set<Integer>> affectedUsers = this.getAffectedUsers(new CalendarObject[]{oldAppointment, newAppointment}, new FolderObject[]{folder});
        CommonEventImpl genericEvent = new CommonEventImpl(this.contextId, this.userId, EventClient.unmodifyable(affectedUsers), 5, 1, newAppointment, oldAppointment, folder, null, this.session);
        Hashtable<String, CommonEventImpl> ht = new Hashtable<String, CommonEventImpl>(1);
        ((Dictionary)ht).put("OX_EVENT", genericEvent);
        Event event = new Event("com/openexchange/groupware/appointment/accepted", ht);
        this.triggerEvent(event);
        EventObject eventObject = new EventObject(newAppointment, 9, this.session);
        EventQueue.add(eventObject);
    }

    public void declined(Appointment appointment) throws OXException {
        Context ctx = ContextStorage.getInstance().getContext(this.contextId);
        int folderId = appointment.getParentFolderID();
        if (folderId > 0) {
            FolderObject folderObj = this.getFolder(folderId, ctx);
            this.declined(null, appointment, folderObj);
        }
    }

    public void declined(Appointment oldAppointment, Appointment newAppointment, FolderObject folder) throws OXException {
        Map<Integer, Set<Integer>> affectedUsers = this.getAffectedUsers(new CalendarObject[]{oldAppointment, newAppointment}, new FolderObject[]{folder});
        CommonEventImpl genericEvent = new CommonEventImpl(this.contextId, this.userId, EventClient.unmodifyable(affectedUsers), 6, 1, newAppointment, oldAppointment, folder, null, this.session);
        Hashtable<String, CommonEventImpl> ht = new Hashtable<String, CommonEventImpl>(1);
        ((Dictionary)ht).put("OX_EVENT", genericEvent);
        Event event = new Event("com/openexchange/groupware/appointment/declined", ht);
        this.triggerEvent(event);
        EventObject eventObject = new EventObject(newAppointment, 10, this.session);
        EventQueue.add(eventObject);
    }

    public void tentative(Appointment appointment) throws OXException {
        Context ctx = ContextStorage.getInstance().getContext(this.contextId);
        int folderId = appointment.getParentFolderID();
        if (folderId > 0) {
            FolderObject folderObj = this.getFolder(folderId, ctx);
            this.tentative(null, appointment, folderObj);
        }
    }

    public void tentative(Appointment oldAppointment, Appointment newAppointment, FolderObject folder) throws OXException {
        Map<Integer, Set<Integer>> affectedUsers = this.getAffectedUsers(new CalendarObject[]{oldAppointment, newAppointment}, new FolderObject[]{folder});
        CommonEventImpl genericEvent = new CommonEventImpl(this.contextId, this.userId, EventClient.unmodifyable(affectedUsers), 7, 1, newAppointment, oldAppointment, folder, null, this.session);
        Hashtable<String, CommonEventImpl> ht = new Hashtable<String, CommonEventImpl>(1);
        ((Dictionary)ht).put("OX_EVENT", genericEvent);
        Event event = new Event("com/openexchange/groupware/appointment/tentative", ht);
        this.triggerEvent(event);
        EventObject eventObject = new EventObject(newAppointment, 11, this.session);
        EventQueue.add(eventObject);
    }

    public void waiting(Appointment appointment) throws OXException {
        Context ctx = ContextStorage.getInstance().getContext(this.contextId);
        int folderId = appointment.getParentFolderID();
        if (folderId > 0) {
            FolderObject folderObj = this.getFolder(folderId, ctx);
            this.waiting(null, appointment, folderObj);
        }
    }

    public void waiting(Appointment oldAppointment, Appointment newAppointment, FolderObject folder) throws OXException {
        Map<Integer, Set<Integer>> affectedUsers = this.getAffectedUsers(new CalendarObject[]{oldAppointment, newAppointment}, new FolderObject[]{folder});
        CommonEventImpl genericEvent = new CommonEventImpl(this.contextId, this.userId, EventClient.unmodifyable(affectedUsers), 8, 1, newAppointment, oldAppointment, folder, null, this.session);
        Hashtable<String, CommonEventImpl> ht = new Hashtable<String, CommonEventImpl>(1);
        ((Dictionary)ht).put("OX_EVENT", genericEvent);
        Event event = new Event("com/openexchange/groupware/appointment/waiting", ht);
        this.triggerEvent(event);
        EventObject eventObject = new EventObject(newAppointment, 11, this.session);
        EventQueue.add(eventObject);
    }

    public void delete(Appointment appointment) throws OXException, OXException {
        Context ctx = ContextStorage.getInstance().getContext(this.contextId);
        int folderId = appointment.getParentFolderID();
        if (folderId > 0) {
            FolderObject folderObj = this.getFolder(folderId, ctx);
            this.delete(appointment, folderObj);
        }
    }

    public void delete(Appointment appointment, FolderObject folder) throws OXException {
        Map<Integer, Set<Integer>> affectedUsers = this.getAffectedUsers(new CalendarObject[]{appointment}, new FolderObject[]{folder});
        CommonEventImpl genericEvent = new CommonEventImpl(this.contextId, this.userId, EventClient.unmodifyable(affectedUsers), 3, 1, appointment, null, folder, null, this.session);
        Hashtable<String, CommonEventImpl> ht = new Hashtable<String, CommonEventImpl>(1);
        ((Dictionary)ht).put("OX_EVENT", genericEvent);
        Event event = new Event("com/openexchange/groupware/appointment/delete", ht);
        this.triggerEvent(event);
        EventObject eventObject = new EventObject(appointment, 7, this.session);
        EventQueue.add(eventObject);
    }

    public void move(Appointment appointment, FolderObject sourceFolder, FolderObject destinationFolder) throws OXException {
        Map<Integer, Set<Integer>> affectedUsers = this.getAffectedUsers(new CalendarObject[]{appointment}, new FolderObject[]{sourceFolder, destinationFolder});
        CommonEventImpl genericEvent = new CommonEventImpl(this.contextId, this.userId, EventClient.unmodifyable(affectedUsers), 4, 1, appointment, null, sourceFolder, destinationFolder, this.session);
        Hashtable<String, CommonEventImpl> ht = new Hashtable<String, CommonEventImpl>(1);
        ((Dictionary)ht).put("OX_EVENT", genericEvent);
        Event event = new Event("com/openexchange/groupware/appointment/move", ht);
        this.triggerEvent(event);
        EventObject eventObject = new EventObject(appointment, 7, this.session);
        EventQueue.add(eventObject);
    }

    public void create(Task task, FolderObject folder) throws OXException {
        Map<Integer, Set<Integer>> affectedUsers = this.getAffectedUsers(new CalendarObject[]{task}, new FolderObject[]{folder});
        CommonEventImpl genericEvent = new CommonEventImpl(this.contextId, this.userId, EventClient.unmodifyable(affectedUsers), 1, 4, task, null, folder, null, this.session);
        Hashtable<String, CommonEventImpl> ht = new Hashtable<String, CommonEventImpl>(1);
        ((Dictionary)ht).put("OX_EVENT", genericEvent);
        Event event = new Event("com/openexchange/groupware/task/insert", ht);
        this.triggerEvent(event);
        EventObject eventObject = new EventObject(task, 5, this.session);
        EventQueue.add(eventObject);
    }

    public void modify(Task oldTask, Task newTask, FolderObject folder) throws OXException {
        Map<Integer, Set<Integer>> affectedUsers = this.getAffectedUsers(new CalendarObject[]{oldTask, newTask}, new FolderObject[]{folder});
        CommonEventImpl genericEvent = new CommonEventImpl(this.contextId, this.userId, EventClient.unmodifyable(affectedUsers), 2, 4, newTask, oldTask, folder, null, this.session);
        Hashtable<String, CommonEventImpl> ht = new Hashtable<String, CommonEventImpl>(1);
        ((Dictionary)ht).put("OX_EVENT", genericEvent);
        Event event = new Event("com/openexchange/groupware/task/update", ht);
        this.triggerEvent(event);
        EventObject eventObject = new EventObject(oldTask, 6, this.session);
        EventQueue.add(eventObject);
    }

    public void accept(Task oldTask, Task newTask) throws OXException {
        Context ctx = ContextStorage.getInstance().getContext(this.contextId);
        int folderId = newTask.getParentFolderID();
        if (folderId > 0) {
            FolderObject folder = this.getFolder(folderId, ctx);
            this.accept(oldTask, newTask, folder);
        }
    }

    public void accept(Task oldTask, Task newTask, FolderObject folder) throws OXException {
        Map<Integer, Set<Integer>> affectedUsers = this.getAffectedUsers(new CalendarObject[]{oldTask, newTask}, new FolderObject[]{folder});
        CommonEventImpl genericEvent = new CommonEventImpl(this.contextId, this.userId, EventClient.unmodifyable(affectedUsers), 5, 4, newTask, oldTask, folder, null, this.session);
        Hashtable<String, CommonEventImpl> ht = new Hashtable<String, CommonEventImpl>(1);
        ((Dictionary)ht).put("OX_EVENT", genericEvent);
        Event event = new Event("com/openexchange/groupware/task/accepted", ht);
        this.triggerEvent(event);
        EventObject eventObject = new EventObject(oldTask, 9, this.session);
        EventQueue.add(eventObject);
    }

    public void declined(Task oldTask, Task newTask) throws OXException {
        Context ctx = ContextStorage.getInstance().getContext(this.contextId);
        int folderId = newTask.getParentFolderID();
        if (folderId > 0) {
            FolderObject folder = this.getFolder(folderId, ctx);
            this.declined(oldTask, newTask, folder);
        }
    }

    public void declined(Task oldTask, Task newTask, FolderObject folder) throws OXException {
        Map<Integer, Set<Integer>> affectedUsers = this.getAffectedUsers(new CalendarObject[]{oldTask, newTask}, new FolderObject[]{folder});
        CommonEventImpl genericEvent = new CommonEventImpl(this.contextId, this.userId, EventClient.unmodifyable(affectedUsers), 6, 4, newTask, oldTask, folder, null, this.session);
        Hashtable<String, CommonEventImpl> ht = new Hashtable<String, CommonEventImpl>(1);
        ((Dictionary)ht).put("OX_EVENT", genericEvent);
        Event event = new Event("com/openexchange/groupware/task/declined", ht);
        this.triggerEvent(event);
        EventObject eventObject = new EventObject(oldTask, 10, this.session);
        EventQueue.add(eventObject);
    }

    public void tentative(Task oldTask, Task newTask) throws OXException {
        Context ctx = ContextStorage.getInstance().getContext(this.contextId);
        int folderId = newTask.getParentFolderID();
        if (folderId > 0) {
            FolderObject folder = this.getFolder(folderId, ctx);
            this.tentative(oldTask, newTask, folder);
        }
    }

    public void tentative(Task oldTask, Task newTask, FolderObject folder) throws OXException {
        Map<Integer, Set<Integer>> affectedUsers = this.getAffectedUsers(new CalendarObject[]{oldTask, newTask}, new FolderObject[]{folder});
        CommonEventImpl genericEvent = new CommonEventImpl(this.contextId, this.userId, EventClient.unmodifyable(affectedUsers), 7, 4, newTask, oldTask, folder, null, this.session);
        Hashtable<String, CommonEventImpl> ht = new Hashtable<String, CommonEventImpl>(1);
        ((Dictionary)ht).put("OX_EVENT", genericEvent);
        Event event = new Event("com/openexchange/groupware/task/tentative", ht);
        this.triggerEvent(event);
        EventObject eventObject = new EventObject(oldTask, 11, this.session);
        EventQueue.add(eventObject);
    }

    public void delete(Task task) throws OXException, OXException {
        Context ctx = ContextStorage.getInstance().getContext(this.contextId);
        int folderId = task.getParentFolderID();
        if (folderId > 0) {
            FolderObject folder = this.getFolder(folderId, ctx);
            this.delete(task, folder);
        }
    }

    public void delete(Task task, FolderObject folder) throws OXException {
        Map<Integer, Set<Integer>> affectedUsers = this.getAffectedUsers(new CalendarObject[]{task}, new FolderObject[]{folder});
        CommonEventImpl genericEvent = new CommonEventImpl(this.contextId, this.userId, EventClient.unmodifyable(affectedUsers), 3, 4, task, null, folder, null, this.session);
        Hashtable<String, CommonEventImpl> ht = new Hashtable<String, CommonEventImpl>(1);
        ((Dictionary)ht).put("OX_EVENT", genericEvent);
        Event event = new Event("com/openexchange/groupware/task/delete", ht);
        this.triggerEvent(event);
        EventObject eventObject = new EventObject(task, 7, this.session);
        EventQueue.add(eventObject);
    }

    public void move(Task task, FolderObject sourceFolder, FolderObject destinationFolder) throws OXException {
        Map<Integer, Set<Integer>> affectedUsers = this.getAffectedUsers(new CalendarObject[]{task}, new FolderObject[]{sourceFolder, destinationFolder});
        CommonEventImpl genericEvent = new CommonEventImpl(this.contextId, this.userId, EventClient.unmodifyable(affectedUsers), 4, 4, task, null, sourceFolder, destinationFolder, this.session);
        Hashtable<String, CommonEventImpl> ht = new Hashtable<String, CommonEventImpl>(1);
        ((Dictionary)ht).put("OX_EVENT", genericEvent);
        Event event = new Event("com/openexchange/groupware/task/move", ht);
        this.triggerEvent(event);
        EventObject eventObject = new EventObject(task, 7, this.session);
        EventQueue.add(eventObject);
    }

    public void create(Contact contact) throws OXException, OXException {
        Context ctx = ContextStorage.getInstance().getContext(this.contextId);
        int folderId = contact.getParentFolderID();
        if (folderId > 0) {
            FolderObject folder = this.getFolder(folderId, ctx);
            this.create(contact, folder);
        }
    }

    public void create(Contact contact, FolderObject folder) throws OXException {
        Map<Integer, Set<Integer>> affectedUsers = this.getAffectedUsers(new FolderObject[]{folder}, contact.getParentFolderID());
        CommonEventImpl genericEvent = new CommonEventImpl(this.contextId, this.userId, EventClient.unmodifyable(affectedUsers), 1, 7, contact, null, folder, null, this.session);
        Hashtable<String, CommonEventImpl> ht = new Hashtable<String, CommonEventImpl>(1);
        ((Dictionary)ht).put("OX_EVENT", genericEvent);
        Event event = new Event("com/openexchange/groupware/contact/insert", ht);
        this.triggerEvent(event);
        EventObject eventObject = new EventObject(contact, 5, this.session);
        EventQueue.add(eventObject);
    }

    public void modify(Contact oldContact, Contact newContact, FolderObject folder) throws OXException {
        Map<Integer, Set<Integer>> affectedUsers = this.getAffectedUsers(new FolderObject[]{folder}, oldContact.getParentFolderID(), newContact.getParentFolderID());
        CommonEventImpl genericEvent = new CommonEventImpl(this.contextId, this.userId, EventClient.unmodifyable(affectedUsers), 2, 7, newContact, oldContact, folder, null, this.session);
        Hashtable<String, CommonEventImpl> ht = new Hashtable<String, CommonEventImpl>(1);
        ((Dictionary)ht).put("OX_EVENT", genericEvent);
        Event event = new Event("com/openexchange/groupware/contact/update", ht);
        this.triggerEvent(event);
        EventObject eventObject = new EventObject(newContact, 6, this.session);
        EventQueue.add(eventObject);
    }

    public void delete(Contact contact) throws OXException, OXException {
        Context ctx = ContextStorage.getInstance().getContext(this.contextId);
        int folderId = contact.getParentFolderID();
        if (folderId > 0) {
            FolderObject folder = this.getFolder(folderId, ctx);
            this.delete(contact, folder);
        }
    }

    public void delete(Contact contact, FolderObject folder) throws OXException {
        Map<Integer, Set<Integer>> affectedUsers = this.getAffectedUsers(new FolderObject[]{folder}, contact.getParentFolderID());
        CommonEventImpl genericEvent = new CommonEventImpl(this.contextId, this.userId, EventClient.unmodifyable(affectedUsers), 3, 7, contact, null, folder, null, this.session);
        Hashtable<String, CommonEventImpl> ht = new Hashtable<String, CommonEventImpl>(1);
        ((Dictionary)ht).put("OX_EVENT", genericEvent);
        Event event = new Event("com/openexchange/groupware/contact/delete", ht);
        this.triggerEvent(event);
        EventObject eventObject = new EventObject(contact, 7, this.session);
        EventQueue.add(eventObject);
    }

    public void move(Contact contact, FolderObject sourceFolder, FolderObject destinationFolder) throws OXException {
        Map<Integer, Set<Integer>> affectedUsers = this.getAffectedUsers(new FolderObject[]{sourceFolder, destinationFolder}, contact.getParentFolderID());
        CommonEventImpl genericEvent = new CommonEventImpl(this.contextId, this.userId, EventClient.unmodifyable(affectedUsers), 4, 7, contact, null, sourceFolder, destinationFolder, this.session);
        Hashtable<String, CommonEventImpl> ht = new Hashtable<String, CommonEventImpl>(1);
        ((Dictionary)ht).put("OX_EVENT", genericEvent);
        Event event = new Event("com/openexchange/groupware/contact/move", ht);
        this.triggerEvent(event);
        EventObject eventObject = new EventObject(contact, 8, this.session);
        EventQueue.add(eventObject);
    }

    public void create(FolderObject folder) throws OXException, OXException {
        Context ctx = ContextStorage.getInstance().getContext(this.contextId);
        int folderId = folder.getParentFolderID();
        if (folderId > 0) {
            FolderObject parentFolderObj = this.getFolder(folderId, ctx);
            this.create(folder, parentFolderObj);
        }
    }

    public void create(FolderObject folder, FolderObject parentFolder) throws OXException {
        Map<Integer, Set<Integer>> affectedUsers = this.getAffectedUsers(new FolderObject[]{folder, parentFolder});
        CommonEventImpl genericEvent = new CommonEventImpl(this.contextId, this.userId, EventClient.unmodifyable(affectedUsers), 1, 20, folder, null, parentFolder, null, this.session);
        Hashtable<String, CommonEventImpl> ht = new Hashtable<String, CommonEventImpl>(1);
        ((Dictionary)ht).put("OX_EVENT", genericEvent);
        Event event = new Event("com/openexchange/groupware/folder/insert", ht);
        this.triggerEvent(event);
        if (null != folder && 8 == folder.getModule()) {
            this.triggerEvent(new Event("com/openexchange/groupware/fsfolder/insert", this.getEventProperties(folder)));
        }
        EventObject eventObject = new EventObject(folder, 5, this.session);
        EventQueue.add(eventObject);
    }

    public void modify(FolderObject oldFolder, FolderObject newFolder, FolderObject parentFolder) throws OXException {
        Map<Integer, Set<Integer>> affectedUsers = this.getAffectedUsers(new FolderObject[]{oldFolder, newFolder, parentFolder}, oldFolder.getParentFolderID(), newFolder.getParentFolderID());
        CommonEventImpl genericEvent = new CommonEventImpl(this.contextId, this.userId, EventClient.unmodifyable(affectedUsers), 2, 20, newFolder, oldFolder, parentFolder, null, this.session);
        Hashtable<String, CommonEventImpl> ht = new Hashtable<String, CommonEventImpl>(1);
        ((Dictionary)ht).put("OX_EVENT", genericEvent);
        Event event = new Event("com/openexchange/groupware/folder/update", ht);
        this.triggerEvent(event);
        if (null != newFolder && 8 == newFolder.getModule()) {
            Dictionary<String, Object> properties = this.getEventProperties(newFolder);
            if (null != oldFolder && oldFolder.getParentFolderID() != newFolder.getParentFolderID()) {
                properties.put("oldParentFolderId", String.valueOf(oldFolder.getParentFolderID()));
            }
            this.triggerEvent(new Event("com/openexchange/groupware/fsfolder/update", properties));
        }
        EventObject eventObject = new EventObject(newFolder, 6, this.session);
        EventQueue.add(eventObject);
    }

    public void delete(FolderObject folder) throws OXException {
        Context ctx = ContextStorage.getInstance().getContext(this.contextId);
        int folderId = folder.getParentFolderID();
        if (folderId > 0) {
            FolderObject parentFolderObj = null;
            try {
                parentFolderObj = this.getFolder(folderId, ctx);
            }
            catch (OXException exc) {
                if (exc.isGeneric(OXException.Generic.NO_PERMISSION)) {
                    LOG.error("cannot load folder", (Throwable)exc);
                }
                throw exc;
            }
            this.delete(folder, parentFolderObj);
        }
    }

    public void delete(FolderObject folder, FolderObject parentFolder) throws OXException {
        Map<Integer, Set<Integer>> affectedUsers = this.getAffectedUsers(new FolderObject[]{folder, parentFolder});
        CommonEventImpl genericEvent = new CommonEventImpl(this.contextId, this.userId, EventClient.unmodifyable(affectedUsers), 3, 20, folder, null, parentFolder, null, this.session);
        Hashtable<String, CommonEventImpl> ht = new Hashtable<String, CommonEventImpl>(1);
        ((Dictionary)ht).put("OX_EVENT", genericEvent);
        Event event = new Event("com/openexchange/groupware/folder/delete", ht);
        this.triggerEvent(event);
        if (null != parentFolder && 8 == parentFolder.getModule()) {
            this.triggerEvent(new Event("com/openexchange/groupware/fsfolder/delete", this.getEventProperties(folder, parentFolder)));
        }
        EventObject eventObject = new EventObject(folder, 7, this.session);
        EventQueue.add(eventObject);
    }

    protected void triggerEvent(Event event) throws OXException {
        EventAdmin eventAdmin = ServerServiceRegistry.getInstance().getService(EventAdmin.class);
        if (eventAdmin == null) {
            throw new OXException().setLogMessage("event service not available");
        }
        eventAdmin.postEvent(event);
    }

    private Dictionary<String, Object> getEventProperties(FolderObject folder) {
        Hashtable<String, Object> properties = new Hashtable<String, Object>(5);
        ((Dictionary)properties).put("session", this.session);
        ((Dictionary)properties).put("folderId", String.valueOf(folder.getObjectID()));
        ((Dictionary)properties).put("accountId", "infostore");
        ((Dictionary)properties).put("service", "com.openexchange.infostore");
        return properties;
    }

    private Dictionary<String, Object> getEventProperties(FolderObject folder, FolderObject parentFolder) {
        Hashtable<String, Object> properties = new Hashtable<String, Object>(5);
        ((Dictionary)properties).put("session", this.session);
        ((Dictionary)properties).put("folderId", String.valueOf(folder.getObjectID()));
        ((Dictionary)properties).put("parentFolderId", String.valueOf(parentFolder.getObjectID()));
        ((Dictionary)properties).put("accountId", "infostore");
        ((Dictionary)properties).put("service", "com.openexchange.infostore");
        return properties;
    }

    private FolderObject getFolder(int folderId, Context ctx) throws OXException {
        return new OXFolderAccess(ctx).getFolderObject(folderId);
    }

    private Map<Integer, Set<Integer>> getAffectedUsers(FolderObject[] folders2, int ... folderIds) throws OXException {
        Map<Integer, Set<Integer>> retval = this.getAffectedUsers(folders2);
        for (int folderId : folderIds) {
            EventClient.getFolderSet(retval, this.userId).add(Autoboxing.I((int)folderId));
        }
        return retval;
    }

    private Map<Integer, Set<Integer>> getAffectedUsers(FolderObject[] folders2) throws OXException {
        HashMap<Integer, Set<Integer>> retval = new HashMap<Integer, Set<Integer>>();
        retval.put(Autoboxing.I((int)this.userId), new HashSet());
        for (FolderObject folder : folders2) {
            this.addFolderToAffectedMap(retval, folder);
        }
        return retval;
    }

    private Map<Integer, Set<Integer>> getAffectedUsers(CalendarObject[] objects, FolderObject[] folders2) throws OXException {
        Map<Integer, Set<Integer>> retval = this.getAffectedUsers(folders2);
        for (CalendarObject object : objects) {
            if (null == object) continue;
            EventClient.getFolderSet(retval, this.userId).add(Autoboxing.I((int)object.getParentFolderID()));
            UserParticipant[] participants = object.getUsers();
            if (null == participants) continue;
            for (UserParticipant participant : object.getUsers()) {
                int participantId = participant.getIdentifier();
                if (-1 == participantId) continue;
                EventClient.getFolderSet(retval, participantId);
                int folderId = participant.getPersonalFolderId();
                if (-1 == folderId || 0 == folderId) continue;
                FolderService folderService = ServerServiceRegistry.getInstance().getService(FolderService.class, true);
                FolderObject folder = folderService.getFolderObject(folderId, this.contextId);
                this.addFolderToAffectedMap(retval, folder);
            }
        }
        return retval;
    }

    private void addFolderToAffectedMap(Map<Integer, Set<Integer>> retval, FolderObject folder) throws OXException {
        for (OCLPermission permission : folder.getPermissions()) {
            if (!permission.isFolderVisible()) continue;
            if (permission.isGroupPermission()) {
                GroupService groupService = ServerServiceRegistry.getInstance().getService(GroupService.class, true);
                Group group = groupService.getGroup(EventClient.getContext(this.contextId), permission.getEntity());
                for (int groupMember : group.getMember()) {
                    EventClient.getFolderSet(retval, groupMember).add(Autoboxing.I((int)folder.getObjectID()));
                }
                continue;
            }
            EventClient.getFolderSet(retval, permission.getEntity()).add(Autoboxing.I((int)folder.getObjectID()));
        }
    }

    private static Set<Integer> getFolderSet(Map<Integer, Set<Integer>> map, int userId) {
        Set<Integer> retval = map.get(Autoboxing.I((int)userId));
        if (null == retval) {
            retval = new HashSet<Integer>();
            map.put(Autoboxing.I((int)userId), retval);
        }
        return retval;
    }

    private static Context getContext(int contextId) throws OXException {
        ContextService contextService = ServerServiceRegistry.getInstance().getService(ContextService.class, true);
        return contextService.getContext(contextId);
    }

    private static Map<Integer, Set<Integer>> unmodifyable(Map<Integer, Set<Integer>> map) {
        for (Map.Entry<Integer, Set<Integer>> entry : map.entrySet()) {
            entry.setValue(Collections.unmodifiableSet(entry.getValue()));
        }
        return Collections.unmodifiableMap(map);
    }
}

