/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.writer;

import com.openexchange.ajax.writer.CommonWriter;
import com.openexchange.ajax.writer.DataWriter;
import com.openexchange.ajax.writer.ParticipantWriter;
import com.openexchange.ajax.writer.WriterProcedure;
import com.openexchange.groupware.container.CalendarObject;
import com.openexchange.groupware.container.Participant;
import com.openexchange.groupware.container.UserParticipant;
import com.openexchange.groupware.container.participants.ConfirmableParticipant;
import com.openexchange.session.Session;
import gnu.trove.map.hash.TIntObjectHashMap;
import java.util.Date;
import java.util.TimeZone;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONWriter;

public abstract class CalendarWriter
extends CommonWriter {
    private static final DataWriter.FieldWriter<CalendarObject> CONFIRMATIONS_WRITER = new DataWriter.FieldWriter<CalendarObject>(){

        @Override
        public void write(CalendarObject obj, TimeZone timeZone, JSONArray json, Session session) throws JSONException {
            json.put((Object)this.createConfirmationArray(obj, session));
        }

        @Override
        public void write(CalendarObject obj, TimeZone timeZone, JSONObject json, Session session) throws JSONException {
            json.put("confirmations", (Object)this.createConfirmationArray(obj, session));
        }

        private JSONArray createConfirmationArray(CalendarObject obj, Session session) throws JSONException {
            JSONArray confirmations = new JSONArray();
            if (obj.containsConfirmations()) {
                ParticipantWriter writer = new ParticipantWriter();
                for (ConfirmableParticipant participant : obj.getConfirmations()) {
                    JSONObject jParticipant = new JSONObject();
                    writer.write(participant, jParticipant, session);
                    confirmations.put((Object)jParticipant);
                }
            }
            return confirmations;
        }
    };
    protected static final DataWriter.FieldWriter<CalendarObject> ORGANIZER_WRITER = new DataWriter.FieldWriter<CalendarObject>(){

        @Override
        public void write(CalendarObject obj, TimeZone timeZone, JSONArray json, Session session) {
            DataWriter.writeValue(obj.getOrganizer(), json, obj.containsOrganizer());
        }

        @Override
        public void write(CalendarObject obj, TimeZone timeZone, JSONObject json, Session session) throws JSONException {
            DataWriter.writeParameter("organizer", obj.getOrganizer(), json, obj.containsOrganizer());
        }
    };
    protected static final DataWriter.FieldWriter<CalendarObject> UID_WRITER = new DataWriter.FieldWriter<CalendarObject>(){

        @Override
        public void write(CalendarObject obj, TimeZone timeZone, JSONArray json, Session session) {
            DataWriter.writeValue(obj.getUid(), json, obj.containsUid());
        }

        @Override
        public void write(CalendarObject obj, TimeZone timeZone, JSONObject json, Session session) throws JSONException {
            DataWriter.writeParameter("uid", obj.getUid(), json, obj.containsUid());
        }
    };
    protected static final DataWriter.FieldWriter<CalendarObject> SEQUENCE_WRITER = new DataWriter.FieldWriter<CalendarObject>(){

        @Override
        public void write(CalendarObject obj, TimeZone timeZone, JSONArray json, Session session) {
            DataWriter.writeValue(obj.getSequence(), json, obj.containsSequence());
        }

        @Override
        public void write(CalendarObject obj, TimeZone timeZone, JSONObject json, Session session) throws JSONException {
            DataWriter.writeParameter("sequence", obj.getSequence(), json, obj.containsSequence());
        }
    };
    protected static final DataWriter.FieldWriter<CalendarObject> ORGANIZER_ID_WRITER = new DataWriter.FieldWriter<CalendarObject>(){

        @Override
        public void write(CalendarObject obj, TimeZone timeZone, JSONArray json, Session session) {
            DataWriter.writeValue(obj.getOrganizerId(), json, obj.containsOrganizerId());
        }

        @Override
        public void write(CalendarObject obj, TimeZone timeZone, JSONObject json, Session session) throws JSONException {
            DataWriter.writeParameter("organizerId", obj.getOrganizerId(), json, obj.containsOrganizerId());
        }
    };
    protected static final DataWriter.FieldWriter<CalendarObject> PRINCIPAL_WRITER = new DataWriter.FieldWriter<CalendarObject>(){

        @Override
        public void write(CalendarObject obj, TimeZone timeZone, JSONArray json, Session session) {
            DataWriter.writeValue(obj.getPrincipal(), json, obj.containsPrincipal());
        }

        @Override
        public void write(CalendarObject obj, TimeZone timeZone, JSONObject json, Session session) throws JSONException {
            DataWriter.writeParameter("principal", obj.getPrincipal(), json, obj.containsPrincipal());
        }
    };
    protected static final DataWriter.FieldWriter<CalendarObject> PRINCIPAL_ID_WRITER = new DataWriter.FieldWriter<CalendarObject>(){

        @Override
        public void write(CalendarObject obj, TimeZone timeZone, JSONArray json, Session session) {
            DataWriter.writeValue(obj.getPrincipalId(), json, obj.containsPrincipalId());
        }

        @Override
        public void write(CalendarObject obj, TimeZone timeZone, JSONObject json, Session session) throws JSONException {
            DataWriter.writeParameter("principalId", obj.getPrincipalId(), json, obj.containsPrincipalId());
        }
    };
    private static final TIntObjectHashMap<DataWriter.FieldWriter<CalendarObject>> WRITER_MAP;

    protected CalendarWriter(TimeZone timeZone, JSONWriter jsonWriter) {
        super(timeZone, jsonWriter);
    }

    protected static JSONArray getParticipantsAsJSONArray(CalendarObject calendarObj) throws JSONException {
        JSONArray jsonArray = new JSONArray();
        Participant[] participants = calendarObj.getParticipants();
        if (participants != null) {
            for (Participant p : participants) {
                JSONObject jsonObj = CalendarWriter.getParticipantAsJSONObject(p);
                jsonArray.put((Object)jsonObj);
            }
        }
        return jsonArray;
    }

    protected static JSONArray getUsersAsJSONArray(CalendarObject calendarObject) throws JSONException {
        JSONArray jsonArray = new JSONArray();
        UserParticipant[] users = calendarObject.getUsers();
        if (users != null) {
            for (int a = 0; a < users.length; ++a) {
                UserParticipant userParticipant = users[a];
                JSONObject jsonObj = CalendarWriter.getUserParticipantAsJSONObject(userParticipant);
                jsonArray.put((Object)jsonObj);
            }
        }
        return jsonArray;
    }

    protected static void writeRecurrenceParameter(CalendarObject calendarObject, JSONObject jsonObj) throws JSONException {
        int recurrenceType = calendarObject.getRecurrenceType();
        if (calendarObject.containsRecurrenceType()) {
            CalendarWriter.writeParameter("recurrence_type", recurrenceType, jsonObj);
        }
        switch (recurrenceType) {
            case 0: {
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                if (!calendarObject.containsDays()) break;
                CalendarWriter.writeParameter("days", calendarObject.getDays(), jsonObj);
                break;
            }
            case 3: {
                if (calendarObject.containsDays()) {
                    CalendarWriter.writeParameter("days", calendarObject.getDays(), jsonObj);
                }
                if (!calendarObject.containsDayInMonth()) break;
                if (calendarObject.getDays() > 0 && calendarObject.getDayInMonth() >= 5) {
                    CalendarWriter.writeParameter("day_in_month", -1, jsonObj);
                    break;
                }
                CalendarWriter.writeParameter("day_in_month", calendarObject.getDayInMonth(), jsonObj);
                break;
            }
            case 4: {
                if (calendarObject.containsDays()) {
                    CalendarWriter.writeParameter("days", calendarObject.getDays(), jsonObj);
                }
                if (calendarObject.containsDayInMonth()) {
                    CalendarWriter.writeParameter("day_in_month", calendarObject.getDayInMonth(), jsonObj);
                }
                if (!calendarObject.containsMonth()) break;
                CalendarWriter.writeParameter("month", calendarObject.getMonth(), jsonObj);
                break;
            }
            default: {
                throw new JSONException("invalid recurrence type: " + recurrenceType);
            }
        }
        if (calendarObject.containsInterval()) {
            CalendarWriter.writeParameter("interval", calendarObject.getInterval(), jsonObj);
        }
        if (calendarObject.containsUntil() && !calendarObject.containsOccurrence()) {
            CalendarWriter.writeParameter("until", calendarObject.getUntil(), jsonObj);
        }
        if (calendarObject.containsOccurrence()) {
            CalendarWriter.writeParameter("occurrences", calendarObject.getOccurrence(), jsonObj);
        }
    }

    private static JSONObject getParticipantAsJSONObject(Participant participant) throws JSONException {
        JSONObject jsonObj = new JSONObject();
        int id = participant.getIdentifier();
        if (-1 != id) {
            CalendarWriter.writeParameter("id", id, jsonObj);
        }
        CalendarWriter.writeParameter("display_name", participant.getDisplayName(), jsonObj);
        CalendarWriter.writeParameter("mail", participant.getEmailAddress(), jsonObj);
        CalendarWriter.writeParameter("type", participant.getType(), jsonObj, participant.getType() > 0);
        if (1 == participant.getType()) {
            UserParticipant userParticipant = (UserParticipant)participant;
            CalendarWriter.writeParameter("confirmation", userParticipant.getConfirm(), jsonObj, userParticipant.containsConfirm());
            CalendarWriter.writeParameter("confirmmessage", userParticipant.getConfirmMessage(), jsonObj, userParticipant.containsConfirmMessage());
        }
        return jsonObj;
    }

    public static JSONArray getExceptionAsJSONArray(Date[] dateExceptions) {
        if (dateExceptions != null) {
            JSONArray jsonArray = new JSONArray();
            for (int a = 0; a < dateExceptions.length; ++a) {
                CalendarWriter.writeValue(dateExceptions[a], jsonArray);
            }
            return jsonArray;
        }
        return null;
    }

    private static JSONObject getUserParticipantAsJSONObject(UserParticipant userParticipant) throws JSONException {
        JSONObject jsonObj = new JSONObject(6);
        CalendarWriter.writeParameter("id", userParticipant.getIdentifier(), jsonObj);
        CalendarWriter.writeParameter("confirmation", userParticipant.getConfirm(), jsonObj, userParticipant.containsConfirm());
        CalendarWriter.writeParameter("confirmmessage", userParticipant.getConfirmMessage(), jsonObj, userParticipant.containsConfirmMessage());
        return jsonObj;
    }

    protected boolean writeField(CalendarObject obj, int column, TimeZone tz, JSONArray json, Session session) throws JSONException {
        DataWriter.FieldWriter writer = (DataWriter.FieldWriter)WRITER_MAP.get(column);
        if (null == writer) {
            return super.writeField(obj, column, tz, json, session);
        }
        writer.write(obj, tz, json, session);
        return true;
    }

    protected void writeFields(CalendarObject obj, TimeZone tz, JSONObject json, Session session) throws JSONException {
        JSONException je;
        super.writeFields(obj, tz, json, session);
        WriterProcedure<CalendarObject> procedure = new WriterProcedure<CalendarObject>(obj, json, tz, session);
        if (!WRITER_MAP.forEachValue(procedure) && null != (je = procedure.getError())) {
            throw je;
        }
    }

    static {
        TIntObjectHashMap m = new TIntObjectHashMap(1, 1.0f);
        m.put(226, CONFIRMATIONS_WRITER);
        m.put(224, ORGANIZER_WRITER);
        m.put(223, UID_WRITER);
        m.put(225, SEQUENCE_WRITER);
        m.put(227, ORGANIZER_ID_WRITER);
        m.put(228, PRINCIPAL_WRITER);
        m.put(229, PRINCIPAL_ID_WRITER);
        WRITER_MAP = m;
    }
}

