/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.writer;

import com.openexchange.ajax.writer.TimedWriter;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.attach.AttachmentField;
import com.openexchange.groupware.attach.AttachmentMetadata;
import com.openexchange.groupware.attach.util.GetSwitch;
import com.openexchange.tools.iterator.SearchIterator;
import java.util.Date;
import java.util.TimeZone;
import org.json.JSONException;
import org.json.JSONWriter;

public class AttachmentWriter
extends TimedWriter<AttachmentMetadata> {
    public AttachmentWriter(JSONWriter writer) {
        super(writer);
    }

    public void writeAttachments(SearchIterator iterator, AttachmentField[] columns, TimeZone tz) throws JSONException, OXException {
        this.jsonWriter.array();
        this.fillArray(iterator, (Object[])columns, tz);
        this.jsonWriter.endArray();
    }

    @Override
    protected void fillArray(SearchIterator iterator, Object[] columns, TimeZone tz) throws OXException, JSONException {
        while (iterator.hasNext()) {
            this.jsonWriter.array();
            AttachmentMetadata attachment = (AttachmentMetadata)iterator.next();
            GetSwitch get = new GetSwitch(attachment);
            for (AttachmentField column : (AttachmentField[])columns) {
                Object o = column.doSwitch(get);
                o = this.jsonCompat(o, column, tz);
                this.jsonWriter.value(o);
            }
            this.jsonWriter.endArray();
        }
    }

    private Object jsonCompat(Object o, AttachmentField column, TimeZone tz) {
        if (column.getId() == 4) {
            long time = ((Date)o).getTime();
            int offset = tz.getOffset(time);
            return time + (long)offset;
        }
        return o;
    }

    public void write(AttachmentMetadata attachment, TimeZone tz) throws JSONException {
        this.jsonWriter.object();
        GetSwitch get = new GetSwitch(attachment);
        for (AttachmentField column : AttachmentField.VALUES) {
            this.jsonWriter.key(column.getName());
            this.jsonWriter.value(this.jsonCompat(column.doSwitch(get), column, tz));
        }
        this.jsonWriter.endObject();
    }

    @Override
    protected int getId(Object object) {
        return ((AttachmentMetadata)object).getId();
    }
}

