/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.requesthandler.converters.preview.cache.groupware;

import com.openexchange.ajax.requesthandler.converters.preview.cache.groupware.AddRefIdForPreviewCacheTable;
import com.openexchange.ajax.requesthandler.converters.preview.cache.groupware.DropDataFromPreviewCacheTable;
import com.openexchange.databaseold.Database;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.update.PerformParameters;
import com.openexchange.groupware.update.UpdateExceptionCodes;
import com.openexchange.groupware.update.UpdateTaskAdapter;
import com.openexchange.tools.sql.DBUtils;
import com.openexchange.tools.update.Column;
import com.openexchange.tools.update.Tools;
import java.sql.Connection;
import java.sql.SQLException;

public class ChangeDataToLongblob
extends UpdateTaskAdapter {
    @Override
    public void perform(PerformParameters params) throws OXException {
        int contextId = params.getContextId();
        Connection con = Database.getNoTimeout(contextId, true);
        boolean rollback = false;
        try {
            DBUtils.startTransaction(con);
            rollback = true;
            Column cData = new Column("data", "longblob");
            Tools.checkAndModifyColumns(con, "previewData", cData);
            con.commit();
            rollback = false;
        }
        catch (SQLException e) {
            throw UpdateExceptionCodes.SQL_PROBLEM.create(e, e.getMessage());
        }
        catch (RuntimeException e) {
            throw UpdateExceptionCodes.UNEXPECTED_ERROR.create(e, e.getMessage());
        }
        finally {
            if (rollback) {
                DBUtils.rollback(con);
            }
            DBUtils.autocommit(con);
            Database.backNoTimeout(contextId, true, con);
        }
    }

    @Override
    public String[] getDependencies() {
        return new String[]{DropDataFromPreviewCacheTable.class.getName(), AddRefIdForPreviewCacheTable.class.getName()};
    }
}

