/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.requesthandler.converters.preview.cache;

import com.openexchange.ajax.requesthandler.cache.AbstractResourceCache;
import com.openexchange.ajax.requesthandler.cache.CachedResource;
import com.openexchange.ajax.requesthandler.cache.ResourceCacheMetadata;
import com.openexchange.ajax.requesthandler.cache.ResourceCacheMetadataStore;
import com.openexchange.database.DatabaseService;
import com.openexchange.database.Databases;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.contexts.impl.ContextStorage;
import com.openexchange.groupware.filestore.FilestoreStorage;
import com.openexchange.java.Streams;
import com.openexchange.preview.PreviewExceptionCodes;
import com.openexchange.server.ServiceLookup;
import com.openexchange.timer.TimerService;
import com.openexchange.tools.file.FileStorage;
import com.openexchange.tools.file.QuotaFileStorage;
import com.openexchange.tools.file.external.FileStorageCodes;
import gnu.trove.ConcurrentTIntObjectHashMap;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.sql.Connection;
import java.sql.DataTruncation;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.RejectedExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileStoreResourceCacheImpl
extends AbstractResourceCache {
    protected static long ALIGNMENT_DELAY = 10000L;
    private static final Logger LOG = LoggerFactory.getLogger(FileStoreResourceCacheImpl.class);
    private static final ConcurrentTIntObjectHashMap<FileStorage> FILE_STORE_CACHE = new ConcurrentTIntObjectHashMap();
    private final boolean quotaAware;
    private static final Object SCHEDULED = new Object();
    private static final Object RUNNING = new Object();
    private final ConcurrentMap<Integer, Object> alignmentRequests = new ConcurrentHashMap<Integer, Object>();

    private static FileStorage getFileStorage(Context ctx, boolean quotaAware) throws OXException {
        int key = ctx.getContextId();
        FileStorage fs = (FileStorage)FILE_STORE_CACHE.get(key);
        if (null == fs) {
            URI uri = FilestoreStorage.createURI(ctx);
            FileStorage newFileStorage = quotaAware ? QuotaFileStorage.getInstance(uri, ctx) : FileStorage.getInstance(uri);
            fs = (FileStorage)FILE_STORE_CACHE.putIfAbsent(key, (Object)newFileStorage);
            if (null == fs) {
                fs = newFileStorage;
            }
        }
        return fs;
    }

    private static FileStorage getFileStorage(int contextId, boolean quotaAware) throws OXException {
        return FileStoreResourceCacheImpl.getFileStorage(ContextStorage.getStorageContext(contextId), quotaAware);
    }

    public FileStoreResourceCacheImpl(ServiceLookup serviceLookup) throws OXException {
        super(serviceLookup);
        this.quotaAware = this.getConfigurationService().getBoolProperty("com.openexchange.preview.cache.quotaAware", false);
    }

    private void batchDeleteFiles(Collection<String> ids, FileStorage fileStorage) {
        try {
            fileStorage.deleteFiles(ids.toArray(new String[0]));
        }
        catch (Exception e) {
            LOG.warn("Error while deleting a batch of preview files. Trying one-by-one now...", (Throwable)e);
            for (String id : ids) {
                if (null == id) continue;
                try {
                    fileStorage.deleteFile(id);
                }
                catch (Exception x) {
                    LOG.warn("Could not remove preview file '{}'. Consider using 'checkconsistency' to clean up the filestore.", (Object)id);
                }
            }
        }
    }

    @Override
    public boolean save(String id, CachedResource resource, int userId, int contextId) throws OXException {
        InputStream in = resource.getInputStream();
        if (null == in) {
            return this.save(id, resource.getBytes(), resource.getFileName(), resource.getFileType(), userId, contextId);
        }
        return this.save(id, in, resource.getFileName(), resource.getFileType(), userId, contextId);
    }

    private boolean save(String id, InputStream in, String optName, String optType, int userId, int contextId) throws OXException {
        try {
            return this.save(id, Streams.stream2bytes((InputStream)in), optName, optType, userId, contextId);
        }
        catch (IOException e) {
            throw PreviewExceptionCodes.IO_ERROR.create((Throwable)e, new Object[]{e.getMessage()});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean save(String id, byte[] bytes, String optName, String optType, int userId, int contextId) throws OXException {
        block39: {
            LOG.debug("Trying to cache resource {}.", (Object)id);
            ResourceCacheMetadataStore metadataStore = this.getMetadataStore();
            FileStorage fileStorage = FileStoreResourceCacheImpl.getFileStorage(contextId, this.quotaAware);
            DatabaseService dbService = this.getDBService();
            if (this.fitsQuotas(bytes.length)) {
                String refId = fileStorage.saveNewFile(Streams.newByteArrayInputStream((byte[])bytes));
                ResourceCacheMetadata newMetadata = new ResourceCacheMetadata();
                newMetadata.setContextId(contextId);
                newMetadata.setUserId(userId);
                newMetadata.setResourceId(id);
                newMetadata.setFileName(this.prepareFileName(optName));
                newMetadata.setFileType(this.prepareFileType(optType));
                newMetadata.setSize(bytes.length);
                newMetadata.setCreatedAt(System.currentTimeMillis());
                newMetadata.setRefId(refId);
                Connection con = dbService.getWritable(contextId);
                ResourceCacheMetadata existingMetadata = null;
                boolean committed = false;
                boolean triggerAlignment = false;
                long start = System.currentTimeMillis();
                try {
                    long usedSize;
                    Databases.startTransaction((Connection)con);
                    if (FileStoreResourceCacheImpl.entryExists(metadataStore, con, contextId, userId, id)) {
                        existingMetadata = FileStoreResourceCacheImpl.loadExistingEntryForUpdate(metadataStore, con, contextId, userId, id);
                        if (existingMetadata == null) {
                            metadataStore.store(con, newMetadata);
                        } else {
                            metadataStore.update(con, newMetadata);
                        }
                    } else {
                        metadataStore.store(con, newMetadata);
                    }
                    long globalQuota = this.getGlobalQuota();
                    if (globalQuota > 0L && (usedSize = metadataStore.getUsedSize(con, contextId)) > globalQuota) {
                        triggerAlignment = true;
                    }
                    con.commit();
                    committed = true;
                    boolean bl = true;
                    return bl;
                }
                catch (DataTruncation e) {
                    throw PreviewExceptionCodes.ERROR.create((Throwable)e, new Object[]{e.getMessage()});
                }
                catch (SQLException e) {
                    if (e.getErrorCode() == 1022) {
                        long transactionDuration = System.currentTimeMillis() - start;
                        LOG.warn("Caching a resource failed due to a duplicate key conflict, this should happen very rarely otherwise this may indicate a performance problem. The transaction lasted {}ms. Original message: {}.", (Object)transactionDuration, (Object)e.getMessage());
                        break block39;
                    }
                    throw PreviewExceptionCodes.ERROR.create((Throwable)e, new Object[]{e.getMessage()});
                }
                finally {
                    if (committed) {
                        Databases.autocommit((Connection)con);
                        dbService.backWritable(contextId, con);
                        if (existingMetadata != null) {
                            try {
                                if (!fileStorage.deleteFile(existingMetadata.getRefId())) {
                                    LOG.warn("Could not remove stored file '{}' after updating cached resource. Consider using 'checkconsistency' to clean up the filestore.", (Object)existingMetadata.getRefId());
                                }
                            }
                            catch (OXException e) {
                                LOG.warn("Could not remove stored file '{}' after updating cached resource. Consider using 'checkconsistency' to clean up the filestore.", (Object)existingMetadata.getRefId(), (Object)e);
                            }
                        }
                        if (triggerAlignment && this.alignmentRequests.putIfAbsent(contextId, SCHEDULED) == null && this.scheduleAlignmentTask(contextId)) {
                            LOG.debug("Scheduling alignment task for context {}.", (Object)contextId);
                        } else {
                            LOG.debug("Skipping scheduling of alignment task for context {}.", (Object)contextId);
                        }
                    } else {
                        if (con != null) {
                            try {
                                con.rollback();
                            }
                            catch (SQLException e) {
                                LOG.warn("Could not rollback database transaction after failing to cache a resource. Consider using 'checkconsistency' to clean up the database.");
                            }
                            Databases.autocommit((Connection)con);
                            dbService.backWritableAfterReading(contextId, con);
                        }
                        try {
                            if (refId != null && !fileStorage.deleteFile(refId)) {
                                LOG.warn("Could not remove stored file '{}' during transaction rollback. Consider using 'checkconsistency' to clean up the filestore.", (Object)refId);
                            }
                        }
                        catch (OXException e) {
                            LOG.warn("Could not remove stored file '{}' during transaction rollback. Consider using 'checkconsistency' to clean up the filestore.", (Object)refId, (Object)e);
                        }
                    }
                }
            }
        }
        return false;
    }

    protected boolean scheduleAlignmentTask(final int contextId) {
        try {
            TimerService timerService = this.optTimerService();
            if (timerService != null) {
                timerService.schedule(new Runnable(){

                    @Override
                    public void run() {
                        FileStoreResourceCacheImpl.this.alignToQuota(contextId);
                    }
                }, ALIGNMENT_DELAY);
                return true;
            }
        }
        catch (RejectedExecutionException e) {
            this.alignmentRequests.remove(contextId);
            LOG.warn("Could not schedule alignment task for context {}.", (Object)contextId, (Object)e);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void alignToQuota(int contextId) {
        if (!this.alignmentRequests.replace(contextId, SCHEDULED, RUNNING)) {
            return;
        }
        try {
            ResourceCacheMetadataStore metadataStore = this.getMetadataStore();
            DatabaseService dbService = this.getDBService();
            Connection con = dbService.getWritable(contextId);
            HashSet<String> refIds = new HashSet<String>();
            boolean transactionStarted = false;
            try {
                long globalQuota = this.getGlobalQuota();
                long usedContextQuota = metadataStore.getUsedSize(con, contextId);
                if (globalQuota > 0L && usedContextQuota > globalQuota) {
                    ResourceCacheMetadata metadata;
                    long neededSpace = usedContextQuota - globalQuota;
                    Databases.startTransaction((Connection)con);
                    transactionStarted = true;
                    List<ResourceCacheMetadata> entries = metadataStore.loadForCleanUp(con, contextId);
                    Iterator<ResourceCacheMetadata> it = entries.iterator();
                    for (long collected = 0L; collected < neededSpace && it.hasNext(); collected += metadata.getSize() > 0L ? metadata.getSize() : 0L) {
                        metadata = it.next();
                        String refId = metadata.getRefId();
                        if (refId == null) continue;
                        refIds.add(refId);
                    }
                    if (!refIds.isEmpty()) {
                        metadataStore.removeByRefIds(con, contextId, refIds);
                    }
                    con.commit();
                }
            }
            catch (SQLException s) {
                if (transactionStarted) {
                    Databases.rollback((Connection)con);
                }
                LOG.error("Could not align preview cache for context {} to quota.", (Object)contextId, (Object)s);
            }
            finally {
                this.alignmentRequests.remove(contextId);
                if (transactionStarted) {
                    Databases.autocommit((Connection)con);
                }
                if (refIds.isEmpty()) {
                    dbService.backWritableAfterReading(contextId, con);
                } else {
                    dbService.backWritable(contextId, con);
                }
            }
            if (refIds.isEmpty()) {
                LOG.debug("No need to align preview cache for context {} to quota.", (Object)contextId);
            } else {
                LOG.debug("Aligning preview cache for context {} to quota.", (Object)contextId);
                this.batchDeleteFiles(refIds, FileStoreResourceCacheImpl.getFileStorage(contextId, this.quotaAware));
            }
        }
        catch (Exception e) {
            LOG.error("Could not align preview cache for context {} to quota.", (Object)contextId, (Object)e);
        }
    }

    @Override
    public void remove(int userId, int contextId) throws OXException {
        ResourceCacheMetadataStore metadataStore = this.getMetadataStore();
        FileStorage fileStorage = FileStoreResourceCacheImpl.getFileStorage(contextId, this.quotaAware);
        List<ResourceCacheMetadata> removed = metadataStore.removeAll(contextId, userId);
        ArrayList<String> refIds = new ArrayList<String>();
        for (ResourceCacheMetadata metadata : removed) {
            if (metadata.getRefId() == null) continue;
            refIds.add(metadata.getRefId());
        }
        this.batchDeleteFiles(refIds, fileStorage);
    }

    @Override
    public void removeAlikes(String id, int userId, int contextId) throws OXException {
        if (null == id) {
            throw PreviewExceptionCodes.ERROR.create(new Object[]{"Missing identifier."});
        }
        ResourceCacheMetadataStore metadataStore = this.getMetadataStore();
        FileStorage fileStorage = FileStoreResourceCacheImpl.getFileStorage(contextId, this.quotaAware);
        List<ResourceCacheMetadata> removed = metadataStore.removeAll(contextId, userId, id);
        ArrayList<String> refIds = new ArrayList<String>();
        for (ResourceCacheMetadata metadata : removed) {
            if (metadata.getRefId() == null) continue;
            refIds.add(metadata.getRefId());
        }
        this.batchDeleteFiles(refIds, fileStorage);
    }

    @Override
    public void clearFor(int contextId) throws OXException {
        this.remove(-1, contextId);
    }

    @Override
    public CachedResource get(String id, int userId, int contextId) throws OXException {
        if (null == id || contextId <= 0) {
            return null;
        }
        ResourceCacheMetadataStore metadataStore = this.getMetadataStore();
        FileStorage fileStorage = FileStoreResourceCacheImpl.getFileStorage(contextId, this.quotaAware);
        ResourceCacheMetadata metadata = metadataStore.load(contextId, userId, id);
        if (metadata == null) {
            return null;
        }
        if (metadata.getRefId() == null) {
            metadataStore.remove(contextId, userId, id);
            return null;
        }
        InputStream file = fileStorage.getFile(metadata.getRefId());
        return new CachedResource(file, metadata.getFileName(), metadata.getFileType(), metadata.getSize());
    }

    @Override
    public boolean exists(String id, int userId, int contextId) throws OXException {
        if (null == id || contextId <= 0) {
            return false;
        }
        FileStorage fileStorage = FileStoreResourceCacheImpl.getFileStorage(contextId, this.quotaAware);
        ResourceCacheMetadataStore metadataStore = this.getMetadataStore();
        ResourceCacheMetadata metadata = metadataStore.load(contextId, userId, id);
        if (metadata == null) {
            return false;
        }
        if (metadata.getRefId() == null) {
            metadataStore.remove(contextId, userId, id);
            return false;
        }
        try {
            Streams.close((Closeable)fileStorage.getFile(metadata.getRefId()));
        }
        catch (OXException e) {
            if (!FileStorageCodes.FILE_NOT_FOUND.equals(e)) {
                throw e;
            }
            metadataStore.remove(contextId, userId, id);
            return false;
        }
        return true;
    }

    private boolean fitsQuotas(long desiredSize) {
        long globalQuota = this.getGlobalQuota();
        long documentQuota = this.getDocumentQuota();
        if (globalQuota > 0L || documentQuota > 0L) {
            if (globalQuota <= 0L) {
                return documentQuota <= 0L || desiredSize <= documentQuota;
            }
            if (desiredSize > globalQuota || desiredSize > documentQuota) {
                return false;
            }
        }
        return true;
    }
}

