/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.request;

import com.openexchange.ajax.fields.OrderFields;
import com.openexchange.ajax.parser.CalendarParser;
import com.openexchange.ajax.parser.DataParser;
import com.openexchange.ajax.parser.TaskParser;
import com.openexchange.ajax.request.CalendarRequest;
import com.openexchange.ajax.writer.TaskWriter;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.container.Participants;
import com.openexchange.groupware.search.Order;
import com.openexchange.groupware.search.TaskSearchObject;
import com.openexchange.groupware.tasks.Task;
import com.openexchange.groupware.tasks.TasksSQLImpl;
import com.openexchange.java.Strings;
import com.openexchange.tools.StringCollection;
import com.openexchange.tools.TimeZoneUtils;
import com.openexchange.tools.iterator.SearchIterator;
import com.openexchange.tools.servlet.AjaxExceptionCodes;
import com.openexchange.tools.session.ServerSession;
import gnu.trove.list.array.TIntArrayList;
import java.util.Date;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskRequest
extends CalendarRequest {
    private static final Logger LOG = LoggerFactory.getLogger(TaskRequest.class);
    protected static final int[] _taskFields = new int[]{1, 2, 4, 5, 3, 20, 101, 100, 200, 201, 202, 203, 209, 220, 223, 302, 303, 204, 305, 100, 314, 312, 315, 301, 309, 300, 307, 308, 313, 102};

    public TaskRequest(ServerSession session) {
        this.session = session;
        this.timeZone = TimeZoneUtils.getTimeZone(session.getUser().getTimeZone());
    }

    public Date getTimestamp() {
        return this.timestamp;
    }

    public JSONValue action(String action, JSONObject json) throws JSONException, OXException {
        if (!this.session.getUserPermissionBits().hasTask()) {
            throw OXException.noPermissionForModule((String)"task");
        }
        String sTimeZone = DataParser.parseString(json, "timezone");
        if (null != sTimeZone) {
            this.timeZone = TimeZoneUtils.getTimeZone(sTimeZone);
        }
        if (action.equalsIgnoreCase("confirm")) {
            return this.actionConfirm(json);
        }
        if (action.equalsIgnoreCase("new")) {
            return this.actionNew(json);
        }
        if (action.equalsIgnoreCase("delete")) {
            return this.actionDelete(json);
        }
        if (action.equalsIgnoreCase("update")) {
            return this.actionUpdate(json);
        }
        if (action.equalsIgnoreCase("updates")) {
            return this.actionUpdates(json);
        }
        if (action.equalsIgnoreCase("list")) {
            return this.actionList(json);
        }
        if (action.equalsIgnoreCase("all")) {
            return this.actionAll(json);
        }
        if (action.equalsIgnoreCase("get")) {
            return this.actionGet(json);
        }
        if (action.equalsIgnoreCase("search")) {
            return this.actionSearch(json);
        }
        if (action.equalsIgnoreCase("copy")) {
            return this.actionCopy(json);
        }
        throw AjaxExceptionCodes.UNKNOWN_ACTION.create(action);
    }

    public JSONObject actionNew(JSONObject jsonObj) throws JSONException, OXException {
        Task task = new Task();
        JSONObject jsonobject = DataParser.checkJSONObject(jsonObj, "data");
        TaskParser taskParser = new TaskParser(this.timeZone);
        taskParser.parse(task, jsonobject, this.session.getUser().getLocale());
        TasksSQLImpl sqlinterface = new TasksSQLImpl(this.session);
        this.convertExternalToInternalUsersIfPossible(task, this.session.getContext(), LOG);
        sqlinterface.insertTaskObject(task);
        this.timestamp = task.getLastModified();
        JSONObject jsonResponseObject = new JSONObject();
        jsonResponseObject.put("id", task.getObjectID());
        return jsonResponseObject;
    }

    public JSONObject actionUpdate(JSONObject jsonObj) throws OXException {
        int id = DataParser.checkInt(jsonObj, "id");
        int inFolder = DataParser.checkInt(jsonObj, "folder");
        this.timestamp = DataParser.checkDate(jsonObj, "timestamp");
        Task task = new Task();
        JSONObject jsonobject = DataParser.checkJSONObject(jsonObj, "data");
        TaskParser taskParser = new TaskParser(this.timeZone);
        taskParser.parse(task, jsonobject, this.session.getUser().getLocale());
        task.setObjectID(id);
        this.convertExternalToInternalUsersIfPossible(task, this.session.getContext(), LOG);
        TasksSQLImpl sqlinterface = new TasksSQLImpl(this.session);
        sqlinterface.updateTaskObject(task, inFolder, this.timestamp);
        this.timestamp = task.getLastModified();
        return new JSONObject();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JSONArray actionUpdates(JSONObject jsonObj) throws JSONException, OXException {
        String[] sColumns = Strings.splitByComma((String)DataParser.checkString(jsonObj, "columns"));
        int[] columns = StringCollection.convertStringArray2IntArray(sColumns);
        int[] columnsToLoad = TaskRequest.removeVirtualColumns(columns);
        Date requestedTimestamp = DataParser.checkDate(jsonObj, "timestamp");
        this.timestamp = new Date(requestedTimestamp.getTime());
        int folderId = DataParser.checkInt(jsonObj, "folder");
        String ignore = DataParser.parseString(jsonObj, "ignore");
        if (ignore == null) {
            ignore = "deleted";
        }
        boolean bIgnoreDelete = false;
        if (ignore.indexOf("deleted") != -1) {
            bIgnoreDelete = true;
        }
        Date lastModified = null;
        JSONArray jsonResponseArray = new JSONArray();
        SearchIterator<Task> it = null;
        try {
            Task taskObj;
            int[] internalColumns = new int[columnsToLoad.length + 1];
            System.arraycopy(columnsToLoad, 0, internalColumns, 0, columnsToLoad.length);
            internalColumns[columnsToLoad.length] = 5;
            TasksSQLImpl taskssql = new TasksSQLImpl(this.session);
            TaskWriter taskWriter = new TaskWriter(this.timeZone).setSession(this.session);
            it = taskssql.getModifiedTasksInFolder(folderId, internalColumns, requestedTimestamp);
            while (it.hasNext()) {
                taskObj = (Task)it.next();
                taskWriter.writeArray(taskObj, columns, jsonResponseArray);
                lastModified = taskObj.getLastModified();
                if (this.timestamp.getTime() >= lastModified.getTime()) continue;
                this.timestamp = lastModified;
            }
            if (!bIgnoreDelete) {
                it.close();
                it = taskssql.getDeletedTasksInFolder(folderId, internalColumns, requestedTimestamp);
                while (it.hasNext()) {
                    taskObj = (Task)it.next();
                    jsonResponseArray.put(taskObj.getObjectID());
                    lastModified = taskObj.getLastModified();
                    if (this.timestamp.getTime() >= lastModified.getTime()) continue;
                    this.timestamp = lastModified;
                }
            }
            JSONArray jSONArray = jsonResponseArray;
            return jSONArray;
        }
        finally {
            if (it != null) {
                it.close();
            }
        }
    }

    public JSONArray actionDelete(JSONObject jsonObj) throws OXException {
        JSONObject jsonobject = DataParser.checkJSONObject(jsonObj, "data");
        int id = DataParser.checkInt(jsonobject, "id");
        int inFolder = DataParser.checkInt(jsonobject, "folder");
        this.timestamp = DataParser.checkDate(jsonObj, "timestamp");
        TasksSQLImpl sqlinterface = new TasksSQLImpl(this.session);
        sqlinterface.deleteTaskObject(id, inFolder, this.timestamp);
        return new JSONArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JSONArray actionList(JSONObject jsonObj) throws JSONException, OXException {
        this.timestamp = new Date(0L);
        Date lastModified = null;
        String[] sColumns = Strings.splitByComma((String)DataParser.checkString(jsonObj, "columns"));
        int[] columns = StringCollection.convertStringArray2IntArray(sColumns);
        int[] columnsToLoad = TaskRequest.removeVirtualColumns(columns);
        JSONArray jData = DataParser.checkJSONArray(jsonObj, "data");
        int[][] objectIdAndFolderId = new int[jData.length()][2];
        for (int a = 0; a < objectIdAndFolderId.length; ++a) {
            JSONObject jObject = jData.getJSONObject(a);
            objectIdAndFolderId[a][0] = DataParser.checkInt(jObject, "id");
            objectIdAndFolderId[a][1] = DataParser.checkInt(jObject, "folder");
        }
        int[] internalColumns = new int[columnsToLoad.length + 1];
        System.arraycopy(columnsToLoad, 0, internalColumns, 0, columnsToLoad.length);
        internalColumns[columnsToLoad.length] = 5;
        SearchIterator<Task> it = null;
        JSONArray jsonResponseArray = new JSONArray();
        try {
            TasksSQLImpl taskssql = new TasksSQLImpl(this.session);
            TaskWriter taskwriter = new TaskWriter(this.timeZone).setSession(this.session);
            it = taskssql.getObjectsById(objectIdAndFolderId, internalColumns);
            while (it.hasNext()) {
                Task taskobject = (Task)it.next();
                taskwriter.writeArray(taskobject, columns, jsonResponseArray);
                lastModified = taskobject.getLastModified();
                if (this.timestamp.getTime() >= lastModified.getTime()) continue;
                this.timestamp = lastModified;
            }
            JSONArray jSONArray = jsonResponseArray;
            return jSONArray;
        }
        finally {
            if (it != null) {
                it.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JSONArray actionAll(JSONObject jsonObj) throws JSONException, OXException {
        String[] sColumns = Strings.splitByComma((String)DataParser.checkString(jsonObj, "columns"));
        int[] columns = StringCollection.convertStringArray2IntArray(sColumns);
        int[] columnsToLoad = TaskRequest.removeVirtualColumns(columns);
        int folderId = DataParser.checkInt(jsonObj, "folder");
        int orderBy = DataParser.parseInt(jsonObj, "sort");
        Order order = OrderFields.parse(DataParser.parseString(jsonObj, "order"));
        int leftHandLimit = DataParser.parseInt(jsonObj, "left_hand_limit");
        int rightHandLimit = DataParser.parseInt(jsonObj, "right_hand_limit");
        int[] internalColumns = new int[columnsToLoad.length + 1];
        System.arraycopy(columnsToLoad, 0, internalColumns, 0, columnsToLoad.length);
        internalColumns[columnsToLoad.length] = 5;
        this.timestamp = new Date(0L);
        Date lastModified = null;
        JSONArray jsonResponseArray = new JSONArray();
        SearchIterator<Task> it = null;
        try {
            TaskWriter taskwriter = new TaskWriter(this.timeZone).setSession(this.session);
            TasksSQLImpl taskssql = new TasksSQLImpl(this.session);
            it = leftHandLimit == 0 ? taskssql.getTaskList(folderId, leftHandLimit, -1, orderBy, order, internalColumns) : taskssql.getTaskList(folderId, leftHandLimit, rightHandLimit, orderBy, order, internalColumns);
            while (it.hasNext()) {
                Task taskobject = (Task)it.next();
                taskwriter.writeArray(taskobject, columns, jsonResponseArray);
                lastModified = taskobject.getLastModified();
                if (this.timestamp.getTime() >= lastModified.getTime()) continue;
                this.timestamp = lastModified;
            }
            JSONArray jSONArray = jsonResponseArray;
            return jSONArray;
        }
        finally {
            if (it != null) {
                it.close();
            }
        }
    }

    public JSONObject actionGet(JSONObject jsonObj) throws OXException, JSONException {
        int id = DataParser.checkInt(jsonObj, "id");
        int inFolder = DataParser.checkInt(jsonObj, "folder");
        this.timestamp = new Date(0L);
        TasksSQLImpl sqlinterface = new TasksSQLImpl(this.session);
        Task task = sqlinterface.getTaskById(id, inFolder);
        TaskWriter taskWriter = new TaskWriter(this.timeZone).setSession(this.session);
        JSONObject jsonResponseObject = new JSONObject();
        taskWriter.writeTask(task, jsonResponseObject);
        this.timestamp = task.getLastModified();
        return jsonResponseObject;
    }

    public JSONObject actionConfirm(JSONObject json) throws OXException, JSONException {
        int taskId;
        JSONObject data = DataParser.checkJSONObject(json, "data");
        Task task = new Task();
        new TaskParser(this.timeZone).parse(task, data, this.session.getUser().getLocale());
        TasksSQLImpl taskSql = new TasksSQLImpl(this.session);
        int taskIdFromParameter = DataParser.parseInt(json, "id");
        if (0 == taskIdFromParameter) {
            if (!task.containsObjectID()) {
                throw AjaxExceptionCodes.MISSING_PARAMETER.create("id");
            }
            taskId = task.getObjectID();
        } else {
            taskId = taskIdFromParameter;
        }
        this.timestamp = taskSql.setUserConfirmation(taskId, this.session.getUserId(), task.getConfirm(), task.getConfirmMessage());
        return new JSONObject();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JSONArray actionSearch(JSONObject jsonObj) throws JSONException, OXException {
        String[] sColumns = Strings.splitByComma((String)DataParser.checkString(jsonObj, "columns"));
        int[] columns = StringCollection.convertStringArray2IntArray(sColumns);
        int[] columnsToLoad = TaskRequest.removeVirtualColumns(columns);
        this.timestamp = new Date(0L);
        Date lastModified = null;
        JSONObject jData = DataParser.checkJSONObject(jsonObj, "data");
        TaskSearchObject searchObj = new TaskSearchObject();
        if (jData.has("folder")) {
            searchObj.addFolder(DataParser.parseInt(jData, "folder"));
        }
        int orderBy = DataParser.parseInt(jsonObj, "sort");
        Order order = OrderFields.parse(DataParser.parseString(jsonObj, "order"));
        if (jsonObj.has("limit")) {
            DataParser.checkInt(jsonObj, "limit");
        }
        Date start = DataParser.parseDate(jsonObj, "start");
        Date end = DataParser.parseDate(jsonObj, "end");
        if (start != null) {
            Date[] dateRange;
            if (end == null) {
                dateRange = new Date[1];
            } else {
                dateRange = new Date[2];
                dateRange[1] = end;
            }
            dateRange[0] = start;
            searchObj.setRange(dateRange);
        }
        if (jData.has("pattern")) {
            searchObj.setPattern(DataParser.parseString(jData, "pattern"));
        }
        searchObj.setTitle(DataParser.parseString(jData, "title"));
        searchObj.setPriority(DataParser.parseInt(jData, "priority"));
        searchObj.setSearchInNote(DataParser.parseBoolean(jData, "searchinnote"));
        searchObj.setStatus(DataParser.parseInt(jData, "status"));
        searchObj.setCatgories(DataParser.parseString(jData, "categories"));
        searchObj.setSubfolderSearch(DataParser.parseBoolean(jData, "subfoldersearch"));
        if (jData.has("participants")) {
            Participants participants = new Participants();
            searchObj.setParticipants(CalendarParser.parseParticipants(jData, participants));
        }
        int[] internalColumns = new int[columnsToLoad.length + 1];
        System.arraycopy(columnsToLoad, 0, internalColumns, 0, columnsToLoad.length);
        internalColumns[columnsToLoad.length] = 5;
        JSONArray jsonResponseArray = new JSONArray();
        SearchIterator<Task> it = null;
        try {
            TaskWriter taskWriter = new TaskWriter(this.timeZone).setSession(this.session);
            TasksSQLImpl taskssql = new TasksSQLImpl(this.session);
            it = taskssql.getTasksByExtendedSearch(searchObj, orderBy, order, internalColumns);
            while (it.hasNext()) {
                Task taskObj = (Task)it.next();
                taskWriter.writeArray(taskObj, columns, jsonResponseArray);
                lastModified = taskObj.getLastModified();
                if (this.timestamp.getTime() >= lastModified.getTime()) continue;
                this.timestamp = lastModified;
            }
            JSONArray jSONArray = jsonResponseArray;
            return jSONArray;
        }
        finally {
            if (it != null) {
                it.close();
            }
        }
    }

    public JSONObject actionCopy(JSONObject jsonObj) throws JSONException, OXException {
        int id = DataParser.checkInt(jsonObj, "id");
        int inFolder = DataParser.checkInt(jsonObj, "folder");
        JSONObject jData = DataParser.checkJSONObject(jsonObj, "data");
        int folderId = DataParser.checkInt(jData, "folder_id");
        TasksSQLImpl taskInterface = new TasksSQLImpl(this.session);
        Task taskObj = taskInterface.getTaskById(id, inFolder);
        taskObj.removeObjectID();
        taskObj.setParentFolderID(folderId);
        taskInterface.insertTaskObject(taskObj);
        this.timestamp = new Date(0L);
        JSONObject jsonResponseObject = new JSONObject();
        jsonResponseObject.put("id", taskObj.getObjectID());
        return jsonResponseObject;
    }

    private static int[] removeVirtualColumns(int[] columns) {
        TIntArrayList tmp = new TIntArrayList(columns.length);
        for (int col : columns) {
            if (col == 6) continue;
            tmp.add(col);
        }
        return tmp.toArray();
    }
}

