/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.parser;

import com.openexchange.exception.OXException;
import com.openexchange.groupware.container.DataObject;
import com.openexchange.java.Strings;
import com.openexchange.tools.servlet.AjaxExceptionCodes;
import com.openexchange.tools.servlet.OXJSONExceptionCodes;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Date;
import java.util.TimeZone;
import java.util.UUID;
import java.util.regex.Pattern;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public abstract class DataParser {
    public static final int NO_INT = 0;
    protected boolean parseAll;
    protected TimeZone timeZone;
    private static final Pattern DIGITS = Pattern.compile("^\\-?\\d+$");

    protected DataParser() {
        this(false, null);
    }

    protected DataParser(TimeZone timeZone) {
        this(false, timeZone);
    }

    protected DataParser(boolean parseAll, TimeZone timeZone) {
        this.parseAll = parseAll;
        this.timeZone = timeZone;
    }

    protected void parseElementDataObject(DataObject dataobject, JSONObject jsonobject) throws JSONException, OXException {
        if (jsonobject.has("id")) {
            dataobject.setObjectID(DataParser.parseInt(jsonobject, "id"));
        }
        if (this.parseAll && jsonobject.has("created_by")) {
            dataobject.setCreatedBy(DataParser.parseInt(jsonobject, "created_by"));
        }
        if (this.parseAll && jsonobject.has("creation_date")) {
            dataobject.setCreationDate(DataParser.parseTime(jsonobject, "creation_date", this.timeZone));
        }
        if (this.parseAll && jsonobject.has("modified_by")) {
            dataobject.setModifiedBy(DataParser.parseInt(jsonobject, "modified_by"));
        }
        if (this.parseAll && jsonobject.has("last_modified")) {
            dataobject.setLastModified(DataParser.parseTime(jsonobject, "last_modified", this.timeZone));
        }
    }

    public static String parseString(JSONObject jsonObj, String name) {
        String test;
        String retval = null;
        if (jsonObj.hasAndNotNull(name) && 0 != (test = jsonObj.optString(name)).length()) {
            retval = test;
        }
        return retval;
    }

    public static int parseInt(JSONObject json, String name) throws JSONException, OXException {
        if (!json.has(name)) {
            return 0;
        }
        String tmp = json.getString(name);
        if (Strings.isEmpty((String)tmp) || json.isNull(name) || "null".equalsIgnoreCase(tmp)) {
            return 0;
        }
        try {
            return Integer.parseInt(tmp);
        }
        catch (NumberFormatException e) {
            throw OXJSONExceptionCodes.NUMBER_PARSING.create(e, tmp, name);
        }
    }

    public static boolean parseBoolean(JSONObject jsonObj, String name) throws JSONException {
        if (!jsonObj.has(name)) {
            return false;
        }
        return jsonObj.getBoolean(name);
    }

    public static BigDecimal parseBigDecimal(JSONObject jsonObj, String name) throws JSONException, OXException {
        if (!jsonObj.has(name)) {
            return null;
        }
        Object obj = jsonObj.get(name);
        if (obj instanceof BigDecimal) {
            return (BigDecimal)obj;
        }
        String tmp = jsonObj.getString(name);
        if (Strings.isEmpty((String)tmp) || jsonObj.isNull(name) || "null".equalsIgnoreCase(tmp)) {
            return null;
        }
        try {
            return new BigDecimal(tmp);
        }
        catch (NumberFormatException exc) {
            throw OXJSONExceptionCodes.INVALID_VALUE.create(exc, name, tmp);
        }
    }

    public static Long parseLong(JSONObject jsonObj, final String name) throws OXException {
        String tmp;
        try {
            tmp = jsonObj.getString(name);
        }
        catch (JSONException e) {
            return null;
        }
        if (Strings.isEmpty((String)tmp) || jsonObj.isNull(name) || "null".equalsIgnoreCase(tmp)) {
            return null;
        }
        OXException.Parsing parsing = new OXException.Parsing(){

            public String getAttribute() {
                return name;
            }
        };
        if (!DIGITS.matcher(tmp).matches()) {
            OXException e = OXJSONExceptionCodes.CONTAINS_NON_DIGITS.create(tmp, name);
            e.addProblematic((OXException.ProblematicAttribute)parsing);
            throw e;
        }
        try {
            return Long.valueOf(tmp);
        }
        catch (NumberFormatException e1) {
            try {
                new BigInteger(tmp);
                OXException e = OXJSONExceptionCodes.TOO_BIG_NUMBER.create(e1, name);
                e.addProblematic((OXException.ProblematicAttribute)parsing);
                throw e;
            }
            catch (NumberFormatException e2) {
                OXException e = OXJSONExceptionCodes.NUMBER_PARSING.create(e1, tmp, name);
                e.addProblematic((OXException.ProblematicAttribute)parsing);
                throw e;
            }
        }
    }

    public static Date parseTime(JSONObject jsonObj, String name, TimeZone timeZone) {
        Date d = DataParser.parseDate(jsonObj, name);
        if (d == null) {
            return null;
        }
        int offset = timeZone.getOffset(d.getTime());
        d.setTime(d.getTime() - (long)offset);
        return d;
    }

    private int getOffSet(TimeZone timeZone, Date d) {
        int offset = timeZone.getOffset(d.getTime());
        Date test = new Date(d.getTime() - (long)offset);
        int clientOffset = timeZone.getOffset(test.getTime());
        if (clientOffset != offset) {
            offset = clientOffset;
        }
        return offset;
    }

    public static Date parseDate(JSONObject jsonObj, String name) {
        if (!jsonObj.has(name)) {
            return null;
        }
        String tmp = DataParser.parseString(jsonObj, name);
        if (tmp == null) {
            return null;
        }
        return new Date(Long.parseLong(tmp));
    }

    public static String checkString(JSONObject jsonObj, String name) throws OXException {
        String tmp = DataParser.parseString(jsonObj, name);
        if (tmp == null) {
            throw AjaxExceptionCodes.MISSING_PARAMETER.create(name);
        }
        if (tmp.length() == 0) {
            throw AjaxExceptionCodes.MISSING_PARAMETER.create(name);
        }
        return tmp;
    }

    public static int checkInt(JSONObject json, String name) throws OXException, OXException {
        String tmp = DataParser.checkString(json, name);
        if (tmp == null || tmp.length() == 0) {
            throw AjaxExceptionCodes.MISSING_PARAMETER.create(name);
        }
        try {
            return Integer.parseInt(tmp);
        }
        catch (NumberFormatException e) {
            throw OXJSONExceptionCodes.NUMBER_PARSING.create(e, tmp, name);
        }
    }

    public static boolean checkBoolean(JSONObject jsonObj, String name) throws JSONException, OXException {
        String tmp = jsonObj.getString(name);
        if (tmp == null || tmp.length() == 0) {
            throw AjaxExceptionCodes.MISSING_PARAMETER.create(name);
        }
        return Boolean.parseBoolean(tmp);
    }

    public static float checkFloat(JSONObject jsonObj, String name) throws JSONException, OXException, OXException {
        String tmp = jsonObj.getString(name);
        if (tmp == null || tmp.length() == 0) {
            throw AjaxExceptionCodes.MISSING_PARAMETER.create(name);
        }
        try {
            return Float.parseFloat(tmp);
        }
        catch (NumberFormatException exc) {
            throw OXJSONExceptionCodes.INVALID_VALUE.create(exc, name, tmp);
        }
    }

    public static Date checkDate(JSONObject jsonObj, String name) throws OXException, OXException {
        String tmp = DataParser.parseString(jsonObj, name);
        if (tmp == null) {
            throw AjaxExceptionCodes.MISSING_PARAMETER.create(name);
        }
        try {
            return new Date(Long.parseLong(tmp));
        }
        catch (NumberFormatException exc) {
            throw OXJSONExceptionCodes.INVALID_VALUE.create(exc, name, tmp);
        }
    }

    public static Date checkTime(JSONObject jsonObj, String name, TimeZone timeZone) throws OXException, OXException {
        String tmp = DataParser.parseString(jsonObj, name);
        if (tmp == null) {
            throw AjaxExceptionCodes.MISSING_PARAMETER.create(name);
        }
        try {
            Date d = new Date(Long.parseLong(tmp));
            int offset = timeZone.getOffset(d.getTime());
            d.setTime(d.getTime() - (long)offset);
            return d;
        }
        catch (NumberFormatException exc) {
            throw OXJSONExceptionCodes.INVALID_VALUE.create(exc, name, tmp);
        }
    }

    public static UUID checkUUID(JSONObject jsonObj, String name) throws OXException, OXException {
        String tmp = DataParser.parseString(jsonObj, name);
        if (tmp == null) {
            throw AjaxExceptionCodes.MISSING_PARAMETER.create(name);
        }
        try {
            return UUID.fromString(tmp);
        }
        catch (IllegalArgumentException exc) {
            throw OXJSONExceptionCodes.INVALID_VALUE.create(exc, name, tmp);
        }
    }

    public static JSONObject checkJSONObject(JSONObject jsonObj, String name) throws OXException {
        JSONObject tmp = jsonObj.optJSONObject(name);
        if (tmp == null) {
            throw AjaxExceptionCodes.MISSING_PARAMETER.create(name);
        }
        return tmp;
    }

    public static JSONArray checkJSONArray(JSONObject jsonObj, String name) throws OXException {
        JSONArray tmp = jsonObj.optJSONArray(name);
        if (tmp == null) {
            throw AjaxExceptionCodes.MISSING_PARAMETER.create(name);
        }
        return tmp;
    }

    public static int[] parseJSONIntArray(JSONObject jsonObj, String name) throws JSONException, OXException {
        if (!jsonObj.has(name)) {
            return null;
        }
        JSONArray tmp = jsonObj.getJSONArray(name);
        if (tmp == null) {
            return null;
        }
        try {
            int[] i = new int[tmp.length()];
            for (int a = 0; a < tmp.length(); ++a) {
                i[a] = tmp.getInt(a);
            }
            return i;
        }
        catch (NumberFormatException exc) {
            throw OXJSONExceptionCodes.INVALID_VALUE.create(exc, name, tmp);
        }
    }

    public static String[] parseJSONStringArray(JSONObject jsonObj, String name) throws JSONException {
        if (!jsonObj.hasAndNotNull(name)) {
            return null;
        }
        JSONArray tmp = jsonObj.getJSONArray(name);
        String[] s = new String[tmp.length()];
        for (int a = 0; a < tmp.length(); ++a) {
            s[a] = tmp.getString(a);
        }
        return s;
    }

    public static UUID parseUUID(JSONObject jsonObj, String name) throws OXException {
        String tmp = DataParser.parseString(jsonObj, name);
        if (tmp == null) {
            return null;
        }
        try {
            return UUID.fromString(tmp);
        }
        catch (IllegalArgumentException exc) {
            return null;
        }
    }

    public static Date[] parseJSONDateArray(JSONObject jsonObj, String name) throws JSONException, OXException {
        if (!jsonObj.has(name)) {
            return null;
        }
        JSONArray tmp = jsonObj.getJSONArray(name);
        if (tmp == null) {
            return null;
        }
        try {
            Date[] d = new Date[tmp.length()];
            for (int a = 0; a < tmp.length(); ++a) {
                d[a] = new Date(tmp.getLong(a));
            }
            return d;
        }
        catch (NumberFormatException exc) {
            throw OXJSONExceptionCodes.INVALID_VALUE.create(exc, name, tmp);
        }
    }

    public static int[] checkJSONIntArray(JSONObject jsonObj, String name) throws JSONException, OXException, OXException {
        int[] i = DataParser.parseJSONIntArray(jsonObj, name);
        if (i == null) {
            throw AjaxExceptionCodes.MISSING_PARAMETER.create(name);
        }
        return i;
    }

    protected TimeZone getTimeZone() {
        return this.timeZone;
    }
}

