/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax;

import com.openexchange.ajax.PermissionServlet;
import com.openexchange.exception.OXException;
import com.openexchange.tools.servlet.AjaxExceptionCodes;
import java.util.Date;
import java.util.Enumeration;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import org.json.JSONException;
import org.json.JSONObject;

public abstract class DataServlet
extends PermissionServlet {
    private static final long serialVersionUID = 5088332994969906626L;
    private static final String _invalidParameter = "invalid parameter: ";
    private static final String _missingField = "missing field: ";
    public static final int maxEntries = 50000;
    private static final Pattern SPLIT = Pattern.compile(" *, *");

    public static int parseIntParameter(HttpServletRequest httpServletRequest, String name) throws OXException {
        if (DataServlet.containsParameter(httpServletRequest, name)) {
            String parameter = httpServletRequest.getParameter(name);
            try {
                return Integer.parseInt(parameter);
            }
            catch (NumberFormatException exc) {
                throw AjaxExceptionCodes.INVALID_PARAMETER_VALUE.create(name, parameter);
            }
        }
        return 0;
    }

    public static Date parseDateParameter(HttpServletRequest httpServletRequest, String name) throws OXException {
        if (DataServlet.containsParameter(httpServletRequest, name)) {
            String parameter = httpServletRequest.getParameter(name);
            try {
                return new Date(Long.parseLong(httpServletRequest.getParameter(name)));
            }
            catch (NumberFormatException exc) {
                throw AjaxExceptionCodes.INVALID_PARAMETER_VALUE.create(name, parameter);
            }
        }
        return null;
    }

    public static String parseStringParameter(HttpServletRequest httpServletRequest, String name) {
        return httpServletRequest.getParameter(name);
    }

    public static String parseMandatoryStringParameter(HttpServletRequest httpServletRequest, String name) throws OXException {
        if (!DataServlet.containsParameter(httpServletRequest, name)) {
            throw AjaxExceptionCodes.MISSING_PARAMETER.create(name);
        }
        return DataServlet.parseStringParameter(httpServletRequest, name);
    }

    public static int parseMandatoryIntParameter(HttpServletRequest httpServletRequest, String name) throws OXException {
        if (!DataServlet.containsParameter(httpServletRequest, name)) {
            throw AjaxExceptionCodes.MISSING_PARAMETER.create(name);
        }
        return DataServlet.parseIntParameter(httpServletRequest, name);
    }

    public static int[] parsIntParameterArray(HttpServletRequest httpServletRequest, String name) {
        if (DataServlet.containsParameter(httpServletRequest, name)) {
            String[] s = httpServletRequest.getParameterValues(name);
            int[] i = new int[s.length];
            for (int a = 0; a < i.length; ++a) {
                i[a] = Integer.parseInt(s[a]);
            }
            return i;
        }
        return null;
    }

    public static String[] parseStringParameterArray(HttpServletRequest httpServletRequest, String name) {
        if (DataServlet.containsParameter(httpServletRequest, name)) {
            String[] s = httpServletRequest.getParameterValues(name);
            return s;
        }
        return null;
    }

    public static int[] parseMandatoryIntParameterArray(HttpServletRequest httpServletRequest, String name) throws OXException {
        if (!DataServlet.containsParameter(httpServletRequest, name)) {
            throw AjaxExceptionCodes.MISSING_PARAMETER.create(name);
        }
        String[] s = httpServletRequest.getParameterValues(name);
        int[] i = new int[s.length];
        for (int a = 0; a < i.length; ++a) {
            i[a] = Integer.parseInt(s[a]);
        }
        return i;
    }

    public static Date parseMandatoryDateParameter(HttpServletRequest httpServletRequest, String name) throws OXException {
        if (!DataServlet.containsParameter(httpServletRequest, name)) {
            throw AjaxExceptionCodes.MISSING_PARAMETER.create(name);
        }
        return DataServlet.parseDateParameter(httpServletRequest, name);
    }

    public static JSONObject convertParameter2JSONObject(HttpServletRequest httpServletRequest) throws JSONException {
        JSONObject jsonObj = new JSONObject();
        Enumeration e = httpServletRequest.getParameterNames();
        while (e.hasMoreElements()) {
            String name = e.nextElement().toString();
            String value = httpServletRequest.getParameter(name);
            if ("columns".equals(name)) {
                jsonObj.put(name, (Object)SPLIT.matcher(value).replaceAll(","));
                continue;
            }
            jsonObj.put(name, (Object)value);
        }
        return jsonObj;
    }
}

