/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax;

import com.openexchange.ajax.PermissionServlet;
import com.openexchange.ajax.container.Response;
import com.openexchange.ajax.helper.DownloadUtility;
import com.openexchange.ajax.parser.AttachmentParser;
import com.openexchange.ajax.request.AttachmentRequest;
import com.openexchange.ajax.request.ServletRequestAdapter;
import com.openexchange.ajax.writer.ResponseWriter;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.attach.AttachmentBase;
import com.openexchange.groupware.attach.AttachmentConfig;
import com.openexchange.groupware.attach.AttachmentExceptionCodes;
import com.openexchange.groupware.attach.AttachmentField;
import com.openexchange.groupware.attach.AttachmentMetadata;
import com.openexchange.groupware.attach.Attachments;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.ldap.User;
import com.openexchange.groupware.ldap.UserStorage;
import com.openexchange.groupware.upload.UploadFile;
import com.openexchange.groupware.upload.impl.UploadEvent;
import com.openexchange.groupware.upload.impl.UploadException;
import com.openexchange.groupware.upload.impl.UploadSizeExceededException;
import com.openexchange.groupware.userconfiguration.UserConfiguration;
import com.openexchange.groupware.userconfiguration.UserConfigurationStorage;
import com.openexchange.java.AllocatingStringWriter;
import com.openexchange.java.Streams;
import com.openexchange.json.OXJSONWriter;
import com.openexchange.session.Session;
import com.openexchange.tools.encoding.Helper;
import com.openexchange.tools.exceptions.OXAborted;
import com.openexchange.tools.servlet.AjaxExceptionCodes;
import com.openexchange.tools.servlet.UploadServletException;
import com.openexchange.tools.servlet.http.Tools;
import com.openexchange.tools.session.ServerSession;
import com.openexchange.tools.session.ServerSessionAdapter;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.FileInputStream;
import java.io.Flushable;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Attachment
extends PermissionServlet {
    private static final String MIME_TEXT_HTML_CHARSET_UTF8 = "text/html; charset=UTF-8";
    private static final String MIME_TEXT_HTML = "text/html";
    private static final String PREFIX_JSON = "json_";
    private static final long serialVersionUID = -5819944675070929520L;
    private static final transient AttachmentParser PARSER = new AttachmentParser();
    public static final transient AttachmentField[] REQUIRED = new AttachmentField[]{AttachmentField.FOLDER_ID_LITERAL, AttachmentField.ATTACHED_ID_LITERAL, AttachmentField.MODULE_ID_LITERAL};
    public static final transient AttachmentBase ATTACHMENT_BASE = Attachments.getInstance();
    private static final transient Logger LOG;
    private long maxUploadSize = -2L;

    @Override
    protected boolean hasModulePermission(ServerSession session) {
        return AttachmentRequest.hasPermission(session.getUserConfiguration());
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        User user;
        ServerSession session;
        String action = req.getParameter("action");
        if (action == null) {
            this.missingParameter("action", res, false, null);
            return;
        }
        try {
            session = ServerSessionAdapter.valueOf(Attachment.getSessionObject((ServletRequest)req));
            user = UserStorage.getInstance().getUser(session.getUserId(), session.getContext());
        }
        catch (OXException e) {
            this.handle(res, e, action, Attachment.getSessionObject((ServletRequest)req));
            return;
        }
        Context ctx = session.getContext();
        UserConfiguration userConfig = UserConfigurationStorage.getInstance().getUserConfigurationSafe(session.getUserId(), session.getContext());
        if ("document".equals(action)) {
            int id;
            int moduleId;
            int attachedId;
            int folderId;
            try {
                this.require(req, "folder", "attached", "module", "id");
            }
            catch (OXException e) {
                this.handle(res, e, action, session);
                return;
            }
            String contentType = req.getParameter("content_type");
            try {
                folderId = this.requireNumber(req, res, action, "folder", session);
                attachedId = this.requireNumber(req, res, action, "attached", session);
                moduleId = this.requireNumber(req, res, action, "module", session);
                id = this.requireNumber(req, res, action, "id", session);
            }
            catch (OXAborted x) {
                return;
            }
            this.document(session, res, req.getHeader("user-agent"), this.isIE(req), folderId, attachedId, moduleId, id, contentType, ctx, user, userConfig);
        } else {
            OXJSONWriter writer = new OXJSONWriter();
            AttachmentRequest attRequest = new AttachmentRequest(session, writer);
            if (!attRequest.action(action, new ServletRequestAdapter(req, res))) {
                this.unknownAction("GET", action, res, false);
            }
            res.setContentType("text/javascript; charset=UTF-8");
            try {
                ((JSONObject)writer.getObject()).write((Writer)res.getWriter());
            }
            catch (JSONException e) {
                if (e.getCause() instanceof IOException) {
                    throw (IOException)e.getCause();
                }
                LOG.error("", (Throwable)e);
            }
        }
    }

    private int requireNumber(HttpServletRequest req, HttpServletResponse res, String action, String parameter, Session session) {
        String value = req.getParameter(parameter);
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException nfe) {
            this.handle(res, AttachmentExceptionCodes.INVALID_REQUEST_PARAMETER.create(parameter, value), action, session);
            throw new OXAborted();
        }
    }

    protected void doPut(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        ServerSession session;
        String action = req.getParameter("action");
        if (action == null) {
            this.missingParameter("action", res, false, null);
            return;
        }
        try {
            session = ServerSessionAdapter.valueOf(Attachment.getSessionObject((ServletRequest)req));
        }
        catch (OXException e) {
            this.handle(res, e, action, Attachment.getSessionObject((ServletRequest)req));
            return;
        }
        OXJSONWriter writer = new OXJSONWriter();
        AttachmentRequest attRequest = new AttachmentRequest(session, writer);
        if (!attRequest.action(action, new ServletRequestAdapter(req, res))) {
            this.unknownAction("PUT", action, res, false);
        }
        res.setContentType("text/javascript; charset=UTF-8");
        try {
            ((JSONObject)writer.getObject()).write((Writer)res.getWriter());
        }
        catch (JSONException e) {
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            LOG.error("", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doPost(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        block14: {
            User user;
            ServerSession session;
            res.setContentType(MIME_TEXT_HTML);
            String action = req.getParameter("action");
            if (action == null) {
                this.missingParameter("action", res, true, "attach");
                return;
            }
            try {
                session = ServerSessionAdapter.valueOf(Attachment.getSessionObject((ServletRequest)req));
                user = UserStorage.getInstance().getUser(session.getUserId(), session.getContext());
            }
            catch (OXException e) {
                this.handle(res, e, action, Attachment.getSessionObject((ServletRequest)req));
                return;
            }
            Context ctx = session.getContext();
            UserConfiguration userConfig = UserConfigurationStorage.getInstance().getUserConfigurationSafe(session.getUserId(), session.getContext());
            try {
                this.checkSize(req.getContentLength());
                if (!"attach".equals(action)) break block14;
                UploadEvent upload = null;
                try {
                    upload = this.processUpload(req);
                    ArrayList<AttachmentMetadata> attachments2 = new ArrayList<AttachmentMetadata>();
                    ArrayList<UploadFile> uploadFiles = new ArrayList<UploadFile>();
                    long sum = 0L;
                    JSONObject json = new JSONObject();
                    List<UploadFile> l = upload.getUploadFiles();
                    int size = l.size();
                    Iterator<UploadFile> iter = l.iterator();
                    for (int a = 0; a < size; ++a) {
                        UploadFile uploadFile = iter.next();
                        String fileField = uploadFile.getFieldName();
                        int index = Integer.parseInt(fileField.substring(5));
                        String obj = upload.getFormField(PREFIX_JSON + index);
                        if (obj == null || obj.length() == 0) continue;
                        json.reset();
                        json.parseJSONString(obj);
                        for (AttachmentField required : REQUIRED) {
                            if (json.has(required.getName())) continue;
                            this.missingParameter(required.getName(), res, true, action);
                        }
                        AttachmentMetadata attachment = PARSER.getAttachmentMetadata(json);
                        this.assureSize(index, attachments2, uploadFiles);
                        attachments2.set(index, attachment);
                        uploadFiles.set(index, uploadFile);
                        this.checkSize(sum += uploadFile.getSize());
                    }
                    this.attach(res, attachments2, uploadFiles, session, ctx, user, userConfig);
                }
                finally {
                    if (upload != null) {
                        upload.cleanUp();
                    }
                }
            }
            catch (OXException x) {
                Response resp = new Response(Attachment.getSessionObject((ServletRequest)req));
                resp.setException(x);
                try {
                    res.setContentType(MIME_TEXT_HTML_CHARSET_UTF8);
                    throw new UploadServletException(res, Attachment.substituteJS(ResponseWriter.getJSON(resp).toString(), "error"), x.getMessage(), x);
                }
                catch (JSONException e) {
                    LOG.error("Giving up", (Throwable)e);
                }
            }
            catch (JSONException e) {
                LOG.error("", (Throwable)e);
            }
        }
    }

    private void assureSize(int index, List<AttachmentMetadata> attachments2, List<UploadFile> uploadFiles) {
        int i;
        int enlarge = index - (attachments2.size() - 1);
        for (i = 0; i < enlarge; ++i) {
            attachments2.add(null);
        }
        enlarge = index - (uploadFiles.size() - 1);
        for (i = 0; i < enlarge; ++i) {
            uploadFiles.add(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void document(Session session, HttpServletResponse res, String userAgent, boolean ie, int folderId, int attachedId, int moduleId, int id, String contentType, Context ctx, User user, UserConfiguration userConfig) {
        InputStream documentData = null;
        ServletOutputStream os = null;
        try {
            ATTACHMENT_BASE.startTransaction();
            AttachmentMetadata attachment = ATTACHMENT_BASE.getAttachment(session, folderId, attachedId, moduleId, id, ctx, user, userConfig);
            res.setContentLength((int)attachment.getFilesize());
            documentData = ATTACHMENT_BASE.getAttachedFile(session, folderId, attachedId, moduleId, id, ctx, user, userConfig);
            if ("application/octet-stream".equals(contentType)) {
                res.setContentType(contentType);
                res.setHeader("Content-Disposition", "attachment; filename=\"" + Helper.escape(Helper.encodeFilename(attachment.getFilename(), "UTF-8", ie)) + "\"");
            } else {
                DownloadUtility.CheckedDownload checkedDownload = DownloadUtility.checkInlineDownload(documentData, attachment.getFilename(), attachment.getFileMIMEType(), userAgent);
                res.setHeader("Content-Disposition", checkedDownload.getContentDisposition());
                res.setContentType(checkedDownload.getContentType());
                documentData = checkedDownload.getInputStream();
            }
            Tools.removeCachingHeader(res);
            os = res.getOutputStream();
            byte[] buffer = new byte[65535];
            int bytesRead = 0;
            while ((bytesRead = documentData.read(buffer)) > 0) {
                os.write(buffer, 0, bytesRead);
            }
            os.flush();
            os = null;
            ATTACHMENT_BASE.commit();
        }
        catch (Throwable t) {
            try {
                this.rollback(t, res, "error", session);
                return;
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                Streams.close(documentData);
                Streams.flush(os);
                try {
                    ATTACHMENT_BASE.finish();
                }
                catch (OXException e) {
                    LOG.debug("", (Throwable)e);
                }
            }
        }
        Streams.close((Closeable)documentData);
        Streams.flush((Flushable)os);
        try {
            ATTACHMENT_BASE.finish();
            return;
        }
        catch (OXException e) {
            LOG.debug("", (Throwable)e);
            return;
        }
    }

    private void rollback(Throwable t, HttpServletResponse res, String action, Session session) {
        try {
            ATTACHMENT_BASE.rollback();
        }
        catch (OXException e) {
            LOG.debug("", (Throwable)e);
        }
        if (t instanceof OXException) {
            this.handle(res, (OXException)t, action, session);
        } else {
            this.handle(res, new OXException(t), action, session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void attach(HttpServletResponse res, List<AttachmentMetadata> attachments2, List<UploadFile> uploadFiles, ServerSession session, Context ctx, User user, UserConfiguration userConfig) {
        this.initAttachments(attachments2, uploadFiles);
        PrintWriter w = null;
        try {
            ATTACHMENT_BASE.startTransaction();
            Iterator<UploadFile> ufIter = uploadFiles.iterator();
            JSONObject result = new JSONObject();
            JSONArray arr = new JSONArray();
            long timestamp = 0L;
            for (AttachmentMetadata attachment : attachments2) {
                UploadFile uploadFile = ufIter.next();
                attachment.setId(0);
                long modified = ATTACHMENT_BASE.attachToObject(attachment, new BufferedInputStream(new FileInputStream(uploadFile.getTmpFile()), 65536), session, ctx, user, userConfig);
                if (modified > timestamp) {
                    timestamp = modified;
                }
                arr.put(attachment.getId());
            }
            result.put("data", (Object)arr);
            result.put("timestamp", timestamp);
            w = res.getWriter();
            w.print(Attachment.substituteJS(result.toString(), "attach"));
            ATTACHMENT_BASE.commit();
        }
        catch (OXException t) {
            try {
                ATTACHMENT_BASE.rollback();
            }
            catch (OXException e) {
                LOG.error("", (Throwable)e);
            }
            this.handle(res, t, "error", session);
            return;
        }
        catch (JSONException e) {
            try {
                ATTACHMENT_BASE.rollback();
            }
            catch (OXException x) {
                LOG.error("", (Throwable)e);
            }
            this.handle(res, AjaxExceptionCodes.JSON_ERROR.create(e, e.getMessage()), "error", session);
            return;
        }
        catch (IOException e) {
            try {
                ATTACHMENT_BASE.rollback();
            }
            catch (OXException x) {
                LOG.error("", (Throwable)e);
            }
            this.handle(res, AjaxExceptionCodes.IO_ERROR.create(e, e.getMessage()), "error", session);
            return;
        }
        finally {
            try {
                ATTACHMENT_BASE.finish();
            }
            catch (OXException e) {
                LOG.debug("", (Throwable)e);
            }
        }
    }

    private void initAttachments(List<AttachmentMetadata> attachments2, List<UploadFile> uploads) {
        ArrayList<AttachmentMetadata> attList = new ArrayList<AttachmentMetadata>(attachments2);
        Iterator<UploadFile> ufIter = new ArrayList<UploadFile>(uploads).iterator();
        int index = 0;
        for (AttachmentMetadata attachment : attList) {
            if (attachment == null) {
                attachments2.remove(index);
                ufIter.next();
                uploads.remove(index);
                continue;
            }
            UploadFile upload = ufIter.next();
            if (upload == null) {
                attachments2.remove(index);
                uploads.remove(index);
                continue;
            }
            if (attachment.getFilename() == null || "".equals(attachment.getFilename())) {
                attachment.setFilename(upload.getPreparedFileName());
            }
            if (attachment.getFilesize() <= 0L) {
                attachment.setFilesize(upload.getSize());
            }
            if (attachment.getFileMIMEType() == null || "".equals(attachment.getFileMIMEType())) {
                attachment.setFileMIMEType(upload.getContentType());
            }
            ++index;
        }
    }

    private void handle(HttpServletResponse res, OXException t, String action, Session session) {
        res.setContentType(MIME_TEXT_HTML_CHARSET_UTF8);
        Response resp = new Response();
        resp.setException(t);
        AllocatingStringWriter writer = null;
        try {
            writer = new AllocatingStringWriter();
            ResponseWriter.write(resp, (Writer)writer, Attachment.localeFrom(session));
            res.getWriter().write(Attachment.substituteJS(writer.toString(), action));
        }
        catch (JSONException e) {
            LOG.error("", (Throwable)t);
        }
        catch (IOException e) {
            LOG.error("", (Throwable)e);
        }
    }

    private void checkSize(long size) throws OXException {
        if (this.maxUploadSize == -2L) {
            this.maxUploadSize = AttachmentConfig.getMaxUploadSize();
        }
        if (this.maxUploadSize == 0L) {
            return;
        }
        if (size > this.maxUploadSize) {
            throw UploadSizeExceededException.create(size, this.maxUploadSize, true);
        }
    }

    protected void require(HttpServletRequest req, String ... parameters) throws OXException {
        for (String param : parameters) {
            if (req.getParameter(param) != null) continue;
            throw UploadException.UploadCode.MISSING_PARAM.create(param);
        }
    }

    static {
        ATTACHMENT_BASE.setTransactional(true);
        LOG = LoggerFactory.getLogger(Attachment.class);
    }
}

