/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.tools.iterator;

import com.openexchange.exception.OXException;
import com.openexchange.tools.iterator.SearchIterator;
import com.openexchange.tools.iterator.SearchIteratorExceptionCodes;
import java.util.ArrayList;
import java.util.Arrays;

public class CombinedSearchIterator<T>
implements SearchIterator<T> {
    private final SearchIterator<T>[] iterators;
    private int i = 0;
    private OXException[] warnings;
    private Boolean hasWarnings;
    private boolean next = false;

    public CombinedSearchIterator(SearchIterator<T> ... iterators) {
        this.iterators = iterators;
    }

    @Override
    public boolean hasNext() throws OXException {
        if (this.iterators.length == 0) {
            return false;
        }
        this.next = false;
        while (this.i < this.iterators.length && !this.next) {
            if (this.iterators[this.i].hasNext()) {
                this.next = true;
                continue;
            }
            ++this.i;
        }
        return this.next;
    }

    @Override
    public T next() throws OXException {
        if (this.iterators.length == 0 || !this.next) {
            throw SearchIteratorExceptionCodes.NO_SUCH_ELEMENT.create().setPrefix("NON");
        }
        return this.iterators[this.i].next();
    }

    @Override
    public void close() throws OXException {
        for (SearchIterator<T> iter : this.iterators) {
            iter.close();
        }
    }

    @Override
    public int size() {
        return -1;
    }

    public boolean hasSize() {
        return false;
    }

    @Override
    public void addWarning(OXException warning) {
        throw new UnsupportedOperationException("Mehtod addWarning() not implemented");
    }

    @Override
    public OXException[] getWarnings() {
        if (null == this.warnings) {
            if (this.iterators.length == 0) {
                this.warnings = new OXException[0];
            } else {
                ArrayList<OXException> list = new ArrayList<OXException>(this.iterators.length << 1);
                for (SearchIterator<T> iter : this.iterators) {
                    if (!iter.hasWarnings()) continue;
                    list.addAll(Arrays.asList(this.iterators[this.i].getWarnings()));
                }
                this.warnings = list.toArray(new OXException[list.size()]);
            }
        }
        return this.warnings.length == 0 ? null : this.warnings;
    }

    @Override
    public boolean hasWarnings() {
        if (null == this.hasWarnings) {
            if (this.iterators.length == 0) {
                this.hasWarnings = Boolean.FALSE;
            } else {
                this.hasWarnings = Boolean.FALSE;
                for (SearchIterator<T> iter : this.iterators) {
                    if (!iter.hasWarnings()) continue;
                    this.hasWarnings = Boolean.TRUE;
                    break;
                }
            }
        }
        return this.hasWarnings;
    }
}

