/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.sessiond;

import com.openexchange.exception.Category;
import com.openexchange.exception.DisplayableOXExceptionCode;
import com.openexchange.exception.OXException;
import com.openexchange.exception.OXExceptionCode;
import com.openexchange.exception.OXExceptionFactory;

public enum SessionExceptionCodes implements DisplayableOXExceptionCode
{
    SESSIOND_EXCEPTION("Sessiond exception", "An error occurred inside the server which prevented it from fulfilling the request.", Category.CATEGORY_ERROR, 1),
    MAX_SESSION_EXCEPTION("Maximum number of sessions elapsed", "The maximum number of sessions is exceeded. Please try again later.", Category.CATEGORY_ERROR, 2),
    SESSIOND_CONFIG_EXCEPTION("Sessiond Config Exception", "An error occurred inside the server which prevented it from fulfilling the request.", Category.CATEGORY_ERROR, 3),
    MISSING_PROPERTY("Missing property '%s'", "An error occurred inside the server which prevented it from fulfilling the request.", Category.CATEGORY_CONFIGURATION, 4),
    UNKNOWN_EVENT_TOPIC("Unknown event topic %s", "An error occurred inside the server which prevented it from fulfilling the request.", Category.CATEGORY_ERROR, 5),
    PASSWORD_UPDATE_FAILED("Password could not be changed", "The password could not be changed in the current session. Please login again.", Category.CATEGORY_ERROR, 6),
    MAX_SESSION_PER_USER_EXCEPTION("Max. number of sessions exceeded for user %1$s in context %2$s", "The maximum number of sessions is exceeded for your account. Please logout from other clients and try again.", Category.CATEGORY_USER_INPUT, 7),
    DUPLICATE_AUTHID("Authentication identifier duplicate found. Existing session login: %1$s. Current denied login request: %2$s.", "A temporary error occurred inside the server which prevented it from fulfilling the request. Please try again later.", Category.CATEGORY_ERROR, 8),
    WRONG_SESSION("SessionD returned wrong session with identifier %1$s for given session identifier %2$s.", "An error occurred inside the server which prevented it from fulfilling the request.", Category.CATEGORY_ERROR, 9),
    SESSIONID_COLLISION("Got a collision while adding a new session to the session container. Colliding session has login %1$s and new session has login %2$s.", "A temporary error occurred inside the server which prevented it from fulfilling the request. Please try again later.", Category.CATEGORY_ERROR, 10),
    WRONG_BY_RANDOM("Received wrong session %1$s having random %2$s when looking for random %3$s and session %4$s.", "An error occurred inside the server which prevented it from fulfilling the request.", Category.CATEGORY_ERROR, 11),
    SESSION_PARAMETER_MISSING("The session parameter is missing.", "An error occurred inside the server which prevented it from fulfilling the request.", Category.CATEGORY_ERROR, 201),
    SESSION_EXPIRED("Your session %s expired. Please start a new browser session.", "Your session expired. Please login again.", Category.CATEGORY_TRY_AGAIN, 203),
    CONTEXT_LOCKED("Context %1$d (%2$s) is currently not enabled.", "The account \"%2$s\" is currently not enabled. Please try again later.", Category.CATEGORY_TRY_AGAIN, 204),
    WRONG_CLIENT_IP("Request to server was refused. Original client IP address changed. Please try again." + System.getProperty("line.separator") + "Client login IP changed from %1$s to %2$s and is not covered by IP white-list or netmask.", "Your session was invalidated. Please login again.", Category.CATEGORY_PERMISSION_DENIED, 205),
    WRONG_SESSION_SECRET("Your session was invalidated. Please try again.", "Your session was invalidated. Please login again.", Category.CATEGORY_TRY_AGAIN, 206),
    MAX_SESSION_PER_CLIENT_EXCEPTION("Max. number of sessions exceeded for client %1$s of user %2$s in context %3$s", "The maximum number of sessions is exceeded for client %1$s. Please logout from other clients and try again.", Category.CATEGORY_ERROR, 207),
    NOT_INITIALIZED("Session daemon is not initialized yet.", "A temporary error occurred inside the server which prevented it from fulfilling the request. Please try again later.", Category.CATEGORY_ERROR, 208),
    NOT_IMPLEMENTED("Method not implemented.", "An error occurred inside the server which prevented it from fulfilling the request.", Category.CATEGORY_ERROR, 209),
    NO_SESSION_FOR_SERVER_TOKEN("Can not find a session for server token %1$s and client token %2$s.", "The session is no longer available. Please try again.", Category.CATEGORY_USER_INPUT, 210),
    NO_SESSION_FOR_CLIENT_TOKEN("Can not find a session for server token %1$s and client token %2$s.", "The session is no longer available. Please try again.", Category.CATEGORY_USER_INPUT, 211);

    private static final String PREFIX = "SES";
    private final String message;
    private final String displayMessage;
    private final Category category;
    private final int number;

    public static boolean hasPrefix(OXException e) {
        if (null == e) {
            return false;
        }
        return PREFIX.equals(e.getPrefix());
    }

    public static String getErrorPrefix() {
        return PREFIX;
    }

    private SessionExceptionCodes(String message, String displayMessage, Category category, int number) {
        this.message = message;
        this.displayMessage = displayMessage;
        this.category = category;
        this.number = number;
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    @Override
    public String getDisplayMessage() {
        return this.displayMessage;
    }

    @Override
    public int getNumber() {
        return this.number;
    }

    @Override
    public String getPrefix() {
        return PREFIX;
    }

    @Override
    public Category getCategory() {
        return this.category;
    }

    @Override
    public boolean equals(OXException e) {
        return OXExceptionFactory.getInstance().equals(this, e);
    }

    public OXException create() {
        return OXExceptionFactory.getInstance().create((OXExceptionCode)this, new Object[0]);
    }

    public OXException create(Object ... args) {
        return OXExceptionFactory.getInstance().create((OXExceptionCode)this, (Throwable)null, args);
    }

    public OXException create(Throwable cause, Object ... args) {
        return OXExceptionFactory.getInstance().create((OXExceptionCode)this, cause, args);
    }
}

