/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.meta.internal;

import com.openexchange.ajax.meta.MetaContributor;
import com.openexchange.exception.OXException;
import com.openexchange.session.Session;
import java.util.Collection;
import java.util.Map;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetaContributorReference
implements MetaContributor {
    private static final Logger LOG = LoggerFactory.getLogger(MetaContributorReference.class);
    private final ServiceReference<MetaContributor> reference;
    private final BundleContext context;
    private MetaContributor contributor;
    private String[] topics;

    public MetaContributorReference(ServiceReference<MetaContributor> reference, BundleContext context) {
        this.reference = reference;
        this.context = context;
    }

    @Override
    public void contributeTo(Map<String, Object> meta, String id, Session session) throws OXException {
        this.doContribution(meta, id, session);
    }

    public synchronized boolean init() {
        this.topics = null;
        Object o = this.reference.getProperty("contributor.topics");
        if (o instanceof String) {
            this.topics = new String[]{(String)o};
        } else if (o instanceof String[]) {
            this.topics = (String[])o;
        } else if (o instanceof Collection) {
            try {
                Collection c = (Collection)o;
                this.topics = c.toArray(new String[c.size()]);
            }
            catch (ArrayStoreException e) {
                LOG.error("Invalid event contributor topics", (Throwable)e);
            }
        }
        return this.topics != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() {
        MetaContributorReference metaContributorReference = this;
        synchronized (metaContributorReference) {
            if (this.contributor == null) {
                return;
            }
            this.contributor = null;
        }
        try {
            this.context.ungetService(this.reference);
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public synchronized String[] getTopics() {
        return this.topics;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MetaContributor getContributor() {
        MetaContributorReference metaContributorReference = this;
        synchronized (metaContributorReference) {
            if (this.contributor != null) {
                return this.contributor;
            }
        }
        MetaContributor tempHandler = null;
        try {
            tempHandler = (MetaContributor)this.context.getService(this.reference);
        }
        catch (IllegalStateException e) {
            // empty catch block
        }
        MetaContributorReference e = this;
        synchronized (e) {
            if (this.contributor == null) {
                this.contributor = tempHandler;
                return this.contributor;
            }
            tempHandler = this.contributor;
        }
        try {
            this.context.ungetService(this.reference);
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        return tempHandler;
    }

    public void doContribution(Map<String, Object> meta, String id, Session session) {
        Bundle bundle = this.reference.getBundle();
        if (bundle == null) {
            return;
        }
        MetaContributor contributor = this.getContributor();
        if (contributor == null) {
            return;
        }
        try {
            contributor.contributeTo(meta, id, session);
        }
        catch (Throwable t) {
            LOG.error("Entity contribution failed", t);
        }
    }
}

